/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CastingTest
extends BaseJDBCTestCase {
    public static String VALID_DATE_STRING = "'2000-01-01'";
    public static String VALID_TIME_STRING = "'15:30:20'";
    public static String VALID_TIMESTAMP_STRING = "'2000-01-01 15:30:20'";
    public static String NULL_VALUE = "NULL";
    public static String ILLEGAL_CAST_EXCEPTION_SQLSTATE = "42846";
    public static String LANG_NOT_STORABLE_SQLSTATE = "42821";
    public static String LANG_NOT_COMPARABLE_SQLSTATE = "42818";
    public static String METHOD_NOT_FOUND_SQLSTATE = "42884";
    public static String LANG_FORMAT_EXCEPTION_SQLSTATE = "22018";
    public static int SQLTYPE_ARRAY_SIZE = 17;
    public static int SMALLINT_OFFSET = 0;
    public static int INTEGER_OFFSET = 1;
    public static int BIGINT_OFFSET = 2;
    public static int DECIMAL_OFFSET = 3;
    public static int REAL_OFFSET = 4;
    public static int DOUBLE_OFFSET = 5;
    public static int CHAR_OFFSET = 6;
    public static int VARCHAR_OFFSET = 7;
    public static int LONGVARCHAR_OFFSET = 8;
    public static int CHAR_FOR_BIT_OFFSET = 9;
    public static int VARCHAR_FOR_BIT_OFFSET = 10;
    public static int LONGVARCHAR_FOR_BIT_OFFSET = 11;
    public static int CLOB_OFFSET = 12;
    public static int DATE_OFFSET = 13;
    public static int TIME_OFFSET = 14;
    public static int TIMESTAMP_OFFSET = 15;
    public static int BLOB_OFFSET = 16;
    public static int[] jdbcTypes = new int[]{5, 4, -5, 3, 7, 8, 1, 12, -1, -2, -3, -4, 2005, 91, 92, 93, 2004};
    public static int NULL_DATA_OFFSET = 0;
    public static int VALID_DATA_OFFSET = 1;
    public static String[][] SQLData = new String[][]{{NULL_VALUE, "0"}, {NULL_VALUE, "11"}, {NULL_VALUE, "22"}, {NULL_VALUE, "3.3"}, {NULL_VALUE, "4.4"}, {NULL_VALUE, "5.5"}, {NULL_VALUE, "'7'"}, {NULL_VALUE, "'8'"}, {NULL_VALUE, "'9'"}, {NULL_VALUE, "X'10aa'"}, {NULL_VALUE, "X'10bb'"}, {NULL_VALUE, "X'10cc'"}, {NULL_VALUE, "'13'"}, {NULL_VALUE, VALID_DATE_STRING}, {NULL_VALUE, VALID_TIME_STRING}, {NULL_VALUE, VALID_TIMESTAMP_STRING}, {NULL_VALUE, "X'01dd'"}};
    public static final boolean n = false;
    public static final boolean X = true;
    public static final boolean[][] T_146 = new boolean[][]{{true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, false, false, true, true, true, false, false, false, true, true, true, true, false}, {true, true, true, true, false, false, true, true, true, false, false, false, true, true, true, true, false}, {false, false, false, false, false, false, true, true, true, false, false, false, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true}, {false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true}, {false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true}, {false, false, false, false, false, false, true, true, true, false, false, false, true, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, true, false, true, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, true, true, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, true, true, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true}};
    public static final boolean[][] T_147a = new boolean[][]{{true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, true, false}, {false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, true, false}, {false, false, false, false, false, false, true, true, true, false, false, false, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, true, true, true, false, false, false, true, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, true, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true}};
    public static final boolean[][] T_147b = new boolean[][]{{true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, true, true, true, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, true, true, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, true, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}};
    private static final String[][] explicitCastValues = new String[][]{{"0", "0", "0", "0.00000", "0.0", "0.0", "0                                                           ", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception"}, {"11", "11", "11", "11.00000", "11.0", "11.0", "11                                                          ", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception"}, {"22", "22", "22", "22.00000", "22.0", "22.0", "22                                                          ", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception"}, {"3", "3", "3", "3.30000", "3.3", "3.3", "3.30000                                                     ", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception"}, {"4", "4", "4", "4.40000", "4.4", "4.400000095367432", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception"}, {"5", "5", "5", "5.50000", "5.5", "5.5", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception"}, {"0", "11", "22", "3.30000", "Exception", "Exception", "7                                                           ", "8                                                           ", "9                                                           ", "Exception", "Exception", "Exception", "13                                                          ", "2000-01-01", "15:30:20", "2000-01-01 15:30:20.0", "Exception"}, {"0", "11", "22", "3.30000", "Exception", "Exception", "7                                                           ", "8", "9", "Exception", "Exception", "Exception", "13", "2000-01-01", "15:30:20", "2000-01-01 15:30:20.0", "Exception"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "7                                                           ", "8", "9", "Exception", "Exception", "Exception", "13", "Exception", "Exception", "Exception", "Exception"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "10aa20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020", "10bb20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020", "10cc20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020", "Exception", "Exception", "Exception", "Exception", "01dd20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "10aa20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020", "10bb", "10cc", "Exception", "Exception", "Exception", "Exception", "01dd"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "10aa20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020", "10bb", "10cc", "Exception", "Exception", "Exception", "Exception", "01dd"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "13                                                          ", "13", "13", "Exception", "Exception", "Exception", "13", "Exception", "Exception", "Exception", "Exception"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "2000-01-01                                                  ", "2000-01-01", "Exception", "Exception", "Exception", "Exception", "Exception", "2000-01-01", "Exception", "2000-01-01 00:00:00.0", "Exception"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "15:30:20                                                    ", "15:30:20", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "15:30:20", "TODAY 15:30:20.0", "Exception"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "2000-01-01 15:30:20.0                                       ", "2000-01-01 15:30:20.0", "Exception", "Exception", "Exception", "Exception", "Exception", "2000-01-01", "15:30:20", "2000-01-01 15:30:20.0", "Exception"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "01dd"}};
    private static final TypedColumn[] LEGAL_BOOLEAN_CASTS = new TypedColumn[]{new TypedColumn("charCol", "char( 5 )", true), new TypedColumn("varcharCol", "varchar( 5 )", true), new TypedColumn("longVarcharCol", "long varchar", false), new TypedColumn("clobCol", "clob", false), new TypedColumn("booleanCol", "boolean", true)};
    private static final TypedColumn[] ILLEGAL_BOOLEAN_CASTS = new TypedColumn[]{new TypedColumn("bigintCol", "bigint", true), new TypedColumn("blobCol", "blob", false), new TypedColumn("charForBitDataCol", "char( 5 ) for bit data", true), new TypedColumn("dateCol", "date", true), new TypedColumn("decimalCol", "decimal", true), new TypedColumn("doubleCol", "double", true), new TypedColumn("floatCol", "float", true), new TypedColumn("integerCol", "integer", true), new TypedColumn("longVarcharForBitDataCol", "long varchar for bit data", false), new TypedColumn("numericCol", "numeric", true), new TypedColumn("realCol", "real", true), new TypedColumn("smallintCol", "smallint", true), new TypedColumn("timeCol", "time", true), new TypedColumn("timestampCol", "timestamp", true), new TypedColumn("varcharForBitDataCol", "varchar( 5 ) for bit data", true), new TypedColumn("xmlCol", "xml", false)};

    public CastingTest(String name) {
        super(name);
    }

    protected void setUp() throws SQLException {
        String tableName;
        Statement scb = this.createStatement();
        for (int type = 0; type < SQLUtilities.SQLTypes.length; ++type) {
            String typeName = SQLUtilities.SQLTypes[type];
            tableName = CastingTest.getTableName(type);
            String createSQL = "create table " + tableName + " (c " + typeName + " )";
            scb.executeUpdate(createSQL);
        }
        for (int dataOffset = 0; dataOffset < SQLData[0].length; ++dataOffset) {
            for (int type = 0; type < SQLUtilities.SQLTypes.length; ++type) {
                try {
                    tableName = CastingTest.getTableName(type);
                    String insertSQL = "insert into " + tableName + " values( " + SQLData[type][dataOffset] + ")";
                    scb.executeUpdate(insertSQL);
                    continue;
                }
                catch (SQLException se) {
                    if (type == BLOB_OFFSET) continue;
                    throw se;
                }
            }
        }
        scb.close();
        this.commit();
    }

    public void testAssignments() throws SQLException {
        Statement scb = this.createStatement();
        for (int dataOffset = 0; dataOffset < SQLData[0].length; ++dataOffset) {
            for (int sourceType = 0; sourceType < SQLUtilities.SQLTypes.length; ++sourceType) {
                String sourceTypeName = SQLUtilities.SQLTypes[sourceType];
                for (int targetType = 0; targetType < SQLUtilities.SQLTypes.length; ++targetType) {
                    try {
                        String targetTableName = CastingTest.getTableName(targetType);
                        String convertString = CastingTest.getCompatibleString(sourceType, targetType, dataOffset);
                        String insertValuesString = " VALUES CAST(" + convertString + " AS " + sourceTypeName + ")";
                        String insertSQL = "INSERT INTO " + targetTableName + insertValuesString;
                        scb.executeUpdate(insertSQL);
                        CastingTest.checkSupportedAssignment(sourceType, targetType);
                        continue;
                    }
                    catch (SQLException se) {
                        String sqlState = se.getSQLState();
                        CastingTest.assertTrue((!CastingTest.isSupportedAssignment(sourceType, targetType) && CastingTest.isNotStorableException(se) || CastingTest.isCastException(se) ? 1 : 0) != 0);
                    }
                }
            }
        }
        scb.close();
        this.commit();
    }

    public void testExplicitCasts() throws SQLException {
        Statement s = this.createStatement();
        for (int sourceType = 0; sourceType < SQLUtilities.SQLTypes.length; ++sourceType) {
            String sourceTypeName = SQLUtilities.SQLTypes[sourceType];
            for (int dataOffset = 0; dataOffset < SQLData[0].length; ++dataOffset) {
                for (int targetType = 0; targetType < SQLUtilities.SQLTypes.length; ++targetType) {
                    try {
                        long startTime = System.currentTimeMillis();
                        String targetTypeName = SQLUtilities.SQLTypes[targetType];
                        String convertString = CastingTest.getCompatibleString(sourceType, targetType, dataOffset);
                        String query = "VALUES CAST (CAST (" + convertString + " AS " + SQLUtilities.SQLTypes[sourceType] + ") AS " + SQLUtilities.SQLTypes[targetType] + " )";
                        ResultSet rs = s.executeQuery(query);
                        rs.next();
                        String val = rs.getString(1);
                        ResultSetMetaData rsmd = rs.getMetaData();
                        CastingTest.assertEquals((int)rsmd.getColumnType(1), (int)jdbcTypes[targetType]);
                        rs.close();
                        long finishTime = System.currentTimeMillis();
                        if (dataOffset == 0) {
                            CastingTest.assertNull((Object)val);
                        } else {
                            String expected = explicitCastValues[sourceType][targetType];
                            if (CastingTest.isTime(sourceType) && CastingTest.isTimestamp(targetType)) {
                                String[] expectedValues = new String[]{expected.replace("TODAY", new Date(startTime).toString()), expected.replace("TODAY", new Date(finishTime).toString())};
                                HashSet<String> valid = new HashSet<String>(Arrays.asList(expectedValues));
                                if (!valid.contains(val)) {
                                    CastingTest.fail((String)("Got " + val + ", expected one of " + String.valueOf(valid)));
                                }
                            } else {
                                CastingTest.assertEquals((String)expected, (String)val);
                            }
                        }
                        CastingTest.checkSupportedCast(sourceType, targetType);
                        continue;
                    }
                    catch (SQLException se) {
                        if (dataOffset != 0) {
                            // empty if block
                        }
                        String sqlState = se.getSQLState();
                        if (!CastingTest.isSupportedCast(sourceType, targetType)) {
                            CastingTest.assertTrue((boolean)CastingTest.isCastException(se));
                            continue;
                        }
                        throw se;
                    }
                }
            }
        }
        this.commit();
    }

    public void testComparisons() throws SQLException {
        Statement scb = this.createStatement();
        for (int type = 0; type < SQLUtilities.SQLTypes.length; ++type) {
            try {
                int dataOffset = 1;
                String tableName = CastingTest.getTableName(type);
                String compareSQL = "SELECT distinct c FROM " + tableName + " WHERE c = " + SQLData[type][dataOffset];
                ResultSet rs = scb.executeQuery(compareSQL);
                CastingTest.assertTrue((boolean)rs.next());
                rs.close();
                continue;
            }
            catch (SQLException se) {
                CastingTest.assertTrue((boolean)CastingTest.isLongType(type));
            }
        }
        for (int dataOffset = 0; dataOffset < SQLData[0].length; ++dataOffset) {
            for (int sourceType = 0; sourceType < SQLUtilities.SQLTypes.length; ++sourceType) {
                String sourceTypeName = SQLUtilities.SQLTypes[sourceType];
                for (int targetType = 0; targetType < SQLUtilities.SQLTypes.length; ++targetType) {
                    try {
                        String targetTableName = CastingTest.getTableName(targetType);
                        String convertString = CastingTest.getCompatibleString(sourceType, targetType, dataOffset);
                        scb.executeUpdate("DELETE FROM " + targetTableName);
                        String insertValuesString = " VALUES CAST(" + convertString + " AS " + sourceTypeName + ")";
                        String insertSQL = "INSERT INTO " + targetTableName + insertValuesString;
                        String compareSQL = "select c from " + targetTableName + " WHERE c = CAST(" + convertString + " AS " + sourceTypeName + ")";
                        ResultSet rs = scb.executeQuery(compareSQL);
                        JDBC.assertDrainResults(rs);
                        CastingTest.checkSupportedComparison(sourceType, targetType);
                        continue;
                    }
                    catch (SQLException se) {
                        String sqlState = se.getSQLState();
                        CastingTest.assertTrue((!CastingTest.isSupportedComparison(sourceType, targetType) && CastingTest.isNotComparableException(se) || CastingTest.isCastException(se) ? 1 : 0) != 0);
                    }
                }
            }
        }
        scb.close();
        this.commit();
    }

    public void test_derby887() throws Exception {
        this.goodStatement("create table t_887 (a int)\n");
        this.expectError(LANG_NOT_COMPARABLE_SQLSTATE, "select * from t_887 where a=0<3\n");
    }

    public void test_legalBooleanCasts() throws Exception {
        this.assertAllTypesCovered();
        int legalTypeCount = LEGAL_BOOLEAN_CASTS.length;
        String tableName = "t_legal_boolean_casts";
        this.makeTableForCasts(tableName, LEGAL_BOOLEAN_CASTS);
        this.goodStatement("insert into " + tableName + "\n( " + this.makeColumnList(LEGAL_BOOLEAN_CASTS) + " )\nselect " + this.makeRepeatedColumnList("c.isIndex", LEGAL_BOOLEAN_CASTS.length) + "\nfrom\n  sys.sysconglomerates c,\n  sys.systables t\nwhere t.tablename='SYSTABLES'\nand t.tableid = c.tableid\nand not c.isIndex\n");
        this.assertBooleanResults("select * from " + tableName + "\n", false, 1);
        for (int i = 0; i < legalTypeCount; ++i) {
            TypedColumn tc = LEGAL_BOOLEAN_CASTS[i];
            String queryText = "select count(*)\nfrom\n  sys.sysconglomerates c,\n  sys.systables t,\n  " + tableName + " tt\nwhere t.tablename='SYSTABLES'\nand t.tableid = c.tableid\nand not c.isIndex\nand tt." + tc.columnName + " = c.isIndex\n";
            if (tc.comparable) {
                this.assertScalarResult(queryText, 1);
                continue;
            }
            this.expectError(LANG_NOT_COMPARABLE_SQLSTATE, queryText);
        }
        this.assertBooleanResults("select\n" + this.makeCastedColumnList("c.isIndex", LEGAL_BOOLEAN_CASTS) + "\nfrom\n  sys.sysconglomerates c,\n  sys.systables t\nwhere t.tablename='SYSTABLES'\nand t.tableid = c.tableid\nand not c.isIndex\n", false, 1);
    }

    private void makeTableForCasts(String tableName, TypedColumn[] columns) throws Exception {
        StringBuffer buffer = new StringBuffer();
        int count = columns.length;
        buffer.append("create table " + tableName + "\n(\n");
        for (int i = 0; i < count; ++i) {
            buffer.append("\t");
            if (i > 0) {
                buffer.append(", ");
            }
            TypedColumn tc = columns[i];
            buffer.append(tc.columnName + "\t" + tc.typeName + "\n");
        }
        buffer.append(")\n");
        this.goodStatement(buffer.toString());
    }

    private String makeColumnList(TypedColumn[] columns) {
        StringBuffer buffer = new StringBuffer();
        int count = columns.length;
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(columns[i].columnName);
        }
        return buffer.toString();
    }

    private String makeCastedColumnList(String columnName, TypedColumn[] targetTypes) {
        StringBuffer buffer = new StringBuffer();
        int count = targetTypes.length;
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append("cast ( " + columnName + " as " + targetTypes[i].typeName + " )");
        }
        return buffer.toString();
    }

    private String makeRepeatedColumnList(String columnName, int N) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < N; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(columnName);
        }
        return buffer.toString();
    }

    private void assertBooleanResults(String queryText, boolean expectedValue, int expectedRowCount) throws Exception {
        PreparedStatement ps = this.chattyPrepare(queryText);
        ResultSet rs = ps.executeQuery();
        int actualRowCount = 0;
        int columnCount = rs.getMetaData().getColumnCount();
        String expectedStringValue = Boolean.toString(expectedValue);
        while (rs.next()) {
            ++actualRowCount;
            for (int i = 0; i < columnCount; ++i) {
                CastingTest.assertEquals((String)("Column " + i), (String)expectedStringValue, (String)rs.getString(i + 1).trim());
            }
        }
        rs.close();
        ps.close();
        CastingTest.assertEquals((int)expectedRowCount, (int)actualRowCount);
    }

    private void assertScalarResult(String queryText, int expectedValue) throws Exception {
        PreparedStatement ps = this.chattyPrepare(queryText);
        ResultSet rs = ps.executeQuery();
        rs.next();
        CastingTest.assertEquals((int)expectedValue, (int)rs.getInt(1));
        rs.close();
        ps.close();
    }

    private void assertAllTypesCovered() throws Exception {
        CastingTest.println("Verify that we are testing the casting behavior of BOOLEAN to/from all Derby data types.");
        Connection conn = this.getConnection();
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getTypeInfo();
        int count = 0;
        int expectedDataTypeCount = LEGAL_BOOLEAN_CASTS.length + ILLEGAL_BOOLEAN_CASTS.length;
        ++expectedDataTypeCount;
        while (rs.next()) {
            ++count;
        }
        CastingTest.assertEquals((String)"You must add your new data type to LEGAL_BOOLEAN_CASTS or ILLEGAL_BOOLEAN_CASTS", (int)expectedDataTypeCount, (int)count);
        rs.close();
    }

    public void test_illegalBooleanCasts() throws Exception {
        TypedColumn tc;
        int i;
        this.assertAllTypesCovered();
        int illegalTypeCount = ILLEGAL_BOOLEAN_CASTS.length;
        String tableName = "t_illegal_boolean_casts";
        this.makeTableForCasts(tableName, ILLEGAL_BOOLEAN_CASTS);
        for (i = 0; i < illegalTypeCount; ++i) {
            tc = ILLEGAL_BOOLEAN_CASTS[i];
            this.expectError(LANG_NOT_STORABLE_SQLSTATE, "insert into " + tableName + "( " + tc.columnName + " ) select c.isIndex from sys.sysconglomerates c\n");
        }
        for (i = 0; i < illegalTypeCount; ++i) {
            tc = ILLEGAL_BOOLEAN_CASTS[i];
            this.expectError(LANG_NOT_COMPARABLE_SQLSTATE, "select * from " + tableName + " t, sys.sysconglomerates c where t." + tc.columnName + " = c.isIndex\n");
        }
        for (i = 0; i < illegalTypeCount; ++i) {
            TypedColumn[] castedColumnList = new TypedColumn[]{ILLEGAL_BOOLEAN_CASTS[i]};
            this.expectError(ILLEGAL_CAST_EXCEPTION_SQLSTATE, "select " + this.makeCastedColumnList("c.isIndex", castedColumnList) + " from sys.sysconglomerates c\n");
        }
    }

    public void testDataTruncationWarning() throws SQLException {
        Statement s = this.createStatement();
        this.checkDataTruncationResult(s, "values (cast('abc' as char(2)), cast('de'   as char(2))),       (cast('fg'  as char(2)), cast('hi'   as char(2))),       (cast('jkl' as char(2)), cast('mnop' as char(2)))");
        this.checkDataTruncationResult(s, "values (cast('abc' as varchar(2)), cast('de'   as varchar(2))),       (cast('fg'  as varchar(2)), cast('hi'   as varchar(2))),       (cast('jkl' as varchar(2)), cast('mnop' as varchar(2)))");
        this.checkDataTruncationResult(s, "values (cast('abc' as clob(2)), cast('de'   as clob(2))),       (cast('fg'  as clob(2)), cast('hi'   as clob(2))),       (cast('jkl' as clob(2)), cast('mnop' as clob(2)))");
        this.checkDataTruncationResult(s, "values (cast(x'abcdef' as char(2) for bit data),        cast(x'abcd' as char(2) for bit data)),       (cast(x'abcd' as char(2) for bit data),        cast(x'cdef' as char(2) for bit data)),       (cast(x'012345' as char(2) for bit data),        cast(x'6789ABCD' as char(2) for bit data))");
        this.checkDataTruncationResult(s, "values (cast(x'abcdef' as varchar(2) for bit data),        cast(x'abcd' as varchar(2) for bit data)),       (cast(x'abcd' as varchar(2) for bit data),        cast(x'cdef' as varchar(2) for bit data)),       (cast(x'012345' as varchar(2) for bit data),        cast(x'6789ABCD' as varchar(2) for bit data))");
        this.checkDataTruncationResult(s, "values    (cast(x'abcdef' as blob(2)), cast(x'abcd' as blob(2))),     (cast(x'abcd' as blob(2)),   cast(x'cdef' as blob(2))),     (cast(x'012345' as blob(2)), cast(x'6789ABCD' as blob(2)))");
        ResultSet rs = s.executeQuery("values cast('abc\u00e6\u00f8\u00e5' as varchar(4))");
        CastingTest.assertTrue((boolean)rs.next());
        CastingTest.assertEquals((String)"abc\u00e6", (String)rs.getString(1));
        this.assertDataTruncation(rs.getWarnings(), -1, true, false, 9, 5);
        CastingTest.assertFalse((boolean)rs.next());
        rs.close();
        this.setAutoCommit(false);
        s.execute("create table t1_d129 (x8 char(8) for bit data)");
        s.execute("create table t2_d129 (x4 char(4) for bit data)");
        s.execute("insert into t1_d129(x8) values x'0123456789ABCDEF'");
        CastingTest.assertNull((Object)s.getWarnings());
        s.execute("insert into t2_d129(x4) select cast(x8 as char(4) for bit data) from t1_d129");
        this.assertDataTruncation(s.getWarnings(), -1, true, false, 8, 4);
        this.rollback();
    }

    private void checkDataTruncationResult(Statement s, String sql) throws SQLException {
        ResultSet rs = s.executeQuery(sql);
        CastingTest.assertTrue((boolean)rs.next());
        SQLWarning w = rs.getWarnings();
        this.assertDataTruncation(w, -1, true, false, 3, 2);
        w = w.getNextWarning();
        CastingTest.assertNull((Object)w);
        rs.clearWarnings();
        CastingTest.assertTrue((boolean)rs.next());
        CastingTest.assertNull((Object)rs.getWarnings());
        CastingTest.assertTrue((boolean)rs.next());
        w = rs.getWarnings();
        this.assertDataTruncation(w, -1, true, false, 3, 2);
        if (CastingTest.usingEmbedded()) {
            w = w.getNextWarning();
            this.assertDataTruncation(w, -1, true, false, 4, 2);
        }
        w = w.getNextWarning();
        CastingTest.assertNull((Object)w);
        rs.clearWarnings();
        CastingTest.assertFalse((boolean)rs.next());
        rs.close();
        CastingTest.assertNull((Object)s.getWarnings());
        CastingTest.assertNull((Object)this.getConnection().getWarnings());
    }

    private void assertDataTruncation(SQLWarning w, int index, boolean read, boolean parameter, int dataSize, int transferSize) throws SQLException {
        CastingTest.assertNotNull((String)"No warning", (Object)w);
        if (!(w instanceof DataTruncation)) {
            CastingTest.fail("Not a DataTruncation warning", w);
        }
        DataTruncation dt = (DataTruncation)w;
        CastingTest.assertEquals((String)"Column index", (int)index, (int)dt.getIndex());
        CastingTest.assertEquals((String)"Read", (boolean)read, (boolean)dt.getRead());
        CastingTest.assertEquals((String)"Parameter", (boolean)parameter, (boolean)dt.getParameter());
        CastingTest.assertEquals((String)"Data size", (int)dataSize, (int)dt.getDataSize());
        CastingTest.assertEquals((String)"Transfer size", (int)transferSize, (int)dt.getTransferSize());
    }

    public void testDateTimeToTimestamp() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("values (cast (current date as timestamp), current date, cast (current time as timestamp), current time)");
        ResultSetMetaData rsmd = rs.getMetaData();
        CastingTest.assertEquals((int)93, (int)rsmd.getColumnType(1));
        CastingTest.assertEquals((int)93, (int)rsmd.getColumnType(3));
        rs.next();
        CastingTest.assertEquals((String)(rs.getString(2) + " 00:00:00.0"), (String)rs.getString(1));
        CastingTest.assertEquals((String)(rs.getString(2) + " " + rs.getString(4) + ".0"), (String)rs.getString(3));
        rs.close();
        this.assertCompileError(ILLEGAL_CAST_EXCEPTION_SQLSTATE, "values cast(current time as date)");
        this.assertCompileError(ILLEGAL_CAST_EXCEPTION_SQLSTATE, "values cast(current date as time)");
        s.execute("create table derby896(id int generated always as identity, d date, t time, ts timestamp)");
        this.assertCompileError(LANG_NOT_STORABLE_SQLSTATE, "insert into derby896(ts) values current time");
        this.assertCompileError(LANG_NOT_STORABLE_SQLSTATE, "insert into derby896(ts) values current date");
        s.execute("insert into derby896(d,t,ts) values (current date, current time, cast(current date as timestamp)), (current date, current time, cast(current time as timestamp))");
        rs = s.executeQuery("select d, t, ts from derby896 order by id");
        rs.next();
        CastingTest.assertEquals((String)(rs.getString(1) + " 00:00:00.0"), (String)rs.getString(3));
        rs.next();
        CastingTest.assertEquals((String)(rs.getString(1) + " " + rs.getString(2) + ".0"), (String)rs.getString(3));
        rs.close();
        s.execute("insert into derby896(d, t) values ({d'1999-12-31'}, {t'23:59:59'}), ({d'2000-01-01'}, {t'00:00:00'}), ({d'1970-01-01'}, {t'00:00:01'}), ({d'1969-12-31'}, {t'12:00:00'})");
        rs = s.executeQuery("select d, cast(d as timestamp) from derby896");
        while (rs.next()) {
            CastingTest.assertEquals((String)(rs.getString(1) + " 00:00:00.0"), (String)rs.getString(2));
        }
        rs.close();
        rs = s.executeQuery("select t, cast(t as timestamp), current date from derby896");
        while (rs.next()) {
            CastingTest.assertEquals((String)(rs.getString(3) + " " + rs.getString(1) + ".0"), (String)rs.getString(2));
        }
        rs.close();
    }

    @Override
    protected void tearDown() throws SQLException, Exception {
        Statement scb = this.createStatement();
        for (int type = 0; type < SQLUtilities.SQLTypes.length; ++type) {
            String typeName = SQLUtilities.SQLTypes[type];
            String tableName = CastingTest.getTableName(type);
            String dropSQL = "drop table " + tableName;
            scb.executeUpdate(dropSQL);
        }
        scb.close();
        this.commit();
        super.tearDown();
    }

    private static String getTableName(int type) {
        return CastingTest.getShortTypeName(type).replace(' ', '_') + "_TAB";
    }

    private static String getShortTypeName(int type) {
        String typeName = SQLUtilities.SQLTypes[type];
        Object shortName = typeName;
        int parenIndex = typeName.indexOf(40);
        if (parenIndex >= 0) {
            shortName = typeName.substring(0, parenIndex);
            int endParenIndex = typeName.indexOf(41);
            shortName = (String)shortName + typeName.substring(endParenIndex + 1, typeName.length());
        }
        return shortName;
    }

    private static String getCompatibleString(int sourceType, int targetType, int dataOffset) {
        String convertString = null;
        convertString = (CastingTest.isCharacterType(sourceType) || CastingTest.isBinaryType(sourceType)) && !CastingTest.isLob(sourceType) ? CastingTest.formatString(SQLData[targetType][dataOffset]) : SQLData[sourceType][dataOffset];
        return convertString;
    }

    private static boolean isSupportedCast(int sourceType, int targetType) {
        return T_146[sourceType][targetType];
    }

    private static boolean isSupportedAssignment(int sourceType, int targetType) {
        return T_147a[sourceType][targetType];
    }

    private static boolean isSupportedComparison(int sourceType, int targetType) {
        return T_147b[sourceType][targetType];
    }

    private static boolean isCastException(SQLException se) {
        return CastingTest.sqlStateMatches(se, ILLEGAL_CAST_EXCEPTION_SQLSTATE);
    }

    private static boolean isMethodNotFoundException(SQLException se) {
        return CastingTest.sqlStateMatches(se, METHOD_NOT_FOUND_SQLSTATE);
    }

    private static boolean sqlStateMatches(SQLException se, String expectedValue) {
        String sqlState = se.getSQLState();
        return sqlState != null && sqlState.equals(expectedValue);
    }

    private static boolean isNotStorableException(SQLException se) {
        String sqlState = se.getSQLState();
        return sqlState != null && sqlState.equals(LANG_NOT_STORABLE_SQLSTATE);
    }

    private static boolean isNotComparableException(SQLException se) {
        String sqlState = se.getSQLState();
        return sqlState != null && sqlState.equals(LANG_NOT_COMPARABLE_SQLSTATE);
    }

    private static void checkSupportedCast(int sourceType, int targetType) {
        String description = " Cast from " + SQLUtilities.SQLTypes[sourceType] + " to " + SQLUtilities.SQLTypes[targetType];
        if (!CastingTest.isSupportedCast(sourceType, targetType)) {
            CastingTest.fail((String)(description + "should not succeed"));
        }
    }

    private static void checkSupportedAssignment(int sourceType, int targetType) {
        String description = " Assignment from " + SQLUtilities.SQLTypes[sourceType] + " to " + SQLUtilities.SQLTypes[targetType];
        if (!CastingTest.isSupportedAssignment(sourceType, targetType)) {
            CastingTest.fail((String)(description + "should not succeed"));
        }
    }

    private static void checkSupportedComparison(int sourceType, int targetType) {
        String description = " Comparison of " + SQLUtilities.SQLTypes[sourceType] + " to " + SQLUtilities.SQLTypes[targetType];
        if (!CastingTest.isSupportedComparison(sourceType, targetType)) {
            CastingTest.fail((String)("FAIL: unsupported comparison:" + description));
        }
    }

    private static boolean isLongType(int typeOffset) {
        return typeOffset == LONGVARCHAR_OFFSET || typeOffset == LONGVARCHAR_FOR_BIT_OFFSET || typeOffset == CLOB_OFFSET || typeOffset == BLOB_OFFSET;
    }

    private static boolean isCharacterType(int typeOffset) {
        return typeOffset == CHAR_OFFSET || typeOffset == VARCHAR_OFFSET || typeOffset == LONGVARCHAR_OFFSET || typeOffset == CLOB_OFFSET;
    }

    private static boolean isBinaryType(int typeOffset) {
        return typeOffset == CHAR_FOR_BIT_OFFSET || typeOffset == VARCHAR_FOR_BIT_OFFSET || typeOffset == LONGVARCHAR_FOR_BIT_OFFSET || typeOffset == BLOB_OFFSET;
    }

    private static boolean isTime(int typeOffset) {
        return typeOffset == TIME_OFFSET;
    }

    private static boolean isTimestamp(int typeOffset) {
        return typeOffset == TIMESTAMP_OFFSET;
    }

    private static boolean isLob(int typeOffset) {
        return typeOffset == CLOB_OFFSET || typeOffset == BLOB_OFFSET;
    }

    private static String formatString(String str) {
        if (str != null && (str.startsWith("X") || str.startsWith("'") || str == NULL_VALUE)) {
            return str;
        }
        return "'" + str + "'";
    }

    private void goodStatement(String ddl) throws SQLException {
        PreparedStatement ps = this.chattyPrepare(ddl);
        ps.execute();
        ps.close();
    }

    private void expectError(String sqlState, String query) {
        CastingTest.println("\nExpecting " + sqlState + " when preparing:\n\t" + query);
        this.assertCompileError(sqlState, query);
    }

    private PreparedStatement chattyPrepare(String text) throws SQLException {
        CastingTest.println("Preparing statement:\n\t" + text);
        return this.prepareStatement(text);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(CastingTest.class);
    }

    public static final class TypedColumn {
        public String columnName;
        public String typeName;
        public boolean comparable;

        public TypedColumn(String columnName, String typeName, boolean comparable) {
            this.columnName = columnName;
            this.typeName = typeName;
            this.comparable = comparable;
        }
    }
}

