/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.functionTests.harness.BackgroundStreamSaver;
import org.apache.derbyTesting.functionTests.harness.TimedProcess;
import org.apache.derbyTesting.functionTests.harness.jvm;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class NetServer {
    File homeDir;
    String jvmName = "jdk13";
    String clPath;
    String javaCmd;
    String jvmflags;
    String framework;
    String appsRequiredPassword;
    int timeout = 60;
    static String hostName;
    Object[] frameworkInfo;
    int port;
    Process pr;
    BackgroundStreamSaver outSaver;
    BackgroundStreamSaver errSaver;
    FileOutputStream fosOut;
    FileOutputStream fosErr;
    private boolean startServer;
    Object networkServer;
    Method pingMethod;
    private static String NETWORK_SERVER_CLASS_NAME;
    public static Hashtable<String, Object[]> m;
    public static int PREFIX_POS;
    public static int SUFFIX_POS;
    public static int DRIVER_POS;
    public static int PORT_POS;
    public static int START_CMD_POS;
    public static int STOP_CMD1_POS;
    public static int STOP_CMD2_POS;

    private static String[] serverArgs(String serverCommand) {
        ArrayList<Object> argList = new ArrayList<Object>();
        boolean isModuleAware = JVMInfo.isModuleAware();
        if (isModuleAware) {
            argList.add("-p");
            argList.add(JVMInfo.getSystemModulePath());
            argList.add("-m");
            argList.add("org.apache.derby.server/" + NETWORK_SERVER_CLASS_NAME);
        } else {
            argList.add(NETWORK_SERVER_CLASS_NAME);
        }
        argList.add(serverCommand);
        String[] retval = new String[argList.size()];
        argList.toArray(retval);
        return retval;
    }

    public NetServer(File homeDir, String jvmName, String clPath, String javaCmd, String jvmflags, String framework, boolean startServer, String appsRequiredPassword) throws Exception {
        int start;
        this.homeDir = homeDir;
        this.jvmName = jvmName;
        this.clPath = clPath;
        this.javaCmd = javaCmd;
        this.jvmflags = jvmflags;
        this.framework = framework;
        if (jvmflags != null && jvmflags.length() > 0 && (start = jvmflags.indexOf("-Dtimeout")) >= 0) {
            String timeoutStr = jvmflags.substring(start);
            String[] tokens = timeoutStr.split(" ");
            timeoutStr = tokens[0];
            timeoutStr = timeoutStr.substring(10);
            this.timeout = Integer.parseInt(timeoutStr.trim());
        }
        this.appsRequiredPassword = appsRequiredPassword;
        this.frameworkInfo = m.get(framework);
        this.port = Integer.parseInt((String)this.frameworkInfo[PORT_POS]);
        this.startServer = startServer;
    }

    public void start() throws Exception {
        if (!this.startServer) {
            System.out.println("startServer = false. Bypass server startup");
            return;
        }
        new File(this.homeDir, this.framework + "Server").mkdir();
        String[] startcmd = (String[])this.frameworkInfo[START_CMD_POS];
        if (startcmd == null) {
            return;
        }
        String homeDirName = this.homeDir.getCanonicalPath();
        jvm jvm2 = null;
        jvm2 = jvm.getJvm(this.jvmName);
        if (this.jvmName.equals("jview")) {
            jvm2.setJavaCmd("jview");
        } else if (this.javaCmd != null) {
            jvm2.setJavaCmd(this.javaCmd);
        }
        Vector<String> jvmProps = new Vector<String>();
        if (this.clPath != null && this.clPath.length() > 0) {
            jvm2.setClasspath(this.clPath);
        }
        if (this.jvmflags != null && this.jvmflags.length() > 0) {
            jvm2.setFlags(this.jvmflags);
        }
        jvmProps.addElement("derby.system.home=" + homeDirName);
        jvm2.setD(jvmProps);
        jvm2.setSecurityProps();
        Vector<String> vCmd = jvm2.getCommandLine();
        for (int i = 0; i < startcmd.length; ++i) {
            vCmd.addElement(startcmd[i]);
        }
        String[] serverCmd = new String[vCmd.size()];
        for (int i = 0; i < vCmd.size(); ++i) {
            serverCmd[i] = vCmd.elementAt(i);
            System.out.print(serverCmd[i] + " ");
        }
        System.out.println("");
        this.pr = Runtime.getRuntime().exec(serverCmd);
        File out = new File(this.homeDir, this.framework + ".out");
        this.fosOut = new FileOutputStream(out);
        this.outSaver = new BackgroundStreamSaver(this.pr.getInputStream(), this.fosOut);
        File err = new File(this.homeDir, this.framework + ".err");
        this.fosErr = new FileOutputStream(err);
        this.errSaver = new BackgroundStreamSaver(this.pr.getErrorStream(), this.fosErr);
        for (int i = 0; i <= 120 && !NetServer.isDB2Connection(this.framework); ++i) {
            try {
                if (NetServer.isNetworkServerConnection(this.framework)) {
                    if (!this.testNetworkServerConnection()) continue;
                    break;
                }
                Socket s = new Socket(hostName, this.port);
                s.close();
                break;
            }
            catch (Exception e) {
                if (err.length() > 0L) break;
                Thread.sleep(1000L);
            }
        }
    }

    public boolean testNetworkServerConnection() throws Exception {
        if (!this.startServer) {
            System.out.println("startServer = false. Bypass server check");
            return true;
        }
        if (this.networkServer == null) {
            Class<?> serverClass = Class.forName(NETWORK_SERVER_CLASS_NAME);
            Constructor<?> serverConstructor = serverClass.getConstructor(new Class[0]);
            this.networkServer = serverConstructor.newInstance(new Object[0]);
            this.pingMethod = this.networkServer.getClass().getMethod("ping", new Class[0]);
        }
        this.pingMethod.invoke(this.networkServer, new Object[0]);
        return true;
    }

    public void stop() throws Exception {
        if (!this.startServer) {
            return;
        }
        System.out.println("Attempt to shutdown framework: " + this.framework);
        jvm jvm2 = null;
        jvm2 = jvm.getJvm(this.jvmName);
        Vector<String> jvmCmd = jvm2.getCommandLine();
        Vector<String> connV = new Vector<String>();
        for (int i = 0; i < jvmCmd.size(); ++i) {
            connV.addElement(jvmCmd.elementAt(i));
        }
        String[] stopcmd1 = (String[])this.frameworkInfo[STOP_CMD1_POS];
        if (stopcmd1 == null) {
            return;
        }
        if (this.appsRequiredPassword != null) {
            String[] modifiedStopCmd = new String[stopcmd1.length + 4];
            System.arraycopy(stopcmd1, 0, modifiedStopCmd, 0, stopcmd1.length);
            modifiedStopCmd[stopcmd1.length] = "-user";
            modifiedStopCmd[stopcmd1.length + 1] = "app";
            modifiedStopCmd[stopcmd1.length + 2] = "-password";
            modifiedStopCmd[stopcmd1.length + 3] = this.appsRequiredPassword;
            stopcmd1 = modifiedStopCmd;
        }
        for (int i = 0; i < stopcmd1.length; ++i) {
            connV.addElement(stopcmd1[i]);
        }
        String[] connCmd = new String[connV.size()];
        for (int i = 0; i < connV.size(); ++i) {
            connCmd[i] = (String)connV.elementAt(i);
        }
        Vector<String> stopV = new Vector<String>();
        for (int i = 0; i < jvmCmd.size(); ++i) {
            stopV.addElement(jvmCmd.elementAt(i));
        }
        Process prconn = Runtime.getRuntime().exec(connCmd);
        TimedProcess tp = new TimedProcess(prconn);
        tp.waitFor(this.timeout);
        String[] stopcmd2 = (String[])this.frameworkInfo[STOP_CMD2_POS];
        if (stopcmd2 != null) {
            for (int i = 0; i < stopcmd2.length; ++i) {
                stopV.addElement(stopcmd2[i]);
            }
            String[] stopCmd = new String[stopV.size()];
            for (int i = 0; i < stopV.size(); ++i) {
                stopCmd[i] = (String)stopV.elementAt(i);
            }
            Process prstop = Runtime.getRuntime().exec(stopCmd);
            prstop.waitFor();
        }
        tp = new TimedProcess(this.pr);
        tp.waitFor(this.timeout);
        this.outSaver.finish();
        this.errSaver.finish();
    }

    public void printFramworkInfo(String framework) {
        System.out.println("PREFIX = " + String.valueOf(this.frameworkInfo[PREFIX_POS]));
        System.out.println("SUFFIX = " + String.valueOf(this.frameworkInfo[SUFFIX_POS]));
        System.out.println("DRIVER = " + String.valueOf(this.frameworkInfo[DRIVER_POS]));
        System.out.println("PORT = " + String.valueOf(this.frameworkInfo[PORT_POS]));
        for (int index = START_CMD_POS; index <= STOP_CMD2_POS; ++index) {
            Object cmdString = "";
            String[] cmdArray = (String[])this.frameworkInfo[index];
            for (int i = 0; i < cmdArray.length; ++i) {
                cmdString = (String)cmdString + " " + cmdArray[i];
            }
            if (index == START_CMD_POS) {
                System.out.println("START_CMD =  " + (String)cmdString);
                continue;
            }
            System.out.println("STOP_CMD = " + (String)cmdString);
        }
    }

    public static String getURLPrefix(String fm) {
        Object[] info = m.get(fm);
        return (String)info[PREFIX_POS];
    }

    public static String getURLSuffix(String fm) {
        Object[] info = m.get(fm);
        return (String)info[SUFFIX_POS];
    }

    public static String getDriverName(String fm) {
        Object[] info = m.get(fm);
        if (info != null) {
            return (String)info[DRIVER_POS];
        }
        return null;
    }

    public static boolean isDB2Connection(String fm) {
        return fm.toUpperCase(Locale.ENGLISH).equals("DB2APP") || fm.toUpperCase(Locale.ENGLISH).equals("DB2JCC");
    }

    public static boolean isNetworkServerConnection(String fm) {
        return fm.toUpperCase(Locale.ENGLISH).startsWith("DERBYNET");
    }

    public static boolean isClientConnection(String fm) {
        return fm.toUpperCase(Locale.ENGLISH).startsWith("DERBYNET") || fm.toUpperCase(Locale.ENGLISH).equals("DB2JCC");
    }

    public static boolean isJCCConnection(String fm) {
        return fm.toUpperCase(Locale.ENGLISH).equals("DB2JCC") || fm.toUpperCase(Locale.ENGLISH).equals("DERBYNET");
    }

    public static String alterURL(String fm, String url) {
        String urlPrefix = "jdbc:derby:";
        String newURLPrefix = NetServer.getURLPrefix(fm);
        String newURLSuffix = NetServer.getURLSuffix(fm);
        if (newURLPrefix == null) {
            return url;
        }
        if (newURLSuffix == null) {
            newURLSuffix = "";
        }
        if (((String)url).equals(urlPrefix)) {
            return newURLPrefix;
        }
        int attrOffset = ((String)url).indexOf(59);
        if (NetServer.isDB2Connection(fm) && attrOffset != -1) {
            url = ((String)url).substring(0, attrOffset);
        }
        if (((String)url).startsWith(urlPrefix)) {
            url = newURLPrefix + ((String)url).substring(urlPrefix.length()) + newURLSuffix;
        } else if (!((String)url).startsWith("jdbc:")) {
            url = newURLPrefix + (String)url + newURLSuffix;
        }
        return url;
    }

    static {
        NETWORK_SERVER_CLASS_NAME = "org.apache.derby.drda.NetworkServerControl";
        PREFIX_POS = 0;
        SUFFIX_POS = 1;
        DRIVER_POS = 2;
        PORT_POS = 3;
        START_CMD_POS = 4;
        STOP_CMD1_POS = 5;
        STOP_CMD2_POS = 6;
        hostName = TestUtil.getHostName();
        m = new Hashtable();
        String url = "jdbc:derby:net://" + hostName + ":1527/";
        m.put("DerbyNet", new Object[]{url, "", "com.ibm.db2.jcc.DB2Driver", "1527", NetServer.serverArgs("start"), NetServer.serverArgs("shutdown"), null});
        url = "jdbc:derby://" + hostName + ":1527/";
        m.put("DerbyNetClient", new Object[]{url, "", "org.apache.derby.jdbc.ClientDriver", "1527", NetServer.serverArgs("start"), NetServer.serverArgs("shutdown"), null});
        url = "jdbc:db2://" + hostName + ":50000/";
        m.put("DB2jcc", new Object[]{url, "", "com.ibm.db2.jcc.DB2Driver", "50000", null, null, null});
        m.put("DB2app", new Object[]{"jdbc:db2:", "", "COM.ibm.db2.jdbc.app.DB2Driver", "0", null, null, null});
    }
}

