/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class NormalizeResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public NoPutResultSet source;
    private ExecRow normalizedRow;
    private int numCols;
    private int startCol;
    private final DataValueDescriptor[] cachedDestinations;
    private ResultDescription resultDescription;
    private DataTypeDescriptor[] desiredTypes;

    public NormalizeResultSet(NoPutResultSet source, Activation activation, int resultSetNumber, int erdNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost, boolean forUpdate) throws StandardException {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.source = source;
        if (!(activation.getPreparedStatement().getSavedObject(erdNumber) instanceof ResultDescription)) {
            SanityManager.THROWASSERT("activation.getPreparedStatement().getSavedObject(erdNumber) expected to be instanceof ResultDescription");
        }
        SanityManager.ASSERT(source != null, "NRS(), source expected to be non-null");
        this.resultDescription = (ResultDescription)activation.getPreparedStatement().getSavedObject(erdNumber);
        this.numCols = this.resultDescription.getColumnCount();
        this.startCol = NormalizeResultSet.computeStartColumn(forUpdate, this.resultDescription);
        this.normalizedRow = activation.getExecutionFactory().getValueRow(this.numCols);
        this.cachedDestinations = new DataValueDescriptor[this.numCols];
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(!this.isOpen, "NormalizeResultSet already open");
        SanityManager.ASSERT(this.source != null, "NRS().openCore(), source expected to be non-null");
        this.source.openCore();
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(this.isOpen, "NormalizeResultSet already open");
        this.source.reopenCore();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow sourceRow = null;
        ExecRow result = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        sourceRow = this.source.getNextRowCore();
        if (sourceRow != null) {
            result = this.normalizeRow(sourceRow);
            ++this.rowsSeen;
        }
        this.setCurrentRow(result);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return result;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.currentRow = null;
            this.source.close();
            super.close();
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of NormalizeResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime - this.source.getTimeSpent(1);
        }
        return totTime;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        SanityManager.ASSERT(this.source instanceof CursorResultSet, "source is not a cursorresultset");
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    @Override
    public ExecRow getCurrentRow() {
        return this.currentRow;
    }

    public static int computeStartColumn(boolean isUpdate, ResultDescription desc) {
        int count = desc.getColumnCount();
        return isUpdate ? (count - 1) / 2 + 1 : 1;
    }

    public static DataValueDescriptor normalizeColumn(DataTypeDescriptor dtd, ExecRow sourceRow, int sourceColumnPosition, DataValueDescriptor resultCol, ResultDescription desc) throws StandardException {
        DataValueDescriptor sourceCol = sourceRow.getColumn(sourceColumnPosition);
        try {
            DataValueDescriptor returnValue = dtd.normalize(sourceCol, resultCol);
            return returnValue;
        }
        catch (StandardException se) {
            if (se.getMessageId().startsWith("23502")) {
                ResultColumnDescriptor columnDescriptor = desc.getColumnDescriptor(sourceColumnPosition);
                throw StandardException.newException("23502", columnDescriptor.getName());
            }
            throw se;
        }
    }

    private ExecRow normalizeRow(ExecRow sourceRow) throws StandardException {
        int count = this.resultDescription.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            DataValueDescriptor sourceCol = sourceRow.getColumn(i);
            if (sourceCol == null) continue;
            DataValueDescriptor normalizedCol = i < this.startCol ? sourceCol : NormalizeResultSet.normalizeColumn(this.getDesiredType(i), sourceRow, i, this.getCachedDestination(i), this.resultDescription);
            this.normalizedRow.setColumn(i, normalizedCol);
        }
        return this.normalizedRow;
    }

    private DataValueDescriptor getCachedDestination(int col) throws StandardException {
        int index = col - 1;
        if (this.cachedDestinations[index] == null) {
            this.cachedDestinations[index] = this.getDesiredType(col).getNull();
        }
        return this.cachedDestinations[index];
    }

    private DataTypeDescriptor getDesiredType(int col) {
        if (this.desiredTypes == null) {
            this.desiredTypes = this.fetchResultTypes(this.resultDescription);
        }
        return this.desiredTypes[col - 1];
    }

    private DataTypeDescriptor[] fetchResultTypes(ResultDescription desc) {
        int count = desc.getColumnCount();
        DataTypeDescriptor[] result = new DataTypeDescriptor[count];
        for (int i = 1; i <= count; ++i) {
            DataTypeDescriptor dtd;
            ResultColumnDescriptor colDesc = desc.getColumnDescriptor(i);
            result[i - 1] = dtd = colDesc.getType();
        }
        return result;
    }

    @Override
    public void updateRow(ExecRow row, RowChanger rowChanger) throws StandardException {
        this.source.updateRow(row, rowChanger);
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
        this.source.markRowAsDeleted();
    }
}

