/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DerbyVersion;

abstract class UpgradeChange
extends BaseJDBCTestCase {
    static final ThreadLocal<Integer> phase = new ThreadLocal();
    static final ThreadLocal<int[]> oldVersion = new ThreadLocal();
    static final String SQLSTATE_NEED_UPGRADE = "XCL47";
    static final String[] PHASES = new String[]{"CREATE", "SOFT UPGRADE", "POST SOFT UPGRADE", "UPGRADE", "POST UPGRADE"};
    static final int PH_CREATE = 0;
    static final int PH_SOFT_UPGRADE = 1;
    static final int PH_POST_SOFT_UPGRADE = 2;
    static final int PH_HARD_UPGRADE = 3;
    static final int PH_POST_HARD_UPGRADE = 4;

    public UpgradeChange(String name) {
        super(name);
    }

    final int getPhase() {
        return phase.get();
    }

    final DerbyVersion getOldVersion() {
        return new DerbyVersion(this.getOldMajor(), this.getOldMinor(), this.getOldFixPack(), this.getOldPoint());
    }

    final int getOldMajor() {
        return oldVersion.get()[0];
    }

    final int getOldMinor() {
        return oldVersion.get()[1];
    }

    final int getOldFixPack() {
        return oldVersion.get()[2];
    }

    final int getOldPoint() {
        return oldVersion.get()[3];
    }

    boolean oldAtLeast(int requiredMajor, int requiredMinor) {
        if (this.getOldMajor() > requiredMajor) {
            return true;
        }
        return this.getOldMajor() == requiredMajor && this.getOldMinor() >= requiredMinor;
    }

    boolean oldLessThan(int major, int minor, int fixpack, int point) {
        int[] old = oldVersion.get();
        int[] version = new int[]{major, minor, fixpack, point};
        for (int i = 0; i < old.length; ++i) {
            if (old[i] < version[i]) {
                return true;
            }
            if (old[i] <= version[i]) continue;
            return false;
        }
        return false;
    }

    boolean oldIs(int requiredMajor, int requiredMinor, int requiredFixpack, int requiredPoint) {
        return this.getOldMajor() == requiredMajor && this.getOldMinor() == requiredMinor && this.getOldFixPack() == requiredFixpack && this.getOldPoint() == requiredPoint;
    }

    boolean oldIs(int requiredMajor, int requiredMinor) {
        return this.getOldMajor() == requiredMajor && this.getOldMinor() == requiredMinor;
    }

    String getPhaseString() {
        return PHASES[this.getPhase()];
    }

    String getOldVersionString() {
        return "( " + this.getOldMajor() + ", " + this.getOldMinor() + ", " + this.getOldFixPack() + ", " + this.getOldPoint() + " )";
    }
}

