/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memorydb;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Random;
import junit.framework.Test;
import org.apache.derby.shared.common.error.ShutdownException;
import org.apache.derbyTesting.functionTests.tests.memorydb.MemoryDbManager;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class DropWhileConnectingTest
extends BaseJDBCTestCase {
    public DropWhileConnectingTest(String name) {
        super(name);
    }

    public void testConcurrentAccessAndDrop() throws SQLException {
        String url = "jdbc:derby:memory:testDB";
        Connection con = MemoryDbManager.getSharedInstance().createDatabase("testDB");
        con.close();
        String threadsStr = DropWhileConnectingTest.getSystemProperty("derby.tests.threadCount");
        if (threadsStr == null) {
            threadsStr = "20";
        }
        int accessThreads = Integer.parseInt(threadsStr);
        DropWhileConnectingTest.println("threadCount=" + accessThreads);
        Report report = new Report(this.getFailureFolder(), accessThreads);
        for (int i = 0; i < accessThreads; ++i) {
            Thread t = new Thread(new AccessThread(report, "jdbc:derby:memory:testDB"));
            t.start();
        }
        report.start();
        DropWhileConnectingTest.sleep(2500L);
        try {
            MemoryDbManager.getSharedInstance().dropDatabase("testDB");
            DropWhileConnectingTest.fail((String)"Dropping database should have raised exception.");
        }
        catch (SQLException sqle) {
            DropWhileConnectingTest.assertSQLState("08006", sqle);
        }
        DropWhileConnectingTest.println("Drop database request executed.");
        while (!report.allThreadsDone()) {
            DropWhileConnectingTest.println("Waiting for " + report.remainingThreads() + " remaining thread(s) to finish...");
            DropWhileConnectingTest.sleep(500L);
        }
        DropWhileConnectingTest.assertFalse((String)report.toString(), (boolean)report.hasUnexpectedExceptions());
        DropWhileConnectingTest.println(report.toString());
    }

    public static Test suite() {
        return new BaseTestSuite(DropWhileConnectingTest.class);
    }

    private static class Report {
        private final Object sync = new Object();
        private boolean ready;
        private final File failureFolder;
        private PrintWriter writer;
        private final int[] accessCounts;
        private final Throwable[] exceptions;
        private int threadsDone;
        private boolean hasExceptions;

        public Report(File failureFolder, int accessThreads) {
            this.failureFolder = failureFolder;
            this.accessCounts = new int[accessThreads];
            this.exceptions = new Throwable[accessThreads];
        }

        public synchronized boolean hasUnexpectedExceptions() {
            return this.hasExceptions;
        }

        public synchronized void reportAccessCount(int id, int accessCount) {
            this.accessCounts[id] = accessCount;
            ++this.threadsDone;
        }

        public synchronized void reportError(int id, int accessCount, Throwable error) {
            this.reportAccessCount(id, accessCount);
            this.exceptions[id] = error;
            this.hasExceptions = true;
            this.dumpToFile(id, error);
        }

        public synchronized boolean allThreadsDone() {
            return this.threadsDone == this.accessCounts.length;
        }

        public synchronized int remainingThreads() {
            return this.accessCounts.length - this.threadsDone;
        }

        public Object getSync() {
            return this.sync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean ready() {
            Object object = this.sync;
            synchronized (object) {
                return this.ready;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Object object = this.sync;
            synchronized (object) {
                this.ready = true;
                this.sync.notifyAll();
            }
        }

        public synchronized String toString() {
            int totalAccessCount = 0;
            for (int i = 0; i < this.accessCounts.length; ++i) {
                int c = this.accessCounts[i];
                if (c <= 0) continue;
                totalAccessCount += c;
            }
            String sep = "\n";
            StringBuffer sb = new StringBuffer(sep + "Number of access threads: ").append(this.accessCounts.length).append(sep);
            sb.append("Access count: " + totalAccessCount).append(sep);
            if (this.hasExceptions) {
                sb.append("Exceptions (see " + this.failureFolder + "/exceptions.log):" + sep);
                for (int i = 0; i < this.exceptions.length; ++i) {
                    Throwable t = this.exceptions[i];
                    if (t instanceof SQLException) {
                        SQLException s = (SQLException)t;
                        sb.append("id=").append(i).append(" : (").append(s.getSQLState()).append(") ").append(s.getMessage()).append(sep);
                        continue;
                    }
                    if (t == null) continue;
                    sb.append("id=").append(i).append(" : (     ) ").append(t.getMessage()).append(sep);
                }
            }
            return sb.toString();
        }

        private void dumpToFile(int id, Throwable exception) {
            if (this.writer == null) {
                try {
                    this.writer = new PrintWriter(PrivilegedFileOpsForTests.getFileOutputStream(new File(this.failureFolder, "exceptions.log")));
                    this.writer.println(new Date());
                }
                catch (IOException ioe) {
                    BaseTestCase.alarm("Failed to create exception log file: " + ioe.getMessage());
                }
            }
            if (this.writer != null) {
                this.writer.println("-----");
                this.writer.println("id=" + id);
                this.writer.println("--");
                exception.printStackTrace(this.writer);
                this.writer.flush();
            }
        }
    }

    private static class AccessThread
    implements Runnable {
        private static final Object LOCK = new Object();
        private static int idCounter = 0;
        private static final boolean noWait;
        private final int id;
        private final Report master;
        private final String url;
        private final Random rnd = new Random();
        private boolean waited;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AccessThread(Report master, String url) {
            Object object = LOCK;
            synchronized (object) {
                this.id = idCounter++;
            }
            this.master = master;
            this.url = url + ";user=test;password=test";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int access = 0;
            Connection con = null;
            while (!this.master.ready()) {
                Object object = this.master.getSync();
                synchronized (object) {
                    try {
                        this.master.getSync().wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            try {
                while (true) {
                    this.waited = false;
                    try {
                        con = DriverManager.getConnection(this.url);
                        ++access;
                    }
                    catch (SQLException sqle) {
                        if (sqle.getSQLState().equals("XJ004")) {
                            this.master.reportAccessCount(this.id, access);
                            break;
                        }
                        if (sqle.getSQLState().equals("XJ005")) {
                            this.allowWait(false);
                            continue;
                        }
                        throw sqle;
                    }
                    try {
                        Statement stmt = con.createStatement();
                        this.allowWait(true);
                        ResultSet rs = stmt.executeQuery("select * from sys.systables order by random()");
                        this.allowWait(true);
                        while (rs.next()) {
                            this.allowWait(true);
                            rs.getString(1);
                        }
                        rs.close();
                        stmt.close();
                        con.close();
                        this.allowWait(false);
                    }
                    catch (SQLException sqle) {
                        if (sqle.getSQLState().equals("08003")) {
                            this.master.reportAccessCount(this.id, access);
                            continue;
                        }
                        if (sqle.getSQLState().equals("XJ001") && sqle.getMessage().indexOf("ShutdownException") != -1) {
                            this.master.reportAccessCount(this.id, access);
                            continue;
                        }
                        this.master.reportError(this.id, access, sqle);
                    }
                }
            }
            catch (Throwable t) {
                if (t instanceof ShutdownException) {
                    System.out.println("Got ShutdownException (extends RuntimeException)");
                    this.master.reportAccessCount(this.id, access);
                }
                this.master.reportError(this.id, access, t);
            }
        }

        private void allowWait(boolean onlyWaitOnce) {
            if (!noWait && (!this.waited && onlyWaitOnce || !onlyWaitOnce)) {
                int split = this.rnd.nextInt(100);
                if (split >= 97) {
                    BaseTestCase.sleep(100L + (long)(this.rnd.nextDouble() * 1200.0));
                    this.waited = true;
                } else if (split > 80) {
                    BaseTestCase.sleep((long)(this.rnd.nextDouble() * 100.0));
                    this.waited = true;
                }
            }
        }

        static {
            String tmp = DropWhileConnectingTest.getSystemProperty("derby.tests.noWait");
            noWait = Boolean.valueOf(tmp);
            BaseTestCase.println("noWait=" + noWait);
        }
    }
}

