/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest;
import org.apache.derbyTesting.functionTests.tests.lang.ModeAggregate;
import org.apache.derbyTesting.functionTests.util.streams.ByteAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.functionTests.util.streams.ReadOnceByteArrayInputStream;
import org.apache.derbyTesting.functionTests.util.streams.StringReaderWithLength;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.XML;

public class TriggerTest
extends BaseJDBCTestCase {
    private static final String SYNTAX_ERROR = "42X01";
    private static final String HAS_DEPENDENT_SPS = "X0Y24";
    private static final String HAS_DEPENDENT_TRIGGER = "X0Y25";
    private static final String TRIGGER_DROPPED = "01502";
    private static final String FOREIGN_KEY_VIOLATION = "23503";
    private static ThreadLocal<List<String>> TRIGGER_INFO = new ThreadLocal();
    StringBuffer listOfCreatedTriggers = new StringBuffer();

    public TriggerTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(TriggerTest.class));
    }

    @Override
    protected void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    protected void setUp() throws Exception {
        JDBC.dropSchema(this.getConnection().getMetaData(), this.getTestConfiguration().getUserName());
        Statement s = this.createStatement();
        s.executeUpdate("CREATE PROCEDURE TRIGGER_LOG_INFO(O VARCHAR(255)) NO SQL PARAMETER STYLE JAVA LANGUAGE JAVA EXTERNAL NAME '" + ((Object)((Object)this)).getClass().getName() + ".logTriggerInfo'");
        s.close();
    }

    @Override
    protected void tearDown() throws Exception {
        TRIGGER_INFO.set(null);
        super.tearDown();
    }

    public void testDerby6383StatementTriggerBugTst1() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE DERBY_6368_TAB1 (X INTEGER, Y INTEGER)");
        s.executeUpdate("CREATE TABLE DERBY_6368_TAB2 (X INTEGER, Y INTEGER)");
        s.executeUpdate("INSERT INTO  DERBY_6368_TAB1 VALUES(1, 2)");
        s.executeUpdate("CREATE TRIGGER t1 AFTER UPDATE OF x ON DERBY_6368_TAB1 REFERENCING old table AS old INSERT INTO DERBY_6368_TAB2 SELECT * FROM old");
        this.assertTableRowCount("DERBY_6368_TAB2", 0);
        s.executeUpdate("UPDATE DERBY_6368_TAB1 SET y = y + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 0);
        s.executeUpdate("CREATE TRIGGER t2 AFTER UPDATE OF x ON DERBY_6368_TAB1 REFERENCING old AS old_row for each row INSERT INTO DERBY_6368_TAB2(x) values(old_row.x)");
        s.executeUpdate("UPDATE DERBY_6368_TAB1 SET y = y + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 0);
        s.executeUpdate("UPDATE DERBY_6368_TAB1 SET x = x + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 2);
        s.executeUpdate("CREATE TRIGGER t3 AFTER UPDATE ON DERBY_6368_TAB1 REFERENCING old table AS old INSERT INTO DERBY_6368_TAB2 SELECT * FROM old");
        s.executeUpdate("UPDATE DERBY_6368_TAB1 SET y = y + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 3);
        s.executeUpdate("UPDATE DERBY_6368_TAB1 SET x = x + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 6);
        s.executeUpdate("ALTER TABLE DERBY_6368_TAB1 ADD COLUMN Z int");
        s.executeUpdate("ALTER TABLE DERBY_6368_TAB2 ADD COLUMN Z int");
        s.executeUpdate("UPDATE DERBY_6368_TAB1 SET z = z + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 7);
        s.executeUpdate("UPDATE DERBY_6368_TAB1 SET y = y + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 8);
        s.executeUpdate("UPDATE DERBY_6368_TAB1 SET x = x + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 11);
        s.executeUpdate("drop TRIGGER T1");
        s.executeUpdate("UPDATE DERBY_6368_TAB1 SET y = y + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 12);
        s.executeUpdate("UPDATE DERBY_6368_TAB1 SET x = x + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 14);
        s.executeUpdate("UPDATE DERBY_6368_TAB1 SET z = z + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 15);
        s.executeUpdate("ALTER TABLE DERBY_6368_TAB1 DROP COLUMN Y");
        s.executeUpdate("ALTER TABLE DERBY_6368_TAB2 DROP COLUMN Y");
        s.executeUpdate("UPDATE DERBY_6368_TAB1 SET x = x + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 16);
        s.executeUpdate("UPDATE DERBY_6368_TAB1 SET z = z + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 16);
        s.executeUpdate("drop table DERBY_6368_TAB1");
        s.executeUpdate("drop table DERBY_6368_TAB2");
    }

    public void testDerby6383StatementTriggerBugTst2() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE DERBY_6368_TAB1 (X INTEGER, Y INTEGER)");
        s.executeUpdate("CREATE TABLE DERBY_6368_TAB2 (X INTEGER, Y INTEGER)");
        s.executeUpdate("INSERT INTO  DERBY_6368_TAB1 VALUES(1, 2)");
        s.executeUpdate("CREATE TRIGGER t1 AFTER UPDATE ON DERBY_6368_TAB1 REFERENCING old table AS old INSERT INTO DERBY_6368_TAB2 SELECT * FROM old");
        this.assertTableRowCount("DERBY_6368_TAB2", 0);
        s.executeUpdate("UPDATE DERBY_6368_TAB1 SET x = x + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 1);
        s.executeUpdate("UPDATE DERBY_6368_TAB1 SET y = y + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 2);
        s.executeUpdate("ALTER TABLE DERBY_6368_TAB1 ADD COLUMN Z int");
        s.executeUpdate("ALTER TABLE DERBY_6368_TAB2 ADD COLUMN Z int");
        s.executeUpdate("UPDATE DERBY_6368_TAB1 SET z = z + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 3);
        s.executeUpdate("ALTER TABLE DERBY_6368_TAB1 DROP COLUMN X");
        s.executeUpdate("ALTER TABLE DERBY_6368_TAB2 DROP COLUMN X");
        s.executeUpdate("UPDATE DERBY_6368_TAB1 SET z = z + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 3);
        s.executeUpdate("drop table DERBY_6368_TAB1");
        s.executeUpdate("drop table DERBY_6368_TAB2");
    }

    public void testDerby6726() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE LOG (ID BIGINT NOT NULL PRIMARY KEY    GENERATED ALWAYS AS IDENTITY    (START WITH 1, INCREMENT BY 1),NAME VARCHAR(80) DEFAULT 'New Log' NOT NULL,VERSION INT NOT NULL,DEPTH_UNITS VARCHAR(12) DEFAULT 'M',TOP_DEPTH DOUBLE DEFAULT -999.25,BOTTOM_DEPTH DOUBLE DEFAULT -999.25)");
        s.executeUpdate("CREATE TABLE CURVE (ID BIGINT NOT NULL PRIMARY KEY    GENERATED ALWAYS AS IDENTITY    (START WITH 1, INCREMENT BY 1),LOG_ID BIGINT NOT NULL,NAME VARCHAR(80) DEFAULT 'New Curve' NOT NULL,TYPE VARCHAR(40) DEFAULT '.' NOT NULL,VERSION INT NOT NULL,PERSISTENCE VARCHAR(40) DEFAULT 'NUMBER',DEPTH_UNITS VARCHAR(12) DEFAULT 'M',CURVE_UNITS VARCHAR(40) DEFAULT '.',TOP_DEPTH DOUBLE DEFAULT -999.25,BOTTOM_DEPTH DOUBLE DEFAULT -999.25,MINCVAL DOUBLE DEFAULT -999.25,MAXCVAL DOUBLE DEFAULT -999.25,CREATED_BY VARCHAR(40) DEFAULT USER,CREATE_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP,LAST_UPDATED TIMESTAMP DEFAULT CURRENT_TIMESTAMP)");
        s.executeUpdate("CREATE TRIGGER CURVE_TRIG_LAST  AFTER UPDATE OF NAME, TYPE, VERSION, PERSISTENCE,        DEPTH_UNITS, CURVE_UNITS, TOP_DEPTH,        BOTTOM_DEPTH, MINCVAL, MAXCVAL ON CURVE  REFERENCING OLD AS UPDATEDROW  FOR EACH ROW     UPDATE CURVE SET LAST_UPDATED=CURRENT_TIMESTAMP            WHERE ID=UPDATEDROW.ID");
        s.executeUpdate("CREATE TRIGGER CURVE_TRIG_UP  AFTER UPDATE OF TOP_DEPTH, BOTTOM_DEPTH ON CURVE  REFERENCING OLD AS UPDATEDROW  FOR EACH ROW     UPDATE LOG SET         TOP_DEPTH=(            SELECT MIN(TOP_DEPTH) FROM CURVE                    WHERE LOG_ID=UPDATEDROW.LOG_ID AND                          TOP_DEPTH<>-999.25),         BOTTOM_DEPTH=(            SELECT MAX(BOTTOM_DEPTH) FROM CURVE                    WHERE LOG_ID=UPDATEDROW.LOG_ID AND                          BOTTOM_DEPTH<>-999.25)         WHERE ID=UPDATEDROW.LOG_ID");
        s.executeUpdate("CREATE TABLE CURVE_DATA_NUMBER (CURVE_ID BIGINT NOT NULL,SEQ_NUM BIGINT NOT NULL,MDEPTH DOUBLE,CVALUE DOUBLE DEFAULT -999.25)");
        s.executeUpdate("ALTER TABLE CURVE_DATA_NUMBER   ADD CONSTRAINT CURVE_DATA_NUMBER_CURVE_ID_FK       FOREIGN KEY (CURVE_ID) REFERENCES CURVE (ID)       ON DELETE CASCADE");
        s.executeUpdate("ALTER TABLE CURVE_DATA_NUMBER   ADD CONSTRAINT CURVE_DATA_NUMBER_UN       UNIQUE (CURVE_ID, SEQ_NUM)");
        s.executeUpdate("CREATE INDEX CURVE_DATA_NUMBER_SEQ_NUM_INDEX   on CURVE_DATA_NUMBER (SEQ_NUM)");
        s.executeUpdate("CREATE TRIGGER CURVE_DATA_NUMBER_TRIG_UP  AFTER UPDATE OF CURVE_ID, SEQ_NUM, MDEPTH, CVALUE        ON CURVE_DATA_NUMBER  REFERENCING OLD AS UPDATEDROW  FOR EACH ROW     UPDATE CURVE SET         TOP_DEPTH=(            SELECT MIN(MDEPTH) FROM CURVE_DATA_NUMBER                    WHERE CURVE_ID=UPDATEDROW.CURVE_ID AND                    MDEPTH<>-999.25),        BOTTOM_DEPTH=(            SELECT MAX(MDEPTH) FROM CURVE_DATA_NUMBER                    WHERE CURVE_ID=UPDATEDROW.CURVE_ID AND                    MDEPTH<>-999.25),        MINCVAL=(            SELECT MIN(CVALUE) FROM CURVE_DATA_NUMBER                    WHERE CURVE_ID=UPDATEDROW.CURVE_ID AND                    CVALUE<>-999.25),        MAXCVAL=(            SELECT MAX(CVALUE) FROM CURVE_DATA_NUMBER                    WHERE CURVE_ID=UPDATEDROW.CURVE_ID AND                    CVALUE<>-999.25)     WHERE ID=UPDATEDROW.CURVE_ID");
        s.executeUpdate("INSERT INTO LOG (NAME, VERSION) VALUES('TESTLOG',1)");
        s.executeUpdate("INSERT INTO CURVE(LOG_ID,NAME,VERSION) VALUES(1,'GR',1)");
        PreparedStatement ps = this.prepareStatement("INSERT INTO CURVE_DATA_NUMBER    (CURVE_ID, SEQ_NUM, MDEPTH, CVALUE)    VALUES(?,?,?,?)");
        for (int i = 1; i < 1000; ++i) {
            ps.setInt(1, 1);
            ps.setInt(2, i);
            ps.setDouble(3, 1000.0 + (double)i);
            ps.setDouble(4, 43.0 + (double)i);
            ps.executeUpdate();
        }
        s.executeUpdate("UPDATE CURVE_DATA_NUMBER   SET CURVE_ID=1 WHERE CURVE_ID=1 AND SEQ_NUM=1");
        s.executeUpdate("DROP TRIGGER CURVE_DATA_NUMBER_TRIG_UP");
        s.executeUpdate("DROP TRIGGER CURVE_TRIG_UP");
        s.executeUpdate("DROP TRIGGER CURVE_TRIG_LAST");
        s.executeUpdate("ALTER TABLE CURVE_DATA_NUMBER  DROP CONSTRAINT CURVE_DATA_NUMBER_CURVE_ID_FK");
        s.executeUpdate("ALTER TABLE CURVE_DATA_NUMBER  DROP CONSTRAINT CURVE_DATA_NUMBER_UN");
        s.executeUpdate("DROP INDEX CURVE_DATA_NUMBER_SEQ_NUM_INDEX");
        s.executeUpdate("DROP TABLE LOG");
        s.executeUpdate("DROP TABLE CURVE");
        s.executeUpdate("DROP TABLE CURVE_DATA_NUMBER");
    }

    public void testDerby5578InvalidateAllStatementsProc() throws SQLException {
        Statement s = this.createStatement();
        CallableStatement cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_INVALIDATE_STORED_STATEMENTS()");
        TriggerTest.assertUpdateCount(cSt, 0);
        cSt.close();
        int numOfRowsInSystatementsBeforeTestStart = this.numberOfRowsInSysstatements(s);
        int numOfInvalidSystatementsBeforeTestStart = this.numberOfInvalidStatementsInSysstatements(s);
        int numOfValidSystatementsBeforeTestStart = this.numberOfValidStatementsInSysstatements(s);
        TriggerTest.assertEquals((String)"All statements should be invalid in SYS.SYSSTATEMENTS ", (int)numOfInvalidSystatementsBeforeTestStart, (int)numOfRowsInSystatementsBeforeTestStart);
        TriggerTest.assertEquals((String)"No statement should be valid in SYS.SYSSTATEMENTS ", (int)numOfValidSystatementsBeforeTestStart, (int)0);
        s.executeUpdate("create table atdc_16_tab1 (a1 integer, b1 integer, c1 integer)");
        s.executeUpdate("create table atdc_16_tab2 (a2 integer, b2 integer, c2 integer)");
        s.executeUpdate("insert into atdc_16_tab1 values(1,11,111)");
        s.executeUpdate("insert into atdc_16_tab2 values(1,11,111)");
        TriggerTest.assertEquals((String)"# of valid statements in SYS.SYSSTATEMENTS should not change", (int)this.numberOfValidStatementsInSysstatements(s), (int)numOfValidSystatementsBeforeTestStart);
        TriggerTest.assertEquals((String)"# of invalid statements in SYS.SYSSTATEMENTS should not change", (int)this.numberOfInvalidStatementsInSysstatements(s), (int)numOfInvalidSystatementsBeforeTestStart);
        s.executeUpdate("create trigger atdc_16_trigger_1 after update of b1 on atdc_16_tab1 REFERENCING NEW AS newt for each row update atdc_16_tab2 set c2 = newt.c1");
        TriggerTest.assertEquals((String)"# of valid rows in SYS.SYSSTATEMENTS should be up by 1 for trigger", (int)this.numberOfValidStatementsInSysstatements(s), (int)(numOfValidSystatementsBeforeTestStart + 1));
        TriggerTest.assertEquals((String)"# of invalid statements in SYS.SYSSTATEMENTS should not change", (int)this.numberOfInvalidStatementsInSysstatements(s), (int)numOfInvalidSystatementsBeforeTestStart);
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_INVALIDATE_STORED_STATEMENTS()");
        TriggerTest.assertUpdateCount(cSt, 0);
        cSt.close();
        TriggerTest.assertEquals((String)"All statements should be invalid in SYS.SYSSTATEMENTS ", (int)this.numberOfInvalidStatementsInSysstatements(s), (int)(numOfRowsInSystatementsBeforeTestStart + 1));
        s.executeUpdate("update atdc_16_tab1 set b1=22,c1=222");
        TriggerTest.assertEquals((String)"# of valid rows in SYS.SYSSTATEMENTS should only be 1 ", (int)this.numberOfValidStatementsInSysstatements(s), (int)1);
        TriggerTest.assertEquals((String)"# of invalid statements in SYS.SYSSTATEMENTS should not change", (int)this.numberOfInvalidStatementsInSysstatements(s), (int)numOfInvalidSystatementsBeforeTestStart);
        DatabaseMetaData dbmd = this.getConnection().getMetaData();
        JDBC.assertDrainResults(dbmd.getTables(null, "APP", "ATDC_16_TAB1", null));
        TriggerTest.assertEquals((String)"# of valid rows in SYS.SYSSTATEMENTS should only be 2 ", (int)this.numberOfValidStatementsInSysstatements(s), (int)2);
        TriggerTest.assertEquals((String)"# of invalid statements in SYS.SYSSTATEMENTS should not change", (int)this.numberOfInvalidStatementsInSysstatements(s), (int)(numOfInvalidSystatementsBeforeTestStart - 1));
        s.executeUpdate("drop table ATDC_16_TAB1");
    }

    private int numberOfInvalidStatementsInSysstatements(Statement st) throws SQLException {
        ResultSet rs = st.executeQuery("SELECT COUNT(*) FROM SYS.SYSSTATEMENTS WHERE VALID = false");
        rs.next();
        int num = rs.getInt(1);
        rs.close();
        return num;
    }

    private int numberOfValidStatementsInSysstatements(Statement st) throws SQLException {
        ResultSet rs = st.executeQuery("SELECT COUNT(*) FROM SYS.SYSSTATEMENTS WHERE VALID = TRUE");
        rs.next();
        int num = rs.getInt(1);
        rs.close();
        return num;
    }

    private int numberOfRowsInSysstatements(Statement st) throws SQLException {
        ResultSet rs = st.executeQuery("SELECT COUNT(*) FROM SYS.SYSSTATEMENTS");
        rs.next();
        int num = rs.getInt(1);
        rs.close();
        return num;
    }

    public void testAlerColumnLength() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE TestAlterTable( element_id INTEGER NOT NULL, altered_id VARCHAR(30) NOT NULL, counter SMALLINT NOT NULL DEFAULT 0, timets TIMESTAMP NOT NULL)");
        s.executeUpdate("CREATE TRIGGER mytrig AFTER UPDATE ON TestAlterTable REFERENCING NEW AS newt OLD AS oldt FOR EACH ROW MODE DB2SQL   UPDATE TestAlterTable set   TestAlterTable.counter = CASE WHEN   (oldt.counter < 32767) THEN (oldt.counter + 1) ELSE 1 END   WHERE ((newt.counter is null) or   (oldt.counter = newt.counter))   AND newt.element_id = TestAlterTable.element_id   AND newt.altered_id = TestAlterTable.altered_id");
        s.executeUpdate("ALTER TABLE TestAlterTable ALTER altered_id SET DATA TYPE VARCHAR(64)");
        s.executeUpdate("insert into TestAlterTable values (99, '012345678901234567890123456789001234567890',1,CURRENT_TIMESTAMP)");
        ResultSet rs = s.executeQuery("SELECT element_id, counter FROM TestAlterTable");
        JDBC.assertFullResultSet(rs, new String[][]{{"99", "1"}});
        s.executeUpdate("update TestAlterTable set timets = CURRENT_TIMESTAMP where ELEMENT_ID = 99");
        rs = s.executeQuery("SELECT element_id, counter FROM TestAlterTable");
        JDBC.assertFullResultSet(rs, new String[][]{{"99", "2"}});
        s.executeUpdate("DROP TABLE TestAlterTable");
    }

    public void testFiringOrder() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE T(ID INT)");
        int triggerCount = this.createRandomTriggers()[0];
        ArrayList info = new ArrayList();
        TRIGGER_INFO.set(info);
        s.execute("INSERT INTO T VALUES 1");
        this.commit();
        int fireCount = this.assertFiringOrder("INSERT", 1);
        info.clear();
        s.execute("UPDATE T SET ID = 2");
        this.commit();
        fireCount += this.assertFiringOrder("UPDATE", 1);
        info.clear();
        s.execute("DELETE FROM T");
        this.commit();
        info.clear();
        TriggerTest.assertEquals((String)"All triggers fired?", (int)triggerCount, (int)(fireCount += this.assertFiringOrder("DELETE", 1)));
        s.execute("INSERT INTO T VALUES 1,2,3");
        this.commit();
        fireCount = this.assertFiringOrder("INSERT", 3);
        info.clear();
        s.execute("UPDATE T SET ID = 2");
        this.commit();
        fireCount += this.assertFiringOrder("UPDATE", 3);
        info.clear();
        s.execute("DELETE FROM T");
        this.commit();
        info.clear();
        TriggerTest.assertTrue((String)"Sufficient triggers fired?", ((fireCount += this.assertFiringOrder("DELETE", 3)) >= triggerCount ? 1 : 0) != 0);
        this.assertTableRowCount("T", 0);
        s.execute("INSERT INTO T SELECT ID FROM T");
        this.commit();
        fireCount = this.assertFiringOrder("INSERT", 0);
        info.clear();
        s.execute("UPDATE T SET ID = 2");
        this.commit();
        fireCount += this.assertFiringOrder("UPDATE", 0);
        info.clear();
        s.execute("DELETE FROM T");
        this.commit();
        fireCount += this.assertFiringOrder("DELETE", 0);
        info.clear();
        s.close();
    }

    private int[] createRandomTriggers() throws SQLException {
        Statement s = this.createStatement();
        int beforeCount = 0;
        int afterCount = 0;
        Random r = new Random();
        int triggerCount = r.nextInt(45) + 45;
        this.listOfCreatedTriggers = new StringBuffer();
        for (int i = 0; i < triggerCount; ++i) {
            String before;
            StringBuffer sb = new StringBuffer();
            sb.append("CREATE TRIGGER TR");
            sb.append(i);
            sb.append(" ");
            if (r.nextInt(2) == 0) {
                before = "NO CASCADE BEFORE";
                ++beforeCount;
            } else {
                before = "AFTER";
                ++afterCount;
            }
            sb.append(before);
            sb.append(" ");
            int type = r.nextInt(3);
            String iud = type == 0 ? "INSERT" : (type == 1 ? "UPDATE" : "DELETE");
            sb.append(iud);
            sb.append(" ON T FOR EACH ");
            String row = r.nextInt(2) == 0 ? "ROW" : "STATEMENT";
            sb.append(row);
            sb.append(" ");
            sb.append("CALL TRIGGER_LOG_INFO('");
            sb.append(i);
            sb.append(",");
            sb.append(before);
            sb.append(",");
            sb.append(iud);
            sb.append(",");
            sb.append(row);
            sb.append("')");
            s.execute(sb.toString());
            this.listOfCreatedTriggers.append(sb.toString());
        }
        this.commit();
        s.close();
        return new int[]{triggerCount, beforeCount, afterCount};
    }

    public void testFiringConstraintOrder() throws SQLException {
        Statement s = this.createStatement();
        s.execute("CREATE TABLE T (I INT PRIMARY KEY,U INT NOT NULL UNIQUE, C INT CHECK (C < 20))");
        s.execute("INSERT INTO T VALUES(1,5,10)");
        s.execute("INSERT INTO T VALUES(11,19,3)");
        s.execute("CREATE TABLE TCHILD (I INT, FOREIGN KEY (I) REFERENCES T)");
        s.execute("INSERT INTO TCHILD VALUES 1");
        this.commit();
        int beforeCount = this.createRandomTriggers()[1];
        ArrayList info = new ArrayList();
        TRIGGER_INFO.set(info);
        TriggerTest.assertStatementError("23505", s, "INSERT INTO T VALUES (1,6,10)");
        this.assertFiringOrder("INSERT", 1, true);
        info.clear();
        TriggerTest.assertStatementError("23505", s, "UPDATE T SET I=1 WHERE I = 11");
        this.assertFiringOrder("UPDATE", 1, true);
        info.clear();
        this.rollback();
        TriggerTest.assertStatementError("23505", s, "INSERT INTO T VALUES (2,5,10)");
        this.assertFiringOrder("INSERT", 1, true);
        info.clear();
        TriggerTest.assertStatementError("23505", s, "UPDATE T SET U=5 WHERE I = 11");
        this.assertFiringOrder("UPDATE", 1, true);
        info.clear();
        this.rollback();
        TriggerTest.assertStatementError("23513", s, "INSERT INTO T VALUES (2,6,22)");
        this.assertFiringOrder("INSERT", 1, true);
        info.clear();
        TriggerTest.assertStatementError("23513", s, "UPDATE T SET C=C+40 WHERE I = 11");
        this.assertFiringOrder("UPDATE", 1, true);
        info.clear();
        this.rollback();
        TriggerTest.assertStatementError(FOREIGN_KEY_VIOLATION, s, "DELETE FROM T WHERE I = 1");
        this.assertFiringOrder("DELETE", 1, true);
        s.close();
        this.commit();
    }

    private int assertFiringOrder(String iud, int modifiedRowCount) {
        return this.assertFiringOrder(iud, modifiedRowCount, false);
    }

    private int assertFiringOrder(String iud, int modifiedRowCount, boolean noAfter) {
        List<String> fires = TRIGGER_INFO.get();
        int lastOrder = -1;
        String lastBefore = null;
        Iterator<String> i = fires.iterator();
        while (i.hasNext()) {
            String info = i.next().toString();
            StringTokenizer st = new StringTokenizer(info, ",");
            TriggerTest.assertEquals((int)4, (int)st.countTokens());
            st.hasMoreTokens();
            int order = Integer.valueOf(st.nextToken());
            st.hasMoreTokens();
            String before = st.nextToken();
            st.hasMoreTokens();
            String fiud = st.nextToken();
            st.hasMoreTokens();
            String row = st.nextToken();
            TriggerTest.assertEquals((String)("Incorrect trigger firing:" + info), (String)iud, (String)fiud);
            if (modifiedRowCount == 0) {
                TriggerTest.assertEquals((String)"Row trigger firing on no rows", (String)"STATEMENT", (String)row);
            }
            if (noAfter) {
                TriggerTest.assertFalse((String)"No AFTER triggers", (boolean)"AFTER".equals(before));
            }
            if (lastOrder == -1) {
                lastOrder = order;
                lastBefore = before;
                continue;
            }
            if (lastBefore.equals(before)) {
                boolean orderOk = modifiedRowCount > 1 ? order >= lastOrder : order > lastOrder;
                TriggerTest.assertTrue((String)("matching triggers need to be fired in order creation:" + info + ". Triggers got fired in this order:" + TRIGGER_INFO.get().toString() + ". Tiggers got created in this order:" + this.listOfCreatedTriggers.toString()), (boolean)orderOk);
                lastOrder = order;
                continue;
            }
            TriggerTest.assertEquals((String)("BEFORE before AFTER:" + info), (String)"NO CASCADE BEFORE", (String)lastBefore);
            TriggerTest.assertEquals((String)("then AFTER:" + info), (String)"AFTER", (String)before);
            lastBefore = before;
            lastOrder = order;
        }
        return fires.size();
    }

    public static void logTriggerInfo(String info) {
        TRIGGER_INFO.get().add(info);
    }

    public void testNPEinTriggerFire() throws SQLException {
        Statement s = this.createStatement();
        String sql = " CREATE TABLE TRADE(ID INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY (START WITH 1000), BUYID INT NOT NULL,QTY FLOAT(2) NOT NULL)";
        s.executeUpdate(sql);
        sql = "CREATE TABLE TOTAL(BUYID INT NOT NULL, TOTALQTY FLOAT(2) NOT NULL)";
        s.executeUpdate(sql);
        sql = "CREATE TRIGGER TRADE_INSERT AFTER INSERT ON TRADE REFERENCING NEW AS NEWROW FOR EACH ROW MODE DB2SQL UPDATE TOTAL SET TOTALQTY = NEWROW.QTY WHERE BUYID = NEWROW.BUYID";
        s.executeUpdate(sql);
        s.executeUpdate("INSERT INTO TOTAL VALUES (1, 0)");
        s.executeUpdate("INSERT INTO TRADE VALUES(1, 1, 10)");
        this.commit();
    }

    public void testReadRequiredColumnsOnlyFromTriggerTable() throws SQLException, IOException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE table1 (c11 int, c12 int, c13 int, c14 int, c15 int)");
        s.executeUpdate("INSERT INTO table1 VALUES(1,2,3,4,5)");
        s.executeUpdate("CREATE TABLE table2 (c21 int, c22 int, c23 int, c24 int, c25 int)");
        s.executeUpdate("INSERT INTO table2 VALUES(2,2,3,-1,5)");
        s.executeUpdate("CREATE TRIGGER tr1 AFTER UPDATE OF c12 ON table1  REFERENCING OLD AS oldt NEW AS newt FOR EACH ROW UPDATE table2 SET c24=oldt.c14");
        this.commit();
        s.executeUpdate("update table1 set c12 = -9 where c11=1");
        ResultSet rs = s.executeQuery("SELECT * FROM table2");
        String[][] result = new String[][]{{"2", "2", "3", "4", "5"}};
        JDBC.assertFullResultSet(rs, result);
        String triggerStmt = "CREATE TRIGGER tr1 AFTER UPDATE OF c12xxx ON table1  REFERENCING OLD AS oldt NEW AS newt FOR EACH ROW UPDATE table2 SET c24=oldt.c14";
        TriggerTest.assertStatementError("42X14", s, triggerStmt);
        triggerStmt = "CREATE TRIGGER tr1 AFTER UPDATE OF c12 ON table1  REFERENCING OLD AS oldt NEW AS newt FOR EACH ROW UPDATE table2 SET c24=oldt.c14xxx";
        TriggerTest.assertStatementError("42X04", s, triggerStmt);
        s.executeUpdate("create table derby1482_lob1 (str1 Varchar(80), c_lob CLOB(50M))");
        s.executeUpdate("create table derby1482_lob1_log(oldvalue CLOB(50M), newvalue  CLOB(50M), chng_time timestamp default current_timestamp)");
        s.executeUpdate("create trigger tr1_derby1482_lob1 after update of c_lob on derby1482_lob1 REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL insert into derby1482_lob1_log(oldvalue, newvalue) values (old.c_lob, new.c_lob)");
        s.executeUpdate("INSERT INTO derby1482_lob1 VALUES ('1',null)");
        s.executeUpdate("update derby1482_lob1 set c_lob = null");
        rs = s.executeQuery("SELECT oldvalue, newvalue FROM derby1482_lob1_log");
        result = new String[][]{{null, null}};
        JDBC.assertFullResultSet(rs, result);
        s.executeUpdate("create table derby1482_selfUpdate (i int, j int)");
        s.executeUpdate("insert into derby1482_selfUpdate values (1,10)");
        s.executeUpdate("create trigger tr_derby1482_selfUpdate after update of i on derby1482_selfUpdate referencing old as old for each row update derby1482_selfUpdate set j = old.j+1");
        s.executeUpdate("update derby1482_selfUpdate set i=i+1");
        rs = s.executeQuery("SELECT * FROM derby1482_selfUpdate");
        result = new String[][]{{"2", "11"}};
        JDBC.assertFullResultSet(rs, result);
        s.executeUpdate("create table t1_noTriggerActionColumn (id int, status smallint)");
        s.executeUpdate("insert into t1_noTriggerActionColumn values(11,1)");
        s.executeUpdate("create table t2_noTriggerActionColumn (id int, updates int default 0)");
        s.executeUpdate("insert into t2_noTriggerActionColumn values(1,1)");
        s.executeUpdate("create trigger tr1_noTriggerActionColumn after update of status on t1_noTriggerActionColumn referencing new as n_row for each row update t2_noTriggerActionColumn set updates = updates + 1 where t2_noTriggerActionColumn.id = 1");
        s.executeUpdate("update t1_noTriggerActionColumn set status=-1");
        rs = s.executeQuery("SELECT * FROM t2_noTriggerActionColumn");
        result = new String[][]{{"1", "2"}};
        JDBC.assertFullResultSet(rs, result);
    }

    public void testDERBY5121() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE T1 (A1 int)");
        s.executeUpdate("CREATE TABLE T2 (B1 int, B2 int, B3 int)");
        s.executeUpdate("CREATE TRIGGER t2UpdateTrigger after UPDATE of b1 on t2 referencing new row as nr for each ROW insert into t1 values ( nr.b3 ) ");
        s.executeUpdate("INSERT INTO T2 VALUES(0,0,0)");
        s.executeUpdate("update t2 set b1 = 100 , b2 = 1");
        ResultSet rs = s.executeQuery("SELECT * FROM T1");
        JDBC.assertFullResultSet(rs, new String[][]{{"0"}});
        s.executeUpdate("CREATE TABLE T3 (A1 int)");
        s.executeUpdate("CREATE TABLE T4 (B1 int, B2 int, B3 int)");
        s.executeUpdate("CREATE TRIGGER t4UpdateTrigger after UPDATE of b1 on t4 referencing new table as nt for each STATEMENT insert into t3 select b3 from nt");
        s.executeUpdate("INSERT INTO T4 VALUES(0,0,0)");
        s.executeUpdate("update t4 set b1 = 100 , b2 = 1");
        rs = s.executeQuery("SELECT * FROM T3");
        JDBC.assertFullResultSet(rs, new String[][]{{"0"}});
    }

    public void testClobInTriggerTable() throws SQLException, IOException {
        this.testClobInTriggerTable(1024);
        this.testClobInTriggerTable(16384);
        this.testClobInTriggerTable(Short.MAX_VALUE);
        this.testClobInTriggerTable(32768);
        this.testClobInTriggerTable(32769);
        this.testClobInTriggerTable(65535);
        this.testClobInTriggerTable(65536);
        this.testClobInTriggerTable(65537);
    }

    private void testClobInTriggerTable(int clobSize) throws SQLException, IOException {
        CharAlphabet a1 = CharAlphabet.singleChar('a');
        CharAlphabet a2 = CharAlphabet.singleChar('b');
        Object trig = " create trigger t_lob1 after update of str1 on lob1 ";
        trig = (String)trig + " REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL ";
        trig = (String)trig + " insert into t_lob1_log(oldvalue, newvalue) values (old.str1, new.str1)";
        Statement s = this.createStatement();
        s.executeUpdate("create table LOB1 (str1 Varchar(80), c_lob CLOB(50M))");
        s.executeUpdate("create table t_lob1_log(oldvalue varchar(80), newvalue varchar(80), chng_time timestamp default current_timestamp)");
        s.executeUpdate((String)trig);
        this.commit();
        PreparedStatement ps = this.prepareStatement("INSERT INTO LOB1 VALUES (?, ?)");
        ps.setString(1, "" + clobSize);
        ps.setCharacterStream(2, (Reader)new LoopingAlphabetReader((long)clobSize, a1), clobSize);
        ps.execute();
        this.closeStatement(ps);
        this.commit();
        s.executeUpdate("update LOB1 set str1 = str1 || ' '");
        s.executeUpdate("drop table lob1");
        s.executeUpdate("drop table t_lob1_log");
        trig = " create trigger t_lob1 after update of c_lob on lob1 ";
        trig = (String)trig + " REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL ";
        trig = (String)trig + " insert into t_lob1_log(oldvalue, newvalue) values (old.c_lob, new.c_lob)";
        s.executeUpdate("create table LOB1 (str1 Varchar(80), c_lob CLOB(50M))");
        s.executeUpdate("create table t_lob1_log(oldvalue CLOB(50M), newvalue  CLOB(50M), chng_time timestamp default current_timestamp)");
        s.executeUpdate((String)trig);
        this.commit();
        ps = this.prepareStatement("INSERT INTO LOB1 VALUES (?, ?)");
        ps.setString(1, "" + clobSize);
        ps.setCharacterStream(2, (Reader)new LoopingAlphabetReader((long)clobSize, a1), clobSize);
        ps.execute();
        this.closeStatement(ps);
        this.commit();
        ps = this.prepareStatement("update LOB1 set c_lob = ?");
        ps.setCharacterStream(1, (Reader)new LoopingAlphabetReader((long)clobSize, a2), clobSize);
        ps.execute();
        this.closeStatement(ps);
        this.commit();
        s.executeUpdate("drop table lob1");
        s.executeUpdate("drop table t_lob1_log");
        trig = " create trigger t_lob1 after update of c_lob on lob1 ";
        trig = (String)trig + " REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL ";
        trig = (String)trig + " insert into t_lob1_log(oldvalue, newvalue, oldvalue_again, newvalue_again) values (old.c_lob, new.c_lob, old.c_lob, new.c_lob)";
        s.executeUpdate("create table LOB1 (str1 Varchar(80), c_lob CLOB(50M))");
        s.executeUpdate("create table t_lob1_log(oldvalue CLOB(50M), newvalue  CLOB(50M), oldvalue_again CLOB(50M), newvalue_again CLOB(50M), chng_time timestamp default current_timestamp)");
        s.executeUpdate((String)trig);
        this.commit();
        ps = this.prepareStatement("INSERT INTO LOB1 VALUES (?, ?)");
        ps.setString(1, "" + clobSize);
        ps.setCharacterStream(2, (Reader)new LoopingAlphabetReader((long)clobSize, a1), clobSize);
        ps.execute();
        this.closeStatement(ps);
        this.commit();
        ps = this.prepareStatement("update LOB1 set c_lob = ?");
        ps.setCharacterStream(1, (Reader)new LoopingAlphabetReader((long)clobSize, a2), clobSize);
        ps.execute();
        this.closeStatement(ps);
        this.commit();
        ResultSet rs = s.executeQuery("SELECT * from t_lob1_log");
        rs.next();
        TriggerTest.assertEquals(new LoopingAlphabetReader((long)clobSize, a1), rs.getCharacterStream(1));
        TriggerTest.assertEquals(new LoopingAlphabetReader((long)clobSize, a2), rs.getCharacterStream(2));
        TriggerTest.assertEquals(new LoopingAlphabetReader((long)clobSize, a1), rs.getCharacterStream(3));
        TriggerTest.assertEquals(new LoopingAlphabetReader((long)clobSize, a2), rs.getCharacterStream(4));
        rs.close();
        s.executeUpdate("drop table lob1");
        s.executeUpdate("drop table t_lob1_log");
    }

    public void testBlobInTriggerTable() throws SQLException, IOException {
        this.testBlobInTriggerTable(1024);
        this.testBlobInTriggerTable(16384);
        this.testBlobInTriggerTable(Short.MAX_VALUE);
        this.testBlobInTriggerTable(32768);
        this.testBlobInTriggerTable(32769);
        this.testBlobInTriggerTable(65535);
        this.testBlobInTriggerTable(65536);
        this.testBlobInTriggerTable(65537);
        this.testBlobInTriggerTable(0x700000);
    }

    private void testBlobInTriggerTable(int blobSize) throws SQLException, IOException {
        ByteAlphabet a1 = ByteAlphabet.singleByte((byte)8);
        ByteAlphabet a2 = ByteAlphabet.singleByte((byte)9);
        Object trig = " create trigger t_lob1 after update of str1 on lob1 ";
        trig = (String)trig + " REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL ";
        trig = (String)trig + " insert into t_lob1_log(oldvalue, newvalue) values (old.str1, new.str1)";
        Statement s = this.createStatement();
        s.executeUpdate("create table LOB1 (str1 Varchar(80), b_lob BLOB(50M), b_lob2 BLOB(50M))");
        s.executeUpdate("create table t_lob1_log(oldvalue varchar(80), newvalue varchar(80), chng_time timestamp default current_timestamp)");
        s.executeUpdate((String)trig);
        this.commit();
        PreparedStatement ps = this.prepareStatement("INSERT INTO LOB1 VALUES (?, ?, ?)");
        ps.setString(1, "" + blobSize);
        ps.setBinaryStream(2, (InputStream)new LoopingAlphabetStream((long)blobSize, a1), blobSize);
        ps.setBinaryStream(3, (InputStream)new LoopingAlphabetStream((long)blobSize, a1), blobSize);
        ps.execute();
        this.closeStatement(ps);
        this.commit();
        s.executeUpdate("update LOB1 set str1 = str1 || ' '");
        s.executeUpdate("drop table lob1");
        s.executeUpdate("drop table t_lob1_log");
        trig = " create trigger t_lob1 after update of b_lob on lob1 ";
        trig = (String)trig + " REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL ";
        trig = (String)trig + " insert into t_lob1_log(oldvalue, newvalue) values (old.b_lob, new.b_lob)";
        s.executeUpdate("create table LOB1 (str1 Varchar(80), b_lob BLOB(50M))");
        s.executeUpdate("create table t_lob1_log(oldvalue BLOB(50M), newvalue  BLOB(50M), chng_time timestamp default current_timestamp)");
        s.executeUpdate((String)trig);
        this.commit();
        ps = this.prepareStatement("INSERT INTO LOB1 VALUES (?, ?)");
        ps.setString(1, "" + blobSize);
        ps.setBinaryStream(2, (InputStream)new LoopingAlphabetStream((long)blobSize, a1), blobSize);
        ps.execute();
        this.closeStatement(ps);
        this.commit();
        ps = this.prepareStatement("update LOB1 set b_lob = ?");
        ps.setBinaryStream(1, (InputStream)new LoopingAlphabetStream((long)blobSize, a2), blobSize);
        ps.execute();
        this.closeStatement(ps);
        this.commit();
        s.executeUpdate("drop table lob1");
        s.executeUpdate("drop table t_lob1_log");
        trig = " create trigger t_lob1 after update of b_lob on lob1 ";
        trig = (String)trig + " REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL ";
        trig = (String)trig + " insert into t_lob1_log(oldvalue, newvalue, oldvalue_again, newvalue_again) values (old.b_lob, new.b_lob, old.b_lob, new.b_lob)";
        s.executeUpdate("create table LOB1 (str1 Varchar(80), b_lob BLOB(50M))");
        s.executeUpdate("create table t_lob1_log(oldvalue BLOB(50M), newvalue  BLOB(50M), oldvalue_again BLOB(50M), newvalue_again BLOB(50M), chng_time timestamp default current_timestamp)");
        s.executeUpdate((String)trig);
        this.commit();
        ps = this.prepareStatement("INSERT INTO LOB1 VALUES (?, ?)");
        ps.setString(1, "" + blobSize);
        ps.setBinaryStream(2, (InputStream)new LoopingAlphabetStream((long)blobSize, a1), blobSize);
        ps.execute();
        this.closeStatement(ps);
        this.commit();
        ps = this.prepareStatement("update LOB1 set b_lob = ?");
        ps.setBinaryStream(1, (InputStream)new LoopingAlphabetStream((long)blobSize, a2), blobSize);
        ps.execute();
        this.closeStatement(ps);
        this.commit();
        ResultSet rs = s.executeQuery("SELECT * from t_lob1_log");
        rs.next();
        TriggerTest.assertEquals(new LoopingAlphabetStream((long)blobSize, a1), rs.getBinaryStream(1));
        TriggerTest.assertEquals(new LoopingAlphabetStream((long)blobSize, a2), rs.getBinaryStream(2));
        TriggerTest.assertEquals(new LoopingAlphabetStream((long)blobSize, a1), rs.getBinaryStream(3));
        TriggerTest.assertEquals(new LoopingAlphabetStream((long)blobSize, a2), rs.getBinaryStream(4));
        rs.close();
        s.executeUpdate("drop table lob1");
        s.executeUpdate("drop table t_lob1_log");
    }

    public void testUpdateTriggerOnClobColumn() throws SQLException, IOException {
        CharAlphabet a1 = CharAlphabet.singleChar('a');
        CharAlphabet a2 = CharAlphabet.singleChar('b');
        Connection conn = this.getConnection();
        Statement s = this.createStatement();
        Object trig = " create trigger t_lob1 after update of str1 on lob1 ";
        trig = (String)trig + " REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL ";
        trig = (String)trig + " insert into t_lob1_log(oldvalue, newvalue) values (old.str1, new.str1)";
        s.executeUpdate("create table LOB1 (str1 Varchar(80), C_lob CLOB(50M))");
        s.executeUpdate("create table t_lob1_log(oldvalue varchar(80), newvalue varchar(80), chng_time timestamp default current_timestamp)");
        s.executeUpdate((String)trig);
        conn.commit();
        PreparedStatement ps = this.prepareStatement("INSERT INTO LOB1 VALUES (?, ?)");
        int clobSize = 65537;
        ps.setString(1, "" + clobSize);
        ps.setCharacterStream(2, (Reader)new LoopingAlphabetReader((long)clobSize, a1), clobSize);
        ps.execute();
        conn.commit();
        PreparedStatement ps2 = this.prepareStatement("update LOB1 set c_lob = ? where str1 = '" + clobSize + "'");
        ps2.setCharacterStream(1, (Reader)new LoopingAlphabetReader((long)clobSize, a2), clobSize);
        ps2.executeUpdate();
        conn.commit();
        ResultSet rs = s.executeQuery("SELECT * FROM LOB1 where str1 = '" + clobSize + "'");
        rs.next();
        TriggerTest.assertEquals(new LoopingAlphabetReader((long)clobSize, a2), rs.getCharacterStream(2));
        rs.close();
        s.executeUpdate("drop table lob1");
        s.executeUpdate("drop table t_lob1_log");
    }

    public void testTypesInActionStatement() throws SQLException, IOException {
        Iterator<String> i;
        List<String> types = DatabaseMetaDataTest.getSQLTypes(this.getConnection());
        if (!XML.classpathMeetsXMLReqs()) {
            types.remove("XML");
        }
        if (!JDBC.vmSupportsJDBC3()) {
            i = types.iterator();
            while (i.hasNext()) {
                String type = i.next().toString();
                if (!type.startsWith("DECIMAL") && !type.startsWith("NUMERIC")) continue;
                i.remove();
            }
        }
        i = types.iterator();
        while (i.hasNext()) {
            this.actionTypeTest(i.next().toString());
        }
    }

    private void actionTypeTest(String type) throws SQLException, IOException {
        TriggerTest.println("actionTypeTest:" + type);
        Statement s = this.createStatement();
        this.actionTypesSetup(type);
        this.actionTypesInsertTest(type);
        this.actionTypesUpdateTest(type);
        this.actionTypesDeleteTest(type);
        s.executeUpdate("DROP TABLE T_MAIN");
        s.executeUpdate("DROP TABLE T_ACTION_ROW");
        s.executeUpdate("DROP TABLE T_ACTION_STATEMENT");
        s.close();
        this.commit();
    }

    private void actionTypesSetup(String type) throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE T_MAIN(ID INT  GENERATED ALWAYS AS IDENTITY PRIMARY KEY, V " + type + " )");
        s.executeUpdate("CREATE TABLE T_ACTION_ROW(ID INT, A CHAR(1), V1 " + type + ", V2 " + type + " )");
        s.executeUpdate("CREATE TABLE T_ACTION_STATEMENT(ID INT, A CHAR(1), V1 " + type + ", V2 " + type + " )");
        s.executeUpdate("CREATE TRIGGER AIR AFTER INSERT ON T_MAIN REFERENCING NEW AS N FOR EACH ROW INSERT INTO T_ACTION_ROW(A, V1, ID, V2) VALUES ('I', N.V, N.ID, N.V)");
        s.executeUpdate("CREATE TRIGGER AIS AFTER INSERT ON T_MAIN REFERENCING NEW TABLE AS N FOR EACH STATEMENT INSERT INTO T_ACTION_STATEMENT(A, V1, ID, V2) SELECT 'I', V, ID, V FROM N");
        s.executeUpdate("CREATE TRIGGER AUR AFTER UPDATE OF V ON T_MAIN REFERENCING NEW AS N OLD AS O FOR EACH ROW INSERT INTO T_ACTION_ROW(A, V1, ID, V2) VALUES ('U', N.V, N.ID, O.V)");
        s.executeUpdate("CREATE TRIGGER AUS AFTER UPDATE OF V ON T_MAIN REFERENCING NEW TABLE AS N OLD TABLE AS O FOR EACH STATEMENT INSERT INTO T_ACTION_STATEMENT(A, V1, ID, V2) SELECT 'U', N.V, N.ID, O.V FROM N,O WHERE O.ID = N.ID");
        s.executeUpdate("CREATE TRIGGER ADR AFTER DELETE ON T_MAIN REFERENCING OLD AS O FOR EACH ROW INSERT INTO T_ACTION_ROW(A, V1, ID, V2) VALUES ('D', O.V, O.ID, O.V)");
        s.executeUpdate("CREATE TRIGGER ADS AFTER DELETE ON T_MAIN REFERENCING OLD TABLE AS O FOR EACH STATEMENT INSERT INTO T_ACTION_STATEMENT(A, V1, ID, V2) SELECT 'D', O.V, O.ID, O.V FROM O");
        s.close();
        this.commit();
    }

    private void actionTypesInsertTest(String type) throws SQLException, IOException {
        Statement s = this.createStatement();
        s.executeUpdate("INSERT INTO T_MAIN(V) VALUES NULL");
        s.close();
        this.actionTypesCompareMainToAction(1, type);
        int jdbcType = DatabaseMetaDataTest.getJDBCType(type);
        int precision = DatabaseMetaDataTest.getPrecision(jdbcType, type);
        if (jdbcType == 2004) {
            return;
        }
        Random r = new Random();
        String ins1 = "INSERT INTO T_MAIN(V) VALUES (?)";
        String ins3 = "INSERT INTO T_MAIN(V) VALUES (?), (?), (?)";
        if (jdbcType == 2009) {
            ins1 = "INSERT INTO T_MAIN(V) VALUES XMLPARSE (DOCUMENT CAST (? AS CLOB) PRESERVE WHITESPACE)";
            ins3 = "INSERT INTO T_MAIN(V) VALUES XMLPARSE (DOCUMENT CAST (? AS CLOB) PRESERVE WHITESPACE),XMLPARSE (DOCUMENT CAST (? AS CLOB) PRESERVE WHITESPACE),XMLPARSE (DOCUMENT CAST (? AS CLOB) PRESERVE WHITESPACE)";
        }
        PreparedStatement ps = this.prepareStatement(ins1);
        TriggerTest.setRandomValue(r, ps, 1, jdbcType, precision);
        ps.executeUpdate();
        ps.close();
        this.actionTypesCompareMainToAction(2, type);
        ps = this.prepareStatement(ins3);
        TriggerTest.setRandomValue(r, ps, 1, jdbcType, precision);
        TriggerTest.setRandomValue(r, ps, 2, jdbcType, precision);
        TriggerTest.setRandomValue(r, ps, 3, jdbcType, precision);
        ps.executeUpdate();
        ps.close();
        this.actionTypesCompareMainToAction(5, type);
    }

    private void actionTypesUpdateTest(String type) throws SQLException, IOException {
        int jdbcType = DatabaseMetaDataTest.getJDBCType(type);
        int precision = DatabaseMetaDataTest.getPrecision(jdbcType, type);
        if (jdbcType == 2004) {
            return;
        }
        Statement s = this.createStatement();
        s.executeUpdate("UPDATE T_MAIN SET V = NULL WHERE ID = 2");
        s.close();
        this.commit();
        this.actionTypesCompareMainToActionForUpdate(type, 2);
        Random r = new Random();
        PreparedStatement ps = this.prepareStatement((jdbcType == 2009 ? "UPDATE T_MAIN SET V = XMLPARSE(DOCUMENT CAST (? AS CLOB) PRESERVE WHITESPACE)" : "UPDATE T_MAIN SET V = ?") + " WHERE ID >= ? AND ID <= ?");
        TriggerTest.setRandomValue(r, ps, 1, jdbcType, precision);
        ps.setInt(2, 3);
        ps.setInt(3, 3);
        TriggerTest.assertUpdateCount(ps, 1);
        this.commit();
        this.actionTypesCompareMainToActionForUpdate(type, 3);
        switch (jdbcType) {
            case -4: 
            case -1: 
            case 2004: 
            case 2005: {
                ps.close();
                return;
            }
        }
        TriggerTest.setRandomValue(r, ps, 1, jdbcType, precision);
        ps.setInt(2, 4);
        ps.setInt(3, 5);
        TriggerTest.assertUpdateCount(ps, 2);
        this.commit();
        this.actionTypesCompareMainToActionForUpdate(type, 4);
        this.actionTypesCompareMainToActionForUpdate(type, 5);
        ps.close();
    }

    private void actionTypesCompareMainToActionForUpdate(String type, int id) throws SQLException, IOException {
        String sqlMain = "SELECT M.V, R.V1 FROM T_MAIN M, T_ACTION_ROW R WHERE M.ID = ? AND R.A = 'I' AND M.ID = R.ID";
        String sqlRow = "SELECT V1, V2 FROM T_ACTION_ROW WHERE A = 'U' AND ID = ?";
        String sqlStmt = "SELECT V1, V2 FROM T_ACTION_STATEMENT WHERE A = 'U' AND ID = ?";
        if ("XML".equals(type)) {
            sqlMain = "SELECT XMLSERIALIZE(M.V AS CLOB), XMLSERIALIZE(R.V1 AS CLOB) FROM T_MAIN M, T_ACTION_ROW R WHERE M.ID = ? AND R.A = 'I' AND M.ID = R.ID";
            sqlRow = "SELECT XMLSERIALIZE(V1 AS CLOB), XMLSERIALIZE(V2 AS CLOB) FROM T_ACTION_ROW WHERE A = 'U' AND ID = ?";
            sqlStmt = "SELECT XMLSERIALIZE(V1 AS CLOB), XMLSERIALIZE(V2 AS CLOB) FROM T_ACTION_STATEMENT WHERE A = 'U' AND ID = ?";
        }
        PreparedStatement psMain = this.prepareStatement(sqlMain);
        PreparedStatement psActionRow = this.prepareStatement(sqlRow);
        PreparedStatement psActionStmt = this.prepareStatement(sqlStmt);
        psMain.setInt(1, id);
        psActionRow.setInt(1, id);
        psActionStmt.setInt(1, id);
        JDBC.assertSameContents(psMain.executeQuery(), psActionRow.executeQuery());
        JDBC.assertSameContents(psMain.executeQuery(), psActionStmt.executeQuery());
        psMain.close();
        psActionRow.close();
        psActionStmt.close();
        this.commit();
    }

    private void actionTypesDeleteTest(String type) throws SQLException, IOException {
        int jdbcType = DatabaseMetaDataTest.getJDBCType(type);
        int precision = DatabaseMetaDataTest.getPrecision(jdbcType, type);
        if (jdbcType == 2004) {
            return;
        }
        Statement s = this.createStatement();
        TriggerTest.assertUpdateCount(s, 1, "DELETE FROM T_MAIN WHERE ID = 3");
        this.commit();
        TriggerTest.assertUpdateCount(s, 4, "DELETE FROM T_MAIN");
        this.commit();
        s.close();
    }

    private void actionTypesCompareMainToAction(int actionCount, String type) throws SQLException, IOException {
        Statement s1 = this.createStatement();
        Statement s2 = this.createStatement();
        String sqlMain = "SELECT ID, V, V FROM T_MAIN ORDER BY 1";
        String sqlActionRow = "SELECT ID, V1, V2 FROM T_ACTION_ROW ORDER BY 1";
        String sqlActionStatement = "SELECT ID, V1, V2 FROM T_ACTION_STATEMENT ORDER BY 1";
        if ("XML".equals(type)) {
            sqlMain = "SELECT ID, XMLSERIALIZE(V AS CLOB), XMLSERIALIZE(V AS CLOB) FROM T_MAIN ORDER BY 1";
            sqlActionRow = "SELECT ID, XMLSERIALIZE(V1 AS CLOB), XMLSERIALIZE(V2 AS CLOB) FROM T_ACTION_ROW ORDER BY 1";
            sqlActionStatement = "SELECT ID, XMLSERIALIZE(V1 AS CLOB), XMLSERIALIZE(V2 AS CLOB) FROM T_ACTION_STATEMENT ORDER BY 1";
        }
        ResultSet rsMain = s1.executeQuery(sqlMain);
        ResultSet rsAction = s2.executeQuery(sqlActionRow);
        JDBC.assertSameContents(rsMain, rsAction);
        rsMain = s1.executeQuery(sqlMain);
        rsAction = s2.executeQuery(sqlActionStatement);
        JDBC.assertSameContents(rsMain, rsAction);
        this.assertTableRowCount("T_ACTION_ROW", actionCount);
        this.assertTableRowCount("T_ACTION_STATEMENT", actionCount);
        s1.close();
        s2.close();
    }

    public static void setRandomValue(Random r, PreparedStatement ps, int column, int jdbcType, int precision) throws SQLException, IOException {
        Object val = TriggerTest.getRandomValue(r, jdbcType, precision);
        if (val instanceof StringReaderWithLength) {
            StringReaderWithLength rd = (StringReaderWithLength)val;
            ps.setCharacterStream(column, (Reader)rd, rd.getLength());
        } else if (val instanceof InputStream) {
            InputStream in = (InputStream)val;
            ps.setBinaryStream(column, in, in.available());
        } else {
            ps.setObject(column, val, jdbcType);
        }
    }

    public static Object getRandomValue(Random r, int jdbcType, int precision) throws IOException {
        switch (jdbcType) {
            case 5: {
                return (short)r.nextInt();
            }
            case 4: {
                return r.nextInt();
            }
            case -5: {
                return r.nextLong();
            }
            case 6: 
            case 7: {
                return Float.valueOf(r.nextFloat());
            }
            case 8: {
                return r.nextDouble();
            }
            case 91: {
                long d = r.nextLong();
                if (d < 0L) {
                    d = -d;
                }
                d /= 86400000L;
                d %= 1460000L;
                return new Date(d *= 86400000L);
            }
            case 92: {
                long t = r.nextLong();
                if (t < 0L) {
                    t = -t;
                }
                return new Time(t % 86400000L);
            }
            case 93: {
                long ts = r.nextLong();
                if (ts < 0L) {
                    ts = -ts;
                }
                return new Timestamp(ts %= 126144000000000L);
            }
            case 1: 
            case 12: {
                return TriggerTest.randomString(r, r.nextInt(precision + 1));
            }
            case -1: {
                return new StringReaderWithLength(TriggerTest.randomString(r, r.nextInt(32701)));
            }
            case 2005: {
                if (precision > 262144) {
                    precision = 262144;
                }
                return new StringReaderWithLength(TriggerTest.randomString(r, r.nextInt(precision)));
            }
            case -3: 
            case -2: {
                return TriggerTest.randomBinary(r, r.nextInt(precision + 1));
            }
            case -4: {
                return new ReadOnceByteArrayInputStream(TriggerTest.randomBinary(r, r.nextInt(32701)));
            }
            case 2004: {
                if (precision > 262144) {
                    precision = 262144;
                }
                return new ReadOnceByteArrayInputStream(TriggerTest.randomBinary(r, r.nextInt(precision)));
            }
            case 2009: {
                return new StringReaderWithLength("<a><b>text</b></a>");
            }
        }
        return null;
    }

    private static byte[] randomBinary(Random r, int len) {
        byte[] bb = new byte[len];
        for (int i = 0; i < bb.length; ++i) {
            bb[i] = (byte)r.nextInt();
        }
        return bb;
    }

    private static String randomString(Random r, int len) {
        char[] cb = new char[len];
        for (int i = 0; i < cb.length; ++i) {
            cb[i] = (char)r.nextInt(65535);
        }
        return new String(cb);
    }

    public void testDerby4095OldTriggerRows() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE APP.TAB (I INT)");
        s.executeUpdate("CREATE TABLE APP.LOG (I INT, NAME VARCHAR(30), DELTIME TIMESTAMP)");
        s.executeUpdate("CREATE TABLE APP.NAMES(ID INT, NAME VARCHAR(30))");
        s.executeUpdate("CREATE TRIGGER  APP.MYTRIG AFTER DELETE ON APP.TAB REFERENCING OLD_TABLE AS OLDROWS FOR EACH STATEMENT INSERT INTO APP.LOG(i,name,deltime) SELECT OLDROWS.I, NAMES.NAME, CURRENT_TIMESTAMP FROM --DERBY-PROPERTIES joinOrder=FIXED\n NAMES, OLDROWS --DERBY-PROPERTIES joinStrategy = NESTEDLOOP\n WHERE (OLDROWS.i = NAMES.ID) AND (1 = 1)");
        s.executeUpdate("insert into APP.tab values(1)");
        s.executeUpdate("insert into APP.tab values(2)");
        s.executeUpdate("insert into APP.tab values(3)");
        s.executeUpdate("insert into APP.names values(1,'Charlie')");
        s.executeUpdate("insert into APP.names values(2,'Hugh')");
        s.executeUpdate("insert into APP.names values(3,'Alex')");
        s.executeUpdate("delete from tab where i = 1");
        ResultSet loggedDeletes = s.executeQuery("SELECT * FROM APP.LOG");
        JDBC.assertDrainResults(loggedDeletes, 1);
        s.executeUpdate("DROP TABLE APP.TAB");
        s.executeUpdate("DROP TABLE APP.LOG");
        s.executeUpdate("DROP TABLE APP.NAMES");
    }

    public void testDerby4095NewTriggerRows() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE APP.TAB (I INT)");
        s.executeUpdate("CREATE TABLE APP.LOG (I INT, NAME VARCHAR(30), UPDTIME TIMESTAMP, NEWVALUE INT)");
        s.executeUpdate("CREATE TABLE APP.NAMES(ID INT, NAME VARCHAR(30))");
        s.executeUpdate("CREATE TRIGGER  APP.MYTRIG AFTER UPDATE ON APP.TAB REFERENCING OLD_TABLE AS OLDROWS NEW_TABLE AS NEWROWS FOR EACH STATEMENT INSERT INTO APP.LOG(i,name,updtime,newvalue) SELECT OLDROWS.I, NAMES.NAME, CURRENT_TIMESTAMP, NEWROWS.I  FROM --DERBY-PROPERTIES joinOrder=FIXED\n NAMES, NEWROWS --DERBY-PROPERTIES joinStrategy = NESTEDLOOP\n ,OLDROWS WHERE (NEWROWS.i = NAMES.ID) AND (1 = 1)");
        s.executeUpdate("insert into tab values(1)");
        s.executeUpdate("insert into tab values(2)");
        s.executeUpdate("insert into tab values(3)");
        s.executeUpdate("insert into names values(1,'Charlie')");
        s.executeUpdate("insert into names values(2,'Hugh')");
        s.executeUpdate("insert into names values(3,'Alex')");
        s.executeUpdate("update tab set i=1 where i = 1");
        ResultSet loggedUpdates = s.executeQuery("SELECT * FROM APP.LOG");
        JDBC.assertDrainResults(loggedUpdates, 1);
        s.executeUpdate("DROP TABLE APP.TAB");
        s.executeUpdate("DROP TABLE APP.LOG");
        s.executeUpdate("DROP TABLE APP.NAMES");
    }

    public void testDerby4610WrongDataType() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table testtable (id integer, name varchar(20), primary key(id))");
        s.execute("create table testchild (id integer constraint fk_id references testtable on delete cascade, ordernum int, primary key(id))");
        s.execute("create procedure testproc (str varchar(20)) PARAMETER STYLE JAVA LANGUAGE JAVA EXTERNAL NAME '" + ((Object)((Object)this)).getClass().getName() + ".derby4610proc'");
        s.execute("create trigger testtabletrigger after delete on testtable referencing old as old for each row mode db2sql call testproc(char(old.id))");
        s.execute("create trigger testchildtrigger after delete on testchild referencing old as old for each row mode db2sql call testproc(char(old.ordernum))");
        s.execute("insert into testtable values (1, 'test1')");
        s.execute("insert into testchild values (1, 10)");
        TriggerTest.assertUpdateCount(s, 1, "delete from testtable where id = 1");
    }

    public static void derby4610proc(String str) {
    }

    public void testDerby6351TransitionTableCorrelation() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table t1(x int)");
        s.execute("create table t2(x varchar(10), y int)");
        s.execute("create trigger tr1 after insert on t1 referencing new table as n insert into t2 select 'tr1', x from n n");
        s.execute("create trigger tr2 after update on t1 referencing old table as o insert into t2 select 'tr2', x from o o");
        s.execute("create trigger tr3 after insert on t1 referencing new table as n insert into t2 select 'tr3', x from n");
        s.execute("create trigger tr4 after update on t1 referencing old table as o insert into t2 select 'tr4', x from o");
        s.execute("create trigger tr5 after insert on t1 referencing new table as n insert into t2 select 'tr5', n1.x from n n1");
        s.execute("create trigger tr6 after update on t1 referencing old table as o insert into t2 select 'tr6', o1.x from o o1");
        s.execute("insert into t1 values 1,2");
        JDBC.assertFullResultSet(s.executeQuery("select * from t2 order by x, y"), new String[][]{{"tr1", "1"}, {"tr1", "2"}, {"tr3", "1"}, {"tr3", "2"}, {"tr5", "1"}, {"tr5", "2"}});
        s.execute("delete from t2");
        s.execute("update t1 set x = x + 1 where x = 1");
        JDBC.assertFullResultSet(s.executeQuery("select * from t2 order by x, y"), new String[][]{{"tr2", "1"}, {"tr4", "1"}, {"tr6", "1"}});
    }

    public void testDerby6357TempTable() throws SQLException {
        Statement s = this.createStatement();
        s.execute("declare global temporary table temptable(x int) not logged");
        s.execute("create table t1(x int)");
        s.execute("create table t2(i int, b boolean)");
        this.assertCompileError("XCL51", "create trigger tr1 after insert on session.temptable referencing new table as new insert into t1(i) select x from new");
        this.assertCompileError("XCL51", "create trigger tr2 after insert on t1 insert into t2(i) select x from session.temptable");
        this.assertCompileError("XCL51", "create trigger tr3 after insert on t1 insert into session.temptable values 1");
        this.assertCompileError("XCL51", "create trigger tr4 after insert on t1 insert into t2(b) values exists(select * from session.temptable)");
        this.assertCompileError("XCL51", "create trigger tr5 after insert on t1 insert into t2(i) values case when exists(select * from session.temptable) then 1 else 2 end");
        this.assertCompileError("XCL51", "create trigger tr6 after insert on t1 insert into t2(b) values (select count(*) from session.temptable) = (select count(*) from sysibm.sysdummy1)");
        this.assertCompileError("XCL51", "create trigger tr7 after insert on t1 merge into t2 using session.temptable on i=x when matched then delete");
        this.assertCompileError("XCL51", "create trigger tr8 after insert on t1 merge into session.temptable using t2 on i=x when matched then delete");
        this.assertCompileError("XCL51", "create trigger tr9 after insert on t1 merge into t2 using t1 on exists(select * from session.temptable where t1.x=t2.i) when matched then delete");
    }

    public void testDerby6371DropColumn() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create schema d6371_s1");
        s.execute("create schema d6371_s2");
        s.execute("create table d6371_s1.t1(x int, y int)");
        s.execute("create table d6371_s1.t2(x int, y int)");
        s.execute("set schema 'D6371_S1'");
        this.commit();
        s.execute("create trigger d6371_s2.tr1 after update of x on t1 for each row insert into t2(x) select x from t1");
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, s, "alter table t1 drop column x restrict");
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, s, "alter table t2 drop column x restrict");
        s.execute("alter table t1 drop column y restrict");
        s.execute("alter table t2 drop column y restrict");
        s.execute("insert into t1 values 1");
        s.execute("update t1 set x = x + 1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from t2"), "2");
        this.rollback();
        Connection c2 = this.openDefaultConnection("D6371_USER_WITHOUT_SCHEMA", "secret");
        Statement s2 = c2.createStatement();
        s2.execute("create trigger d6371_s1.tr2 after update of x on d6371_s1.t1 for each row insert into d6371_s1.t2(x) select x from d6371_s1.t1");
        s2.close();
        c2.commit();
        c2.close();
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, s, "alter table t1 drop column x restrict");
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, s, "alter table t2 drop column x restrict");
        s.execute("alter table t1 drop column y restrict");
        s.execute("alter table t2 drop column y restrict");
        s.execute("insert into t1 values 1");
        s.execute("update t1 set x = x + 1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from t2"), "2");
    }

    public void testDerby6348() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table d6348(x int)");
        s.execute("insert into d6348 values 1");
        s.execute("create trigger d6348_tr1 after update on d6348 values 1");
        s.execute("create trigger d6348_tr2 after update on d6348 for each row update d6348 set x = x + 1 where x < 3");
        s.execute("update d6348 set x = x + 1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from d6348"), "3");
        this.rollback();
        s.execute("create table d6348(x int)");
        s.execute("create trigger d6348_tr1 after insert on d6348 values current_user");
        s.execute("create trigger d6348_tr2 after insert on d6348 values current_user");
        s.execute("insert into d6348 values 1");
    }

    public void testDerby2041DropDependencies() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table t1(x int, y int, z int)");
        s.execute("create table t2(x int, y int, z int)");
        s.execute("create table syn_table(x int, y int, z int)");
        s.execute("create table view_table(x int, y int, z int)");
        s.execute("create function f(x int) returns int language java parameter style java external name 'java.lang.Math.abs'");
        s.execute("create procedure p() language java parameter style java external name '" + ((Object)((Object)this)).getClass().getName() + ".dummyProc' no sql");
        s.execute("create function tf() returns table (x int) language java parameter style derby_jdbc_result_set external name '" + ((Object)((Object)this)).getClass().getName() + ".dummyTableFunction' no sql");
        s.execute("create derby aggregate intmode for int external name '" + ModeAggregate.class.getName() + "'");
        s.execute("create sequence seq");
        s.execute("create synonym syn for syn_table");
        s.execute("create view v(x) as select x from view_table");
        s.execute("create type tp external name 'java.util.List' language java");
        s.execute("create trigger tr_t2 after insert on t1 select x from t2");
        s.execute("create trigger tr_f after insert on t1 values f(1)");
        s.execute("create trigger tr_p after insert on t1 call p()");
        s.execute("create trigger tr_tf after insert on t1 select * from table(tf()) t");
        s.execute("create trigger tr_intmode after insert on t1 select intmode(x) from (values 1,2,3) v(x)");
        s.execute("create trigger tr_seq after insert on t1 values next value for seq");
        s.execute("create trigger tr_syn after insert on t1 select * from syn");
        s.execute("create trigger tr_v after insert on t1 select * from v");
        s.execute("create trigger tr_tp after insert on t1 values cast(null as tp)");
        PreparedStatement checkTrigger = this.prepareStatement("select triggername from sys.systriggers join sys.sysschemas using (schemaid) where triggername = ? and schemaname = ?");
        checkTrigger.setString(2, this.getTestConfiguration().getUserName());
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, s, "drop table t2");
        checkTrigger.setString(1, "TR_T2");
        JDBC.assertSingleValueResultSet(checkTrigger.executeQuery(), "TR_T2");
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, s, "drop function f");
        checkTrigger.setString(1, "TR_F");
        JDBC.assertSingleValueResultSet(checkTrigger.executeQuery(), "TR_F");
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, s, "drop procedure p");
        checkTrigger.setString(1, "TR_P");
        JDBC.assertSingleValueResultSet(checkTrigger.executeQuery(), "TR_P");
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, s, "drop function tf");
        checkTrigger.setString(1, "TR_TF");
        JDBC.assertSingleValueResultSet(checkTrigger.executeQuery(), "TR_TF");
        TriggerTest.assertStatementError(SYNTAX_ERROR, s, "drop derby aggregate intmode cascade");
        TriggerTest.assertStatementError(HAS_DEPENDENT_SPS, s, "drop derby aggregate intmode restrict");
        checkTrigger.setString(1, "TR_INTMODE");
        JDBC.assertSingleValueResultSet(checkTrigger.executeQuery(), "TR_INTMODE");
        TriggerTest.assertStatementError(SYNTAX_ERROR, s, "drop sequence seq cascade");
        TriggerTest.assertStatementError(HAS_DEPENDENT_SPS, s, "drop sequence seq restrict");
        checkTrigger.setString(1, "TR_SEQ");
        JDBC.assertSingleValueResultSet(checkTrigger.executeQuery(), "TR_SEQ");
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, s, "drop synonym syn");
        checkTrigger.setString(1, "TR_SYN");
        JDBC.assertSingleValueResultSet(checkTrigger.executeQuery(), "TR_SYN");
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, s, "drop view v");
        checkTrigger.setString(1, "TR_V");
        JDBC.assertSingleValueResultSet(checkTrigger.executeQuery(), "TR_V");
        TriggerTest.assertStatementError(SYNTAX_ERROR, s, "drop type tp cascade");
        TriggerTest.assertStatementError(HAS_DEPENDENT_SPS, s, "drop type tp restrict");
        checkTrigger.setString(1, "TR_TP");
        JDBC.assertSingleValueResultSet(checkTrigger.executeQuery(), "TR_TP");
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, s, "alter table t2 drop column x restrict");
        checkTrigger.setString(1, "TR_T2");
        JDBC.assertSingleValueResultSet(checkTrigger.executeQuery(), "TR_T2");
        s.execute("alter table t2 drop column y restrict");
        TriggerTest.assertNull((Object)s.getWarnings());
        checkTrigger.setString(1, "TR_T2");
        JDBC.assertSingleValueResultSet(checkTrigger.executeQuery(), "TR_T2");
        JDBC.assertColumnNames(s.executeQuery("select * from t2"), "X", "Z");
        s.execute("alter table t2 drop column x cascade");
        TriggerTest.assertSQLState(TRIGGER_DROPPED, s.getWarnings());
        checkTrigger.setString(1, "TR_T2");
        JDBC.assertEmpty(checkTrigger.executeQuery());
        JDBC.assertColumnNames(s.executeQuery("select * from t2"), "Z");
    }

    public void testDerby2041RecompileOnly() throws SQLException {
        Statement s = this.createStatement();
        PreparedStatement spsValid = this.prepareStatement("select valid from sys.sysschemas join sys.systriggers using (schemaid) join sys.sysstatements on stmtid = actionstmtid where schemaname = ? and triggername = ?");
        spsValid.setString(1, this.getTestConfiguration().getUserName());
        spsValid.setString(2, "TR");
        s.execute("create table t1(x int not null)");
        s.execute("create table t2(x int not null)");
        s.execute("create index idx on t2(x)");
        s.execute("create trigger tr after insert on t1 insert into t2 values 1");
        JDBC.assertSingleValueResultSet(spsValid.executeQuery(), "true");
        s.execute("drop index idx");
        JDBC.assertSingleValueResultSet(spsValid.executeQuery(), "false");
        s.execute("insert into t1 values 1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from t2"), "1");
        JDBC.assertSingleValueResultSet(spsValid.executeQuery(), "true");
        s.execute("truncate table t2");
        this.assertTableRowCount("T2", 0);
        JDBC.assertSingleValueResultSet(spsValid.executeQuery(), "false");
        s.execute("insert into t1 values 1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from t2"), "1");
        JDBC.assertSingleValueResultSet(spsValid.executeQuery(), "true");
        s.execute("drop trigger tr");
        s.execute("alter table t2 add constraint t2_pk primary key (x)");
        s.execute("create table t3(x int, y int references t2 on delete cascade)");
        s.execute("create trigger tr after delete on t1 delete from t2");
        JDBC.assertSingleValueResultSet(spsValid.executeQuery(), "true");
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, s, "drop table t3");
        JDBC.assertSingleValueResultSet(spsValid.executeQuery(), "true");
    }

    public static void dummyProc() {
    }

    public static ResultSet dummyTableFunction() {
        return null;
    }

    public void testDerby6540TransitionTableNameClash() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table d6540_t1(x int)");
        s.execute("create table d6540_t2(y int)");
        s.execute("create table d6540_t3(z int)");
        s.execute("create trigger d6540_tr after insert on d6540_t1 referencing new table as d6540_t2 insert into d6540_t3 select x from d6540_t2 union all select y from app.d6540_t2");
        PreparedStatement selT3 = this.prepareStatement("select * from d6540_t3 order by z");
        JDBC.assertEmpty(selT3.executeQuery());
        s.execute("insert into d6540_t1 values 1");
        JDBC.assertSingleValueResultSet(selT3.executeQuery(), "1");
        s.execute("insert into d6540_t2 values 2, 3");
        s.execute("insert into d6540_t1 values 4, 5");
        JDBC.assertFullResultSet(selT3.executeQuery(), new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}});
        s.execute("truncate table d6540_t1");
        s.execute("truncate table d6540_t2");
        s.execute("truncate table d6540_t3");
        s.execute("drop trigger d6540_tr");
        s.execute("create trigger d6540_tr after insert on d6540_t1 referencing new as d6540_t2 for each row insert into d6540_t3 select * from app.d6540_t2 where d6540_t2.x = app.d6540_t2.y");
        JDBC.assertEmpty(selT3.executeQuery());
        s.execute("insert into d6540_t1 values 1");
        JDBC.assertEmpty(selT3.executeQuery());
        s.execute("insert into d6540_t2 values 1, 2, 3");
        s.execute("insert into d6540_t1 values 2, 3, 4");
        JDBC.assertFullResultSet(selT3.executeQuery(), new String[][]{{"2"}, {"3"}});
        s.execute("drop trigger d6540_tr");
        s.execute("create table d6540_t4(c1 int, c2 int)");
        s.execute("create trigger d6540_tr after insert on d6540_t1 referencing new as d6540_t2 for each row insert into d6540_t4 select y, d6540_t2.x from d6540_t2");
        s.execute("insert into d6540_t1 values 1");
        JDBC.assertFullResultSet(s.executeQuery("select * from d6540_t4 order by c1"), new String[][]{{"1", "1"}, {"2", "1"}, {"3", "1"}});
        this.assertCompileError(SYNTAX_ERROR, "create trigger d6540_tr1 after insert on d6540_t1 referencing new table as app.n values 1");
        this.assertCompileError(SYNTAX_ERROR, "create trigger d6540_tr2 after insert on d6540_t1 referencing new as app.n for each row values 1");
    }

    public void testDerby6543() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table d6543_1(x int)");
        s.execute("create table d6543_2(x int)");
        s.execute("create trigger d6543_tr after insert on d6543_1 referencing new as new for each row insert into d6543_2 select x from d6543_1 where new . x = x");
        TriggerTest.assertUpdateCount(s, 4, "insert into d6543_1 values 1, 2, 2, 3");
        JDBC.assertFullResultSet(s.executeQuery("select * from d6543_2 order by x"), new String[][]{{"1"}, {"2"}, {"2"}, {"2"}, {"2"}, {"3"}});
    }

    public void testQualifiedNamesInSystemTables() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create schema d6370");
        s.execute("set schema d6370");
        s.execute("create table t1(x int, y int, z int)");
        s.execute("create table t2(x int, y int, z int)");
        s.execute("create table t3(x int, y int, z int)");
        s.execute("create table syn_table(x int, y int, z int)");
        s.execute("create table view_table(x int, y int, z int)");
        s.execute("create function f(x int) returns int language java parameter style java external name 'java.lang.Math.abs'");
        s.execute("create procedure p() language java parameter style java external name '" + ((Object)((Object)this)).getClass().getName() + ".dummyProc' no sql");
        s.execute("create function tf() returns table (x int) language java parameter style derby_jdbc_result_set external name '" + ((Object)((Object)this)).getClass().getName() + ".dummyTableFunction' no sql");
        s.execute("create derby aggregate intmode for int external name '" + ModeAggregate.class.getName() + "'");
        s.execute("create sequence seq");
        s.execute("create synonym syn for syn_table");
        s.execute("create view v(x) as select x from view_table");
        s.execute("create type tp external name 'java.util.List' language java");
        s.execute("create table tp_t1(x tp)");
        s.execute("create table tp_t2(x tp)");
        s.execute("create trigger tr01 no cascade before insert on t1 when (exists(select f(y) from v join t1 t on v.x = t.x)) call p()");
        s.execute("create trigger tr02 after insert on t1 when (exists(select * from table(tf()) t)) insert into t2(z) select 1 from t1");
        s.execute("create trigger tr03 after delete on t1 insert into t2(z) select intmode(x) from syn");
        s.execute("create trigger tr04 after insert on tp_t1 referencing new as new for each row insert into tp_t2 values new.x, cast(null as tp)");
        s.execute("create trigger tr05 after insert on t1 referencing new table as new when (next value for seq < 1000) insert into t2(y) select a.z from new a, t1 b, new c, t1 d");
        s.execute("create trigger tr06 after insert on t1 update t2 set t2.x = t2.y");
        s.execute("create trigger tr07 after insert on t1 insert into t2 (t2.x, t2.y) values (1, default)");
        s.execute("create trigger tr08 after update on t1 delete from t2 where t2.x = t2.y");
        s.execute("create trigger tr09 after delete on t1 merge into t2 using t3 on t2.x = t3.x when matched and t3.y = 5 then update set t2.x = t3.y when not matched then insert values (t3.x, t3.y, t3.z)");
        s.execute("create trigger tr10 after insert on t1 referencing new as new for each row update t2 set x = (select count(*) from t1 where new.x = t2.x)");
        s.execute("create trigger tr11 after insert on t1 for each row values sin(0)");
        s.execute("create function sin(x double) returns double language java parameter style java external name 'java.lang.Math.sin'");
        s.execute("create trigger tr12 after insert on t1 for each row values sin(0)");
        String[][] expectedRows = new String[][]{{"TR01", "exists(select \"D6370\".\"F\"(y) from \"D6370\".\"V\" join \"D6370\".\"T1\" t on \"V\".x = \"T\".x)", "VALUES exists(select \"D6370\".\"F\"(y) from \"D6370\".\"V\" join \"D6370\".\"T1\" t on \"V\".x = \"T\".x)", "call \"D6370\".\"P\"()", "call \"D6370\".\"P\"()"}, {"TR02", "exists(select * from table(\"D6370\".\"TF\"()) t)", "VALUES exists(select * from table(\"D6370\".\"TF\"()) t)", "insert into \"D6370\".\"T2\"(z) select 1 from \"D6370\".\"T1\"", "insert into \"D6370\".\"T2\"(z) select 1 from \"D6370\".\"T1\""}, {"TR03", null, null, "insert into \"D6370\".\"T2\"(z) select \"D6370\".\"INTMODE\"(x) from \"D6370\".\"SYN\"", "insert into \"D6370\".\"T2\"(z) select \"D6370\".\"INTMODE\"(x) from \"D6370\".\"SYN\""}, {"TR04", null, null, "insert into \"D6370\".\"TP_T2\" values new.x, cast(null as \"D6370\".\"TP\")", "insert into \"D6370\".\"TP_T2\" values CAST (org.apache.derby.iapi.db.Factory::getTriggerExecutionContext().getNewRow().getObject(1) AS \"D6370\".\"TP\") , cast(null as \"D6370\".\"TP\")"}, {"TR05", "next value for \"D6370\".\"SEQ\" < 1000", "VALUES next value for \"D6370\".\"SEQ\" < 1000", "insert into \"D6370\".\"T2\"(y) select \"A\".z from new a, \"D6370\".\"T1\" b, new c, \"D6370\".\"T1\" d", "insert into \"D6370\".\"T2\"(y) select \"A\".z from new org.apache.derby.catalog.TriggerNewTransitionRows()  a, \"D6370\".\"T1\" b, new org.apache.derby.catalog.TriggerNewTransitionRows()  c, \"D6370\".\"T1\" d"}, {"TR06", null, null, "update \"D6370\".\"T2\" set t2.x = \"T2\".y", "update \"D6370\".\"T2\" set t2.x = \"T2\".y"}, {"TR07", null, null, "insert into \"D6370\".\"T2\" (t2.x, t2.y) values (1, default)", "insert into \"D6370\".\"T2\" (t2.x, t2.y) values (1, default)"}, {"TR08", null, null, "delete from \"D6370\".\"T2\" where \"D6370\".\"T2\".x = \"D6370\".\"T2\".y", "delete from \"D6370\".\"T2\" where \"D6370\".\"T2\".x = \"D6370\".\"T2\".y"}, {"TR09", null, null, "merge into \"D6370\".\"T2\" using \"D6370\".\"T3\" on \"D6370\".\"T2\".x = \"D6370\".\"T3\".x when matched and \"D6370\".\"T3\".y = 5 then update set t2.x = \"D6370\".\"T3\".y when not matched then insert values (\"D6370\".\"T3\".x, \"D6370\".\"T3\".y, \"D6370\".\"T3\".z)", "merge into \"D6370\".\"T2\" using \"D6370\".\"T3\" on \"D6370\".\"T2\".x = \"D6370\".\"T3\".x when matched and \"D6370\".\"T3\".y = 5 then update set t2.x = \"D6370\".\"T3\".y when not matched then insert values (\"D6370\".\"T3\".x, \"D6370\".\"T3\".y, \"D6370\".\"T3\".z)"}, {"TR10", null, null, "update \"D6370\".\"T2\" set x = (select count(*) from \"D6370\".\"T1\" where new.x = \"D6370\".\"T2\".x)", "update \"D6370\".\"T2\" set x = (select count(*) from \"D6370\".\"T1\" where CAST (org.apache.derby.iapi.db.Factory::getTriggerExecutionContext().getNewRow().getObject(1) AS INTEGER)  = \"D6370\".\"T2\".x)"}, {"TR11", null, null, "values \"SYSFUN\".\"SIN\"(0)", "values \"SYSFUN\".\"SIN\"(0)"}, {"TR12", null, null, "values \"D6370\".\"SIN\"(0)", "values \"D6370\".\"SIN\"(0)"}};
        ResultSet rs = s.executeQuery("select triggername, whenclausetext, s1.text, triggerdefinition, s2.text from sys.systriggers join sys.sysschemas using (schemaid) left join sys.sysstatements s1 on whenstmtid = stmtid join sys.sysstatements s2 on actionstmtid = s2.stmtid where schemaname = 'D6370' order by triggername");
        JDBC.assertFullResultSet(rs, expectedRows);
        s.execute("insert into tp_t1 values cast(null as tp)");
    }

    public void testDerby6663() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table d6663_t1(pk int primary key)");
        s.execute("create table d6663_t2(x int references d6663_t1)");
        s.execute("create table d6663_t3(y int)");
        s.execute("create trigger d6663_tr after insert on d6663_t3 referencing new as new for each row insert into d6663_t2 values new.y");
        TriggerTest.assertStatementError(FOREIGN_KEY_VIOLATION, s, "insert into d6663_t3 values 1");
        s.execute("insert into d6663_t1 values 1");
        s.execute("insert into d6663_t3 values 1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from d6663_t2"), "1");
    }
}

