/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import org.apache.derbyTesting.functionTests.util.UniqueRandomSequence;
import org.apache.derbyTesting.perf.clients.DBFiller;
import org.apache.derbyTesting.perf.clients.WisconsinFiller;

public class SingleRecordFiller
implements DBFiller {
    private final int numberOfTables;
    private final int tableSize;
    private final int dataType;
    private final String dataTypeString;
    private final boolean withSecIndexColumn;
    private final boolean withNonIndexedColumn;
    static final int TEXT_SIZE = 100;
    private static final String[] RANDOM_STRINGS = new String[16];
    private static final byte[][] RANDOM_BYTES = new byte[16][100];

    public SingleRecordFiller(int n, int n2) {
        this(n, n2, 12, false, false);
    }

    public SingleRecordFiller(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.tableSize = n;
        this.numberOfTables = n2;
        this.dataType = n3;
        switch (n3) {
            case 12: {
                this.dataTypeString = "VARCHAR";
                break;
            }
            case 2004: {
                this.dataTypeString = "BLOB";
                break;
            }
            case 2005: {
                this.dataTypeString = "CLOB";
                break;
            }
            default: {
                throw new IllegalArgumentException("type = " + n3);
            }
        }
        this.withSecIndexColumn = bl;
        this.withNonIndexedColumn = bl2;
    }

    @Override
    public void fill(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        for (int i = 0; i < this.numberOfTables; ++i) {
            String string = SingleRecordFiller.getTableName(this.tableSize, i, this.dataType, this.withSecIndexColumn, this.withNonIndexedColumn);
            WisconsinFiller.dropTable(connection, string);
            statement.executeUpdate("CREATE TABLE " + string + "(ID INT NOT NULL, " + (this.withSecIndexColumn ? "SEC INT, " : "") + (this.withNonIndexedColumn ? "NI INT, " : "") + "TEXT " + this.dataTypeString + "(100))");
            Object object = "";
            Object object2 = "";
            if (this.withSecIndexColumn) {
                object = (String)object + ", SEC";
                object2 = (String)object2 + ", ?";
            }
            if (this.withNonIndexedColumn) {
                object = (String)object + ", NI";
                object2 = (String)object2 + ", ?";
            }
            PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO " + string + "(ID, TEXT" + (String)object + ") VALUES (?, ?" + (String)object2 + ")");
            UniqueRandomSequence uniqueRandomSequence = null;
            if (this.withSecIndexColumn) {
                uniqueRandomSequence = new UniqueRandomSequence(this.tableSize);
            }
            UniqueRandomSequence uniqueRandomSequence2 = null;
            if (this.withNonIndexedColumn) {
                uniqueRandomSequence2 = new UniqueRandomSequence(this.tableSize);
            }
            for (int j = 0; j < this.tableSize; ++j) {
                Closeable closeable;
                int n = 1;
                preparedStatement.setInt(n++, j);
                if (this.dataType == 12) {
                    preparedStatement.setString(n++, SingleRecordFiller.randomString(j));
                } else if (this.dataType == 2005) {
                    closeable = new StringReader(SingleRecordFiller.randomString(j));
                    preparedStatement.setCharacterStream(n++, (Reader)closeable, 100);
                } else if (this.dataType == 2004) {
                    closeable = new ByteArrayInputStream(SingleRecordFiller.randomBytes(j));
                    preparedStatement.setBinaryStream(n++, (InputStream)closeable, 100);
                }
                if (this.withSecIndexColumn) {
                    preparedStatement.setInt(n++, uniqueRandomSequence.nextValue());
                }
                if (this.withNonIndexedColumn) {
                    preparedStatement.setInt(n++, uniqueRandomSequence2.nextValue());
                }
                preparedStatement.executeUpdate();
                if (j % 1000 != 0) continue;
                connection.commit();
            }
            statement.executeUpdate("ALTER TABLE " + string + " ADD CONSTRAINT " + string + "_PK PRIMARY KEY (ID)");
            if (this.withSecIndexColumn) {
                statement.executeUpdate("CREATE INDEX " + string + "_SECONDARY_INDEX ON " + string + "(SEC)");
            }
            preparedStatement.close();
            connection.commit();
        }
        statement.close();
    }

    static String randomString(int n) {
        return RANDOM_STRINGS[(n & Integer.MAX_VALUE) % RANDOM_STRINGS.length];
    }

    static byte[] randomBytes(int n) {
        return RANDOM_BYTES[(n & Integer.MAX_VALUE) % RANDOM_BYTES.length];
    }

    static String getTableName(int n, int n2, int n3, boolean bl, boolean bl2) {
        String string = "SINGLE_RECORD_" + n + "_" + n2;
        if (bl) {
            string = string + "_SECIDX";
        }
        if (bl2) {
            string = string + "_NONIDX";
        }
        if (n3 == 12) {
            string = string + "_VARCHAR";
        } else if (n3 == 2004) {
            string = string + "_BLOB";
        } else if (n3 == 2005) {
            string = string + "_CLOB";
        } else {
            throw new IllegalArgumentException("dataType = " + n3);
        }
        return string;
    }

    static {
        Random random = new Random();
        for (int i = 0; i < RANDOM_STRINGS.length; ++i) {
            int n;
            StringBuffer stringBuffer = new StringBuffer(100);
            for (n = 0; n < 100; ++n) {
                stringBuffer.append("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890_-+*/(){}[]&%$#!".charAt(random.nextInt("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890_-+*/(){}[]&%$#!".length())));
            }
            SingleRecordFiller.RANDOM_STRINGS[i] = stringBuffer.toString();
            for (n = 0; n < 100; ++n) {
                SingleRecordFiller.RANDOM_BYTES[i][n] = (byte)RANDOM_STRINGS[i].charAt(n);
            }
        }
    }
}

