/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.cache;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.jmx.ManagementService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.util.Matchable;
import org.apache.derby.impl.services.cache.BackgroundCleaner;
import org.apache.derby.impl.services.cache.CacheEntry;
import org.apache.derby.impl.services.cache.ClockPolicy;
import org.apache.derby.impl.services.cache.ConcurrentCacheMBeanImpl;
import org.apache.derby.impl.services.cache.ReplacementPolicy;
import org.apache.derby.mbeans.CacheManagerMBean;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

final class ConcurrentCache
implements CacheManager {
    private final ConcurrentHashMap<Object, CacheEntry> cache;
    private final CacheableFactory holderFactory;
    private final String name;
    private final int maxSize;
    private final ReplacementPolicy replacementPolicy;
    private Object mbean;
    private volatile boolean collectAccessCounts;
    private final AtomicLong hits = new AtomicLong();
    private final AtomicLong misses = new AtomicLong();
    private final AtomicLong evictions = new AtomicLong();
    private volatile boolean stopped;
    private BackgroundCleaner cleaner;

    ConcurrentCache(CacheableFactory holderFactory, String name, int initialSize, int maxSize) {
        this.cache = new ConcurrentHashMap(initialSize);
        this.replacementPolicy = new ClockPolicy(this, initialSize, maxSize);
        this.holderFactory = holderFactory;
        this.name = name;
        this.maxSize = maxSize;
    }

    ReplacementPolicy getReplacementPolicy() {
        return this.replacementPolicy;
    }

    private CacheEntry getEntry(Object key) {
        CacheEntry freshEntry;
        CacheEntry entry = this.cache.get(key);
        while (true) {
            if (entry != null) {
                entry.lock();
                entry.waitUntilIdentityIsSet();
                if (entry.isValid()) {
                    return entry;
                }
                entry.unlock();
                entry = this.cache.get(key);
                continue;
            }
            freshEntry = new CacheEntry();
            freshEntry.lock();
            CacheEntry oldEntry = this.cache.putIfAbsent(key, freshEntry);
            if (oldEntry == null) break;
            entry = oldEntry;
        }
        return freshEntry;
    }

    private void removeEntry(Object key) {
        CacheEntry entry = this.cache.remove(key);
        Cacheable c = entry.getCacheable();
        if (c != null && c.getIdentity() != null) {
            c.clearIdentity();
        }
        entry.free();
    }

    void evictEntry(Object key) {
        CacheEntry entry = this.cache.remove(key);
        entry.getCacheable().clearIdentity();
        entry.setCacheable(null);
        this.countEviction();
    }

    private Cacheable insertIntoFreeSlot(Object key, CacheEntry entry) throws StandardException {
        try {
            this.replacementPolicy.insertEntry(entry);
        }
        catch (StandardException se) {
            this.removeEntry(key);
            throw se;
        }
        Cacheable free = entry.getCacheable();
        if (free == null) {
            free = this.holderFactory.newCacheable(this);
        }
        entry.keep(true);
        return free;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void settingIdentityComplete(Object key, CacheEntry entry, Cacheable item) {
        entry.lock();
        try {
            entry.settingIdentityComplete();
            if (item != null) {
                entry.setCacheable(item);
            } else {
                this.removeEntry(key);
            }
        }
        finally {
            entry.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cacheable find(Object key) throws StandardException {
        Cacheable item;
        if (this.stopped) {
            return null;
        }
        CacheEntry entry = this.getEntry(key);
        try {
            item = entry.getCacheable();
            if (item != null) {
                entry.keep(true);
                this.countHit();
                Cacheable cacheable = item;
                return cacheable;
            }
            item = this.insertIntoFreeSlot(key, entry);
            this.countMiss();
        }
        finally {
            entry.unlock();
        }
        Cacheable itemWithIdentity = null;
        try {
            itemWithIdentity = item.setIdentity(key);
        }
        finally {
            this.settingIdentityComplete(key, entry, itemWithIdentity);
        }
        return itemWithIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cacheable findCached(Object key) throws StandardException {
        if (this.stopped) {
            return null;
        }
        CacheEntry entry = this.cache.get(key);
        if (entry == null) {
            this.countMiss();
            return null;
        }
        entry.lock();
        try {
            entry.waitUntilIdentityIsSet();
            Cacheable item = entry.getCacheable();
            if (item != null) {
                this.countHit();
                entry.keep(true);
            } else {
                this.countMiss();
            }
            Cacheable cacheable = item;
            return cacheable;
        }
        finally {
            entry.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cacheable create(Object key, Object createParameter) throws StandardException {
        Cacheable item;
        if (this.stopped) {
            return null;
        }
        CacheEntry entry = new CacheEntry();
        entry.lock();
        if (this.cache.putIfAbsent(key, entry) != null) {
            throw StandardException.newException("XBCA0.S", this.name, key);
        }
        try {
            item = this.insertIntoFreeSlot(key, entry);
        }
        finally {
            entry.unlock();
        }
        Cacheable itemWithIdentity = null;
        try {
            itemWithIdentity = item.createIdentity(key, createParameter);
        }
        finally {
            this.settingIdentityComplete(key, entry, itemWithIdentity);
        }
        return itemWithIdentity;
    }

    @Override
    public void release(Cacheable item) {
        CacheEntry entry = this.cache.get(item.getIdentity());
        entry.lock();
        try {
            SanityManager.ASSERT(item == entry.getCacheable());
            entry.unkeep();
        }
        finally {
            entry.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Cacheable item) throws StandardException {
        Object key = item.getIdentity();
        CacheEntry entry = this.cache.get(key);
        entry.lock();
        try {
            SanityManager.ASSERT(item == entry.getCacheable());
            entry.unkeepForRemove();
            item.clean(true);
            this.removeEntry(key);
        }
        finally {
            entry.unlock();
        }
    }

    @Override
    public void cleanAll() throws StandardException {
        this.cleanCache(null);
    }

    @Override
    public void clean(Matchable partialKey) throws StandardException {
        this.cleanCache(partialKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCache(Matchable partialKey) throws StandardException {
        for (CacheEntry entry : this.cache.values()) {
            Cacheable dirtyObject;
            entry.lock();
            try {
                if (!entry.isValid()) continue;
                Cacheable c = entry.getCacheable();
                if (partialKey != null && !partialKey.match(c.getIdentity()) || !c.isDirty()) continue;
                entry.keep(false);
                dirtyObject = c;
            }
            finally {
                entry.unlock();
                continue;
            }
            this.cleanAndUnkeepEntry(entry, dirtyObject);
        }
    }

    void cleanEntry(CacheEntry entry) throws StandardException {
        Cacheable item;
        entry.lock();
        try {
            item = entry.getCacheable();
            if (item == null) {
                return;
            }
            entry.keep(false);
        }
        finally {
            entry.unlock();
        }
        this.cleanAndUnkeepEntry(entry, item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanAndUnkeepEntry(CacheEntry entry, Cacheable item) throws StandardException {
        try {
            item.clean(false);
            entry.lock();
        }
        catch (Throwable throwable) {
            entry.lock();
            try {
                SanityManager.ASSERT(entry.getCacheable() == item, "CacheEntry didn't contain the expected Cacheable");
                entry.unkeep();
            }
            finally {
                entry.unlock();
            }
            throw throwable;
        }
        try {
            SanityManager.ASSERT(entry.getCacheable() == item, "CacheEntry didn't contain the expected Cacheable");
            entry.unkeep();
        }
        finally {
            entry.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ageOut() {
        for (CacheEntry entry : this.cache.values()) {
            entry.lock();
            try {
                Cacheable c;
                if (entry.isKept() || (c = entry.getCacheable()) == null || c.isDirty()) continue;
                this.removeEntry(c.getIdentity());
            }
            finally {
                entry.unlock();
            }
        }
    }

    @Override
    public void shutdown() throws StandardException {
        this.stopped = true;
        this.cleanAll();
        this.ageOut();
        if (this.cleaner != null) {
            this.cleaner.unsubscribe();
        }
        this.deregisterMBean();
    }

    @Override
    public void useDaemonService(DaemonService daemon) {
        if (this.cleaner != null) {
            this.cleaner.unsubscribe();
        }
        this.cleaner = new BackgroundCleaner(this, daemon, Math.max(this.maxSize / 10, 1));
    }

    BackgroundCleaner getBackgroundCleaner() {
        return this.cleaner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean discard(Matchable partialKey) {
        boolean allRemoved = true;
        for (CacheEntry entry : this.cache.values()) {
            entry.lock();
            try {
                Cacheable c = entry.getCacheable();
                if (c == null || partialKey != null && !partialKey.match(c.getIdentity())) continue;
                if (entry.isKept()) {
                    allRemoved = false;
                    continue;
                }
                this.removeEntry(c.getIdentity());
            }
            finally {
                entry.unlock();
            }
        }
        return allRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Cacheable> values() {
        ArrayList<Cacheable> values = new ArrayList<Cacheable>();
        for (CacheEntry entry : this.cache.values()) {
            entry.lock();
            try {
                Cacheable c = entry.getCacheable();
                if (c == null) continue;
                values.add(c);
            }
            finally {
                entry.unlock();
            }
        }
        return values;
    }

    @Override
    public void registerMBean(String dbName) throws StandardException {
        SanityManager.ASSERT(this.mbean == null, "registerMBean() called twice");
        ManagementService managementService = (ManagementService)ConcurrentCache.getSystemModule("org.apache.derby.iapi.services.jmx.ManagementService");
        if (managementService != null) {
            this.mbean = managementService.registerMBean(new ConcurrentCacheMBeanImpl(this), CacheManagerMBean.class, "type=CacheManager,name=" + this.name + ",db=" + managementService.quotePropertyValue(dbName));
        }
    }

    @Override
    public void deregisterMBean() {
        if (this.mbean != null) {
            ManagementService managementService = (ManagementService)ConcurrentCache.getSystemModule("org.apache.derby.iapi.services.jmx.ManagementService");
            if (managementService != null) {
                managementService.unregisterMBean(this.mbean);
            }
            this.mbean = null;
        }
    }

    private void countHit() {
        if (this.collectAccessCounts) {
            this.hits.getAndIncrement();
        }
    }

    private void countMiss() {
        if (this.collectAccessCounts) {
            this.misses.getAndIncrement();
        }
    }

    private void countEviction() {
        if (this.collectAccessCounts) {
            this.evictions.getAndIncrement();
        }
    }

    void setCollectAccessCounts(boolean collect) {
        this.collectAccessCounts = collect;
    }

    boolean getCollectAccessCounts() {
        return this.collectAccessCounts;
    }

    long getHitCount() {
        return this.hits.get();
    }

    long getMissCount() {
        return this.misses.get();
    }

    long getEvictionCount() {
        return this.evictions.get();
    }

    long getMaxEntries() {
        return this.maxSize;
    }

    long getAllocatedEntries() {
        return this.replacementPolicy.size();
    }

    long getUsedEntries() {
        return this.cache.size();
    }

    private static Object getSystemModule(final String factoryInterface) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Monitor.getSystemModule(factoryInterface);
            }
        });
    }
}

