/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;

public class MaxLogNumber {
    static final int COMMIT = 1;
    static final int ROLLBACK = 2;
    static final int NOACTION = 3;

    MaxLogNumber() {
    }

    private void runTest(Connection conn) throws SQLException {
        this.logMessage("Begin MaxLogNumber Test");
        this.performCheckPoint(conn);
        this.createTable(conn);
        this.insert(conn, 100, 1, 10);
        this.insert(conn, 100, 2, 10);
        this.update(conn, 50, 1, 10);
        this.update(conn, 50, 2, 10);
        this.verifyData(conn, 100);
        this.insert(conn, 2000, 3, 2000);
        this.logMessage("End MaxLogNumber Test");
    }

    void performCheckPoint(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.executeUpdate("CALL SYSCS_UTIL.SYSCS_CHECKPOINT_DATABASE()");
        stmt.close();
    }

    void insert(Connection conn, int rowCount, int txStatus, int commitCount) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("INSERT INTO emp VALUES(?,?,?)");
        for (int i = 0; i < rowCount; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "skywalker" + i);
            ps.setFloat(3, i * 2000);
            ps.executeUpdate();
            if (i % commitCount != 0) continue;
            this.endTransaction(conn, txStatus);
        }
        this.endTransaction(conn, txStatus);
        ps.close();
    }

    void endTransaction(Connection conn, int txStatus) throws SQLException {
        switch (txStatus) {
            case 1: {
                conn.commit();
                break;
            }
            case 2: {
                conn.rollback();
                break;
            }
        }
    }

    void update(Connection conn, int rowCount, int txStatus, int commitCount) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("update emp SET salary=? where id=?");
        for (int i = 0; i < rowCount; ++i) {
            ps.setFloat(1, (float)((double)(i * 2000) * 0.08));
            ps.setInt(2, i);
            ps.executeUpdate();
            if (i % commitCount != 0) continue;
            this.endTransaction(conn, txStatus);
        }
        this.endTransaction(conn, txStatus);
        ps.close();
    }

    void verifyData(Connection conn, int expectedRowCount) throws SQLException {
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("SELECT ID, name from emp order by id");
        int count = 0;
        int id = 0;
        while (rs.next()) {
            int tid = rs.getInt(1);
            String name = rs.getString(2);
            if (name.equals("skywalker" + id) && tid != id) {
                this.logMessage("DATA IN THE TABLE IS NOT AS EXPECTED");
                this.logMessage("Got :ID=" + tid + " Name=:" + name);
                this.logMessage("Expected: ID=" + id + "Name=skywalker" + id);
            }
            ++id;
            ++count;
        }
        if (count != expectedRowCount) {
            this.logMessage("Expected Number Of Rows (" + expectedRowCount + ")!=No Of rows in the Table(" + count + ")");
        }
        s.close();
    }

    void createTable(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.executeUpdate("CREATE TABLE emp(id INT,name CHAR(200),salary float)");
        s.executeUpdate("create index emp_idx on emp(id) ");
        conn.commit();
        s.close();
    }

    void logMessage(String str) {
        System.out.println(str);
    }

    public static void main(String[] argv) throws Throwable {
        MaxLogNumber test = new MaxLogNumber();
        ij.getPropertyArg((String[])argv);
        Connection conn = ij.startJBMS();
        conn.setAutoCommit(false);
        try {
            test.runTest(conn);
        }
        catch (SQLException sqle) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sqle);
            sqle.printStackTrace(System.out);
        }
    }
}

