/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class TruncateTableAndOnlineBackupTest
extends BaseJDBCTestCase {
    static String home = null;
    static final String dbName = "TTOB_db";
    static final String backupDir = "TTOB_backup";

    public TruncateTableAndOnlineBackupTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("TruncateTableAndOnlineBackupTest");
        suite.addTest(TruncateTableAndOnlineBackupTest.baseSuite("TruncateTableAndOnlineBackupTest:Embedded"));
        return TestConfiguration.singleUseDatabaseDecorator((Test)suite, dbName);
    }

    protected static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        suite.addTestSuite(TruncateTableAndOnlineBackupTest.class);
        return new CleanDatabaseTestSetup((Test)suite);
    }

    public void setUp() throws Exception {
        this.getConnection();
        home = TruncateTableAndOnlineBackupTest.getSystemProperty("derby.system.home");
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table truncable(i int)");
        PreparedStatement ps = this.getConnection().prepareStatement("insert into truncable values (?)");
        this.getConnection().setAutoCommit(false);
        for (int i = 1; i <= 1000; ++i) {
            ps.setInt(1, i);
            ps.executeUpdate();
        }
        this.getConnection().commit();
    }

    @Override
    public void tearDown() throws Exception {
        this.getConnection().createStatement().execute("drop table truncable");
        super.tearDown();
    }

    public void testUncommittedTruncateBasicBackup() throws Exception {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        JDBC.assertFullResultSet(s.executeQuery("select count(*) from truncable"), new String[][]{{"1000"}});
        s.executeUpdate("truncate table truncable");
        ResultSet rs = s.executeQuery("select * from truncable");
        JDBC.assertEmpty(rs);
        CallableStatement cs = this.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        String fullBackupDir = home + "/TTOB_backup";
        cs.setString(1, fullBackupDir);
        cs.execute();
        DataSource ds2 = JDBCDataSource.getDataSource(fullBackupDir + "/TTOB_db");
        Connection con2 = ds2.getConnection();
        Statement s2 = con2.createStatement();
        JDBC.assertFullResultSet(s2.executeQuery("select count(*) from truncable"), new String[][]{{"1000"}});
        con2.close();
        DataSource[] srcs = new DataSource[]{JDBCDataSource.getDataSource(), JDBCDataSource.getDataSource(fullBackupDir + "/TTOB_db")};
        for (int i = 0; i < srcs.length; ++i) {
            JDBCDataSource.setBeanProperty(srcs[i], "connectionAttributes", "shutdown=true");
            try {
                srcs[i].getConnection();
                TruncateTableAndOnlineBackupTest.fail((String)"shutdown failed: expected exception");
                continue;
            }
            catch (SQLException e) {
                TruncateTableAndOnlineBackupTest.assertSQLState("database shutdown", "08006", e);
            }
        }
        TruncateTableAndOnlineBackupTest.assertDirectoryDeleted(new File(fullBackupDir));
    }

    public void testUncommittedTruncateBackupEnableLog() throws Exception {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        JDBC.assertFullResultSet(s.executeQuery("select count(*) from truncable"), new String[][]{{"1000"}});
        s.executeUpdate("truncate table truncable");
        ResultSet rs = s.executeQuery("select * from truncable");
        JDBC.assertEmpty(rs);
        CallableStatement cs = this.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE(?,1)");
        String fullBackupDir = home + "/TTOB_backup";
        cs.setString(1, fullBackupDir);
        cs.execute();
        this.commit();
        DataSource ds2 = JDBCDataSource.getDataSource(fullBackupDir + "/TTOB_db");
        Connection con2 = ds2.getConnection();
        Statement s2 = con2.createStatement();
        JDBC.assertFullResultSet(s2.executeQuery("select count(*) from truncable"), new String[][]{{"1000"}});
        con2.close();
        String fullBackupDir2 = fullBackupDir + "2";
        cs.setString(1, fullBackupDir2);
        cs.execute();
        DataSource ds3 = JDBCDataSource.getDataSource(fullBackupDir2 + "/TTOB_db");
        Connection con3 = ds3.getConnection();
        Statement s3 = con3.createStatement();
        rs = s3.executeQuery("select * from truncable");
        JDBC.assertEmpty(rs);
        DataSource[] srcs = new DataSource[]{JDBCDataSource.getDataSource(), JDBCDataSource.getDataSource(fullBackupDir + "/TTOB_db"), JDBCDataSource.getDataSource(fullBackupDir2 + "/TTOB_db")};
        for (int i = 0; i < srcs.length; ++i) {
            JDBCDataSource.setBeanProperty(srcs[i], "connectionAttributes", "shutdown=true");
            try {
                srcs[i].getConnection();
                TruncateTableAndOnlineBackupTest.fail((String)"shutdown failed: expected exception");
                continue;
            }
            catch (SQLException e) {
                TruncateTableAndOnlineBackupTest.assertSQLState("database shutdown", "08006", e);
            }
        }
        TruncateTableAndOnlineBackupTest.assertDirectoryDeleted(new File(fullBackupDir));
        TruncateTableAndOnlineBackupTest.assertDirectoryDeleted(new File(fullBackupDir2));
    }

    public void testTruncateFreezeUnfreeze() throws Exception {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        JDBC.assertFullResultSet(s.executeQuery("select count(*) from truncable"), new String[][]{{"1000"}});
        s.executeUpdate("truncate table truncable");
        ResultSet rs = s.executeQuery("select * from truncable");
        JDBC.assertEmpty(rs);
        s.execute("call syscs_util.syscs_freeze_database()");
        String fullBackupDir = "TTOB_backup2";
        File DbDir = new File(home, dbName);
        File fullBackupDbDir = new File(home, fullBackupDir);
        PrivilegedFileOpsForTests.copy(DbDir, fullBackupDbDir);
        rs = s.executeQuery("select * from truncable");
        JDBC.assertEmpty(rs);
        DataSource ds2 = JDBCDataSource.getDataSource(fullBackupDir);
        Connection con2 = ds2.getConnection();
        Statement s2 = con2.createStatement();
        JDBC.assertFullResultSet(s2.executeQuery("select count(*) from truncable"), new String[][]{{"1000"}});
        s.execute("call syscs_util.syscs_unfreeze_database()");
        rs = s.executeQuery("select * from truncable");
        JDBC.assertEmpty(rs);
        s.executeUpdate("insert into truncable values(2001)");
        JDBC.assertFullResultSet(s.executeQuery("select count(*) from truncable"), new String[][]{{"1"}});
        this.rollback();
        JDBC.assertFullResultSet(s.executeQuery("select count(*) from truncable"), new String[][]{{"1000"}});
        JDBC.assertFullResultSet(s2.executeQuery("select count(*) from truncable"), new String[][]{{"1000"}});
        s2.close();
        con2.close();
        DataSource[] srcs = new DataSource[]{JDBCDataSource.getDataSource(), ds2};
        for (int i = 0; i < srcs.length; ++i) {
            JDBCDataSource.setBeanProperty(srcs[i], "connectionAttributes", "shutdown=true");
            try {
                srcs[i].getConnection();
                TruncateTableAndOnlineBackupTest.fail((String)"shutdown failed: expected exception");
                continue;
            }
            catch (SQLException e) {
                TruncateTableAndOnlineBackupTest.assertSQLState("database shutdown", "08006", e);
            }
        }
        TruncateTableAndOnlineBackupTest.assertDirectoryDeleted(new File(home + "/" + fullBackupDir));
    }
}

