/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubCheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class SYSCONSTRAINTSRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSCONSTRAINTS";
    protected static final int SYSCONSTRAINTS_COLUMN_COUNT = 7;
    protected static final int SYSCONSTRAINTS_CONSTRAINTID = 1;
    protected static final int SYSCONSTRAINTS_TABLEID = 2;
    protected static final int SYSCONSTRAINTS_CONSTRAINTNAME = 3;
    protected static final int SYSCONSTRAINTS_TYPE = 4;
    protected static final int SYSCONSTRAINTS_SCHEMAID = 5;
    public static final int SYSCONSTRAINTS_STATE = 6;
    protected static final int SYSCONSTRAINTS_REFERENCECOUNT = 7;
    protected static final int SYSCONSTRAINTS_INDEX1_ID = 0;
    protected static final int SYSCONSTRAINTS_INDEX2_ID = 1;
    protected static final int SYSCONSTRAINTS_INDEX3_ID = 2;
    private static final boolean[] uniqueness = new boolean[]{true, true, false};
    private static final int[][] indexColumnPositions = new int[][]{{1}, {3, 5}, {2}};
    private static final String[] uuids = new String[]{"8000002f-00d0-fd77-3ed8-000a0a0b1900", "80000036-00d0-fd77-3ed8-000a0a0b1900", "80000031-00d0-fd77-3ed8-000a0a0b1900", "80000033-00d0-fd77-3ed8-000a0a0b1900", "80000035-00d0-fd77-3ed8-000a0a0b1900"};

    SYSCONSTRAINTSRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(7, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        String constraintSType = null;
        String constraintID = null;
        String tableID = null;
        String constraintName = null;
        String schemaID = null;
        boolean deferrable = false;
        boolean initiallyDeferred = false;
        boolean enforced = true;
        int referenceCount = 0;
        if (td != null) {
            ConstraintDescriptor constraint = (ConstraintDescriptor)td;
            UUID oid = constraint.getUUID();
            constraintID = oid.toString();
            oid = constraint.getTableId();
            tableID = oid.toString();
            constraintName = constraint.getConstraintName();
            int constraintIType = constraint.getConstraintType();
            switch (constraintIType) {
                case 2: {
                    constraintSType = "P";
                    break;
                }
                case 3: {
                    constraintSType = "U";
                    break;
                }
                case 4: {
                    constraintSType = "C";
                    break;
                }
                case 6: {
                    constraintSType = "F";
                    break;
                }
                default: {
                    SanityManager.THROWASSERT("invalid constraint type");
                }
            }
            schemaID = constraint.getSchemaDescriptor().getUUID().toString();
            deferrable = constraint.deferrable();
            initiallyDeferred = constraint.initiallyDeferred();
            enforced = constraint.enforced();
            referenceCount = constraint.getReferenceCount();
        }
        ExecRow row = this.getExecutionFactory().getValueRow(7);
        row.setColumn(1, new SQLChar(constraintID));
        row.setColumn(2, new SQLChar(tableID));
        row.setColumn(3, new SQLVarchar(constraintName));
        row.setColumn(4, new SQLChar(constraintSType));
        row.setColumn(5, new SQLChar(schemaID));
        row.setColumn(6, new SQLChar(this.encodeCharacteristics(deferrable, initiallyDeferred, enforced)));
        row.setColumn(7, new SQLInteger(referenceCount));
        return row;
    }

    private String encodeCharacteristics(boolean deferrable, boolean initiallyDeferred, boolean enforced) {
        char c;
        if (deferrable) {
            c = initiallyDeferred ? (enforced ? (char)'e' : 'd') : (enforced ? (char)'i' : 'j');
        } else if (initiallyDeferred) {
            SanityManager.NOTREACHED();
            c = 'E';
        } else {
            c = enforced ? (char)'E' : 'D';
        }
        return String.valueOf(c);
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        ConstraintDescriptor constraintDesc = null;
        SanityManager.ASSERT(row.nColumns() == 7, "Wrong number of columns for a SYSCONSTRAINTS row");
        TableDescriptor td = null;
        int constraintIType = -1;
        int[] keyColumns = null;
        UUID referencedConstraintId = null;
        boolean deferrable = false;
        boolean initiallyDeferred = false;
        boolean enforced = true;
        if (!(parentTupleDescriptor instanceof SubConstraintDescriptor)) {
            SanityManager.THROWASSERT("parentTupleDescriptor expected to be instanceof SubConstraintDescriptor, not " + parentTupleDescriptor.getClass().getName());
        }
        SubConstraintDescriptor scd = (SubConstraintDescriptor)parentTupleDescriptor;
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        DataValueDescriptor col = row.getColumn(1);
        String constraintUUIDString = col.getString();
        UUID constraintUUID = this.getUUIDFactory().recreateUUID(constraintUUIDString);
        col = row.getColumn(2);
        String tableUUIDString = col.getString();
        UUID tableUUID = this.getUUIDFactory().recreateUUID(tableUUIDString);
        if (scd != null) {
            td = scd.getTableDescriptor();
        }
        if (td == null) {
            td = dd.getTableDescriptor(tableUUID);
        }
        col = row.getColumn(3);
        String constraintName = col.getString();
        col = row.getColumn(4);
        String constraintSType = col.getString();
        SanityManager.ASSERT(constraintSType.length() == 1, "Fourth column type incorrect");
        boolean typeSet = false;
        switch (constraintSType.charAt(0)) {
            case 'P': {
                constraintIType = 2;
                typeSet = true;
            }
            case 'U': {
                if (!typeSet) {
                    constraintIType = 3;
                    typeSet = true;
                }
            }
            case 'F': {
                ConglomerateDescriptor conglomDesc;
                if (!typeSet) {
                    constraintIType = 6;
                }
                if (!(parentTupleDescriptor instanceof SubKeyConstraintDescriptor)) {
                    SanityManager.THROWASSERT("parentTupleDescriptor expected to be instanceof SubKeyConstraintDescriptor, not " + parentTupleDescriptor.getClass().getName());
                }
                if ((conglomDesc = td.getConglomerateDescriptor(((SubKeyConstraintDescriptor)parentTupleDescriptor).getIndexId())) == null) {
                    td = dd.getTableDescriptor(tableUUID);
                    if (scd != null) {
                        scd.setTableDescriptor(td);
                    }
                    conglomDesc = td.getConglomerateDescriptor(((SubKeyConstraintDescriptor)parentTupleDescriptor).getIndexId());
                }
                SanityManager.ASSERT(conglomDesc != null, "conglomDesc is expected to be non-null for backing index");
                keyColumns = conglomDesc.getIndexDescriptor().baseColumnPositions();
                referencedConstraintId = ((SubKeyConstraintDescriptor)parentTupleDescriptor).getKeyConstraintId();
                keyColumns = conglomDesc.getIndexDescriptor().baseColumnPositions();
                break;
            }
            case 'C': {
                constraintIType = 4;
                if (parentTupleDescriptor instanceof SubCheckConstraintDescriptor) break;
                SanityManager.THROWASSERT("parentTupleDescriptor expected to be instanceof SubCheckConstraintDescriptor, not " + parentTupleDescriptor.getClass().getName());
                break;
            }
            default: {
                SanityManager.THROWASSERT("Fourth column value invalid");
            }
        }
        col = row.getColumn(5);
        String schemaUUIDString = col.getString();
        UUID schemaUUID = this.getUUIDFactory().recreateUUID(schemaUUIDString);
        SchemaDescriptor schema = dd.getSchemaDescriptor(schemaUUID, null);
        col = row.getColumn(6);
        String constraintStateStr = col.getString();
        SanityManager.ASSERT(constraintStateStr.length() == 1, "Sixth column (state) type incorrect");
        switch (constraintStateStr.charAt(0)) {
            case 'E': {
                deferrable = false;
                initiallyDeferred = false;
                enforced = true;
                break;
            }
            case 'D': {
                deferrable = false;
                initiallyDeferred = false;
                enforced = false;
                break;
            }
            case 'e': {
                deferrable = true;
                initiallyDeferred = true;
                enforced = true;
                break;
            }
            case 'd': {
                deferrable = true;
                initiallyDeferred = true;
                enforced = false;
                break;
            }
            case 'i': {
                deferrable = true;
                initiallyDeferred = false;
                enforced = true;
                break;
            }
            case 'j': {
                deferrable = true;
                initiallyDeferred = false;
                enforced = false;
                break;
            }
            default: {
                SanityManager.THROWASSERT("Invalidate state value '" + constraintStateStr + "' for constraint");
            }
        }
        col = row.getColumn(7);
        int referenceCount = col.getInt();
        switch (constraintIType) {
            case 2: {
                constraintDesc = ddg.newPrimaryKeyConstraintDescriptor(td, constraintName, deferrable, initiallyDeferred, keyColumns, constraintUUID, ((SubKeyConstraintDescriptor)parentTupleDescriptor).getIndexId(), schema, enforced, referenceCount);
                break;
            }
            case 3: {
                constraintDesc = ddg.newUniqueConstraintDescriptor(td, constraintName, deferrable, initiallyDeferred, keyColumns, constraintUUID, ((SubKeyConstraintDescriptor)parentTupleDescriptor).getIndexId(), schema, enforced, referenceCount);
                break;
            }
            case 6: {
                SanityManager.ASSERT(referenceCount == 0, "REFERENCECOUNT column is nonzero for fk constraint");
                constraintDesc = ddg.newForeignKeyConstraintDescriptor(td, constraintName, deferrable, initiallyDeferred, keyColumns, constraintUUID, ((SubKeyConstraintDescriptor)parentTupleDescriptor).getIndexId(), schema, referencedConstraintId, enforced, ((SubKeyConstraintDescriptor)parentTupleDescriptor).getRaDeleteRule(), ((SubKeyConstraintDescriptor)parentTupleDescriptor).getRaUpdateRule());
                break;
            }
            case 4: {
                SanityManager.ASSERT(referenceCount == 0, "REFERENCECOUNT column is nonzero for check constraint");
                constraintDesc = ddg.newCheckConstraintDescriptor(td, constraintName, deferrable, initiallyDeferred, constraintUUID, ((SubCheckConstraintDescriptor)parentTupleDescriptor).getConstraintText(), ((SubCheckConstraintDescriptor)parentTupleDescriptor).getReferencedColumnsDescriptor(), schema, enforced);
            }
        }
        return constraintDesc;
    }

    protected UUID getConstraintId(ExecRow row) throws StandardException {
        DataValueDescriptor col = row.getColumn(1);
        String constraintUUIDString = col.getString();
        return this.getUUIDFactory().recreateUUID(constraintUUIDString);
    }

    protected String getConstraintName(ExecRow row) throws StandardException {
        DataValueDescriptor col = row.getColumn(3);
        String constraintName = col.getString();
        return constraintName;
    }

    protected UUID getSchemaId(ExecRow row) throws StandardException {
        DataValueDescriptor col = row.getColumn(5);
        String schemaUUIDString = col.getString();
        return this.getUUIDFactory().recreateUUID(schemaUUIDString);
    }

    protected UUID getTableId(ExecRow row) throws StandardException {
        DataValueDescriptor col = row.getColumn(2);
        String tableUUIDString = col.getString();
        return this.getUUIDFactory().recreateUUID(tableUUIDString);
    }

    protected int getConstraintType(ExecRow row) throws StandardException {
        int constraintIType;
        DataValueDescriptor col = row.getColumn(4);
        String constraintSType = col.getString();
        SanityManager.ASSERT(constraintSType.length() == 1, "Fourth column type incorrect");
        switch (constraintSType.charAt(0)) {
            case 'P': {
                constraintIType = 2;
                break;
            }
            case 'U': {
                constraintIType = 3;
                break;
            }
            case 'C': {
                constraintIType = 4;
                break;
            }
            case 'F': {
                constraintIType = 6;
                break;
            }
            default: {
                SanityManager.THROWASSERT("Fourth column value invalid");
                constraintIType = -1;
            }
        }
        return constraintIType;
    }

    @Override
    public SystemColumn[] buildColumnList() {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("CONSTRAINTID", false), SystemColumnImpl.getUUIDColumn("TABLEID", false), SystemColumnImpl.getIdentifierColumn("CONSTRAINTNAME", false), SystemColumnImpl.getIndicatorColumn("TYPE"), SystemColumnImpl.getUUIDColumn("SCHEMAID", false), SystemColumnImpl.getIndicatorColumn("STATE"), SystemColumnImpl.getColumn("REFERENCECOUNT", 4, false)};
    }
}

