/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.drda.AppRequester;
import org.apache.derby.impl.drda.Database;
import org.apache.derby.impl.drda.DssTrace;
import org.apache.derby.impl.drda.NetworkServerControlImpl;

class Session {
    protected static final int INIT = 1;
    protected static final int ATTEXC = 2;
    protected static final int SECACC = 3;
    protected static final int CHKSEC = 4;
    protected static final int CLOSED = 5;
    protected static final int DRDA_SESSION = 1;
    protected static final int CMD_SESSION = 2;
    private static final String TRACENAME_PREFIX = "Server";
    private static final String TRACENAME_SUFFIX = ".trace";
    protected Socket clientSocket;
    protected int connNum;
    protected InputStream sessionInput;
    protected OutputStream sessionOutput;
    protected String traceFileName;
    protected boolean traceOn;
    protected int state;
    protected int sessionType;
    protected String drdaID;
    protected DssTrace dssTrace;
    protected AppRequester appRequester;
    protected Database database;
    protected int qryinsid;
    protected LocalizedResource langUtil;
    private Hashtable<String, Database> dbtable;
    private NetworkServerControlImpl nsctrl;

    Session(NetworkServerControlImpl nsctrl, int connNum, Socket clientSocket, String traceDirectory, boolean traceOn) throws Exception {
        this.nsctrl = nsctrl;
        this.connNum = connNum;
        this.clientSocket = clientSocket;
        this.traceOn = traceOn;
        if (traceOn) {
            this.dssTrace = new DssTrace();
        }
        this.dbtable = new Hashtable();
        this.initialize(traceDirectory);
    }

    protected void close() throws SQLException {
        try {
            this.sessionInput.close();
            this.sessionOutput.close();
            this.clientSocket.close();
            this.setTraceOff();
            if (this.dbtable != null) {
                Enumeration<Database> e = this.dbtable.elements();
                while (e.hasMoreElements()) {
                    e.nextElement().close();
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.state = 5;
            this.dbtable = null;
            this.database = null;
        }
    }

    protected void initTrace(String traceDirectory, boolean throwException) throws Exception {
        this.traceFileName = traceDirectory != null ? traceDirectory + "/" + TRACENAME_PREFIX + this.connNum + TRACENAME_SUFFIX : TRACENAME_PREFIX + this.connNum + TRACENAME_SUFFIX;
        if (this.dssTrace == null) {
            this.dssTrace = new DssTrace();
        }
        try {
            this.dssTrace.startComBufferTrace(this.traceFileName);
            this.traceOn = true;
        }
        catch (Exception e) {
            if (throwException) {
                throw e;
            }
            this.nsctrl.consoleExceptionPrintTrace(e);
        }
    }

    protected void setTraceOn(String traceDirectory, boolean throwException) throws Exception {
        if (this.traceOn) {
            return;
        }
        this.initTrace(traceDirectory, throwException);
    }

    protected boolean isTraceOn() {
        return this.traceOn;
    }

    protected int getConnNum() {
        return this.connNum;
    }

    protected void setTraceOff() {
        if (!this.traceOn) {
            return;
        }
        this.traceOn = false;
        if (this.traceFileName != null) {
            this.dssTrace.stopComBufferTrace();
        }
    }

    protected void addDatabase(Database d) {
        this.dbtable.put(d.getDatabaseName(), d);
    }

    protected Database getDatabase(String dbName) {
        return this.dbtable.get(dbName);
    }

    protected int getRequiredSecurityCodepoint() {
        switch (this.state) {
            case 2: {
                return 4205;
            }
            case 3: {
                return 4206;
            }
        }
        return -1;
    }

    protected boolean requiresSecurityCodepoint() {
        return this.getRequiredSecurityCodepoint() != -1;
    }

    protected void setState(int s) {
        this.state = s;
    }

    private void initialize(String traceDirectory) throws Exception {
        this.sessionInput = this.clientSocket.getInputStream();
        this.sessionOutput = this.clientSocket.getOutputStream();
        if (this.traceOn) {
            this.initTrace(traceDirectory, false);
        }
        this.state = 1;
    }

    protected String buildRuntimeInfo(String indent, LocalizedResource localLangUtil) {
        String s = "";
        s = s + indent + localLangUtil.getTextMessage("DRDA_RuntimeInfoSessionNumber.I", new Object[0]) + this.connNum + "\n";
        Database db = this.database;
        if (db != null) {
            s = s + db.buildRuntimeInfo(indent, localLangUtil);
            s = s + "\n";
        }
        return s;
    }
}

