/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.drda;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;

public class NetServlet
extends HttpServlet {
    private static final int MAX_CONNECT_TRYS = 20;
    private static final String SERVLET_PROP_MESSAGES = "org.apache.derby.loc.drda.servlet";
    private static final String SERVLET_ADDRESS = "derbynet";
    private static final String[] knownLang = new String[]{"cs", "en", "es", "de_DE", "fr", "hu", "it", "ja_JP", "ko_KR", "pl", "pt_BR", "ru", "zh_CN", "zh_TW"};
    private String host = "localhost";
    private int portNumber = 1527;
    private volatile String tracingDirectory;
    private volatile boolean logStatus = false;
    private volatile boolean traceStatus = false;
    private static final int NOT_GIVEN = -2;
    private static final int INVALID = -3;
    private NetworkServerControl server;

    public void init(ServletConfig config) throws ServletException {
        boolean start;
        String hostName;
        int p;
        String port = config.getInitParameter("portNumber");
        if (port != null && (p = Integer.parseInt(port)) > 0) {
            this.portNumber = p;
        }
        if ((hostName = config.getInitParameter("host")) != null) {
            this.host = hostName;
        }
        this.tracingDirectory = config.getInitParameter("tracingDirectory");
        if (this.tracingDirectory == null) {
            this.tracingDirectory = "";
        }
        String startup = config.getInitParameter("startNetworkServerOnInit");
        try {
            if (this.server == null) {
                this.server = new NetworkServerControl(InetAddress.getByName(this.host), this.portNumber);
                if (!this.tracingDirectory.trim().equals("")) {
                    this.server.setTraceDirectory(this.tracingDirectory);
                }
            }
            if (NetServlet.isServerStarted(this.server, 1)) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (startup != null && (start = Boolean.valueOf(startup).booleanValue())) {
            LocalizedResource langUtil = new LocalizedResource(SERVLET_PROP_MESSAGES);
            this.runServer(langUtil, null, null);
            return;
        }
    }

    public synchronized void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String[] locale = new String[1];
        LocalizedResource langUtil = this.getCurrentAppUI(request, locale);
        response.setContentType("text/html; charset=UTF-8");
        response.setHeader("Cache-Control", "no-cache,no-store");
        String formTarget = request.getContextPath() + request.getServletPath();
        String formHeader = "<form enctype='multipart/form-data; charset=UTF-8' action='" + formTarget + "'>";
        PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF8"), true);
        String logOnMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_LogOn", new Object[0]));
        String logOffMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_LogOff", new Object[0]));
        String traceOnMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_TraceOn", new Object[0]));
        String traceOffMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_TraceOff", new Object[0]));
        String startMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_Start", new Object[0]));
        String stopMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_Stop", new Object[0]));
        String traceSessionMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_TraceSessButton", new Object[0]));
        String traceOnOffMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_TraceOnOff", new Object[0]));
        String returnMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_Return", new Object[0]));
        String traceDirMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_TraceDir", new Object[0]));
        String netParamMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_NetParam", new Object[0]));
        this.printBanner(langUtil, out);
        if (this.server == null) {
            try {
                this.server = new NetworkServerControl();
            }
            catch (Exception e) {
                this.printErrorForm(langUtil, e, returnMessage, out);
                return;
            }
        }
        this.server.setClientLocale(locale[0]);
        String form = this.getForm(request);
        String doAction = this.getDoAction(request);
        if (doAction != null) {
            form = doAction.equals(traceOnOffMessage) ? traceSessionMessage : doAction;
        }
        boolean serverStatus = this.getServerStatus();
        if (form == null) {
            form = serverStatus ? startMessage : stopMessage;
        } else if (form.equals(startMessage)) {
            if (!serverStatus) {
                this.runServer(langUtil, returnMessage, out);
            }
        } else if (form.equals(stopMessage)) {
            if (serverStatus) {
                this.shutdownServer(langUtil, returnMessage, out);
            }
            this.setDefaults();
        } else if (form.equals(returnMessage)) {
            form = serverStatus ? startMessage : stopMessage;
        }
        out.println(formHeader);
        form = this.escapeSingleQuotes(form);
        doAction = this.escapeSingleQuotes(doAction);
        if (form.equals(startMessage)) {
            String logButton = this.getLogging(request);
            String traceButton = this.getTrace(request);
            if (logButton != null && logButton.equals(logOnMessage) && this.logging(langUtil, true, returnMessage, out)) {
                this.logStatus = true;
            }
            if (logButton != null && logButton.equals(logOffMessage) && this.logging(langUtil, false, returnMessage, out)) {
                this.logStatus = false;
            }
            if (traceButton != null && traceButton.equals(traceOnMessage) && this.traceAll(langUtil, true, returnMessage, out)) {
                this.traceStatus = true;
            }
            if (traceButton != null && traceButton.equals(traceOffMessage) && this.traceAll(langUtil, false, returnMessage, out)) {
                this.traceStatus = false;
            }
            this.displayCurrentStatus(langUtil, returnMessage, out);
            out.println("<h4>" + langUtil.getTextMessage("SRV_StopButton", new Object[0]) + "</h4>");
            out.println("<INPUT type=submit name=form value='" + stopMessage + "'>");
            out.println("<h4>" + langUtil.getTextMessage("SRV_LogButton2", new Object[0]) + "</h4>");
            if (this.logStatus) {
                out.println("<INPUT type=submit name=logform value='" + logOffMessage + "'>");
            } else {
                out.println("<INPUT type=submit name=logform value='" + logOnMessage + "'>");
            }
            out.println("<h4>" + langUtil.getTextMessage("SRV_TraceButton2", new Object[0]) + "</h4>");
            if (this.traceStatus) {
                out.println("<INPUT type=submit name=traceform value='" + traceOffMessage + "'>");
            } else {
                out.println("<INPUT type=submit name=traceform value='" + traceOnMessage + "'>");
            }
            out.println("<h4>" + langUtil.getTextMessage("SRV_TraceSession", new Object[0]) + "</h4>");
            out.println("<INPUT type=submit name=form value='" + traceSessionMessage + "'>");
            out.println("<h4>" + langUtil.getTextMessage("SRV_TraceDirButton", new Object[0]) + "</h4>");
            out.println("<INPUT type=submit name=form value='" + traceDirMessage + "'>");
            out.println("<h4>" + langUtil.getTextMessage("SRV_ThreadButton", new Object[0]) + "</h4>");
            out.println("<INPUT type=submit name=form value='" + netParamMessage + "'>");
        } else if (form.equals(stopMessage)) {
            this.printAsContentHeader(langUtil.getTextMessage("SRV_NotStarted", new Object[0]), out);
            String logButton = this.getLogging(request);
            String traceButton = this.getTrace(request);
            if (logButton != null && logButton.equals(logOnMessage)) {
                this.logStatus = true;
            }
            if (logButton != null && logButton.equals(logOffMessage)) {
                this.logStatus = false;
            }
            if (traceButton != null && traceButton.equals(traceOnMessage)) {
                this.traceStatus = true;
            }
            if (traceButton != null && traceButton.equals(traceOffMessage)) {
                this.traceStatus = false;
            }
            if (this.logStatus) {
                out.println("<h4>" + langUtil.getTextMessage("SRV_LogOffButton", new Object[0]) + "</h4>");
                out.println("<INPUT type=submit name=logform value='" + logOffMessage + "'>");
            } else {
                out.println("<h4>" + langUtil.getTextMessage("SRV_LogOnButton", new Object[0]) + "</h4>");
                out.println("<INPUT type=submit name=logform value='" + logOnMessage + "'>");
            }
            if (this.traceStatus) {
                out.println("<h4>" + langUtil.getTextMessage("SRV_TraceOffButton", new Object[0]) + "</h4>");
                out.println("<INPUT type=submit name=traceform value='" + traceOffMessage + "'>");
            } else {
                out.println("<h4>" + langUtil.getTextMessage("SRV_TraceOnButton", new Object[0]) + "</h4>");
                out.println("<INPUT type=submit name=traceform value='" + traceOnMessage + "'>");
            }
            out.println("<h4>" + langUtil.getTextMessage("SRV_StartButton", new Object[0]) + "</h4>");
            out.println("<INPUT type=submit name=form value='" + startMessage + "'>");
        } else if (form.equals(traceSessionMessage)) {
            if (doAction != null && doAction.equals(traceOnOffMessage)) {
                Properties p;
                Integer session;
                String sessionid = request.getParameter("sessionid");
                try {
                    session = Integer.valueOf(sessionid);
                }
                catch (NumberFormatException nfe) {
                    this.printErrorForm(langUtil, langUtil.getTextMessage("SRV_InvalidVal", sessionid, langUtil.getTextMessage("SRV_SessionID", new Object[0])), returnMessage, out);
                    return;
                }
                try {
                    p = this.server.getCurrentProperties();
                }
                catch (Exception e) {
                    this.printErrorForm(langUtil, e, returnMessage, out);
                    return;
                }
                boolean val = p.getProperty("derby.drda.trace" + sessionid) == null;
                if (this.traceSession(langUtil, val, session, returnMessage, out)) {
                    out.println("<h4>" + langUtil.getTextMessage(val ? "SRV_StatusTraceNoOn" : "SRV_StatusTraceNoOff", session.toString()) + "</h4>");
                } else {
                    return;
                }
            }
            this.printAsContentHeader(langUtil.getTextMessage("SRV_TraceSessButton", new Object[0]), out);
            out.println("<h4>" + this.getHtmlLabelledMessageInstance(langUtil, "SRV_SessionID", "sessionId") + "</h4>");
            out.println("<INPUT type=text name=sessionid size=10 maxlength=10 id='sessionId' value=''>");
            out.println("<h4> </h4>");
            out.println("<INPUT type=submit name=doaction value='" + traceOnOffMessage + "'>");
            out.println("<INPUT type=submit name=form value='" + returnMessage + "'>");
        } else if (form.equals(traceDirMessage)) {
            boolean set = false;
            String traceDirectory = null;
            this.printAsContentHeader(traceDirMessage, out);
            if (doAction != null && doAction.equals(traceDirMessage)) {
                traceDirectory = this.getParam(request, "tracedirectory");
                if (this.traceDirectory(langUtil, traceDirectory, returnMessage, out)) {
                    set = true;
                } else {
                    return;
                }
            }
            if (set) {
                out.println("<h2>" + langUtil.getTextMessage("SRV_TraceDirDone", this.escapeHTML(traceDirectory)) + "</h2>");
                out.println("<INPUT type=submit name=form value='" + returnMessage + "'>");
            } else {
                out.println("<h4>" + this.getHtmlLabelledMessageInstance(langUtil, "SRV_TraceDir", "tracedir") + "</h4>");
                out.println("<INPUT type=text name=tracedirectory size=60 maxlength=256 id='tracedir' value='" + this.escapeHTML(this.tracingDirectory) + "'>");
                out.println("<h4> </h4>");
                out.println("<INPUT type=submit name=doaction value='" + traceDirMessage + "'>");
                out.println("<INPUT type=submit name=form value='" + returnMessage + "'>");
            }
        } else if (form.equals(netParamMessage)) {
            int timeSlice;
            int maxThreads;
            String maxName = langUtil.getTextMessage("SRV_NewMaxThreads", new Object[0]);
            String sliceName = langUtil.getTextMessage("SRV_NewTimeSlice", new Object[0]);
            try {
                Properties p = this.server.getCurrentProperties();
                String val = p.getProperty("derby.drda.maxThreads");
                maxThreads = Integer.parseInt(val);
                val = p.getProperty("derby.drda.timeSlice");
                timeSlice = Integer.parseInt(val);
            }
            catch (Exception e) {
                this.printErrorForm(langUtil, e, returnMessage, out);
                return;
            }
            if (doAction != null && doAction.equals(netParamMessage)) {
                int newTimeSlice;
                int newMaxThreads = this.getIntParameter(request, "newmaxthreads", "SRV_NewMaxThreads", langUtil, returnMessage, out);
                int n = newTimeSlice = newMaxThreads == -3 ? -2 : this.getIntParameter(request, "newtimeslice", "SRV_NewTimeSlice", langUtil, returnMessage, out);
                if (newMaxThreads == -3 || newTimeSlice == -3) {
                    return;
                }
                if (newMaxThreads != -2 || newTimeSlice != -2) {
                    if (newMaxThreads != -2) {
                        maxThreads = newMaxThreads;
                    }
                    if (newTimeSlice != -2) {
                        timeSlice = newTimeSlice;
                    }
                    if (!this.setNetParam(langUtil, maxThreads, timeSlice, returnMessage, out)) {
                        return;
                    }
                }
            }
            out.println(formHeader);
            this.printAsContentHeader(netParamMessage, out);
            out.println("<h4>" + langUtil.getTextMessage("SRV_MaxThreads", Integer.toString(maxThreads) + "</h4>"));
            out.println("<h4>" + langUtil.getTextMessage("SRV_TimeSlice", Integer.toString(timeSlice) + "</h4>"));
            out.println("<h4> </h4>");
            out.println("<h4> <label for='newmaxthreads'>" + maxName + "</label> </h4>");
            out.println("<INPUT type=text name=newmaxthreads size=10 maxlength=10 id='newmaxthreads' value=''>");
            out.println("<h4> <label for='newslice'>" + sliceName + "</label> </h4>");
            out.println("<INPUT type=text name=newtimeslice size=10 maxlength=10 id='newslice' value=''>");
            out.println("<h4> </h4>");
            out.println("<INPUT type=submit name=doaction value='" + netParamMessage + "'>");
            out.println("<INPUT type=submit name=form value='" + returnMessage + "'>");
        } else {
            System.out.println("Internal Error: Unknown form, " + form);
            out.println("Internal Error: Unknown form");
        }
        out.println("</body>");
        out.println("</html>");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private String getForm(HttpServletRequest request) throws IOException {
        return this.getParam(request, "form");
    }

    private String getDoAction(HttpServletRequest request) throws IOException {
        return this.getParam(request, "doaction");
    }

    private String getLogging(HttpServletRequest request) throws IOException {
        return this.getParam(request, "logform");
    }

    private String getTrace(HttpServletRequest request) throws IOException {
        return this.getParam(request, "traceform");
    }

    private String getParam(HttpServletRequest request, String paramName) throws IOException {
        String value = request.getParameter(paramName);
        if (value != null) {
            return new String(value.getBytes("ISO-8859-1"), "UTF8");
        }
        return null;
    }

    private void runServer(LocalizedResource localUtil, String returnMessage, PrintWriter out) throws ServletException {
        final Runnable service = new Runnable(){

            @Override
            public void run() {
                try {
                    NetworkServerControl runserver = new NetworkServerControl(InetAddress.getByName(NetServlet.this.host), NetServlet.this.portNumber);
                    runserver.start(null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        };
        Thread servThread = null;
        try {
            servThread = AccessController.doPrivileged(new PrivilegedExceptionAction<Thread>(){

                @Override
                public Thread run() throws Exception {
                    return new Thread(service);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        servThread.start();
        try {
            boolean connectWorked = false;
            int t = 0;
            do {
                ++t;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    throw new ServletException(localUtil.getTextMessage("SRV_Interupt", new Object[0]));
                }
                try {
                    if (!NetServlet.isServerStarted(this.server, 1)) continue;
                    connectWorked = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (!connectWorked && t < 20);
            if (t >= 20) {
                throw new Exception(localUtil.getTextMessage("SRV_MaxTrys", Integer.toString(20)));
            }
            if (this.logStatus) {
                this.server.logConnections(true);
            }
            if (this.traceStatus) {
                this.server.trace(true);
            }
        }
        catch (Exception e) {
            if (out != null) {
                this.printErrorForm(localUtil, e, returnMessage, out);
            }
            throw new ServletException(e.getMessage());
        }
    }

    private void printErrorForm(LocalizedResource localUtil, Exception e, String returnMessage, PrintWriter out) {
        this.printAsContentHeader(localUtil.getTextMessage("SRV_NetworkServerError", new Object[0]), out);
        out.println("<h4>" + localUtil.getTextMessage("SRV_Message", this.escapeHTML(e.getMessage())) + "</h4>");
        out.println("<INPUT type=submit name=form value='" + returnMessage + "'>");
        out.println("</body>");
        out.println("</html>");
    }

    private void printErrorForm(LocalizedResource localUtil, String msg, String returnMessage, PrintWriter out) {
        this.printAsContentHeader(localUtil.getTextMessage("SRV_NetworkServerError", new Object[0]), out);
        out.println("<h4>" + localUtil.getTextMessage("SRV_Message", this.escapeHTML(msg)) + "</h4>");
        out.println("<INPUT type=submit name=form value='" + returnMessage + "'>");
        out.println("</body>");
        out.println("</html>");
    }

    private void displayCurrentStatus(LocalizedResource localUtil, String returnMessage, PrintWriter out) {
        try {
            this.printAsContentHeader(localUtil.getTextMessage("SRV_Started", new Object[0]), out);
            Properties p = this.server.getCurrentProperties();
            String val = p.getProperty("derby.drda.logConnections");
            this.logStatus = val.equals("true");
            if (this.logStatus) {
                out.println("<h4>" + localUtil.getTextMessage("SRV_StatusLogOn", new Object[0]) + "</h4>");
            } else {
                out.println("<h4>" + localUtil.getTextMessage("SRV_StatusLogOff", new Object[0]) + "</h4>");
            }
            val = p.getProperty("derby.drda.traceAll");
            this.traceStatus = val.equals("true");
            if (this.traceStatus) {
                out.println("<h4>" + localUtil.getTextMessage("SRV_StatusTraceOn", new Object[0]) + "</h4>");
            } else {
                out.println("<h4>" + localUtil.getTextMessage("SRV_StatusTraceOff", new Object[0]) + "</h4>");
            }
            val = p.getProperty("derby.drda.portNumber");
            out.println("<h4>" + localUtil.getTextMessage("SRV_PortNumber", val) + "</h4>");
        }
        catch (Exception e) {
            this.printErrorForm(localUtil, e, returnMessage, out);
        }
    }

    private boolean getServerStatus() {
        try {
            if (NetServlet.isServerStarted(this.server, 1)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean shutdownServer(LocalizedResource localUtil, String returnMessage, PrintWriter out) {
        boolean retval = false;
        try {
            this.server.shutdown();
            retval = true;
        }
        catch (Exception e) {
            this.printErrorForm(localUtil, e, returnMessage, out);
        }
        return retval;
    }

    private boolean logging(LocalizedResource localUtil, boolean val, String returnMessage, PrintWriter out) {
        boolean retval = false;
        try {
            this.server.logConnections(val);
            retval = true;
        }
        catch (Exception e) {
            this.printErrorForm(localUtil, e, returnMessage, out);
        }
        return retval;
    }

    private boolean traceAll(LocalizedResource localUtil, boolean val, String returnMessage, PrintWriter out) {
        boolean retval = false;
        try {
            this.server.trace(val);
            retval = true;
        }
        catch (Exception e) {
            this.printErrorForm(localUtil, e, returnMessage, out);
        }
        return retval;
    }

    private boolean traceSession(LocalizedResource localUtil, boolean val, int session, String returnMessage, PrintWriter out) {
        boolean retval = false;
        try {
            this.server.trace(session, val);
            retval = true;
        }
        catch (Exception e) {
            this.printErrorForm(localUtil, e, returnMessage, out);
        }
        return retval;
    }

    private boolean traceDirectory(LocalizedResource localUtil, String traceDirectory, String returnMessage, PrintWriter out) {
        boolean retval = false;
        if (traceDirectory == null || traceDirectory.equals("")) {
            this.printErrorForm(localUtil, localUtil.getTextMessage("SRV_MissingParam", localUtil.getTextMessage("SRV_TraceDir", new Object[0])), returnMessage, out);
            return retval;
        }
        try {
            this.tracingDirectory = traceDirectory;
            this.server.setTraceDirectory(traceDirectory);
            retval = true;
        }
        catch (Exception e) {
            this.printErrorForm(localUtil, e, returnMessage, out);
        }
        return retval;
    }

    private boolean setNetParam(LocalizedResource localUtil, int max, int slice, String returnMessage, PrintWriter out) {
        boolean retval = false;
        try {
            this.server.setMaxThreads(max);
            this.server.setTimeSlice(slice);
            retval = true;
        }
        catch (Exception e) {
            this.printErrorForm(localUtil, e, returnMessage, out);
        }
        return retval;
    }

    private void setDefaults() {
        this.logStatus = false;
        this.traceStatus = false;
    }

    private int getIntParameter(HttpServletRequest request, String name, String fieldKey, LocalizedResource localUtil, String returnMessage, PrintWriter out) {
        int retval;
        String val = request.getParameter(name);
        if (val == null || val.equals("")) {
            return -2;
        }
        try {
            retval = Integer.parseInt(val);
        }
        catch (Exception e) {
            this.printErrorForm(localUtil, localUtil.getTextMessage("SRV_InvalidVal", val, localUtil.getTextMessage(fieldKey, new Object[0])), returnMessage, out);
            return -3;
        }
        if (retval < 0) {
            this.printErrorForm(localUtil, localUtil.getTextMessage("SRV_InvalidVal", val, localUtil.getTextMessage(fieldKey, new Object[0])), returnMessage, out);
            return -3;
        }
        return retval;
    }

    private void printBanner(LocalizedResource localUtil, PrintWriter out) {
        out.println("<!DOCTYPE html>");
        out.println("<html>");
        out.println("<head>");
        out.println("<title>" + localUtil.getTextMessage("SRV_Banner", new Object[0]) + "</title>");
        out.println("</head>");
        out.println("<body>");
        out.println("<a href=\"#navskip\">[ " + localUtil.getTextMessage("SRV_SkipToContent", new Object[0]) + " ]</a>");
        out.println("  -  <a href=\"derbynet\">[ " + localUtil.getTextMessage("SRV_BackToMain", new Object[0]) + " ]</a>");
        out.println("<hr>");
        out.println("<h1>" + localUtil.getTextMessage("SRV_Banner", new Object[0]) + "</h1>");
        out.println("<hr>");
    }

    private LocalizedResource getCurrentAppUI(HttpServletRequest request, String[] locale) {
        String acceptLanguage = request.getHeader("Accept-Language");
        LocalizedResource localUtil = new LocalizedResource(SERVLET_PROP_MESSAGES);
        locale[0] = null;
        if (acceptLanguage == null) {
            return localUtil;
        }
        StringTokenizer tokenizer = new StringTokenizer(acceptLanguage, ",");
        while (tokenizer.hasMoreTokens()) {
            String lang = tokenizer.nextToken();
            int langindex = this.translationAvailable(lang = this.getLocStringFromLanguage(lang));
            if (langindex == -1) continue;
            localUtil.init(null, lang, SERVLET_PROP_MESSAGES);
            locale[0] = lang;
            return localUtil;
        }
        return localUtil;
    }

    private String getLocStringFromLanguage(String lang) {
        int semi = lang.indexOf(59);
        if (semi != -1) {
            lang = lang.substring(0, semi);
        }
        lang = this.fixLanguageCode(lang.trim());
        return lang;
    }

    private int translationAvailable(String lang) {
        for (int i = 0; i < knownLang.length; ++i) {
            if (!knownLang[i].equals(lang)) continue;
            return i;
        }
        return -1;
    }

    private String fixLanguageCode(String lang) {
        int index = lang.indexOf(45);
        if (index != -1) {
            return this.fixLanguageCode(lang, index);
        }
        index = lang.indexOf(95);
        if (index != -1) {
            return this.fixLanguageCode(lang, index);
        }
        return lang;
    }

    private String fixLanguageCode(String lang, int index) {
        return lang.substring(0, index) + "_" + lang.substring(index + 1).toUpperCase(Locale.ENGLISH);
    }

    private String getHtmlLabelledMessageInstance(LocalizedResource localUtil, String key, String id) {
        if (id == null) {
            id = "";
        }
        return "<label for='" + id + "'>" + localUtil.getTextMessage(key, new Object[0]) + "</label>";
    }

    private void printAsContentHeader(String str, PrintWriter out) {
        out.println("<a name=\"navskip\"></a><h2>" + str + "</h2>");
    }

    private String escapeSingleQuotes(String str) {
        if (str == null || str.indexOf("'") < 0) {
            return str;
        }
        char[] cA = str.toCharArray();
        char[] result = new char[5 * cA.length];
        int j = 0;
        for (int i = 0; i < cA.length; ++i) {
            if (cA[i] == '\'') {
                result[j++] = 38;
                result[j++] = 35;
                result[j++] = 51;
                result[j++] = 57;
                result[j++] = 59;
                continue;
            }
            result[j++] = cA[i];
        }
        return new String(result, 0, j);
    }

    private String escapeHTML(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        char[] cA = str.toCharArray();
        char[] result = new char[5 * cA.length];
        int j = 0;
        for (int i = 0; i < cA.length; ++i) {
            boolean escaped = true;
            char c = cA[i];
            switch (c) {
                case ';': {
                    result[j++] = 38;
                    result[j++] = 35;
                    result[j++] = 53;
                    result[j++] = 57;
                    break;
                }
                case '\\': {
                    result[j++] = 38;
                    result[j++] = 35;
                    result[j++] = 57;
                    result[j++] = 50;
                    break;
                }
                case '/': {
                    result[j++] = 38;
                    result[j++] = 35;
                    result[j++] = 52;
                    result[j++] = 55;
                    break;
                }
                case '<': {
                    result[j++] = 38;
                    result[j++] = 108;
                    result[j++] = 116;
                    break;
                }
                case '>': {
                    result[j++] = 38;
                    result[j++] = 103;
                    result[j++] = 116;
                    break;
                }
                case '\"': {
                    result[j++] = 38;
                    result[j++] = 35;
                    result[j++] = 51;
                    result[j++] = 52;
                    break;
                }
                case '\'': {
                    result[j++] = 38;
                    result[j++] = 35;
                    result[j++] = 51;
                    result[j++] = 57;
                    break;
                }
                case '=': {
                    result[j++] = 38;
                    result[j++] = 35;
                    result[j++] = 54;
                    result[j++] = 49;
                    break;
                }
                case '&': {
                    result[j++] = 38;
                    result[j++] = 97;
                    result[j++] = 109;
                    result[j++] = 112;
                    break;
                }
                default: {
                    result[j++] = c;
                    escaped = false;
                }
            }
            if (!escaped) continue;
            result[j++] = 59;
        }
        return String.copyValueOf(result, 0, j);
    }

    private static boolean isServerStarted(NetworkServerControl server, int ntries) {
        for (int i = 1; i <= ntries; ++i) {
            try {
                Thread.sleep(500L);
                server.ping();
                return true;
            }
            catch (Exception e) {
                if (i != ntries) continue;
                return false;
            }
        }
        return false;
    }
}

