/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ResultColumnList;

class ReplaceAggregatesWithCRVisitor
implements Visitor {
    private ResultColumnList rcl;
    private Class<?> skipOverClass;
    private int tableNumber;

    ReplaceAggregatesWithCRVisitor(ResultColumnList rcl, int tableNumber) {
        this(rcl, tableNumber, null);
    }

    ReplaceAggregatesWithCRVisitor(ResultColumnList rcl, int tableNumber, Class<?> skipOverClass) {
        this.rcl = rcl;
        this.tableNumber = tableNumber;
        this.skipOverClass = skipOverClass;
    }

    ReplaceAggregatesWithCRVisitor(ResultColumnList rcl, Class<?> nodeToSkip) {
        this.rcl = rcl;
        this.skipOverClass = nodeToSkip;
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (node instanceof AggregateNode) {
            node = ((AggregateNode)node).replaceAggregatesWithColumnReferences(this.rcl, this.tableNumber);
        }
        return node;
    }

    @Override
    public boolean skipChildren(Visitable node) {
        return this.skipOverClass == null ? false : this.skipOverClass.isInstance(node);
    }

    @Override
    public boolean visitChildrenFirst(Visitable node) {
        return false;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }
}

