/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.Dependable;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.shared.common.sanity.SanityManager;

public class DDdependableFinder
implements DependableFinder,
Formatable {
    private final int formatId;

    public DDdependableFinder(int formatId) {
        this.formatId = formatId;
    }

    public String toString() {
        return this.getSQLObjectType();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public final int getTypeFormatId() {
        return this.formatId;
    }

    @Override
    public String getSQLObjectType() {
        switch (this.formatId) {
            case 136: {
                return "Alias";
            }
            case 135: {
                return "Conglomerate";
            }
            case 208: {
                return "Constraint";
            }
            case 325: {
                return "Default";
            }
            case 273: {
                return "File";
            }
            case 371: {
                return "Schema";
            }
            case 226: {
                return "StoredPreparedStatement";
            }
            case 137: {
                return "Table";
            }
            case 393: {
                return "ColumnsInTable";
            }
            case 320: {
                return "Trigger";
            }
            case 145: {
                return "View";
            }
            case 462: {
                return "TablePrivilege";
            }
            case 463: {
                return "ColumnsPrivilege";
            }
            case 461: {
                return "RoutinePrivilege";
            }
            case 471: {
                return "RoleGrant";
            }
            case 472: {
                return "Sequence";
            }
            case 473: {
                return "Perm";
            }
        }
        SanityManager.THROWASSERT("getSQLObjectType() called with unexpeced formatId = " + this.formatId);
        return null;
    }

    @Override
    public final Dependable getDependable(DataDictionary dd, UUID dependableObjectID) throws StandardException {
        Dependable dependable = this.findDependable(dd, dependableObjectID);
        if (dependable == null) {
            throw StandardException.newException("42X94", this.getSQLObjectType(), dependableObjectID);
        }
        return dependable;
    }

    Dependable findDependable(DataDictionary dd, UUID dependableObjectID) throws StandardException {
        switch (this.formatId) {
            case 136: {
                return dd.getAliasDescriptor(dependableObjectID);
            }
            case 135: {
                return dd.getConglomerateDescriptor(dependableObjectID);
            }
            case 208: {
                return dd.getConstraintDescriptor(dependableObjectID);
            }
            case 325: {
                ColumnDescriptor cd = dd.getColumnDescriptorByDefaultId(dependableObjectID);
                if (cd != null) {
                    return new DefaultDescriptor(dd, cd.getDefaultUUID(), cd.getReferencingUUID(), cd.getPosition());
                }
                return null;
            }
            case 273: {
                return dd.getFileInfoDescriptor(dependableObjectID);
            }
            case 371: {
                return dd.getSchemaDescriptor(dependableObjectID, null);
            }
            case 226: {
                return dd.getSPSDescriptor(dependableObjectID);
            }
            case 137: {
                return dd.getTableDescriptor(dependableObjectID);
            }
            case 320: {
                return dd.getTriggerDescriptor(dependableObjectID);
            }
            case 145: {
                return dd.getViewDescriptor(dependableObjectID);
            }
            case 463: {
                return dd.getColumnPermissions(dependableObjectID);
            }
            case 462: {
                return dd.getTablePermissions(dependableObjectID);
            }
            case 461: {
                return dd.getRoutinePermissions(dependableObjectID);
            }
            case 471: {
                return dd.getRoleGrantDescriptor(dependableObjectID);
            }
            case 472: {
                return dd.getSequenceDescriptor(dependableObjectID);
            }
            case 473: {
                return dd.getGenericPermissions(dependableObjectID);
            }
        }
        SanityManager.THROWASSERT("getDependable() called with unexpeced formatId = " + this.formatId);
        return null;
    }
}

