/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoRowsResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;

public class RealDeleteResultSetStatistics
extends RealNoRowsResultSetStatistics {
    public int rowCount;
    public boolean deferred;
    public boolean tableLock;
    public int indexesUpdated;

    public RealDeleteResultSetStatistics(int rowCount, boolean deferred, int indexesUpdated, boolean tableLock, long executeTime, ResultSetStatistics sourceResultSetStatistics) {
        super(executeTime, sourceResultSetStatistics);
        this.rowCount = rowCount;
        this.deferred = deferred;
        this.indexesUpdated = indexesUpdated;
        this.tableLock = tableLock;
        this.sourceResultSetStatistics = sourceResultSetStatistics;
    }

    @Override
    public String getStatementExecutionPlanText(int depth) {
        this.initFormatInfo(depth);
        return this.indent + MessageService.getTextMessage("43X13.U", new Object[0]) + " " + MessageService.getTextMessage(this.tableLock ? "43X14.U" : "43X15.U", new Object[0]) + ":\n" + this.indent + MessageService.getTextMessage("43X16.U", new Object[0]) + ": " + this.deferred + "\n" + this.indent + MessageService.getTextMessage("43X17.U", new Object[0]) + " = " + this.rowCount + "\n" + this.indent + MessageService.getTextMessage("43X18.U", new Object[0]) + " = " + this.indexesUpdated + "\n" + this.dumpTimeStats(this.indent) + (this.sourceResultSetStatistics == null ? "" : this.sourceResultSetStatistics.getStatementExecutionPlanText(1));
    }

    @Override
    public String getScanStatisticsText(String tableName, int depth) {
        if (this.sourceResultSetStatistics == null) {
            return "";
        }
        return this.sourceResultSetStatistics.getScanStatisticsText(tableName, depth);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage("43X19.U", new Object[0]);
    }

    @Override
    public void accept(XPLAINVisitor visitor) {
        int noChildren = 0;
        if (this.sourceResultSetStatistics != null) {
            ++noChildren;
        }
        visitor.setNumberOfChildren(noChildren);
        visitor.visit(this);
        if (this.sourceResultSetStatistics != null) {
            this.sourceResultSetStatistics.accept(visitor);
        }
    }

    @Override
    public String getRSXplainType() {
        return "DELETE";
    }

    @Override
    public Object getResultSetDescriptor(Object rsID, Object parentID, Object scanID, Object sortID, Object stmtID, Object timingID) {
        return new XPLAINResultSetDescriptor((UUID)rsID, this.getRSXplainType(), this.getRSXplainDetails(), null, this.indexesUpdated, null, this.tableLock ? "T" : "R", (UUID)parentID, null, null, this.rowCount, XPLAINUtil.getYesNoCharFromBoolean(this.deferred), null, null, null, null, null, null, null, (UUID)scanID, (UUID)sortID, (UUID)stmtID, (UUID)timingID);
    }
}

