/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;

class DropSchemaNode
extends DDLStatementNode {
    private int dropBehavior;
    private String schemaName;

    DropSchemaNode(String schemaName, int dropBehavior, ContextManager cm) {
        super(null, cm);
        this.schemaName = schemaName;
        this.dropBehavior = dropBehavior;
    }

    @Override
    public void bindStatement() throws StandardException {
        if (this.getDataDictionary().isSystemSchemaName(this.schemaName)) {
            throw StandardException.newException("42Y67", this.schemaName);
        }
        if (this.isPrivilegeCollectionRequired()) {
            LanguageConnectionContext lcc = this.getLanguageConnectionContext();
            StatementContext stx = lcc.getStatementContext();
            String currentUser = stx.getSQLSessionContext().getCurrentUser();
            this.getCompilerContext().addRequiredSchemaPriv(this.schemaName, currentUser, 18);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "dropBehavior: \n" + this.dropBehavior + "\n";
    }

    @Override
    String statementToString() {
        return "DROP SCHEMA";
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropSchemaConstantAction(this.schemaName);
    }
}

