/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.shared.common.sanity.SanityManager;

public abstract class CatalogRowFactory {
    protected String[] indexNames;
    protected int[][] indexColumnPositions;
    protected boolean[] indexUniqueness;
    protected UUID tableUUID;
    protected UUID heapUUID;
    protected UUID[] indexUUID;
    protected DataValueFactory dvf;
    private final ExecutionFactory ef;
    private UUIDFactory uuidf;
    private int indexCount;
    private int columnCount;
    private String catalogName;

    public CatalogRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        this.uuidf = uuidf;
        this.dvf = dvf;
        this.ef = ef;
    }

    public ExecutionFactory getExecutionFactory() {
        return this.ef;
    }

    public UUIDFactory getUUIDFactory() {
        return this.uuidf;
    }

    public UUID getCanonicalTableUUID() {
        return this.tableUUID;
    }

    public UUID getCanonicalHeapUUID() {
        return this.heapUUID;
    }

    public UUID getCanonicalIndexUUID(int indexNumber) {
        return this.indexUUID[indexNumber];
    }

    public int getIndexColumnCount(int indexNum) {
        return this.indexColumnPositions[indexNum].length;
    }

    public String getCanonicalHeapName() {
        return this.catalogName + "_HEAP";
    }

    public String getIndexName(int indexNum) {
        return this.indexNames[indexNum];
    }

    public boolean isIndexUnique(int indexNumber) {
        return this.indexUniqueness != null ? this.indexUniqueness[indexNumber] : true;
    }

    public DataValueFactory getDataValueFactory() {
        return this.dvf;
    }

    public String generateIndexName(int indexNumber) {
        return this.catalogName + "_INDEX" + ++indexNumber;
    }

    public int getNumIndexes() {
        return this.indexCount;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void initInfo(int columnCount, String catalogName, int[][] indexColumnPositions, boolean[] indexUniqueness, String[] uuidStrings) {
        this.indexCount = indexColumnPositions != null ? indexColumnPositions.length : 0;
        this.catalogName = catalogName;
        this.columnCount = columnCount;
        UUIDFactory uf = this.getUUIDFactory();
        this.tableUUID = uf.recreateUUID(uuidStrings[0]);
        this.heapUUID = uf.recreateUUID(uuidStrings[1]);
        if (this.indexCount > 0) {
            this.indexNames = new String[this.indexCount];
            this.indexUUID = new UUID[this.indexCount];
            for (int ictr = 0; ictr < this.indexCount; ++ictr) {
                this.indexNames[ictr] = this.generateIndexName(ictr);
                this.indexUUID[ictr] = uf.recreateUUID(uuidStrings[ictr + 2]);
            }
            this.indexColumnPositions = ArrayUtil.copy2(indexColumnPositions);
            this.indexUniqueness = ArrayUtil.copy(indexUniqueness);
        }
    }

    public Properties getCreateHeapProperties() {
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", "1024");
        properties.put("derby.storage.pageReservedSpace", "0");
        properties.put("derby.storage.minimumRecordSize", "1");
        return properties;
    }

    public Properties getCreateIndexProperties(int indexNumber) {
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", "1024");
        return properties;
    }

    public int getPrimaryKeyIndexNumber() {
        SanityManager.NOTREACHED();
        return 0;
    }

    public int getHeapColumnCount() throws StandardException {
        return this.columnCount;
    }

    public ExecRow makeEmptyRow() throws StandardException {
        return this.makeRow(null, null);
    }

    public ExecRow makeEmptyRowForCurrentVersion() throws StandardException {
        return this.makeEmptyRow();
    }

    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        SanityManager.THROWASSERT("Should not get here.");
        return null;
    }

    public abstract TupleDescriptor buildDescriptor(ExecRow var1, TupleDescriptor var2, DataDictionary var3) throws StandardException;

    public abstract SystemColumn[] buildColumnList() throws StandardException;

    public int[] getIndexColumnPositions(int indexNumber) {
        return this.indexColumnPositions[indexNumber];
    }
}

