/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.context;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.shared.common.error.ShutdownException;

final class SystemContext
extends ContextImpl {
    SystemContext(ContextManager cm) {
        super(cm, "SystemContext");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupOnError(Throwable t) {
        boolean doShutdown = false;
        if (t instanceof StandardException) {
            StandardException se = (StandardException)t;
            int severity = se.getSeverity();
            if (severity < 40000) {
                return;
            }
            this.popMe();
            if (severity >= 50000) {
                doShutdown = true;
            }
        } else if (t instanceof ShutdownException || t instanceof ThreadDeath) {
            // empty if block
        }
        if (!doShutdown) {
            this.getContextManager().owningCsf.removeContext(this.getContextManager());
            return;
        }
        try {
            System.err.println("Shutting down due to severe error.");
            Monitor.getStream().printlnWithHeader("Shutting down due to severe error." + t.getMessage());
        }
        finally {
            SystemContext.getMonitor().shutdown();
        }
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }
}

