/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.ObjectFactory;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DataSourceReferenceTest
extends BaseJDBCTestCase {
    private static final int BASE_DS = 0;
    private static final int POOL_DS = 1;
    private static final int XA_DS = 2;
    private static final DataSourceDescriptor BASE_EMBEDDED_DS = new DataSourceDescriptor("Basic embedded data source");
    private static final DataSourceDescriptor BASE_CLIENT_DS;
    private static final DataSourceDescriptor POOL_CLIENT_DS;

    public DataSourceReferenceTest(String name) {
        super(name);
    }

    public static Test suite() {
        Object suite = JDBC.vmSupportsJSR169() || !JDBC.vmSupportsJNDI() ? new BaseTestSuite("DatasourceReferenceTest cannot run with JSR169") : TestConfiguration.defaultSuite(DataSourceReferenceTest.class);
        return suite;
    }

    public void testDataSourceReference() throws Exception {
        DataSourceDescriptor[] descriptors = DataSourceReferenceTest.usingDerbyNetClient() ? new DataSourceDescriptor[]{BASE_CLIENT_DS, POOL_CLIENT_DS, BASE_CLIENT_DS} : new DataSourceDescriptor[]{BASE_EMBEDDED_DS, BASE_EMBEDDED_DS, BASE_EMBEDDED_DS};
        String className = JDBCDataSource.getDataSource().getClass().getName();
        DataSourceReferenceTest.println("Testing base data source: " + className);
        this.assertDataSourceReference(descriptors[0], className);
        className = J2EEDataSource.getConnectionPoolDataSource().getClass().getName();
        DataSourceReferenceTest.println("Testing connection pool data source: " + className);
        this.assertDataSourceReference(descriptors[1], className);
        className = J2EEDataSource.getXADataSource().getClass().getName();
        DataSourceReferenceTest.println("Testing XA data source: " + className);
        this.assertDataSourceReference(descriptors[2], className);
    }

    private void assertDataSourceReference(DataSourceDescriptor dsDesc, String className) throws Exception {
        Class<?> clazz = Class.forName(className);
        Object dsObj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        String[] properties = DataSourceReferenceTest.getPropertyBeanList(dsObj);
        this.assertDataSourceProperties(dsDesc, properties);
        this.assertDataSourceReferenceEmpty(dsDesc, className);
        this.assertDataSourceReferencePopulated(dsDesc, className);
    }

    private void assertDataSourceProperties(DataSourceDescriptor dsDesc, String[] properties) {
        DataSourceReferenceTest.println("Testing data source bean properties.");
        for (int i = 0; i < properties.length; ++i) {
            DataSourceReferenceTest.assertTrue((String)("Property '" + properties[i] + "' not in descriptor '" + dsDesc.getName() + "'"), (boolean)dsDesc.hasProperty(properties[i]));
        }
        Iterator descPropIter = dsDesc.getPropertyIterator();
        while (descPropIter.hasNext()) {
            String descProp = (String)descPropIter.next();
            boolean match = false;
            for (int i = 0; i < properties.length; ++i) {
                if (!properties[i].equals(descProp)) continue;
                if (match) {
                    DataSourceReferenceTest.fail((String)("Duplicate entry '" + descProp + "' in data source property list"));
                }
                match = true;
            }
            DataSourceReferenceTest.assertTrue((String)("Property '" + descProp + "' not found in data source property list"), (boolean)match);
        }
        DataSourceReferenceTest.assertEquals((int)dsDesc.getPropertyCount(), (int)properties.length);
    }

    private void assertDataSourceReferenceEmpty(DataSourceDescriptor dsDesc, String className) throws Exception {
        DataSourceReferenceTest.println("Testing recreated empty data source.");
        Class<?> clazz = Class.forName(className);
        Object ds = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        Referenceable refDs = (Referenceable)ds;
        Reference dsAsReference = refDs.getReference();
        String factoryClassName = dsAsReference.getFactoryClassName();
        clazz = Class.forName(factoryClassName);
        ObjectFactory factory = (ObjectFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        Object recreatedDs = factory.getObjectInstance(dsAsReference, null, null, null);
        DataSourceReferenceTest.assertNotNull((String)"Recreated datasource is <null>", (Object)recreatedDs);
        DataSourceReferenceTest.assertNotSame((Object)recreatedDs, ds);
        this.compareDataSources(dsDesc, ds, recreatedDs, true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(ds);
        oos.flush();
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        recreatedDs = ois.readObject();
        this.compareDataSources(dsDesc, ds, recreatedDs, true);
    }

    private void assertDataSourceReferencePopulated(DataSourceDescriptor dsDesc, String className) throws Exception {
        DataSourceReferenceTest.println("Testing recreated populated data source.");
        Class<?> clazz = Class.forName(className);
        Object ds = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        Iterator propIter = dsDesc.getPropertyIterator();
        while (propIter.hasNext()) {
            String property = (String)propIter.next();
            String value = dsDesc.getPropertyValue(property);
            Method getMethod = DataSourceReferenceTest.getGet(property, ds);
            Method setMethod = DataSourceReferenceTest.getSet(getMethod, ds);
            Class<?> paramType = getMethod.getReturnType();
            if (paramType.equals(Integer.TYPE)) {
                setMethod.invoke(ds, Integer.valueOf(value));
                continue;
            }
            if (paramType.equals(String.class)) {
                setMethod.invoke(ds, value);
                continue;
            }
            if (paramType.equals(Boolean.TYPE)) {
                setMethod.invoke(ds, Boolean.valueOf(value));
                continue;
            }
            if (paramType.equals(Short.TYPE)) {
                setMethod.invoke(ds, Short.valueOf(value));
                continue;
            }
            if (paramType.equals(Long.TYPE)) {
                setMethod.invoke(ds, Long.valueOf(value));
                continue;
            }
            DataSourceReferenceTest.fail((String)("'" + property + "' not settable - update test!!"));
        }
        Referenceable refDs = (Referenceable)ds;
        Reference dsAsReference = refDs.getReference();
        String factoryClassName = dsAsReference.getFactoryClassName();
        clazz = Class.forName(factoryClassName);
        ObjectFactory factory = (ObjectFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        Object recreatedDs = factory.getObjectInstance(dsAsReference, null, null, null);
        DataSourceReferenceTest.assertNotSame((Object)recreatedDs, ds);
        this.compareDataSources(dsDesc, ds, recreatedDs, false);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(ds);
        oos.flush();
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        recreatedDs = ois.readObject();
        this.compareDataSources(dsDesc, ds, recreatedDs, false);
    }

    private void compareDataSources(DataSourceDescriptor dsDesc, Object ds, Object rds, boolean useDefaultsForComparison) throws Exception {
        Iterator propIter = dsDesc.getPropertyIterator();
        while (propIter.hasNext()) {
            String property = (String)propIter.next();
            Method getMethod = DataSourceReferenceTest.getGet(property, ds);
            Object dsValue = getMethod.invoke(ds, null);
            Object rdsValue = getMethod.invoke(rds, null);
            if (dsValue == null) {
                DataSourceReferenceTest.assertNull((Object)rdsValue);
            } else {
                DataSourceReferenceTest.assertEquals((Object)dsValue, (Object)rdsValue);
            }
            if (useDefaultsForComparison) {
                if (dsValue != null) {
                    DataSourceReferenceTest.assertEquals((String)("Wrong default value for '" + property + "'"), (String)dsDesc.getPropertyDefault(property), (String)dsValue.toString());
                    continue;
                }
                DataSourceReferenceTest.assertNull((Object)dsDesc.getPropertyDefault(property));
                continue;
            }
            if (dsValue != null) {
                DataSourceReferenceTest.assertEquals((String)("'" + property + "' has incorrect value"), (String)dsDesc.getPropertyValue(property), (String)dsValue.toString());
                continue;
            }
            DataSourceReferenceTest.fail((String)"Test does not handle this situation...");
        }
    }

    private static String[] getPropertyBeanList(Object ds) {
        Method[] allMethods = ds.getClass().getMethods();
        ArrayList<String> properties = new ArrayList<String>();
        for (int i = 0; i < allMethods.length; ++i) {
            Method method = allMethods[i];
            String methodName = method.getName();
            if (methodName.length() < 5 || !methodName.startsWith("get") || method.getParameterTypes().length != 0) continue;
            Class<?> rt = method.getReturnType();
            if (rt.equals(Integer.TYPE) || rt.equals(String.class) || rt.equals(Boolean.TYPE) || rt.equals(Short.TYPE) || rt.equals(Long.TYPE)) {
                String beanName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                properties.add(beanName);
                continue;
            }
            DataSourceReferenceTest.assertFalse((String)("Method '" + methodName + "' with primitive return type not supported - update test!!"), (boolean)rt.isPrimitive());
        }
        return properties.toArray(new String[properties.size()]);
    }

    private static Method getGet(String property, Object ds) throws NoSuchMethodException {
        String methodName = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
        Method m = ds.getClass().getMethod(methodName, null);
        return m;
    }

    private static Method getSet(Method getMethod, Object ds) throws NoSuchMethodException {
        String methodName = "s" + getMethod.getName().substring(1);
        Method m = ds.getClass().getMethod(methodName, getMethod.getReturnType());
        return m;
    }

    static {
        BASE_EMBEDDED_DS.addProperty("attributesAsPassword", "true", "false");
        BASE_EMBEDDED_DS.addProperty("connectionAttributes", "XX_connectionAttributes_2135");
        BASE_EMBEDDED_DS.addProperty("createDatabase", "create");
        BASE_EMBEDDED_DS.addProperty("dataSourceName", "XX_dataSourceName_1420");
        BASE_EMBEDDED_DS.addProperty("databaseName", "XX_databaseName_1206");
        BASE_EMBEDDED_DS.addProperty("description", "XX_description_1188");
        BASE_EMBEDDED_DS.addProperty("loginTimeout", "1280", "0");
        BASE_EMBEDDED_DS.addProperty("password", "XX_password_883");
        BASE_EMBEDDED_DS.addProperty("shutdownDatabase", "shutdown");
        BASE_EMBEDDED_DS.addProperty("user", "XX_user_447");
        BASE_CLIENT_DS = new DataSourceDescriptor("Basic client data source");
        BASE_CLIENT_DS.addProperty("loginTimeout", "1280", "0");
        BASE_CLIENT_DS.addProperty("portNumber", "1070", "1527");
        BASE_CLIENT_DS.addProperty("retrieveMessageText", "false", "true");
        BASE_CLIENT_DS.addProperty("securityMechanism", "1851", "4");
        BASE_CLIENT_DS.addProperty("serverName", "tmpHostName", "localhost");
        BASE_CLIENT_DS.addProperty("ssl", "basic", "off");
        BASE_CLIENT_DS.addProperty("user", "XX_user_447", "APP");
        BASE_CLIENT_DS.addProperty("connectionAttributes", "XX_connectionAttributes_2135");
        BASE_CLIENT_DS.addProperty("createDatabase", "create");
        BASE_CLIENT_DS.addProperty("databaseName", "XX_databaseName_1206");
        BASE_CLIENT_DS.addProperty("dataSourceName", "XX_dataSourceName_1420");
        BASE_CLIENT_DS.addProperty("description", "XX_description_1188");
        BASE_CLIENT_DS.addProperty("password", "XX_password_883");
        BASE_CLIENT_DS.addProperty("shutdownDatabase", "shutdown");
        BASE_CLIENT_DS.addProperty("traceFile", "XX_traceFile_911");
        BASE_CLIENT_DS.addProperty("traceFileAppend", "true", "false");
        BASE_CLIENT_DS.addProperty("traceLevel", "1031", "-1");
        BASE_CLIENT_DS.addProperty("traceDirectory", "XX_traceDirectory_1476");
        POOL_CLIENT_DS = new DataSourceDescriptor("Connection pool client data source", BASE_CLIENT_DS);
        POOL_CLIENT_DS.addProperty("maxStatements", "10", "0");
    }

    private static class DataSourceDescriptor {
        private final String dsName;
        private final Properties propertyValues;
        private final Properties propertyDefaults;

        DataSourceDescriptor(String dsName) {
            this.dsName = dsName;
            this.propertyValues = new Properties();
            this.propertyDefaults = new Properties();
        }

        DataSourceDescriptor(String dsName, DataSourceDescriptor copyFrom) {
            this.dsName = dsName;
            this.propertyValues = new Properties();
            this.propertyValues.putAll((Map<?, ?>)copyFrom.propertyValues);
            this.propertyDefaults = new Properties(copyFrom.propertyDefaults);
            this.propertyDefaults.putAll((Map<?, ?>)copyFrom.propertyDefaults);
        }

        String getName() {
            return this.dsName;
        }

        void addProperty(String name, String value) {
            this.propertyValues.setProperty(name, value);
        }

        void addProperty(String name, String value, String defaultValue) {
            this.propertyValues.setProperty(name, value);
            this.propertyDefaults.setProperty(name, defaultValue);
        }

        String getPropertyValue(String name) {
            if (!this.propertyValues.containsKey(name)) {
                Assert.fail((String)("Property '" + name + "' not in data source descriptor '" + this.dsName + "'"));
            }
            return this.propertyValues.getProperty(name);
        }

        String getPropertyDefault(String name) {
            if (!this.propertyValues.containsKey(name)) {
                Assert.fail((String)("Property '" + name + "' not in data source descriptor '" + this.dsName + "'"));
            }
            return this.propertyDefaults.getProperty(name, null);
        }

        Iterator getPropertyIterator() {
            return this.propertyValues.keySet().iterator();
        }

        boolean hasProperty(String name) {
            return this.propertyValues.containsKey(name);
        }

        int getPropertyCount() {
            return this.propertyValues.size();
        }
    }
}

