/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.NativeWritableBufferImpl;
import org.apache.datasketches.memory.internal.NonNativeWritableBufferImpl;
import org.apache.datasketches.memory.internal.PositionalImpl;

public abstract class WritableBufferImpl
extends PositionalImpl
implements WritableBuffer {
    WritableBufferImpl(MemorySegment seg, int typeId, MemoryRequestServer memReqSvr, Arena arena) {
        super(seg, typeId, memReqSvr, arena);
    }

    public static WritableBuffer wrapByteBuffer(ByteBuffer byteBuffer, boolean localReadOnly, ByteOrder byteOrder, MemoryRequestServer memReqSvr) {
        ByteBuffer byteBuf;
        Objects.requireNonNull(byteBuffer, "ByteBuffer must not be null");
        Objects.requireNonNull(byteOrder, "ByteOrder must not be null");
        if (localReadOnly) {
            byteBuf = byteBuffer.isReadOnly() ? byteBuffer.duplicate() : byteBuffer.asReadOnlyBuffer();
        } else {
            if (byteBuffer.isReadOnly()) {
                throw new IllegalArgumentException("ByteBuffer must be writable.");
            }
            byteBuf = byteBuffer.duplicate();
        }
        byteBuf.clear();
        MemorySegment seg = MemorySegment.ofBuffer(byteBuf);
        int type = 0xC0 | (localReadOnly ? 1 : 0) | (seg.isNative() ? 8 : 0) | (seg.isMapped() ? 16 : 0);
        WritableBufferImpl wbuf = byteOrder == NON_NATIVE_BYTE_ORDER ? new NonNativeWritableBufferImpl(seg, type |= 0x20, memReqSvr, null) : new NativeWritableBufferImpl(seg, type, memReqSvr, null);
        wbuf.setStartPositionEnd(0L, byteBuffer.position(), byteBuffer.limit());
        return wbuf;
    }

    @Override
    public Buffer region(long offsetBytes, long capacityBytes, ByteOrder byteOrder) {
        return this.regionImpl(offsetBytes, capacityBytes, true, byteOrder);
    }

    @Override
    public WritableBuffer writableRegion(long offsetBytes, long capacityBytes, ByteOrder byteOrder) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Cannot create a writable region from a read-only Memory.");
        }
        return this.regionImpl(offsetBytes, capacityBytes, false, byteOrder);
    }

    private WritableBuffer regionImpl(long offsetBytes, long capacityBytes, boolean localReadOnly, ByteOrder byteOrder) {
        if (!this.isAlive()) {
            throw new IllegalStateException("This Buffer is not alive.");
        }
        Objects.requireNonNull(byteOrder, "byteOrder must be non-null.");
        boolean readOnly = this.isReadOnly() || localReadOnly;
        MemorySegment slice = readOnly && !this.seg.isReadOnly() ? this.seg.asSlice(offsetBytes, capacityBytes).asReadOnly() : this.seg.asSlice(offsetBytes, capacityBytes);
        boolean duplicateType = this.isDuplicate();
        boolean mapType = this.seg.isMapped();
        boolean directType = this.seg.isNative();
        boolean nativeBOType = byteOrder == ByteOrder.nativeOrder();
        boolean byteBufferType = this.hasByteBuffer();
        int type = 0x42 | (readOnly ? 1 : 0) | (duplicateType ? 4 : 0) | (mapType ? 16 : 0) | (directType ? 8 : 0) | (nativeBOType ? 0 : 32) | (byteBufferType ? 128 : 0);
        WritableBuffer wbuf = WritableBufferImpl.selectBuffer(slice, type, this.memReqSvr, byteBufferType, mapType, nativeBOType);
        wbuf.setStartPositionEnd(0L, 0L, wbuf.getCapacity());
        return wbuf;
    }

    @Override
    public Buffer duplicate() {
        return this.duplicateImpl(true, this.getTypeByteOrder());
    }

    @Override
    public Buffer duplicate(ByteOrder byteOrder) {
        return this.duplicateImpl(true, byteOrder);
    }

    @Override
    public WritableBuffer writableDuplicate() {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Cannot create a writable duplicate from a read-only Buffer.");
        }
        return this.duplicateImpl(false, this.getTypeByteOrder());
    }

    @Override
    public WritableBuffer writableDuplicate(ByteOrder byteOrder) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Cannot create a writable duplicate from a read-only Buffer.");
        }
        return this.duplicateImpl(false, byteOrder);
    }

    private WritableBuffer duplicateImpl(boolean localReadOnly, ByteOrder byteOrder) {
        if (!this.isAlive()) {
            throw new IllegalStateException("This Memory is not alive.");
        }
        boolean readOnly = this.isReadOnly() || localReadOnly;
        MemorySegment seg2 = readOnly && !this.seg.isReadOnly() ? this.seg.asReadOnly() : this.seg;
        boolean regionType = this.isRegion();
        boolean mapType = this.seg.isMapped();
        boolean directType = this.seg.isNative();
        boolean nativeBOType = byteOrder == ByteOrder.nativeOrder();
        boolean byteBufferType = this.hasByteBuffer();
        int type = 0x44 | (readOnly ? 1 : 0) | (regionType ? 2 : 0) | (mapType ? 16 : 0) | (directType ? 8 : 0) | (nativeBOType ? 0 : 32) | (byteBufferType ? 128 : 0);
        WritableBuffer wbuf = WritableBufferImpl.selectBuffer(seg2, type, this.memReqSvr, byteBufferType, mapType, nativeBOType);
        wbuf.setStartPositionEnd(this.getStart(), this.getPosition(), this.getEnd());
        return wbuf;
    }

    @Override
    public Memory asMemory(ByteOrder byteOrder) {
        return this.asWritableMemoryImpl(true, byteOrder);
    }

    @Override
    public WritableMemory asWritableMemory(ByteOrder byteOrder) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Cannot create a writable Memory from a read-only Buffer.");
        }
        return this.asWritableMemoryImpl(false, byteOrder);
    }

    private WritableMemory asWritableMemoryImpl(boolean localReadOnly, ByteOrder byteOrder) {
        if (!this.isAlive()) {
            throw new IllegalStateException("This Buffer is not alive.");
        }
        Objects.requireNonNull(byteOrder, "byteOrder must be non-null");
        boolean readOnly = this.isReadOnly() || localReadOnly;
        MemorySegment seg2 = readOnly && !this.seg.isReadOnly() ? this.seg.asReadOnly() : this.seg;
        boolean regionType = this.isRegion();
        boolean duplicateType = this.isDuplicate();
        boolean mapType = this.seg.isMapped();
        boolean directType = this.seg.isNative();
        boolean nativeBOType = byteOrder == ByteOrder.nativeOrder();
        boolean byteBufferType = this.hasByteBuffer();
        int type = 0 | (readOnly ? 1 : 0) | (regionType ? 2 : 0) | (duplicateType ? 4 : 0) | (mapType ? 16 : 0) | (directType ? 8 : 0) | (nativeBOType ? 0 : 32) | (byteBufferType ? 128 : 0);
        WritableMemory wmem = WritableBufferImpl.selectMemory(seg2, type, this.memReqSvr, byteBufferType, mapType, nativeBOType);
        return wmem;
    }

    @Override
    public final boolean getBoolean() {
        return this.getByte() != 0;
    }

    @Override
    public final boolean getBoolean(long offsetBytes) {
        return this.getByte(offsetBytes) != 0;
    }

    @Override
    public final byte getByte() {
        long pos = this.getPosition();
        byte aByte = this.seg.get(ValueLayout.JAVA_BYTE, pos);
        this.setPosition(pos + 1L);
        return aByte;
    }

    @Override
    public final byte getByte(long offsetBytes) {
        return this.seg.get(ValueLayout.JAVA_BYTE, offsetBytes);
    }

    @Override
    public final void getByteArray(byte[] dstArray, int dstOffsetBytes, int lengthBytes) {
        long pos = this.getPosition();
        MemorySegment dstSeg = MemorySegment.ofArray(dstArray);
        MemorySegment.copy(this.seg, pos, dstSeg, dstOffsetBytes, lengthBytes);
        this.setPosition(pos + (long)lengthBytes);
    }

    @Override
    public final void putBoolean(boolean value) {
        this.putByte(value ? (byte)1 : 0);
    }

    @Override
    public final void putBoolean(long offsetBytes, boolean value) {
        this.putByte(offsetBytes, value ? (byte)1 : 0);
    }

    @Override
    public final void putByte(byte value) {
        long pos = this.getPosition();
        this.seg.set(ValueLayout.JAVA_BYTE, pos, value);
        this.setPosition(pos + 1L);
    }

    @Override
    public final void putByte(long offsetBytes, byte value) {
        this.seg.set(ValueLayout.JAVA_BYTE, offsetBytes, value);
    }

    @Override
    public final void putByteArray(byte[] srcArray, int srcOffsetBytes, int lengthBytes) {
        long pos = this.getPosition();
        MemorySegment srcSeg = MemorySegment.ofArray(srcArray);
        MemorySegment.copy(srcSeg, srcOffsetBytes, this.seg, pos, lengthBytes);
        this.setPosition(pos + (long)lengthBytes);
    }

    @Override
    public final void clear() {
        this.seg.fill((byte)0);
    }

    @Override
    public final void fill(byte value) {
        this.seg.fill(value);
    }

    @Override
    public final byte[] getArray() {
        return this.seg.toArray(ValueLayout.JAVA_BYTE);
    }
}

