/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.apache.datasketches.memory.internal.UtilForTest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NonNativeWritableBufferImplTest {
    @Test
    public void checkPutGetNonNativeCharacters() {
        int i;
        char[] srcArray = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h'};
        int len = srcArray.length;
        int half = len / 2;
        WritableBuffer wbuf = WritableMemory.allocate((int)(len * 2), (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER).asWritableBuffer();
        wbuf.putChar(srcArray[0]);
        wbuf.putCharArray(srcArray, 1, 2);
        wbuf.putChar(srcArray[3]);
        for (int i2 = half; i2 < len; ++i2) {
            wbuf.putChar((long)(i2 * 2), srcArray[i2]);
        }
        wbuf.resetPosition();
        WritableBuffer wbuf2 = WritableMemory.allocate((int)(len * 2), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER).asWritableBuffer();
        for (i = 0; i < len * 2; ++i) {
            wbuf2.putByte(wbuf.getByte());
        }
        wbuf2.resetPosition();
        for (i = 0; i < len; ++i) {
            Assert.assertTrue((srcArray[i] == Character.reverseBytes(wbuf2.getChar()) ? 1 : 0) != 0);
        }
        wbuf.resetPosition();
        char[] dstArray = new char[len];
        dstArray[0] = wbuf.getChar();
        wbuf.getCharArray(dstArray, 1, 2);
        dstArray[3] = wbuf.getChar();
        for (int i3 = half; i3 < len; ++i3) {
            dstArray[i3] = wbuf.getChar((long)(i3 * 2));
        }
        Assert.assertEquals((char[])srcArray, (char[])dstArray);
    }

    @Test
    public void checkPutGetNonNativeDoubles() {
        int i;
        double[] srcArray = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0};
        int len = srcArray.length;
        int half = len / 2;
        WritableBuffer wbuf = WritableMemory.allocate((int)(len * 8), (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER).asWritableBuffer();
        wbuf.putDouble(srcArray[0]);
        wbuf.putDoubleArray(srcArray, 1, 2);
        wbuf.putDouble(srcArray[3]);
        for (int i2 = half; i2 < len; ++i2) {
            wbuf.putDouble((long)(i2 * 8), srcArray[i2]);
        }
        wbuf.resetPosition();
        WritableBuffer wbuf2 = WritableMemory.allocate((int)(len * 8), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER).asWritableBuffer();
        for (i = 0; i < len * 8; ++i) {
            wbuf2.putByte(wbuf.getByte());
        }
        wbuf2.resetPosition();
        for (i = 0; i < len; ++i) {
            Assert.assertTrue((srcArray[i] == UtilForTest.doubleReverseBytes(wbuf2.getDouble()) ? 1 : 0) != 0);
        }
        wbuf.resetPosition();
        double[] dstArray = new double[len];
        dstArray[0] = wbuf.getDouble();
        wbuf.getDoubleArray(dstArray, 1, 2);
        dstArray[3] = wbuf.getDouble();
        for (int i3 = half; i3 < len; ++i3) {
            dstArray[i3] = wbuf.getDouble((long)(i3 * 8));
        }
        Assert.assertEquals((double[])srcArray, (double[])dstArray);
    }

    @Test
    public void checkPutGetNonNativeFloats() {
        int i;
        float[] srcArray = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f};
        int len = srcArray.length;
        int half = len / 2;
        WritableBuffer wbuf = WritableMemory.allocate((int)(len * 4), (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER).asWritableBuffer();
        wbuf.putFloat(srcArray[0]);
        wbuf.putFloatArray(srcArray, 1, 2);
        wbuf.putFloat(srcArray[3]);
        for (int i2 = half; i2 < len; ++i2) {
            wbuf.putFloat((long)(i2 * 4), srcArray[i2]);
        }
        wbuf.resetPosition();
        WritableBuffer wbuf2 = WritableMemory.allocate((int)(len * 4), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER).asWritableBuffer();
        for (i = 0; i < len * 4; ++i) {
            wbuf2.putByte(wbuf.getByte());
        }
        wbuf2.resetPosition();
        for (i = 0; i < len; ++i) {
            Assert.assertTrue((srcArray[i] == UtilForTest.floatReverseBytes(wbuf2.getFloat()) ? 1 : 0) != 0);
        }
        wbuf.resetPosition();
        float[] dstArray = new float[len];
        dstArray[0] = wbuf.getFloat();
        wbuf.getFloatArray(dstArray, 1, 2);
        dstArray[3] = wbuf.getFloat();
        for (int i3 = half; i3 < len; ++i3) {
            dstArray[i3] = wbuf.getFloat((long)(i3 * 4));
        }
        Assert.assertEquals((float[])srcArray, (float[])dstArray);
    }

    @Test
    public void checkPutGetNonNativeInts() {
        int i;
        int[] srcArray = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
        int len = srcArray.length;
        int half = len / 2;
        WritableBuffer wbuf = WritableMemory.allocate((int)(len * 4), (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER).asWritableBuffer();
        wbuf.putInt(srcArray[0]);
        wbuf.putIntArray(srcArray, 1, 2);
        wbuf.putInt(srcArray[3]);
        for (int i2 = half; i2 < len; ++i2) {
            wbuf.putInt((long)(i2 * 4), srcArray[i2]);
        }
        wbuf.resetPosition();
        WritableBuffer wbuf2 = WritableMemory.allocate((int)(len * 4), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER).asWritableBuffer();
        for (i = 0; i < len * 4; ++i) {
            wbuf2.putByte(wbuf.getByte());
        }
        wbuf2.resetPosition();
        for (i = 0; i < len; ++i) {
            Assert.assertTrue((srcArray[i] == Integer.reverseBytes(wbuf2.getInt()) ? 1 : 0) != 0);
        }
        wbuf.resetPosition();
        int[] dstArray = new int[len];
        dstArray[0] = wbuf.getInt();
        wbuf.getIntArray(dstArray, 1, 2);
        dstArray[3] = wbuf.getInt();
        for (int i3 = half; i3 < len; ++i3) {
            dstArray[i3] = wbuf.getInt((long)(i3 * 4));
        }
        Assert.assertEquals((int[])srcArray, (int[])dstArray);
    }

    @Test
    public void checkPutGetNonNativeLongs() {
        int i;
        long[] srcArray = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L};
        int len = srcArray.length;
        int half = len / 2;
        WritableBuffer wbuf = WritableMemory.allocate((int)(len * 8), (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER).asWritableBuffer();
        wbuf.putLong(srcArray[0]);
        wbuf.putLongArray(srcArray, 1, 2);
        wbuf.putLong(srcArray[3]);
        for (int i2 = half; i2 < len; ++i2) {
            wbuf.putLong((long)(i2 * 8), srcArray[i2]);
        }
        wbuf.resetPosition();
        WritableBuffer wbuf2 = WritableMemory.allocate((int)(len * 8), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER).asWritableBuffer();
        for (i = 0; i < len * 8; ++i) {
            wbuf2.putByte(wbuf.getByte());
        }
        wbuf2.resetPosition();
        for (i = 0; i < len; ++i) {
            Assert.assertTrue((srcArray[i] == Long.reverseBytes(wbuf2.getLong()) ? 1 : 0) != 0);
        }
        wbuf.resetPosition();
        long[] dstArray = new long[len];
        dstArray[0] = wbuf.getLong();
        wbuf.getLongArray(dstArray, 1, 2);
        dstArray[3] = wbuf.getLong();
        for (int i3 = half; i3 < len; ++i3) {
            dstArray[i3] = wbuf.getLong((long)(i3 * 8));
        }
        Assert.assertEquals((long[])srcArray, (long[])dstArray);
    }

    @Test
    public void checkPutGetNonNativeShorts() {
        int i;
        short[] srcArray = new short[]{1, 2, 3, 4, 5, 6, 7, 8};
        int len = srcArray.length;
        int half = len / 2;
        WritableBuffer wbuf = WritableMemory.allocate((int)(len * 2), (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER).asWritableBuffer();
        wbuf.putShort(srcArray[0]);
        wbuf.putShortArray(srcArray, 1, 2);
        wbuf.putShort(srcArray[3]);
        for (int i2 = half; i2 < len; ++i2) {
            wbuf.putShort((long)(i2 * 2), srcArray[i2]);
        }
        wbuf.resetPosition();
        WritableBuffer wbuf2 = WritableMemory.allocate((int)(len * 2), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER).asWritableBuffer();
        for (i = 0; i < len * 2; ++i) {
            wbuf2.putByte(wbuf.getByte());
        }
        wbuf2.resetPosition();
        for (i = 0; i < len; ++i) {
            Assert.assertTrue((srcArray[i] == Short.reverseBytes(wbuf2.getShort()) ? 1 : 0) != 0);
        }
        wbuf.resetPosition();
        short[] dstArray = new short[len];
        dstArray[0] = wbuf.getShort();
        wbuf.getShortArray(dstArray, 1, 2);
        dstArray[3] = wbuf.getShort();
        for (int i3 = half; i3 < len; ++i3) {
            dstArray[i3] = wbuf.getShort((long)(i3 * 2));
        }
        Assert.assertEquals((short[])srcArray, (short[])dstArray);
    }

    @Test
    public void checkDuplicate() {
        byte[] bArr = new byte[8];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])bArr, (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER);
        WritableBuffer wbuf = wmem.asWritableBuffer();
        WritableBuffer wdup = wbuf.writableDuplicate();
        Assert.assertEquals((Object)wdup.getTypeByteOrder(), (Object)ResourceImpl.NON_NATIVE_BYTE_ORDER);
        WritableBuffer wreg = wbuf.writableRegion();
        Assert.assertEquals((Object)wreg.getTypeByteOrder(), (Object)ResourceImpl.NON_NATIVE_BYTE_ORDER);
    }

    @Test
    public void checkConversionByteOrder() {
        byte[] bArr = new byte[8];
        bArr[1] = 1;
        WritableMemory wmem = WritableMemory.writableWrap((byte[])bArr, (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER);
        Assert.assertEquals((Object)wmem.getTypeByteOrder(), (Object)ResourceImpl.NON_NATIVE_BYTE_ORDER);
        Assert.assertEquals((int)wmem.getChar(0L), (int)1);
        Buffer buf = wmem.asBuffer();
        Assert.assertEquals((Object)buf.getTypeByteOrder(), (Object)ResourceImpl.NON_NATIVE_BYTE_ORDER);
        Assert.assertEquals((int)buf.getChar(0L), (int)1);
        Buffer dup = buf.duplicate();
        Assert.assertEquals((Object)dup.getTypeByteOrder(), (Object)ResourceImpl.NON_NATIVE_BYTE_ORDER);
        Assert.assertEquals((int)dup.getChar(0L), (int)1);
        Buffer reg = buf.region();
        Assert.assertEquals((Object)reg.getTypeByteOrder(), (Object)ResourceImpl.NON_NATIVE_BYTE_ORDER);
        Assert.assertEquals((int)reg.getChar(0L), (int)1);
        Memory mem = reg.asMemory();
        Assert.assertEquals((Object)mem.getTypeByteOrder(), (Object)ResourceImpl.NON_NATIVE_BYTE_ORDER);
        Assert.assertEquals((int)mem.getChar(0L), (int)1);
        Memory mreg = mem.region(0L, 8L);
        Assert.assertEquals((Object)mreg.getTypeByteOrder(), (Object)ResourceImpl.NON_NATIVE_BYTE_ORDER);
        Assert.assertEquals((int)mreg.getChar(0L), (int)1);
    }

    @Test
    public void checkPutIntArray() {
        WritableMemory wmem = WritableMemory.allocate((int)12, (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER);
        WritableBuffer wbuf = wmem.asWritableBuffer(ResourceImpl.NON_NATIVE_BYTE_ORDER);
        wbuf.putInt(1);
        int[] array = new int[]{2};
        wbuf.putIntArray(array, 0, 1);
        wbuf.putInt(3);
        WritableBuffer buf = wmem.asWritableBuffer();
        Assert.assertEquals((int)buf.getInt(), (int)1);
        Assert.assertEquals((int)buf.getInt(), (int)2);
        Assert.assertEquals((int)buf.getInt(), (int)3);
    }
}

