/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import jdk.incubator.foreign.ResourceScope;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.apache.datasketches.memory.internal.Util;
import org.apache.datasketches.memory.internal.UtilTest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AllocateDirectMapMemoryTest {
    @Test
    public void simpleMap() throws IOException {
        File file = UtilTest.setGettysburgAddressFileToReadOnly();
        try (Memory mem = Memory.map((File)file);){
            mem.close();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testIllegalArguments() throws IOException {
        Memory mem2;
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        try {
            mem2 = Memory.map((File)file, (long)-1L, (long)Integer.MAX_VALUE, (ByteOrder)ByteOrder.nativeOrder());
            try {
                Assert.fail((String)"Failed: test IllegalArgumentException: Position was negative.");
                mem2.getCapacity();
            }
            finally {
                if (mem2 != null) {
                    mem2.close();
                }
            }
        }
        catch (IllegalArgumentException mem2) {
            // empty catch block
        }
        try {
            mem2 = Memory.map((File)file, (long)0L, (long)-1L, (ByteOrder)ByteOrder.nativeOrder());
            try {
                Assert.fail((String)"Failed: testIllegalArgumentException: Size was negative.");
            }
            finally {
                if (mem2 != null) {
                    mem2.close();
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMapAndMultipleClose() throws IOException {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        long memCapacity = file.length();
        Memory mem2 = null;
        try (Memory mem = Memory.map((File)file, (long)0L, (long)memCapacity, (ByteOrder)ByteOrder.nativeOrder());){
            mem2 = mem;
            Assert.assertEquals((long)memCapacity, (long)mem.getCapacity());
            mem.close();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            mem2.close();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testLoad() throws IOException {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        long memCapacity = file.length();
        try (Memory mem = Memory.map((File)file, (long)0L, (long)memCapacity, (ByteOrder)ByteOrder.nativeOrder());){
            mem.load();
            Assert.assertTrue((boolean)mem.isAlive());
        }
    }

    @Test
    public void testScopeHandle() throws IOException {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        long memCapacity = file.length();
        Memory mem = Memory.map((File)file, (long)0L, (long)memCapacity, (ByteOrder)ByteOrder.nativeOrder());
        ResourceScope scope = mem.scope();
        ResourceScope.Handle handle = scope.acquire();
        mem.load();
        mem.scope().release(handle);
        Assert.assertTrue((boolean)mem.isAlive());
        mem.close();
        Assert.assertFalse((boolean)mem.isAlive());
    }

    @Test
    public void printlnTest() {
        AllocateDirectMapMemoryTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
        if (o == null) {
            AllocateDirectMapMemoryTest.print(ResourceImpl.LS);
        } else {
            AllocateDirectMapMemoryTest.print(o.toString() + ResourceImpl.LS);
        }
    }

    static void print(Object o) {
        if (o != null) {
            // empty if block
        }
    }
}

