/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.core.dpath;

import java.io.Serializable;
import org.apache.daffodil.core.dpath.Expression;
import org.apache.daffodil.core.dpath.PathExpressionNoContextError;
import org.apache.daffodil.core.dpath.PredicateExpression;
import org.apache.daffodil.core.dpath.RelativePathExpression;
import org.apache.daffodil.lib.equality.package$;
import org.apache.daffodil.lib.equality.package$TypeEqual$;
import org.apache.daffodil.lib.equality.package$TypeEquality$;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.xml.NS;
import org.apache.daffodil.lib.xml.NS$;
import org.apache.daffodil.lib.xml.QName$;
import org.apache.daffodil.lib.xml.StepQName;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.dpath.NodeInfo$ArrayIndex$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$Complex$;
import org.apache.daffodil.runtime1.dsom.DPathCompileInfo;
import org.apache.daffodil.runtime1.dsom.DPathElementCompileInfo;
import org.apache.daffodil.runtime1.dsom.RelativePathPastRootError;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public abstract class StepExpression
extends Expression {
    public static final long OFFSET$12 = LazyVals$.MODULE$.getOffsetStatic(StepExpression.class.getDeclaredField("targetType$lzy3"));
    public static final long OFFSET$11 = LazyVals$.MODULE$.getOffsetStatic(StepExpression.class.getDeclaredField("checkAmbiguousPath$lzy1"));
    public static final long OFFSET$10 = LazyVals$.MODULE$.getOffsetStatic(StepExpression.class.getDeclaredField("isArrayOrOptional$lzy1"));
    public static final long OFFSET$9 = LazyVals$.MODULE$.getOffsetStatic(StepExpression.class.getDeclaredField("isArray$lzy1"));
    public static final long OFFSET$8 = LazyVals$.MODULE$.getOffsetStatic(StepExpression.class.getDeclaredField("isLastStep$lzy1"));
    public static final long OFFSET$7 = LazyVals$.MODULE$.getOffsetStatic(StepExpression.class.getDeclaredField("isFirstStep$lzy1"));
    public static final long OFFSET$6 = LazyVals$.MODULE$.getOffsetStatic(StepExpression.class.getDeclaredField("positionInStepsSequence$lzy1"));
    public static final long OFFSET$5 = LazyVals$.MODULE$.getOffsetStatic(StepExpression.class.getDeclaredField("isAbsolutePath$lzy2"));
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(StepExpression.class.getDeclaredField("relPathParent$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(StepExpression.class.getDeclaredField("priorStep$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(StepExpression.class.getDeclaredField("children$lzy5"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(StepExpression.class.getDeclaredField("stepQName$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(StepExpression.class.getDeclaredField("stepElements$lzy1"));
    private final String step;
    private final Option pred;
    private volatile Object stepElements$lzy1;
    private volatile Object stepQName$lzy1;
    private volatile Object children$lzy5;
    private volatile Object priorStep$lzy1;
    private volatile Object relPathParent$lzy1;
    private volatile Object isAbsolutePath$lzy2;
    private volatile Object positionInStepsSequence$lzy1;
    private volatile Object isFirstStep$lzy1;
    private volatile Object isLastStep$lzy1;
    private volatile Object isArray$lzy1;
    private volatile Object isArrayOrOptional$lzy1;
    private volatile Object checkAmbiguousPath$lzy1;
    private volatile Object targetType$lzy3;

    public StepExpression(String step, Option<PredicateExpression> pred) {
        this.step = step;
        this.pred = pred;
    }

    public String step() {
        return this.step;
    }

    public Option<PredicateExpression> pred() {
        return this.pred;
    }

    @Override
    public final String text() {
        return this.step() + this.pred().map((Function1 & Serializable)_$151 -> _$151.text()).getOrElse(StepExpression::text$$anonfun$3);
    }

    public void checkIfNodeIndexedLikeArray() {
        StepExpression SDEUsingMacrosMixin_this = this;
        boolean testThatWillThrowIfTrue$proxy1 = this.pred().isDefined();
        if (testThatWillThrowIfTrue$proxy1) {
            throw SDEUsingMacrosMixin_this.SDE("Indexing is only allowed on arrays. Offending path step: '%s'.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.text()}));
        }
    }

    public Nothing$ relPathErr() {
        PathExpressionNoContextError err = this.compileInfo().elementCompileInfos().isEmpty() || !this.rootElement().isDistinguishedRoot() ? new PathExpressionNoContextError() : new RelativePathPastRootError(this.schemaFileLocation(), "Relative path '%s' past root element.", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.wholeExpressionText()}));
        return this.toss(err);
    }

    public void verifyQNames(Seq<DPathElementCompileInfo> cis) {
        cis.foreach((Function1)(JProcedure1 & Serializable)ci -> {
            if (!ci.namedQName().matches(this.stepQName())) {
                throw ci.noMatchError(this.stepQName(), ci.noMatchError$default$2());
            }
        });
    }

    public final Seq<DPathElementCompileInfo> stepElements() {
        Object object = this.stepElements$lzy1;
        if (object instanceof Seq) {
            return (Seq)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Seq)this.stepElements$lzyINIT1();
    }

    private Object stepElements$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.stepElements$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Seq<DPathElementCompileInfo> seq = null;
                    Seq<DPathElementCompileInfo> seq2 = null;
                    try {
                        Seq<DPathElementCompileInfo> res;
                        seq2 = res = this.stepElementDefs();
                        seq = seq2 == null ? LazyVals.NullValue$.MODULE$ : seq2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, seq)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.stepElements$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, seq);
                            waiting.countDown();
                        }
                    }
                    return seq2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public abstract Seq<DPathElementCompileInfo> stepElementDefs();

    public boolean equals(Object x) {
        Object object = x;
        if (object instanceof Object) {
            Object ar = object;
            StepExpression stepExpression = (StepExpression)package$.MODULE$.TypeEqual(this);
            return package$TypeEqual$.MODULE$._eq_$extension(stepExpression, ar, package$TypeEquality$.MODULE$.leftSubtypeOfRightEquality());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public final boolean hasReferenceTo(DPathElementCompileInfo elem) {
        return this.stepElements().contains((Object)elem);
    }

    public StepQName stepQName() {
        Object object = this.stepQName$lzy1;
        if (object instanceof StepQName) {
            return (StepQName)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (StepQName)this.stepQName$lzyINIT1();
    }

    private Object stepQName$lzyINIT1() {
        Object object;
        block10: {
            while (true) {
                if ((object = this.stepQName$lzy1) == null) {
                    Try<StepQName> try_;
                    StepQName stepQName;
                    Object object2;
                    block9: {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        object2 = null;
                        stepQName = null;
                        try {
                            Try<StepQName> e;
                            try_ = e = QName$.MODULE$.resolveStep(this.step(), this.namespaces(), this.noPrefixNamespace(), this.tunable().unqualifiedPathStepPolicy());
                            if (!(try_ instanceof Failure)) break block9;
                            Throwable th = ((Failure)try_).exception();
                            throw this.SDE("Step %s prefix has no corresponding namespace.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.step()}));
                        }
                        catch (Throwable throwable) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.stepQName$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                                waiting.countDown();
                            }
                            throw throwable;
                        }
                    }
                    if (!(try_ instanceof Success)) {
                        throw new MatchError(try_);
                    }
                    StepQName v = (StepQName)((Success)try_).value();
                    stepQName = v;
                    object2 = stepQName == null ? LazyVals.NullValue$.MODULE$ : stepQName;
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.stepQName$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return stepQName;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block10;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Seq<Expression> children() {
        Object object = this.children$lzy5;
        if (object instanceof Seq) {
            return (Seq)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Seq)this.children$lzyINIT5();
    }

    private Object children$lzyINIT5() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.children$lzy5) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    List list = null;
                    try {
                        list = this.pred().toList();
                        object2 = list == null ? LazyVals.NullValue$.MODULE$ : list;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.children$lzy5;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return list;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<StepExpression> priorStep() {
        Object object = this.priorStep$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.priorStep$lzyINIT1();
    }

    private Object priorStep$lzyINIT1() {
        Object object;
        block10: {
            while (true) {
                if ((object = this.priorStep$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    None$ none$ = null;
                    try {
                        None$ res;
                        None$ none$2;
                        if (this.isFirstStep()) {
                            none$2 = None$.MODULE$;
                        } else {
                            int pos = this.positionInStepsSequence() - 1;
                            StepExpression step = (StepExpression)this.relPathParent().steps().apply(pos);
                            none$2 = Some$.MODULE$.apply((Object)step);
                        }
                        none$ = res = none$2;
                        object2 = none$ == null ? LazyVals.NullValue$.MODULE$ : none$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.priorStep$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return none$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block10;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public RelativePathExpression relPathParent() {
        Object object = this.relPathParent$lzy1;
        if (object instanceof RelativePathExpression) {
            return (RelativePathExpression)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RelativePathExpression)this.relPathParent$lzyINIT1();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object relPathParent$lzyINIT1() {
        while (true) {
            Object object;
            if ((object = this.relPathParent$lzy1) == null) {
                void var2_5;
                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                Object var2_2 = null;
                RelativePathExpression relativePathExpression = null;
                try {
                    RelativePathExpression rel;
                    Expression expression;
                    Option<Expression> option = this.parentOpt();
                    if (option instanceof Some) {
                        expression = (Expression)((Some)option).value();
                        if (!(expression instanceof RelativePathExpression)) {
                            Expression x = expression;
                            throw Assert$.MODULE$.invariantFailed("StepExpression must have RelativePathExpression parent.");
                        }
                    } else {
                        if (None$.MODULE$.equals(option)) {
                            throw Assert$.MODULE$.invariantFailed("StepExpression must have parent.");
                        }
                        throw new MatchError(option);
                    }
                    relativePathExpression = rel = (RelativePathExpression)expression;
                    if (relativePathExpression == null) {
                        LazyVals.NullValue$ nullValue$ = LazyVals.NullValue$.MODULE$;
                    } else {
                        RelativePathExpression relativePathExpression2 = relativePathExpression;
                    }
                }
                catch (Throwable throwable) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, var2_2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.relPathParent$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, var2_2);
                        waiting.countDown();
                    }
                    throw throwable;
                }
                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, (Object)var2_5)) {
                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.relPathParent$lzy1;
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, (Object)var2_5);
                    waiting.countDown();
                }
                return relativePathExpression;
            }
            if (!(object instanceof LazyVals.LazyValControlState)) {
                return object;
            }
            if (object == LazyVals.Evaluating$.MODULE$) {
                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                continue;
            }
            if (!(object instanceof LazyVals.Waiting)) {
                return null;
            }
            ((LazyVals.Waiting)object).await();
        }
    }

    public boolean isAbsolutePath() {
        Object object = this.isAbsolutePath$lzy2;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.isAbsolutePath$lzyINIT2());
    }

    private Object isAbsolutePath$lzyINIT2() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.isAbsolutePath$lzy2) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)this.relPathParent().isAbsolutePath());
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.isAbsolutePath$lzy2;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int positionInStepsSequence() {
        Object object = this.positionInStepsSequence$lzy1;
        if (object instanceof Integer) {
            return BoxesRunTime.unboxToInt((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToInt(null);
        }
        return BoxesRunTime.unboxToInt((Object)this.positionInStepsSequence$lzyINIT1());
    }

    private Object positionInStepsSequence$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.positionInStepsSequence$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Integer n = null;
                    try {
                        List<StepExpression> steps = this.relPathParent().steps();
                        n = BoxesRunTime.boxToInteger((int)steps.indexOf((Object)this));
                        object2 = n == null ? LazyVals.NullValue$.MODULE$ : n;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.positionInStepsSequence$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return n;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean isFirstStep() {
        Object object = this.isFirstStep$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.isFirstStep$lzyINIT1());
    }

    private Object isFirstStep$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.isFirstStep$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        boolean res = this.positionInStepsSequence() == 0;
                        bl = BoxesRunTime.boxToBoolean((boolean)res);
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.isFirstStep$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean isLastStep() {
        Object object = this.isLastStep$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.isLastStep$lzyINIT1());
    }

    private Object isLastStep$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.isLastStep$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        boolean res = this.positionInStepsSequence() == this.relPathParent().steps().length() - 1;
                        bl = BoxesRunTime.boxToBoolean((boolean)res);
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.isLastStep$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final boolean isArray() {
        Object object = this.isArray$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.isArray$lzyINIT1());
    }

    private Object isArray$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.isArray$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$9, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        this.checkAmbiguousPath();
                        bl = BoxesRunTime.boxToBoolean((boolean)this.stepElements().exists((Function1 & Serializable)_$152 -> _$152.isArray()));
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$9, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.isArray$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$9, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$9, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final boolean isArrayOrOptional() {
        Object object = this.isArrayOrOptional$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.isArrayOrOptional$lzyINIT1());
    }

    private Object isArrayOrOptional$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.isArrayOrOptional$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$10, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        this.checkAmbiguousPath();
                        bl = BoxesRunTime.boxToBoolean((this.stepElements().exists((Function1 & Serializable)_$153 -> _$153.isArray()) || this.stepElements().exists((Function1 & Serializable)_$154 -> _$154.isOptional()) ? 1 : 0) != 0);
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$10, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.isArrayOrOptional$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$10, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$10, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final void checkAmbiguousPath() {
        Object object = this.checkAmbiguousPath$lzy1;
        if (object instanceof BoxedUnit) {
            return (void)((BoxedUnit)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (void)((BoxedUnit)this.checkAmbiguousPath$lzyINIT1());
    }

    private Object checkAmbiguousPath$lzyINIT1() {
        Object object;
        block9: {
            while (true) {
                if ((object = this.checkAmbiguousPath$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$11, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    BoxedUnit boxedUnit = null;
                    try {
                        boolean testThatWillThrowIfTrue$proxy2;
                        Tuple2 tuple2 = this.stepElements().partition((Function1 & Serializable)_$155 -> _$155.isArray());
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Seq arrays = (Seq)tuple2._1();
                        Seq nonArrays = (Seq)tuple2._2();
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)arrays, (Object)nonArrays);
                        Seq arrays2 = (Seq)tuple22._1();
                        Seq nonArrays2 = (Seq)tuple22._2();
                        StepExpression SDEUsingMacrosMixin_this = this;
                        boolean bl = testThatWillThrowIfTrue$proxy2 = arrays2.length() > 0 && nonArrays2.length() > 0;
                        if (testThatWillThrowIfTrue$proxy2) {
                            throw SDEUsingMacrosMixin_this.SDE("Path step %s is ambiguous. It can reference both an array and a non-array element, which is not allowed.\n- Array: %s\n- Non-array: %s\n", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.step(), ((DPathCompileInfo)arrays2.head()).schemaFileLocation().locationDescription(), ((DPathCompileInfo)nonArrays2.head()).schemaFileLocation().locationDescription()}));
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        object2 = boxedUnit == null ? LazyVals.NullValue$.MODULE$ : boxedUnit;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$11, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.checkAmbiguousPath$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$11, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$11, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.checkAmbiguousPath$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$11, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return boxedUnit;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block9;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$11, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Seq<String> suggestedPossiblePrefixes(NS ns) {
        Seq<String> res = NS$.MODULE$.allPrefixes(ns, this.compileInfo().namespaces());
        return res;
    }

    @Override
    public NodeInfo.Kind targetType() {
        Object object = this.targetType$lzy3;
        if (object instanceof NodeInfo.Kind) {
            return (NodeInfo.Kind)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (NodeInfo.Kind)this.targetType$lzyINIT3();
    }

    private Object targetType$lzyINIT3() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.targetType$lzy3) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$12, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    NodeInfo$Complex$ nodeInfo$Complex$ = null;
                    try {
                        NodeInfo.Kind kind = nodeInfo$Complex$ = this.isLastStep() ? this.parent().targetTypeForSubexpression(this) : NodeInfo$Complex$.MODULE$;
                        object2 = nodeInfo$Complex$ == null ? LazyVals.NullValue$.MODULE$ : nodeInfo$Complex$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$12, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.targetType$lzy3;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$12, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return nodeInfo$Complex$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$12, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public NodeInfo.Kind targetTypeForSubexpression(Expression subexp) {
        if (!this.pred().isDefined()) {
            throw Assert$.MODULE$.abort("Invariant broken: StepExpression.this.pred.isDefined");
        }
        Object object = this.pred().get();
        Expression expression = subexp;
        if (object == null ? expression != null : !object.equals(expression)) {
            throw Assert$.MODULE$.abort("Invariant broken: StepExpression.this.pred.get.==(subexp)");
        }
        return NodeInfo$ArrayIndex$.MODULE$;
    }

    private static final String text$$anonfun$3() {
        return "";
    }
}

