/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.main.api.sax;

import com.siemens.ct.exi.core.EXIFactory;
import com.siemens.ct.exi.core.FidelityOptions;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.main.api.sax.SAXDecoder;
import com.siemens.ct.exi.main.api.sax.SAXEncoder;
import com.siemens.ct.exi.main.api.sax.SAXEncoderExtendedHandler;
import org.xml.sax.XMLReader;

public class SAXFactory {
    protected final EXIFactory exiFactory;

    public SAXFactory(EXIFactory exiFactory) {
        this.exiFactory = exiFactory;
    }

    public XMLReader createEXIReader() throws EXIException {
        return new SAXDecoder(this.exiFactory);
    }

    public SAXEncoder createEXIWriter() throws EXIException {
        FidelityOptions fidelityOptions = this.exiFactory.getFidelityOptions();
        if (fidelityOptions.isFidelityEnabled("PRESERVE_PREFIXES") || fidelityOptions.isFidelityEnabled("PRESERVE_COMMENTS") || fidelityOptions.isFidelityEnabled("PRESERVE_PIS") || fidelityOptions.isFidelityEnabled("PRESERVE_DTDS")) {
            return new SAXEncoderExtendedHandler(this.exiFactory);
        }
        return new SAXEncoder(this.exiFactory);
    }
}

