/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.layers.runtime1;

import java.io.OutputStream;
import java.io.Serializable;
import org.apache.daffodil.layers.runtime1.LineFoldMode;
import org.apache.daffodil.layers.runtime1.LineFoldMode$;
import org.apache.daffodil.lib.exceptions.Assert$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public class LineFoldedOutputStream
extends OutputStream {
    private final LineFoldMode mode;
    private final OutputStream jos;
    private final int lineLength;
    private final byte[] breaker;
    private final StringBuilder line;
    private boolean closed;

    public LineFoldedOutputStream(LineFoldMode mode, OutputStream jos) {
        Tuple2 tuple2;
        this.mode = mode;
        this.jos = jos;
        LineFoldMode lineFoldMode = mode;
        LineFoldMode lineFoldMode2 = LineFoldMode$.IMF;
        LineFoldMode lineFoldMode3 = lineFoldMode;
        if (!(lineFoldMode2 != null ? !lineFoldMode2.equals(lineFoldMode3) : lineFoldMode3 != null)) {
            tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)78), (Object)"\r\n".getBytes("ascii"));
        } else {
            LineFoldMode lineFoldMode4 = LineFoldMode$.iCalendar;
            LineFoldMode lineFoldMode5 = lineFoldMode;
            if (!(lineFoldMode4 != null ? !lineFoldMode4.equals(lineFoldMode5) : lineFoldMode5 != null)) {
                tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)75), (Object)"\r\n ".getBytes("ascii"));
            } else {
                throw new MatchError((Object)lineFoldMode);
            }
        }
        Tuple2 tuple22 = tuple2;
        this.lineLength = BoxesRunTime.unboxToInt((Object)tuple22._1());
        this.breaker = (byte[])tuple22._2();
        this.line = new StringBuilder(this.lineLength + this.breaker.length);
        this.closed = false;
    }

    private byte[] lineBytes() {
        return (byte[])((IterableOnceOps)this.line.map((Function1 & Serializable)_$2 -> LineFoldedOutputStream.lineBytes$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$2)))).toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
    }

    private boolean lastCharWas(char c) {
        if (this.line.length() == 0) {
            return false;
        }
        return BoxesRunTime.unboxToChar((Object)this.line.last()) == (byte)c;
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.line.length() > 0) {
                this.jos.write(this.lineBytes());
            }
            this.jos.close();
            this.closed = true;
            return;
        }
    }

    @Override
    public void write(int bInt) {
        if (this.closed) {
            throw Assert$.MODULE$.usageError("LineFoldedOutputStream.this.closed.unary_!");
        }
        if (this.line.length() > this.lineLength) {
            throw Assert$.MODULE$.abort("Invariant broken: LineFoldedOutputStream.this.line.length().<=(LineFoldedOutputStream.this.lineLength)");
        }
        if (bInt < 0) {
            throw Assert$.MODULE$.usageError("bInt.>=(0)");
        }
        char b = (char)bInt;
        if (this.line.length() < this.lineLength) {
            char c = b;
            if ('\r' == c) {
                this.line.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)b));
                return;
            }
            if ('\n' == c) {
                if (!this.lastCharWas('\r')) {
                    this.line.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'\r'));
                    this.line.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'\n'));
                    this.jos.write(this.lineBytes());
                    this.line.clear();
                    return;
                }
                if (this.lastCharWas('\r')) {
                    this.line.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'\n'));
                    this.jos.write(this.lineBytes());
                    this.line.clear();
                    return;
                }
            }
            char c2 = c;
            if (this.lastCharWas('\r')) {
                this.line.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'\n'));
                this.jos.write(this.lineBytes());
                this.line.clear();
                this.line.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)c2));
                return;
            }
            char c3 = c;
            this.line.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)c3));
            return;
        }
        LineFoldMode lineFoldMode = this.mode;
        LineFoldMode lineFoldMode2 = LineFoldMode$.iCalendar;
        LineFoldMode lineFoldMode3 = lineFoldMode;
        if (!(lineFoldMode2 != null ? !lineFoldMode2.equals(lineFoldMode3) : lineFoldMode3 != null)) {
            this.tooLongLineICalendar(b);
            return;
        }
        LineFoldMode lineFoldMode4 = LineFoldMode$.IMF;
        LineFoldMode lineFoldMode5 = lineFoldMode;
        if (!(lineFoldMode4 != null ? !lineFoldMode4.equals(lineFoldMode5) : lineFoldMode5 != null)) {
            this.tooLongLineIMF(b);
            return;
        }
        throw new MatchError((Object)lineFoldMode);
    }

    private void tooLongLineICalendar(char b) {
        this.line.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'\r'));
        this.line.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'\n'));
        this.line.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)' '));
        this.jos.write(this.lineBytes());
        this.line.clear();
        this.line.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)b));
    }

    private void tooLongLineIMF(char b) {
        boolean done = false;
        for (int i = this.line.length() - 1; i > 0 && !done; --i) {
            BoxedUnit boxedUnit;
            char c = this.line.apply(i);
            char c2 = c;
            if (' ' == c2 || '\t' == c2) {
                done = true;
                this.jos.write(this.lineBytes(), 0, i);
                this.jos.write(this.breaker);
                this.line.delete(0, i);
                boxedUnit = this.line.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)b));
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        if (!done) {
            this.jos.write(this.lineBytes());
            this.line.clear();
            this.line.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)b));
            return;
        }
    }

    private static final /* synthetic */ byte lineBytes$$anonfun$1(char _$2) {
        return (byte)_$2;
    }
}

