/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.uri.AbstractCFSchema;
import org.apache.activemq.artemis.uri.JMSConnectionOptions;
import org.apache.activemq.artemis.uri.schema.serverLocator.UDPServerLocatorSchema;
import org.apache.activemq.artemis.utils.uri.BeanSupport;

public class UDPSchema
extends AbstractCFSchema {
    public String getSchemaName() {
        return "udp";
    }

    public ActiveMQConnectionFactory internalNewObject(URI uri, Map<String, String> query, String name) throws Exception {
        JMSConnectionOptions options = this.newConectionOptions(uri, query);
        DiscoveryGroupConfiguration dgc = UDPServerLocatorSchema.getDiscoveryGroupConfiguration((URI)uri, query, (String)this.getHost(uri), (int)this.getPort(uri), (String)name);
        ActiveMQConnectionFactory factory = options.isHa() ? ActiveMQJMSClient.createConnectionFactoryWithHA(dgc, options.getFactoryTypeEnum()) : ActiveMQJMSClient.createConnectionFactoryWithoutHA(dgc, options.getFactoryTypeEnum());
        return this.setData(uri, query, factory);
    }

    protected URI internalNewURI(ActiveMQConnectionFactory bean) throws Exception {
        DiscoveryGroupConfiguration dgc = bean.getDiscoveryGroupConfiguration();
        UDPBroadcastEndpointFactory endpoint = (UDPBroadcastEndpointFactory)dgc.getBroadcastEndpointFactory();
        String query = BeanSupport.getData((List)UDPServerLocatorSchema.IGNORED, (Object[])new Object[]{bean, dgc, endpoint});
        dgc.setBroadcastEndpointFactory((BroadcastEndpointFactory)endpoint);
        return new URI("udp", null, endpoint.getGroupAddress(), endpoint.getGroupPort(), null, query, null);
    }
}

