/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.spec;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.impl.AbstractRequestContextImpl;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;

public class ClientRequestContextImpl
extends AbstractRequestContextImpl
implements ClientRequestContext {
    public ClientRequestContextImpl(Message m, boolean responseContext) {
        super(m, responseContext);
    }

    public MediaType getMediaType() {
        if (!this.hasEntity()) {
            return null;
        }
        Object mt = HttpUtils.getModifiableHeaders((Message)this.m).getFirst((Object)"Content-Type");
        return mt instanceof MediaType ? (MediaType)mt : JAXRSUtils.toMediaType((String)mt.toString());
    }

    public Client getClient() {
        return (Client)this.m.getContextualProperty(Client.class.getName());
    }

    public Configuration getConfiguration() {
        ClientProviderFactory cpf = ClientProviderFactory.getInstance(this.m);
        return cpf.getConfiguration(this.m);
    }

    private Object getMessageContent() {
        MessageContentsList objs = MessageContentsList.getContentsList((Message)this.m);
        if (objs == null || objs.isEmpty()) {
            return null;
        }
        return objs.get(0);
    }

    public Object getEntity() {
        return this.getMessageContent();
    }

    public Annotation[] getEntityAnnotations() {
        Annotation[] anns = (Annotation[])this.m.get((Object)Annotation.class.getName());
        return anns == null ? new Annotation[]{} : anns;
    }

    public Class<?> getEntityClass() {
        Object entity = this.getEntity();
        return entity == null ? null : entity.getClass();
    }

    public Type getEntityType() {
        Class<?> t = (Class<?>)this.m.get(Type.class);
        return t != null ? t : this.getEntityClass();
    }

    public OutputStream getEntityStream() {
        return (OutputStream)this.m.getContent(OutputStream.class);
    }

    public boolean hasEntity() {
        return this.getEntity() != null;
    }

    public void setEntity(Object entity, Annotation[] anns, MediaType mt) {
        if (mt != null) {
            MultivaluedMap<String, Object> headers = this.getHeaders();
            headers.putSingle((Object)"Content-Type", (Object)mt);
            this.m.put((Object)"Content-Type", (Object)mt.toString());
        }
        if (anns != null) {
            this.m.put((Object)Annotation.class.getName(), (Object)anns);
        }
        this.doSetEntity(entity);
    }

    public void setEntity(Object entity) {
        this.doSetEntity(entity);
    }

    private void doSetEntity(Object entity) {
        Object actualEntity = InjectionUtils.getEntity((Object)entity);
        this.m.setContent(List.class, (Object)(actualEntity == null ? new MessageContentsList() : new MessageContentsList(new Object[]{actualEntity})));
        if (entity != null) {
            Type type = GenericEntity.class.isAssignableFrom(entity.getClass()) ? ((GenericEntity)entity).getType() : entity.getClass();
            this.m.put(Type.class, type);
            this.m.remove((Object)"org.apache.cxf.empty.request");
        }
    }

    public URI getUri() {
        String requestURI = (String)this.m.get((Object)"org.apache.cxf.request.uri");
        if (requestURI == null) {
            return null;
        }
        if (requestURI.startsWith("/")) {
            String endpointAddress = (String)this.m.get((Object)Message.ENDPOINT_ADDRESS);
            requestURI = requestURI.length() == 1 ? endpointAddress : endpointAddress + requestURI;
        }
        return URI.create(requestURI);
    }

    public void setEntityStream(OutputStream os) {
        this.m.setContent(OutputStream.class, (Object)os);
    }

    public void setUri(URI requestURI) {
        this.m.put((Object)Message.ENDPOINT_ADDRESS, (Object)requestURI.toString());
        this.m.put((Object)"org.apache.cxf.request.uri", (Object)requestURI.toString());
    }

    public MultivaluedMap<String, Object> getHeaders() {
        this.h = null;
        return HttpUtils.getModifiableHeaders((Message)this.m);
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        this.h = null;
        return HttpUtils.getModifiableStringHeaders((Message)this.m);
    }
}

