/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class CreateProducerMessage
extends PacketImpl {
    protected int id;
    protected SimpleString address;

    public CreateProducerMessage() {
        super((byte)-20);
    }

    public CreateProducerMessage(int id, SimpleString address) {
        super((byte)-20);
        this.id = id;
        this.address = address;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public SimpleString getAddress() {
        return this.address;
    }

    public void setAddress(SimpleString address) {
        this.address = address;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeInt(this.id);
        buffer.writeNullableSimpleString(this.address);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.id = buffer.readInt();
        this.address = buffer.readNullableSimpleString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CreateProducerMessage that = (CreateProducerMessage)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.address, that.address);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.id, this.address);
    }
}

