/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.collections.AST;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.wsdl.Anonfixed;
import org.apache.cxf.binding.corba.wsdl.CorbaType;
import org.apache.cxf.binding.corba.wsdl.Fixed;
import org.apache.cxf.tools.corba.processors.idl.Scope;
import org.apache.cxf.tools.corba.processors.idl.TypesUtils;
import org.apache.cxf.tools.corba.processors.idl.VisitorBase;
import org.apache.cxf.tools.corba.processors.idl.WSDLASTVisitor;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaFractionDigitsFacet;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaTotalDigitsFacet;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.constants.Constants;

public class FixedVisitor
extends VisitorBase {
    private AST identifierNode;

    public FixedVisitor(Scope scope, Definition defn, XmlSchema schemaRef, WSDLASTVisitor wsdlVisitor, AST identifierNodeRef) {
        super(scope, defn, schemaRef, wsdlVisitor);
        this.identifierNode = identifierNodeRef;
    }

    public static boolean accept(AST node) {
        return node.getType() == 74;
    }

    @Override
    public void visit(AST fixedNode) {
        Fixed type;
        AST digitsNode = fixedNode.getFirstChild();
        AST scaleNode = digitsNode.getNextSibling();
        Scope scopedName = this.identifierNode == null ? TypesUtils.generateAnonymousScopedName(this.getScope(), this.schema) : new Scope(this.getScope(), this.identifierNode);
        Long digits = Long.valueOf(digitsNode.toString());
        Long scale = Long.valueOf(scaleNode.toString());
        if (digits < 1L || digits > 31L) {
            System.out.println("Digits cannot be greater than 31");
            return;
        }
        if (scale.compareTo(digits) > 0) {
            System.out.println("Scale cannot be greater than digits");
            return;
        }
        XmlSchemaSimpleType fixedSimpleType = new XmlSchemaSimpleType(this.schema, true);
        XmlSchemaSimpleTypeRestriction fixedRestriction = new XmlSchemaSimpleTypeRestriction();
        fixedRestriction.setBaseTypeName(Constants.XSD_DECIMAL);
        XmlSchemaTotalDigitsFacet fixedTotalDigits = new XmlSchemaTotalDigitsFacet();
        fixedTotalDigits.setValue((Object)digitsNode.toString());
        XmlSchemaFractionDigitsFacet fixedFractionDigits = new XmlSchemaFractionDigitsFacet();
        fixedFractionDigits.setValue((Object)scaleNode.toString());
        fixedFractionDigits.setFixed(true);
        fixedRestriction.getFacets().add(fixedTotalDigits);
        fixedRestriction.getFacets().add(fixedFractionDigits);
        fixedSimpleType.setName(this.mapper.mapToQName(scopedName));
        fixedSimpleType.setContent((XmlSchemaSimpleTypeContent)fixedRestriction);
        this.setSchemaType((XmlSchemaType)fixedSimpleType);
        if (this.identifierNode != null) {
            Fixed corbaFixed = new Fixed();
            corbaFixed.setQName(new QName(this.typeMap.getTargetNamespace(), scopedName.toString()));
            corbaFixed.setDigits(digits.longValue());
            corbaFixed.setScale(scale.longValue());
            corbaFixed.setRepositoryID(scopedName.toIDLRepositoryID());
            corbaFixed.setType(fixedSimpleType.getQName());
            type = corbaFixed;
        } else {
            Anonfixed corbaFixed = new Anonfixed();
            corbaFixed.setQName(new QName(this.typeMap.getTargetNamespace(), scopedName.toString()));
            corbaFixed.setDigits(digits.longValue());
            corbaFixed.setScale(scale.longValue());
            corbaFixed.setType(fixedSimpleType.getQName());
            this.typeMap.getStructOrExceptionOrUnion().add(corbaFixed);
            type = corbaFixed;
        }
        this.setCorbaType((CorbaType)type);
    }
}

