/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.Serializable;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.vfs2.FileType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileTypeTest {
    private void assertFileTypeEquals(FileType expected, FileType actualFileType) {
        Assertions.assertEquals((Object)expected.getName(), (Object)actualFileType.getName());
        Assertions.assertEquals((Object)expected.hasAttributes(), (Object)actualFileType.hasAttributes());
        Assertions.assertEquals((Object)expected.hasChildren(), (Object)actualFileType.hasChildren());
        Assertions.assertEquals((Object)expected.hasContent(), (Object)actualFileType.hasContent());
    }

    private void test(FileType expected) {
        byte[] serialized = SerializationUtils.serialize((Serializable)expected);
        FileType actualFileType = (FileType)SerializationUtils.deserialize((byte[])serialized);
        this.assertFileTypeEquals(expected, actualFileType);
    }

    @Test
    public void testSerializationContainer() {
        Fixture expectedFixture = new Fixture();
        byte[] serialized = SerializationUtils.serialize((Serializable)expectedFixture);
        Fixture actualFixture = (Fixture)SerializationUtils.deserialize((byte[])serialized);
        this.assertFileTypeEquals(expectedFixture.getFileType(), actualFixture.getFileType());
    }

    @Test
    public void testSerializationFile() {
        this.test(FileType.FILE);
    }

    @Test
    public void testSerializationFileOrFolder() {
        this.test(FileType.FILE_OR_FOLDER);
    }

    @Test
    public void testSerializationFolder() {
        this.test(FileType.FOLDER);
    }

    @Test
    public void testSerializationImaginary() {
        this.test(FileType.IMAGINARY);
    }

    private static class Fixture
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final FileType fileType = FileType.FILE;

        private Fixture() {
        }

        public FileType getFileType() {
            return this.fileType;
        }
    }
}

