/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.DefaultStringLookup;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.commons.text.lookup.StringLookupFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class StringSubstitutorWithInterpolatorStringLookupTest {
    StringSubstitutorWithInterpolatorStringLookupTest() {
    }

    private static StringLookup createInterpolatorWithLookups(DefaultStringLookup ... lookups) {
        HashMap<String, StringLookup> lookupMap = new HashMap<String, StringLookup>();
        for (DefaultStringLookup lookup : lookups) {
            lookupMap.put(lookup.getKey().toLowerCase(), lookup.getStringLookup());
        }
        return StringLookupFactory.INSTANCE.interpolatorStringLookup(lookupMap, null, false);
    }

    @Test
    void testCustomFunctionWithDefaults() {
        this.testCustomFunctionWithDefaults(true);
    }

    private void testCustomFunctionWithDefaults(boolean addDefaultLookups) {
        String key = "key";
        String value = "value";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        StringLookup mapStringLookup = StringLookupFactory.INSTANCE.functionStringLookup(map::get);
        HashMap<String, StringLookup> stringLookupMap = new HashMap<String, StringLookup>();
        stringLookupMap.put("customLookup", mapStringLookup);
        StringSubstitutor strSubst = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup(stringLookupMap, null, addDefaultLookups));
        if (addDefaultLookups) {
            String spKey = "user.name";
            Assertions.assertEquals((Object)System.getProperty("user.name"), (Object)strSubst.replace("${sys:user.name}"));
        }
        Assertions.assertEquals((Object)"value", (Object)strSubst.replace("${customLookup:key}"));
    }

    @Test
    void testCustomFunctionWithoutDefaults() {
        this.testCustomFunctionWithDefaults(false);
    }

    @Test
    void testCustomMapWithDefaults() {
        this.testCustomMapWithDefaults(true);
    }

    private void testCustomMapWithDefaults(boolean addDefaultLookups) {
        String key = "key";
        String value = "value";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        StringLookup mapStringLookup = StringLookupFactory.INSTANCE.mapStringLookup(map);
        HashMap<String, StringLookup> stringLookupMap = new HashMap<String, StringLookup>();
        stringLookupMap.put("customLookup", mapStringLookup);
        StringSubstitutor strSubst = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup(stringLookupMap, null, addDefaultLookups));
        if (addDefaultLookups) {
            String spKey = "user.name";
            Assertions.assertEquals((Object)System.getProperty("user.name"), (Object)strSubst.replace("${sys:user.name}"));
        }
        Assertions.assertEquals((Object)"value", (Object)strSubst.replace("${customLookup:key}"));
        Assertions.assertEquals((Object)"${UnknownLookup:key}", (Object)strSubst.replace("${UnknownLookup:key}"));
    }

    @Test
    void testCustomMapWithoutDefaults() {
        this.testCustomMapWithDefaults(false);
    }

    @Test
    void testDefaultInterpolator() {
        StringSubstitutor interpolator = StringSubstitutor.createInterpolator();
        String text = interpolator.replace("Base64 Decoder:        ${base64Decoder:SGVsbG9Xb3JsZCE=}\nBase64 Encoder:        ${base64Encoder:HelloWorld!}\nJava Constant:         ${const:java.awt.event.KeyEvent.VK_ESCAPE}\nDate:                  ${date:yyyy-MM-dd}\nEnvironment Variable:  ${env:USERNAME}\nFile Content:          ${file:UTF-8:src/test/resources/org/apache/commons/text/document.properties}\nJava:                  ${java:version}\nLocalhost:             ${localhost:canonical-name}\nProperties File:       ${properties:src/test/resources/org/apache/commons/text/document.properties::mykey}\nResource Bundle:       ${resourceBundle:org.apache.commons.text.example.testResourceBundleLookup:mykey}\nSystem Property:       ${sys:user.dir}\nURL Decoder:           ${urlDecoder:Hello%20World%21}\nURL Encoder:           ${urlEncoder:Hello World!}\nXML XPath:             ${xml:src/test/resources/org/apache/commons/text/document.xml:/root/path/to/node}\n");
        Assertions.assertNotNull((Object)text);
        Assertions.assertFalse((boolean)text.contains("${base64Decoder:SGVsbG9Xb3JsZCE=}"));
        Assertions.assertFalse((boolean)text.contains("${base64Encoder:HelloWorld!}"));
        Assertions.assertFalse((boolean)text.contains("${urlDecoder:Hello%20World%21}"));
        Assertions.assertFalse((boolean)text.contains("${urlEncoder:Hello World!}"));
        Assertions.assertFalse((boolean)text.contains("${resourceBundle:org.apache.commons.text.example.testResourceBundleLookup:mykey}"));
    }

    @Test
    void testDefaultValueForMissingKeyInResourceBundle() {
        StringLookup interpolatorStringLookup = StringLookupFactory.INSTANCE.interpolatorStringLookup(StringLookupFactory.INSTANCE.resourceBundleStringLookup("org.apache.commons.text.example.testResourceBundleLookup"));
        Assertions.assertEquals((Object)"${missingKey:-defaultValue}", (Object)interpolatorStringLookup.apply("keyWithMissingKey"));
        Assertions.assertEquals((Object)"${missingKey:-defaultValue}", (Object)interpolatorStringLookup.lookup("keyWithMissingKey"));
        StringSubstitutor stringSubstitutor = new StringSubstitutor(interpolatorStringLookup);
        Assertions.assertEquals((Object)"defaultValue", (Object)stringSubstitutor.replace("${keyWithMissingKey}"));
    }

    @Test
    void testDnsLookup() throws UnknownHostException {
        StringSubstitutor strSubst = new StringSubstitutor(StringSubstitutorWithInterpolatorStringLookupTest.createInterpolatorWithLookups(DefaultStringLookup.DNS));
        String hostName = InetAddress.getLocalHost().getHostName();
        Assertions.assertEquals((Object)InetAddress.getByName(hostName).getHostAddress(), (Object)strSubst.replace("${dns:" + hostName + "}"));
    }

    @Test
    void testDnsLookup_disabledByDefault() throws UnknownHostException {
        StringSubstitutor strSubst = StringSubstitutor.createInterpolator();
        String hostName = InetAddress.getLocalHost().getHostName();
        String input = "${dns:" + hostName + "}";
        Assertions.assertEquals((Object)input, (Object)strSubst.replace(input));
    }

    @Test
    void testDnsLookupAddress() throws UnknownHostException {
        StringSubstitutor strSubst = new StringSubstitutor(StringSubstitutorWithInterpolatorStringLookupTest.createInterpolatorWithLookups(DefaultStringLookup.DNS));
        Assertions.assertEquals((Object)InetAddress.getByName("apache.org").getHostAddress(), (Object)strSubst.replace("${dns:address|apache.org}"));
    }

    @Test
    void testDnsLookupCanonicalName() throws UnknownHostException {
        StringSubstitutor strSubst = new StringSubstitutor(StringSubstitutorWithInterpolatorStringLookupTest.createInterpolatorWithLookups(DefaultStringLookup.DNS));
        String address = InetAddress.getLocalHost().getHostAddress();
        InetAddress inetAddress = InetAddress.getByName(address);
        Assertions.assertEquals((Object)inetAddress.getCanonicalHostName(), (Object)strSubst.replace("${dns:canonical-name|" + address + "}"));
    }

    @Test
    void testDnsLookupName() throws UnknownHostException {
        StringSubstitutor strSubst = new StringSubstitutor(StringSubstitutorWithInterpolatorStringLookupTest.createInterpolatorWithLookups(DefaultStringLookup.DNS));
        String address = InetAddress.getLocalHost().getHostAddress();
        InetAddress inetAddress = InetAddress.getByName(address);
        Assertions.assertEquals((Object)inetAddress.getHostName(), (Object)strSubst.replace("${dns:name|" + address + "}"));
    }

    @Test
    void testDnsLookupNameUntrimmed() throws UnknownHostException {
        StringSubstitutor strSubst = new StringSubstitutor(StringSubstitutorWithInterpolatorStringLookupTest.createInterpolatorWithLookups(DefaultStringLookup.DNS));
        String address = InetAddress.getLocalHost().getHostAddress();
        InetAddress inetAddress = InetAddress.getByName(address);
        Assertions.assertEquals((Object)inetAddress.getHostName(), (Object)strSubst.replace("${dns:name| " + address + " }"));
    }

    @Test
    void testDnsLookupUnknown() {
        StringSubstitutor strSubst = new StringSubstitutor(StringSubstitutorWithInterpolatorStringLookupTest.createInterpolatorWithLookups(DefaultStringLookup.DNS));
        String unknown = "${dns: u n k n o w n}";
        Assertions.assertEquals((Object)"${dns: u n k n o w n}", (Object)strSubst.replace("${dns: u n k n o w n}"));
    }

    @Test
    void testJavaScript() {
        StringSubstitutor strSubst = new StringSubstitutor(StringSubstitutorWithInterpolatorStringLookupTest.createInterpolatorWithLookups(DefaultStringLookup.SCRIPT));
        Assertions.assertEquals((Object)"Hello World!", (Object)strSubst.replace("${script:javascript:\"Hello World!\"}"));
        Assertions.assertEquals((Object)"7", (Object)strSubst.replace("${script:javascript:3 + 4}"));
    }

    @Test
    void testJavaScript_disabledByDefault() {
        StringSubstitutor strSubst = StringSubstitutor.createInterpolator();
        Assertions.assertEquals((Object)"${script:javascript:3 + 4}", (Object)strSubst.replace("${script:javascript:3 + 4}"));
    }

    @Test
    void testLocalHostLookup_Address() throws UnknownHostException {
        StringSubstitutor strSubst = StringSubstitutor.createInterpolator();
        Assertions.assertEquals((Object)InetAddress.getLocalHost().getHostAddress(), (Object)strSubst.replace("${localhost:address}"));
    }

    @Test
    void testLocalHostLookup_CanonicalName() throws UnknownHostException {
        StringSubstitutor strSubst = StringSubstitutor.createInterpolator();
        Assertions.assertEquals((Object)InetAddress.getLocalHost().getCanonicalHostName(), (Object)strSubst.replace("${localhost:canonical-name}"));
    }

    @Test
    void testLocalHostLookup_Name() throws UnknownHostException {
        StringSubstitutor strSubst = StringSubstitutor.createInterpolator();
        Assertions.assertEquals((Object)InetAddress.getLocalHost().getHostName(), (Object)strSubst.replace("${localhost:name}"));
    }

    @Test
    void testMapAndSystemProperty() {
        String key = "key";
        String value = "value";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        StringSubstitutor strSubst = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup(map));
        String spKey = "user.name";
        Assertions.assertEquals((Object)System.getProperty("user.name"), (Object)strSubst.replace("${sys:user.name}"));
        Assertions.assertEquals((Object)"value", (Object)strSubst.replace("${key}"));
    }

    @Test
    void testSystemProperty() {
        StringSubstitutor strSubst = StringSubstitutor.createInterpolator();
        String spKey = "user.name";
        Assertions.assertEquals((Object)System.getProperty("user.name"), (Object)strSubst.replace("${sys:user.name}"));
    }

    @Test
    void testSystemPropertyDefaultStringLookup() {
        StringSubstitutor strSubst = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup(StringLookupFactory.INSTANCE.systemPropertyStringLookup()));
        String spKey = "user.name";
        Assertions.assertEquals((Object)System.getProperty("user.name"), (Object)strSubst.replace("${user.name}"));
        Assertions.assertEquals((Object)System.getProperty("user.name"), (Object)strSubst.replace("${sys:user.name}"));
    }
}

