/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.env.jexl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.scxml.Context;
import org.apache.commons.scxml.Evaluator;
import org.apache.commons.scxml.SCXMLExpressionException;
import org.apache.commons.scxml.env.jexl.JexlContext;
import org.w3c.dom.Node;

public class JexlEvaluator
implements Evaluator,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ERR_CTX_TYPE = "Error evaluating JEXL expression, Context must be a org.apache.commons.jexl.JexlContext";
    private static Pattern inFct = Pattern.compile("In\\(");
    private static Pattern dataFct = Pattern.compile("Data\\(");

    public Object eval(Context ctx, String expr) throws SCXMLExpressionException {
        if (expr == null) {
            return null;
        }
        JexlContext jexlCtx = null;
        if (!(ctx instanceof JexlContext)) {
            throw new SCXMLExpressionException(ERR_CTX_TYPE);
        }
        jexlCtx = (JexlContext)ctx;
        Expression exp = null;
        try {
            String evalExpr = inFct.matcher(expr).replaceAll("_builtin.isMember(_ALL_STATES, ");
            evalExpr = dataFct.matcher(evalExpr).replaceAll("_builtin.data(_ALL_NAMESPACES, ");
            exp = ExpressionFactory.createExpression((String)evalExpr);
            return exp.evaluate((org.apache.commons.jexl.JexlContext)this.getEffectiveContext(jexlCtx));
        }
        catch (Exception e) {
            throw new SCXMLExpressionException("eval('" + expr + "'):" + e.getMessage(), e);
        }
    }

    public Boolean evalCond(Context ctx, String expr) throws SCXMLExpressionException {
        if (expr == null) {
            return null;
        }
        JexlContext jexlCtx = null;
        if (!(ctx instanceof JexlContext)) {
            throw new SCXMLExpressionException(ERR_CTX_TYPE);
        }
        jexlCtx = (JexlContext)ctx;
        Expression exp = null;
        try {
            String evalExpr = inFct.matcher(expr).replaceAll("_builtin.isMember(_ALL_STATES, ");
            evalExpr = dataFct.matcher(evalExpr).replaceAll("_builtin.data(_ALL_NAMESPACES, ");
            exp = ExpressionFactory.createExpression((String)evalExpr);
            return (Boolean)exp.evaluate((org.apache.commons.jexl.JexlContext)this.getEffectiveContext(jexlCtx));
        }
        catch (Exception e) {
            throw new SCXMLExpressionException("eval('" + expr + "'):" + e.getMessage(), e);
        }
    }

    public Node evalLocation(Context ctx, String expr) throws SCXMLExpressionException {
        if (expr == null) {
            return null;
        }
        JexlContext jexlCtx = null;
        if (!(ctx instanceof JexlContext)) {
            throw new SCXMLExpressionException(ERR_CTX_TYPE);
        }
        jexlCtx = (JexlContext)ctx;
        Expression exp = null;
        try {
            String evalExpr = inFct.matcher(expr).replaceAll("_builtin.isMember(_ALL_STATES, ");
            evalExpr = dataFct.matcher(evalExpr).replaceFirst("_builtin.dataNode(_ALL_NAMESPACES, ");
            evalExpr = dataFct.matcher(evalExpr).replaceAll("_builtin.data(_ALL_NAMESPACES, ");
            exp = ExpressionFactory.createExpression((String)evalExpr);
            return (Node)exp.evaluate((org.apache.commons.jexl.JexlContext)this.getEffectiveContext(jexlCtx));
        }
        catch (Exception e) {
            throw new SCXMLExpressionException("eval('" + expr + "'):" + e.getMessage(), e);
        }
    }

    public Context newContext(Context parent) {
        return new JexlContext(parent);
    }

    private JexlContext getEffectiveContext(JexlContext nodeCtx) {
        ArrayList<JexlContext> contexts = new ArrayList<JexlContext>();
        for (JexlContext currentCtx = nodeCtx; currentCtx != null; currentCtx = (JexlContext)currentCtx.getParent()) {
            contexts.add(currentCtx);
        }
        HashMap vars = new HashMap();
        for (int i = contexts.size() - 1; i > -1; --i) {
            vars.putAll(((JexlContext)contexts.get(i)).getVars());
        }
        return new JexlContext(vars);
    }
}

