/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.env;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.scxml.Context;
import org.apache.commons.scxml.Evaluator;
import org.apache.commons.scxml.SCXMLExecutor;
import org.apache.commons.scxml.SCXMLListener;
import org.apache.commons.scxml.TriggerEvent;
import org.apache.commons.scxml.env.SimpleDispatcher;
import org.apache.commons.scxml.env.SimpleErrorHandler;
import org.apache.commons.scxml.env.SimpleErrorReporter;
import org.apache.commons.scxml.env.jexl.JexlContext;
import org.apache.commons.scxml.env.jexl.JexlEvaluator;
import org.apache.commons.scxml.io.SCXMLParser;
import org.apache.commons.scxml.model.ModelException;
import org.apache.commons.scxml.model.SCXML;
import org.apache.commons.scxml.model.Transition;
import org.apache.commons.scxml.model.TransitionTarget;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public abstract class AbstractStateMachine {
    private SCXML stateMachine;
    private SCXMLExecutor engine;
    private Log log;
    private static final Class[] SIGNATURE = new Class[0];
    private static final Object[] PARAMETERS = new Object[0];

    public AbstractStateMachine(URL scxmlDocument) {
        this(scxmlDocument, (Context)new JexlContext(), (Evaluator)new JexlEvaluator());
    }

    public AbstractStateMachine(URL scxmlDocument, Context rootCtx, Evaluator evaluator) {
        this.log = LogFactory.getLog(this.getClass());
        SimpleErrorHandler errHandler = new SimpleErrorHandler();
        try {
            this.stateMachine = SCXMLParser.parse(scxmlDocument, (ErrorHandler)errHandler);
        }
        catch (IOException ioe) {
            this.logError(ioe);
        }
        catch (SAXException sae) {
            this.logError(sae);
        }
        catch (ModelException me) {
            this.logError(me);
        }
        this.initialize(this.stateMachine, rootCtx, evaluator);
    }

    public AbstractStateMachine(SCXML stateMachine) {
        this(stateMachine, (Context)new JexlContext(), (Evaluator)new JexlEvaluator());
    }

    public AbstractStateMachine(SCXML stateMachine, Context rootCtx, Evaluator evaluator) {
        this.initialize(stateMachine, rootCtx, evaluator);
    }

    private void initialize(SCXML stateMachine, Context rootCtx, Evaluator evaluator) {
        this.engine = new SCXMLExecutor(evaluator, new SimpleDispatcher(), new SimpleErrorReporter());
        this.engine.setStateMachine(stateMachine);
        this.engine.setSuperStep(true);
        this.engine.setRootContext(rootCtx);
        this.engine.addListener(stateMachine, (SCXMLListener)new EntryListener());
        try {
            this.engine.go();
        }
        catch (ModelException me) {
            this.logError(me);
        }
    }

    public boolean fireEvent(String event) {
        TriggerEvent[] evts = new TriggerEvent[]{new TriggerEvent(event, 3, null)};
        try {
            this.engine.triggerEvents(evts);
        }
        catch (ModelException me) {
            this.logError(me);
        }
        return this.engine.getCurrentStatus().isFinal();
    }

    public static SCXML getStateMachine() {
        return null;
    }

    public SCXMLExecutor getEngine() {
        return this.engine;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public boolean invoke(String methodName) {
        Class<?> clas = this.getClass();
        try {
            Method method = clas.getDeclaredMethod(methodName, SIGNATURE);
            method.invoke((Object)this, PARAMETERS);
        }
        catch (SecurityException se) {
            this.logError(se);
            return false;
        }
        catch (NoSuchMethodException nsme) {
            this.logError(nsme);
            return false;
        }
        catch (IllegalArgumentException iae) {
            this.logError(iae);
            return false;
        }
        catch (IllegalAccessException iae) {
            this.logError(iae);
            return false;
        }
        catch (InvocationTargetException ite) {
            this.logError(ite);
            return false;
        }
        return true;
    }

    public boolean resetMachine() {
        try {
            this.engine.reset();
        }
        catch (ModelException me) {
            this.logError(me);
            return false;
        }
        return true;
    }

    protected void logError(Exception exception) {
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    protected class EntryListener
    implements SCXMLListener {
        protected EntryListener() {
        }

        public void onEntry(TransitionTarget entered) {
            AbstractStateMachine.this.invoke(entered.getId());
        }

        public void onTransition(TransitionTarget from, TransitionTarget to, Transition transition) {
        }

        public void onExit(TransitionTarget exited) {
        }
    }
}

