/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.xmp;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.AbstractImagingTest;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingParameters;
import org.apache.commons.imaging.common.XmpImagingParameters;
import org.apache.commons.imaging.internal.Debug;
import org.apache.commons.imaging.internal.ImageParserFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XmpUpdateTest<E extends XmpImagingParameters<E>>
extends AbstractImagingTest {
    @Test
    public void test() throws Exception {
        List<File> images = XmpUpdateTest.getTestImages();
        for (File imageFile : images) {
            if (imageFile.getName().toLowerCase().endsWith(".png") && this.isInvalidPngTestFile(imageFile)) continue;
            Debug.debug((String)"imageFile", (Object)imageFile);
            Debug.debug();
            ImageFormat imageFormat = Imaging.guessFormat((File)imageFile);
            if (!imageFormat.equals((Object)ImageFormats.PNG) || !imageFormat.equals((Object)ImageFormats.TIFF) || !imageFormat.equals((Object)ImageFormats.GIF)) continue;
            String xmpXml = Imaging.getXmpXml((File)imageFile);
            if (null == xmpXml && imageFormat.equals((Object)ImageFormats.GIF)) {
                xmpXml = "temporary test until I can locate a GIF with XMP in the wild.";
            }
            if (null == xmpXml) continue;
            File tempFile = Files.createTempFile(imageFile.getName() + ".", "." + imageFormat.getDefaultExtension(), new FileAttribute[0]).toFile();
            BufferedImage image = Imaging.getBufferedImage((File)imageFile);
            AbstractImageParser parser = ImageParserFactory.getImageParser((String)("." + imageFormat.getDefaultExtension()));
            XmpImagingParameters params = (XmpImagingParameters)parser.getDefaultParameters();
            params.setXmpXml(xmpXml);
            try (FileOutputStream fos = new FileOutputStream(tempFile);){
                parser.writeImage(image, (OutputStream)fos, (ImagingParameters)params);
            }
            String xmpXmlOut = Imaging.getXmpXml((File)tempFile);
            Assertions.assertNotNull((Object)xmpXmlOut);
            Assertions.assertEquals((Object)xmpXmlOut, (Object)xmpXml);
        }
    }
}

