/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingPreparedStatement;
import org.apache.commons.dbcp2.TesterConnection;
import org.apache.commons.dbcp2.TesterPreparedStatement;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDelegatingPreparedStatement {
    private TesterConnection testerConn;
    private DelegatingConnection connection;
    private PreparedStatement obj;
    private DelegatingPreparedStatement delegate;

    @BeforeEach
    public void setUp() throws Exception {
        this.testerConn = new TesterConnection("test", "test");
        this.connection = new DelegatingConnection((Connection)this.testerConn);
        this.obj = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        this.delegate = new DelegatingPreparedStatement(this.connection, this.obj);
    }

    @Test
    void testAddBatch() throws Exception {
        try {
            this.delegate.addBatch();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).addBatch();
    }

    @Test
    void testClearParameters() throws Exception {
        try {
            this.delegate.clearParameters();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).clearParameters();
    }

    @Test
    void testExecute() throws Exception {
        try {
            this.delegate.execute();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).execute();
    }

    @Test
    void testExecuteLargeUpdate() throws Exception {
        try {
            this.delegate.executeLargeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).executeLargeUpdate();
    }

    @Test
    void testExecuteQuery() throws Exception {
        try {
            this.delegate.executeQuery();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).executeQuery();
    }

    @Test
    void testExecuteQueryReturnsNotNull() throws Exception {
        this.obj = new TesterPreparedStatement(this.testerConn, "select * from foo");
        this.delegate = new DelegatingPreparedStatement(this.connection, this.obj);
        Assertions.assertNotNull((Object)this.delegate.executeQuery());
    }

    @Test
    void testExecuteQueryReturnsNull() throws Exception {
        this.obj = new TesterPreparedStatement(this.testerConn, "null");
        this.delegate = new DelegatingPreparedStatement(this.connection, this.obj);
        Assertions.assertNull((Object)this.delegate.executeQuery());
    }

    @Test
    void testExecuteUpdate() throws Exception {
        try {
            this.delegate.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).executeUpdate();
    }

    @Test
    void testGetDelegate() throws Exception {
        this.obj = new TesterPreparedStatement(this.testerConn, "select * from foo");
        this.delegate = new DelegatingPreparedStatement(this.connection, this.obj);
        Assertions.assertEquals((Object)this.obj, (Object)this.delegate.getDelegate());
    }

    @Test
    void testGetMetaData() throws Exception {
        try {
            this.delegate.getMetaData();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMetaData();
    }

    @Test
    void testGetParameterMetaData() throws Exception {
        try {
            this.delegate.getParameterMetaData();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getParameterMetaData();
    }

    @Test
    void testSetArrayIntegerArray() throws Exception {
        try {
            this.delegate.setArray(1, (Array)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setArray(1, null);
    }

    @Test
    void testSetAsciiStreamIntegerInputStream() throws Exception {
        try {
            this.delegate.setAsciiStream(1, (InputStream)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setAsciiStream(1, null);
    }

    @Test
    void testSetAsciiStreamIntegerInputStreamInteger() throws Exception {
        try {
            this.delegate.setAsciiStream(1, (InputStream)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setAsciiStream(1, (InputStream)null, 1);
    }

    @Test
    void testSetAsciiStreamIntegerInputStreamLong() throws Exception {
        try {
            this.delegate.setAsciiStream(1, (InputStream)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setAsciiStream(1, (InputStream)null, 1L);
    }

    @Test
    void testSetBigDecimalIntegerBigDecimal() throws Exception {
        try {
            this.delegate.setBigDecimal(1, BigDecimal.valueOf(1.0));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBigDecimal(1, BigDecimal.valueOf(1.0));
    }

    @Test
    void testSetBinaryStreamIntegerInputStream() throws Exception {
        try {
            this.delegate.setBinaryStream(1, (InputStream)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBinaryStream(1, null);
    }

    @Test
    void testSetBinaryStreamIntegerInputStreamInteger() throws Exception {
        try {
            this.delegate.setBinaryStream(1, (InputStream)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBinaryStream(1, (InputStream)null, 1);
    }

    @Test
    void testSetBinaryStreamIntegerInputStreamLong() throws Exception {
        try {
            this.delegate.setBinaryStream(1, (InputStream)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBinaryStream(1, (InputStream)null, 1L);
    }

    @Test
    void testSetBlobIntegerBlob() throws Exception {
        try {
            this.delegate.setBlob(1, (Blob)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBlob(1, (Blob)null);
    }

    @Test
    void testSetBlobIntegerInputStream() throws Exception {
        try {
            this.delegate.setBlob(1, (InputStream)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBlob(1, (InputStream)null);
    }

    @Test
    void testSetBlobIntegerInputStreamLong() throws Exception {
        try {
            this.delegate.setBlob(1, (InputStream)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBlob(1, null, 1L);
    }

    @Test
    void testSetBooleanIntegerBoolean() throws Exception {
        try {
            this.delegate.setBoolean(1, Boolean.TRUE.booleanValue());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBoolean(1, Boolean.TRUE);
    }

    @Test
    void testSetByteIntegerByte() throws Exception {
        try {
            this.delegate.setByte(1, (byte)1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setByte(1, (byte)1);
    }

    @Test
    void testSetBytesIntegerByteArray() throws Exception {
        try {
            this.delegate.setBytes(1, new byte[]{1});
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBytes(1, new byte[]{1});
    }

    @Test
    void testSetCharacterStreamIntegerReader() throws Exception {
        try {
            this.delegate.setCharacterStream(1, (Reader)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setCharacterStream(1, null);
    }

    @Test
    void testSetCharacterStreamIntegerReaderInteger() throws Exception {
        try {
            this.delegate.setCharacterStream(1, (Reader)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setCharacterStream(1, (Reader)null, 1);
    }

    @Test
    void testSetCharacterStreamIntegerReaderLong() throws Exception {
        try {
            this.delegate.setCharacterStream(1, (Reader)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setCharacterStream(1, (Reader)null, 1L);
    }

    @Test
    void testSetClobIntegerClob() throws Exception {
        try {
            this.delegate.setClob(1, (Clob)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setClob(1, (Clob)null);
    }

    @Test
    void testSetClobIntegerReader() throws Exception {
        try {
            this.delegate.setClob(1, (Reader)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setClob(1, (Reader)null);
    }

    @Test
    void testSetClobIntegerReaderLong() throws Exception {
        try {
            this.delegate.setClob(1, (Reader)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setClob(1, null, 1L);
    }

    @Test
    void testSetDateIntegerSqlDate() throws Exception {
        try {
            this.delegate.setDate(1, new Date(1529827548745L));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setDate(1, new Date(1529827548745L));
    }

    @Test
    void testSetDateIntegerSqlDateCalendar() throws Exception {
        try {
            this.delegate.setDate(1, new Date(1529827548745L), (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setDate(1, new Date(1529827548745L), null);
    }

    @Test
    void testSetDoubleIntegerDouble() throws Exception {
        try {
            this.delegate.setDouble(1, 1.0);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setDouble(1, 1.0);
    }

    @Test
    void testSetFloatIntegerFloat() throws Exception {
        try {
            this.delegate.setFloat(1, 1.0f);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setFloat(1, 1.0f);
    }

    @Test
    void testSetIntIntegerInteger() throws Exception {
        try {
            this.delegate.setInt(1, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setInt(1, 1);
    }

    @Test
    void testSetLongIntegerLong() throws Exception {
        try {
            this.delegate.setLong(1, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setLong(1, 1L);
    }

    @Test
    void testSetNCharacterStreamIntegerReader() throws Exception {
        try {
            this.delegate.setNCharacterStream(1, (Reader)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNCharacterStream(1, null);
    }

    @Test
    void testSetNCharacterStreamIntegerReaderLong() throws Exception {
        try {
            this.delegate.setNCharacterStream(1, (Reader)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNCharacterStream(1, null, 1L);
    }

    @Test
    void testSetNClobIntegerNClob() throws Exception {
        try {
            this.delegate.setNClob(1, (NClob)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNClob(1, (NClob)null);
    }

    @Test
    void testSetNClobIntegerReader() throws Exception {
        try {
            this.delegate.setNClob(1, (Reader)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNClob(1, (Reader)null);
    }

    @Test
    void testSetNClobIntegerReaderLong() throws Exception {
        try {
            this.delegate.setNClob(1, (Reader)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNClob(1, null, 1L);
    }

    @Test
    void testSetNStringIntegerString() throws Exception {
        try {
            this.delegate.setNString(1, "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNString(1, "foo");
    }

    @Test
    void testSetNullIntegerInteger() throws Exception {
        try {
            this.delegate.setNull(1, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNull(1, 1);
    }

    @Test
    void testSetNullIntegerIntegerString() throws Exception {
        try {
            this.delegate.setNull(1, 1, "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNull(1, 1, "foo");
    }

    @Test
    void testSetObjectIntegerObject() throws Exception {
        try {
            this.delegate.setObject(1, (Object)System.err);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setObject(1, System.err);
    }

    @Test
    void testSetObjectIntegerObjectInteger() throws Exception {
        try {
            this.delegate.setObject(1, (Object)System.err, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setObject(1, (Object)System.err, 1);
    }

    @Test
    void testSetObjectIntegerObjectIntegerInteger() throws Exception {
        try {
            this.delegate.setObject(1, (Object)System.err, 1, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setObject(1, (Object)System.err, 1, 1);
    }

    @Test
    void testSetObjectIntegerObjectSQLType() throws Exception {
        try {
            this.delegate.setObject(1, (Object)System.err, (SQLType)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setObject(1, (Object)System.err, null);
    }

    @Test
    void testSetObjectIntegerObjectSQLTypeInteger() throws Exception {
        try {
            this.delegate.setObject(1, (Object)System.err, (SQLType)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setObject(1, (Object)System.err, null, 1);
    }

    @Test
    void testSetRefIntegerRef() throws Exception {
        try {
            this.delegate.setRef(1, (Ref)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setRef(1, null);
    }

    @Test
    void testSetRowIdIntegerRowId() throws Exception {
        try {
            this.delegate.setRowId(1, (RowId)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setRowId(1, null);
    }

    @Test
    void testSetShortIntegerShort() throws Exception {
        try {
            this.delegate.setShort(1, (short)1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setShort(1, (short)1);
    }

    @Test
    void testSetSQLXMLIntegerSQLXML() throws Exception {
        try {
            this.delegate.setSQLXML(1, (SQLXML)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setSQLXML(1, null);
    }

    @Test
    void testSetStringIntegerString() throws Exception {
        try {
            this.delegate.setString(1, "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setString(1, "foo");
    }

    @Test
    void testSetTimeIntegerTime() throws Exception {
        try {
            this.delegate.setTime(1, (Time)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setTime(1, null);
    }

    @Test
    void testSetTimeIntegerTimeCalendar() throws Exception {
        try {
            this.delegate.setTime(1, (Time)null, (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setTime(1, null, null);
    }

    @Test
    void testSetTimestampIntegerTimestamp() throws Exception {
        try {
            this.delegate.setTimestamp(1, (Timestamp)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setTimestamp(1, null);
    }

    @Test
    void testSetTimestampIntegerTimestampCalendar() throws Exception {
        try {
            this.delegate.setTimestamp(1, (Timestamp)null, (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setTimestamp(1, null, null);
    }

    @Test
    void testSetUnicodeStreamIntegerInputStreamInteger() throws Exception {
        try {
            this.delegate.setUnicodeStream(1, (InputStream)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setUnicodeStream(1, null, 1);
    }

    @Test
    void testSetURLIntegerUrl() throws Exception {
        try {
            this.delegate.setURL(1, (URL)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setURL(1, null);
    }
}

