/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.JdbcPkGenerator;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbKeyGenerator;

public class OraclePkGenerator
extends JdbcPkGenerator {
    private static final String _SEQUENCE_PREFIX = "pk_";

    protected OraclePkGenerator() {
    }

    protected OraclePkGenerator(JdbcAdapter adapter) {
        super(adapter);
    }

    public void createAutoPk(DataNode node, List dbEntities) throws Exception {
        List sequences = this.getExistingSequences(node);
        for (DbEntity ent : dbEntities) {
            if (sequences.contains(this.sequenceName(ent))) continue;
            this.runUpdate(node, this.createSequenceString(ent));
        }
    }

    public List createAutoPkStatements(List dbEntities) {
        ArrayList<String> list = new ArrayList<String>();
        for (DbEntity ent : dbEntities) {
            list.add(this.createSequenceString(ent));
        }
        return list;
    }

    public void dropAutoPk(DataNode node, List dbEntities) throws Exception {
        List sequences = this.getExistingSequences(node);
        for (DbEntity ent : dbEntities) {
            String name;
            if (ent.getDataMap().isQuotingSQLIdentifiers()) {
                DbEntity tempEnt = new DbEntity();
                DataMap dm = new DataMap();
                dm.setQuotingSQLIdentifiers(false);
                tempEnt.setDataMap(dm);
                tempEnt.setName(ent.getName());
                name = this.stripSchemaName(this.sequenceName(tempEnt));
            } else {
                name = this.stripSchemaName(this.sequenceName(ent));
            }
            if (!sequences.contains(name)) continue;
            this.runUpdate(node, this.dropSequenceString(ent));
        }
    }

    public List dropAutoPkStatements(List dbEntities) {
        ArrayList<String> list = new ArrayList<String>();
        for (DbEntity ent : dbEntities) {
            list.add(this.dropSequenceString(ent));
        }
        return list;
    }

    protected String createSequenceString(DbEntity ent) {
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE SEQUENCE ").append(this.sequenceName(ent)).append(" START WITH 200").append(" INCREMENT BY ").append(this.pkCacheSize(ent));
        return buf.toString();
    }

    protected String dropSequenceString(DbEntity ent) {
        StringBuilder buf = new StringBuilder();
        buf.append("DROP SEQUENCE ").append(this.sequenceName(ent));
        return buf.toString();
    }

    /*
     * Exception decompiling
     */
    protected long longPkFromDatabase(DataNode node, DbEntity entity) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected int pkFromDatabase(DataNode node, DbEntity ent) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected int pkCacheSize(DbEntity entity) {
        DbKeyGenerator keyGenerator = entity.getPrimaryKeyGenerator();
        if (keyGenerator != null && "ORACLE".equals(keyGenerator.getGeneratorType()) && keyGenerator.getGeneratorName() != null) {
            Integer size = keyGenerator.getKeyCacheSize();
            return size != null && size >= 1 ? size.intValue() : super.getPkCacheSize();
        }
        return super.getPkCacheSize();
    }

    protected String sequenceName(DbEntity entity) {
        boolean status = entity.getDataMap() != null && entity.getDataMap().isQuotingSQLIdentifiers();
        QuotingStrategy context = this.getAdapter().getQuotingStrategy(status);
        DbKeyGenerator keyGenerator = entity.getPrimaryKeyGenerator();
        if (keyGenerator != null && "ORACLE".equals(keyGenerator.getGeneratorType()) && keyGenerator.getGeneratorName() != null) {
            return keyGenerator.getGeneratorName().toLowerCase();
        }
        String entName = entity.getName();
        String seqName = _SEQUENCE_PREFIX + entName.toLowerCase();
        seqName = entity.getSchema() != null && entity.getSchema().length() > 0 ? context.quoteString(entity.getSchema()) + "." + context.quoteString(seqName) : context.quoteString(seqName);
        return seqName;
    }

    protected String stripSchemaName(String sequenceName) {
        int ind = sequenceName.indexOf(46);
        return ind >= 0 ? sequenceName.substring(ind + 1) : sequenceName;
    }

    /*
     * Exception decompiling
     */
    protected List getExistingSequences(DataNode node) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

