/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.util.DeleteRuleUpdater;
import org.apache.cayenne.util.Util;
import org.scopemvc.core.Selector;
import org.scopemvc.model.basic.BasicModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjRelationshipInfoModel
extends BasicModel {
    static final String COLLECTION_TYPE_MAP = "java.util.Map";
    static final String COLLECTION_TYPE_SET = "java.util.Set";
    static final String COLLECTION_TYPE_COLLECTION = "java.util.Collection";
    static final String DEFAULT_MAP_KEY = "ID (default)";
    public static final Selector DB_RELATIONSHIPS_SELECTOR = Selector.fromString((String)"dbRelationships");
    public static final Selector SOURCE_ENTITY_NAME_SELECTOR = Selector.fromString((String)"relationship.sourceEntity.name");
    public static final Selector OBJECT_TARGET_SELECTOR = Selector.fromString((String)"objectTarget");
    public static final Selector OBJECT_TARGETS_SELECTOR = Selector.fromString((String)"objectTargets");
    public static final Selector RELATIONSHIP_NAME_SELECTOR = Selector.fromString((String)"relationshipName");
    public static final Selector TARGET_COLLECTIONS_SELECTOR = Selector.fromString((String)"targetCollections");
    public static final Selector TARGET_COLLECTION_SELECTOR = Selector.fromString((String)"targetCollection");
    public static final Selector MAP_KEYS_SELECTOR = Selector.fromString((String)"mapKeys");
    public static final Selector MAP_KEY_SELECTOR = Selector.fromString((String)"mapKey");
    public static final Selector CURRENT_PATH_SELECTOR = Selector.fromString((String)"currentPath");
    protected ObjRelationship relationship;
    protected List<DbRelationship> dbRelationships;
    protected List<DbRelationship> savedDbRelationships;
    protected ObjEntity objectTarget;
    protected List<ObjEntity> objectTargets;
    protected List<String> targetCollections;
    protected List<String> mapKeys;
    protected String relationshipName;
    protected String targetCollection;
    protected String mapKey;
    protected String currentPath;

    public ObjRelationshipInfoModel(ObjRelationship relationship) {
        this.relationship = relationship;
        this.relationshipName = relationship.getName();
        this.mapKey = relationship.getMapKey();
        this.targetCollection = relationship.getCollectionType();
        if (this.targetCollection == null) {
            this.targetCollection = "java.util.List";
        }
        this.objectTarget = (ObjEntity)relationship.getTargetEntity();
        if (this.objectTarget != null) {
            this.updateTargetCombo(this.objectTarget.getDbEntity());
        }
        this.validateCanMap();
        this.targetCollections = new ArrayList<String>(4);
        this.targetCollections.add(COLLECTION_TYPE_COLLECTION);
        this.targetCollections.add("java.util.List");
        this.targetCollections.add(COLLECTION_TYPE_MAP);
        this.targetCollections.add(COLLECTION_TYPE_SET);
        this.mapKeys = new ArrayList<String>();
        this.initMapKeys();
        this.dbRelationships = new ArrayList<DbRelationship>(relationship.getDbRelationships());
        this.selectPath();
        this.fireModelChange(0, DB_RELATIONSHIPS_SELECTOR);
        this.connectEnds();
    }

    protected void updateTargetCombo(DbEntity dbTarget) {
        this.objectTargets = new ArrayList<ObjEntity>();
        if (dbTarget != null) {
            this.objectTargets.addAll(dbTarget.getDataMap().getMappedEntities(dbTarget));
            Collections.sort(this.objectTargets, Comparators.getNamedObjectComparator());
        }
        this.fireModelChange(0, OBJECT_TARGETS_SELECTOR);
    }

    public ObjRelationship getRelationship() {
        return this.relationship;
    }

    public List<DbRelationship> getDbRelationships() {
        return this.dbRelationships;
    }

    public List<DbRelationship> getSavedDbRelationships() {
        return this.savedDbRelationships;
    }

    public DbRelationship getLastRelationship() {
        return this.dbRelationships.size() == 0 ? null : this.dbRelationships.get(this.dbRelationships.size() - 1);
    }

    public void setDbRelationships(List<DbRelationship> rels) {
        this.dbRelationships = rels;
        this.updateTargetCombo(rels.size() > 0 ? (DbEntity)rels.get(rels.size() - 1).getTargetEntity() : null);
    }

    public void setSavedDbRelationships(List<DbRelationship> rels) {
        this.savedDbRelationships = rels;
        String currPath = "";
        for (DbRelationship rel : rels) {
            currPath = currPath + "->" + rel.getName();
        }
        if (rels.size() > 0) {
            currPath = currPath.substring(2);
        }
        this.currentPath = currPath;
        this.fireModelChange(0, CURRENT_PATH_SELECTOR);
    }

    public void selectPath() {
        this.setSavedDbRelationships(new ArrayList<DbRelationship>(this.dbRelationships));
    }

    public ObjEntity getObjectTarget() {
        return this.objectTarget;
    }

    public void setObjectTarget(ObjEntity objectTarget) {
        if (this.objectTarget != objectTarget) {
            this.unlistenOldSubmodel(OBJECT_TARGET_SELECTOR);
            this.objectTarget = objectTarget;
            this.listenNewSubmodel(OBJECT_TARGET_SELECTOR);
            this.fireModelChange(0, OBJECT_TARGET_SELECTOR);
            this.initMapKeys();
        }
    }

    private void initMapKeys() {
        this.mapKeys.clear();
        this.mapKeys.add(DEFAULT_MAP_KEY);
        if (this.objectTarget == null) {
            return;
        }
        for (ObjAttribute attribute : this.objectTarget.getAttributes()) {
            this.mapKeys.add(attribute.getName());
        }
        this.fireModelChange(0, MAP_KEYS_SELECTOR);
        if (this.mapKey != null && !this.mapKeys.contains(this.mapKey)) {
            this.mapKey = DEFAULT_MAP_KEY;
            this.fireModelChange(0, MAP_KEY_SELECTOR);
        }
    }

    public List<ObjEntity> getObjectTargets() {
        return this.objectTargets;
    }

    public String getRelationshipName() {
        return this.relationshipName;
    }

    public void setRelationshipName(String relationshipName) {
        this.relationshipName = relationshipName;
    }

    public synchronized void relationshipChanged(int index) {
        this.breakChain(index);
        this.connectEnds();
        this.fireModelChange(0, null);
    }

    public boolean isToMany() {
        for (DbRelationship relationship : this.dbRelationships) {
            if (relationship == null || !relationship.isToMany()) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean savePath() {
        String mapKey;
        String collectionType;
        List oldPath;
        boolean hasChanges = false;
        boolean oldToMany = this.relationship.isToMany();
        if (!Util.nullSafeEquals((Object)this.relationship.getName(), (Object)this.relationshipName)) {
            hasChanges = true;
            this.relationship.setName(this.relationshipName);
        }
        if (this.savedDbRelationships.size() > 0) {
            DbEntity lastEntity = (DbEntity)this.savedDbRelationships.get(this.savedDbRelationships.size() - 1).getTargetEntity();
            if (this.objectTarget == null || this.objectTarget.getDbEntity() != lastEntity) {
                Collection objEntities = lastEntity.getDataMap().getMappedEntities(lastEntity);
                ObjEntity objEntity = this.objectTarget = objEntities.size() == 0 ? null : (ObjEntity)objEntities.iterator().next();
            }
        }
        if (this.objectTarget == null || !Util.nullSafeEquals((Object)this.objectTarget.getName(), (Object)this.relationship.getTargetEntityName())) {
            hasChanges = true;
            this.relationship.setTargetEntity((Entity)this.objectTarget);
        }
        if ((oldPath = this.relationship.getDbRelationships()).size() != this.savedDbRelationships.size()) {
            hasChanges = true;
            this.updatePath();
        } else {
            for (int i = 0; i < oldPath.size(); ++i) {
                DbRelationship next = this.savedDbRelationships.get(i);
                if (oldPath.get(i) == next) continue;
                hasChanges = true;
                this.updatePath();
                break;
            }
        }
        String string = collectionType = "java.util.List".equals(this.targetCollection) || !this.relationship.isToMany() ? null : this.targetCollection;
        if (!Util.nullSafeEquals((Object)collectionType, (Object)this.relationship.getCollectionType())) {
            hasChanges = true;
            this.relationship.setCollectionType(collectionType);
        }
        String string2 = mapKey = COLLECTION_TYPE_MAP.equals(collectionType) && !DEFAULT_MAP_KEY.equals(this.mapKey) ? this.mapKey : null;
        if (!Util.nullSafeEquals((Object)mapKey, (Object)this.relationship.getMapKey())) {
            hasChanges = true;
            this.relationship.setMapKey(mapKey);
        }
        if (hasChanges && this.relationship.isToMany() != oldToMany) {
            DeleteRuleUpdater.updateObjRelationship((ObjRelationship)this.relationship);
        }
        return hasChanges;
    }

    private void updatePath() {
        this.relationship.clearDbRelationships();
        for (DbRelationship nextPathComponent : this.dbRelationships) {
            if (nextPathComponent == null) break;
            this.relationship.addDbRelationship(nextPathComponent);
        }
    }

    private void breakChain(int index) {
        while (this.dbRelationships.size() > index + 1) {
            this.dbRelationships.remove(this.dbRelationships.size() - 1);
        }
    }

    private void connectEnds() {
        DbEntity target;
        Relationship last = null;
        int size = this.dbRelationships.size();
        if (size > 0) {
            last = (Relationship)this.dbRelationships.get(size - 1);
        }
        if ((target = this.getEndEntity()) != null && (last == null || last.getTargetEntity() != target)) {
            DbEntity source;
            Object object = source = last == null ? this.getStartEntity() : last.getTargetEntity();
            if (source != null) {
                Relationship anyConnector;
                Relationship relationship = anyConnector = source != null ? source.getAnyRelationship((Entity)target) : null;
                if (anyConnector != null) {
                    this.dbRelationships.add((DbRelationship)anyConnector);
                }
            }
        }
    }

    private void validateCanMap() {
        if (this.relationship.getSourceEntity() == null) {
            throw new CayenneRuntimeException("Can't map relationship without source entity.");
        }
        if (this.getStartEntity() == null) {
            throw new CayenneRuntimeException("Can't map relationship without source DbEntity.");
        }
    }

    public DbEntity getStartEntity() {
        return ((ObjEntity)this.relationship.getSourceEntity()).getDbEntity();
    }

    public DbEntity getEndEntity() {
        if (this.objectTarget == null) {
            return null;
        }
        return this.objectTarget.getDbEntity();
    }

    public String getMapKey() {
        return this.mapKey;
    }

    public void setMapKey(String mapKey) {
        this.mapKey = mapKey;
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    public String getTargetCollection() {
        return this.targetCollection;
    }

    public void setTargetCollection(String targetCollection) {
        this.targetCollection = targetCollection;
    }

    public List getMapKeys() {
        return this.mapKeys;
    }

    public List<String> getTargetCollections() {
        return this.targetCollections;
    }
}

