/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.AboutAction;
import org.apache.cayenne.modeler.action.ConfigurePreferencesAction;
import org.apache.cayenne.modeler.action.CopyAction;
import org.apache.cayenne.modeler.action.CopyAttributeAction;
import org.apache.cayenne.modeler.action.CopyProcedureParameterAction;
import org.apache.cayenne.modeler.action.CopyRelationshipAction;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.CreateCallbackMethodAction;
import org.apache.cayenne.modeler.action.CreateCallbackMethodForDataMapListenerAction;
import org.apache.cayenne.modeler.action.CreateCallbackMethodForListenerAction;
import org.apache.cayenne.modeler.action.CreateDataMapAction;
import org.apache.cayenne.modeler.action.CreateDataMapEntityListenerAction;
import org.apache.cayenne.modeler.action.CreateDbEntityAction;
import org.apache.cayenne.modeler.action.CreateDomainAction;
import org.apache.cayenne.modeler.action.CreateEmbeddableAction;
import org.apache.cayenne.modeler.action.CreateNodeAction;
import org.apache.cayenne.modeler.action.CreateObjEntityAction;
import org.apache.cayenne.modeler.action.CreateObjEntityListenerAction;
import org.apache.cayenne.modeler.action.CreateProcedureAction;
import org.apache.cayenne.modeler.action.CreateProcedureParameterAction;
import org.apache.cayenne.modeler.action.CreateQueryAction;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.action.CutAction;
import org.apache.cayenne.modeler.action.CutAttributeAction;
import org.apache.cayenne.modeler.action.CutProcedureParameterAction;
import org.apache.cayenne.modeler.action.CutRelationshipAction;
import org.apache.cayenne.modeler.action.DbEntitySyncAction;
import org.apache.cayenne.modeler.action.DocumentationAction;
import org.apache.cayenne.modeler.action.ExitAction;
import org.apache.cayenne.modeler.action.FindAction;
import org.apache.cayenne.modeler.action.GenerateCodeAction;
import org.apache.cayenne.modeler.action.GenerateDBAction;
import org.apache.cayenne.modeler.action.ImportDBAction;
import org.apache.cayenne.modeler.action.ImportDataMapAction;
import org.apache.cayenne.modeler.action.ImportEOModelAction;
import org.apache.cayenne.modeler.action.InferRelationshipsAction;
import org.apache.cayenne.modeler.action.MigrateAction;
import org.apache.cayenne.modeler.action.NavigateBackwardAction;
import org.apache.cayenne.modeler.action.NavigateForwardAction;
import org.apache.cayenne.modeler.action.NewProjectAction;
import org.apache.cayenne.modeler.action.ObjEntitySyncAction;
import org.apache.cayenne.modeler.action.OpenProjectAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.ProjectAction;
import org.apache.cayenne.modeler.action.RedoAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.action.RemoveAttributeAction;
import org.apache.cayenne.modeler.action.RemoveCallbackMethodAction;
import org.apache.cayenne.modeler.action.RemoveCallbackMethodForDataMapListenerAction;
import org.apache.cayenne.modeler.action.RemoveCallbackMethodForListenerAction;
import org.apache.cayenne.modeler.action.RemoveEntityListenerAction;
import org.apache.cayenne.modeler.action.RemoveEntityListenerForDataMapAction;
import org.apache.cayenne.modeler.action.RemoveProcedureParameterAction;
import org.apache.cayenne.modeler.action.RemoveRelationshipAction;
import org.apache.cayenne.modeler.action.RevertAction;
import org.apache.cayenne.modeler.action.SaveAction;
import org.apache.cayenne.modeler.action.SaveAsAction;
import org.apache.cayenne.modeler.action.ShowLogConsoleAction;
import org.apache.cayenne.modeler.action.UndoAction;
import org.apache.cayenne.modeler.action.ValidateAction;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.project.ProjectPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionManager {
    static final Collection<String> SPECIAL_ACTIONS = Arrays.asList(SaveAction.getActionName(), UndoAction.getActionName(), RedoAction.getActionName());
    static final Collection<String> PROJECT_ACTIONS = Arrays.asList(RevertAction.getActionName(), CreateDomainAction.getActionName(), ProjectAction.getActionName(), ValidateAction.getActionName(), SaveAsAction.getActionName(), FindAction.getActionName());
    static final Collection<String> DOMAIN_ACTIONS = new HashSet<String>(PROJECT_ACTIONS);
    static final Collection<String> DATA_MAP_ACTIONS;
    static final Collection<String> OBJ_ENTITY_ACTIONS;
    static final Collection<String> DB_ENTITY_ACTIONS;
    static final Collection<String> EMBEDDABLE_ACTIONS;
    static final Collection<String> PROCEDURE_ACTIONS;
    static final Collection<String> MULTIPLE_OBJECTS_ACTIONS;
    protected Map<String, Action> actionMap = new HashMap<String, Action>(40);

    public ActionManager(Application application) {
        this.registerAction(new ProjectAction(application));
        this.registerAction(new NewProjectAction(application)).setAlwaysOn(true);
        this.registerAction(new OpenProjectAction(application)).setAlwaysOn(true);
        this.registerAction(new ImportDataMapAction(application));
        this.registerAction(new SaveAction(application));
        this.registerAction(new SaveAsAction(application));
        this.registerAction(new RevertAction(application));
        this.registerAction(new ValidateAction(application));
        this.registerAction(new RemoveAction(application));
        this.registerAction(new CreateDomainAction(application));
        this.registerAction(new CreateNodeAction(application));
        this.registerAction(new CreateDataMapAction(application));
        this.registerAction(new GenerateCodeAction(application));
        this.registerAction(new CreateObjEntityAction(application));
        this.registerAction(new CreateDbEntityAction(application));
        this.registerAction(new CreateProcedureAction(application));
        this.registerAction(new CreateProcedureParameterAction(application));
        this.registerAction(new RemoveProcedureParameterAction(application));
        this.registerAction(new CreateQueryAction(application));
        this.registerAction(new CreateAttributeAction(application));
        this.registerAction(new RemoveAttributeAction(application));
        this.registerAction(new CreateRelationshipAction(application));
        this.registerAction(new RemoveRelationshipAction(application));
        this.registerAction(new CreateCallbackMethodAction(application)).setAlwaysOn(true);
        this.registerAction(new CreateCallbackMethodForListenerAction(application));
        this.registerAction(new CreateCallbackMethodForDataMapListenerAction(application));
        this.registerAction(new RemoveCallbackMethodAction(application));
        this.registerAction(new RemoveCallbackMethodForListenerAction(application));
        this.registerAction(new RemoveCallbackMethodForDataMapListenerAction(application));
        this.registerAction(new CreateObjEntityListenerAction(application)).setAlwaysOn(true);
        this.registerAction(new CreateDataMapEntityListenerAction(application)).setAlwaysOn(true);
        this.registerAction(new RemoveEntityListenerAction(application));
        this.registerAction(new RemoveEntityListenerForDataMapAction(application));
        this.registerAction(new DbEntitySyncAction(application));
        this.registerAction(new ObjEntitySyncAction(application));
        this.registerAction(new ImportDBAction(application));
        this.registerAction(new InferRelationshipsAction(application));
        this.registerAction(new ImportEOModelAction(application));
        this.registerAction(new GenerateDBAction(application));
        this.registerAction(new MigrateAction(application));
        this.registerAction(new AboutAction(application)).setAlwaysOn(true);
        this.registerAction(new DocumentationAction(application)).setAlwaysOn(true);
        this.registerAction(new ConfigurePreferencesAction(application)).setAlwaysOn(true);
        this.registerAction(new ExitAction(application)).setAlwaysOn(true);
        this.registerAction(new NavigateBackwardAction(application)).setAlwaysOn(true);
        this.registerAction(new NavigateForwardAction(application)).setAlwaysOn(true);
        this.registerAction(new FindAction(application));
        this.registerAction(new ShowLogConsoleAction(application)).setAlwaysOn(true);
        this.registerAction(new CutAction(application));
        this.registerAction(new CutAttributeAction(application));
        this.registerAction(new CutRelationshipAction(application));
        this.registerAction(new CutProcedureParameterAction(application));
        this.registerAction(new CopyAction(application));
        this.registerAction(new CopyAttributeAction(application));
        this.registerAction(new CopyRelationshipAction(application));
        this.registerAction(new CopyProcedureParameterAction(application));
        this.registerAction(new PasteAction(application));
        UndoAction undoAction = new UndoAction(application);
        undoAction.setEnabled(false);
        this.registerAction(undoAction);
        RedoAction redoAction = new RedoAction(application);
        redoAction.setEnabled(false);
        this.registerAction(redoAction);
        this.registerAction(new CreateEmbeddableAction(application));
    }

    private CayenneAction registerAction(CayenneAction action) {
        this.actionMap.put(action.getKey(), action);
        return action;
    }

    public CayenneAction getAction(String key) {
        return (CayenneAction)this.actionMap.get(key);
    }

    public void projectOpened() {
        this.processActionsState(PROJECT_ACTIONS);
        this.updateActions("");
    }

    public void projectClosed() {
        this.processActionsState(Collections.EMPTY_SET);
        this.updateActions("");
    }

    public void domainSelected() {
        this.processActionsState(DOMAIN_ACTIONS);
        this.updateActions("DataDomain");
    }

    public void dataNodeSelected() {
        this.processActionsState(DOMAIN_ACTIONS);
        this.updateActions("DataNode");
    }

    public void dataMapSelected() {
        this.processActionsState(DATA_MAP_ACTIONS);
        this.updateActions("DataMap");
    }

    public void objEntitySelected() {
        this.processActionsState(OBJ_ENTITY_ACTIONS);
        this.updateActions("ObjEntity");
    }

    public void dbEntitySelected() {
        this.processActionsState(DB_ENTITY_ACTIONS);
        this.updateActions("DbEntity");
    }

    public void derivedDbEntitySelected() {
        this.processActionsState(DB_ENTITY_ACTIONS);
        this.updateActions("Derived DbEntity");
    }

    public void procedureSelected() {
        this.processActionsState(PROCEDURE_ACTIONS);
        this.updateActions("Procedure");
    }

    public void querySelected() {
        this.processActionsState(DATA_MAP_ACTIONS);
        this.updateActions("Query");
    }

    public void embeddableSelected() {
        this.processActionsState(EMBEDDABLE_ACTIONS);
        this.updateActions("Embeddable");
    }

    public void multipleObjectsSelected(ProjectPath[] paths) {
        this.processActionsState(MULTIPLE_OBJECTS_ACTIONS);
        this.updateActions("Selected Objects");
        CayenneAction cutAction = this.getAction(CutAction.getActionName());
        boolean canCopy = true;
        if (!cutAction.enableForPath(paths[0])) {
            canCopy = false;
        } else {
            Object parent = paths[0].getObjectParent();
            for (int i = 1; i < paths.length; ++i) {
                if (paths[i].getObjectParent() == parent && cutAction.enableForPath(paths[i])) continue;
                canCopy = false;
                break;
            }
        }
        cutAction.setEnabled(canCopy);
        this.getAction(CopyAction.getActionName()).setEnabled(canCopy);
    }

    private void updateActions(String postfix) {
        if (postfix.length() > 0) {
            postfix = " " + postfix;
        }
        this.getAction(RemoveAction.getActionName()).setName("Remove" + postfix);
        this.getAction(CutAction.getActionName()).setName("Cut" + postfix);
        this.getAction(CopyAction.getActionName()).setName("Copy" + postfix);
        ((PasteAction)this.getAction(PasteAction.getActionName())).updateState();
    }

    protected void processActionsState(Collection<String> namesOfEnabled) {
        for (Map.Entry<String, Action> entry : this.actionMap.entrySet()) {
            if (SPECIAL_ACTIONS.contains(entry.getKey())) continue;
            entry.getValue().setEnabled(namesOfEnabled.contains(entry.getKey()));
        }
    }

    public void setupCCP(JComponent comp, String cutName, String copyName) {
        ActionMap map = comp.getActionMap();
        map.put(TransferHandler.getCutAction().getValue("Name"), this.getAction(cutName));
        map.put(TransferHandler.getCopyAction().getValue("Name"), this.getAction(copyName));
        map.put(TransferHandler.getPasteAction().getValue("Name"), this.getAction(PasteAction.getActionName()));
    }

    static {
        DOMAIN_ACTIONS.addAll(Arrays.asList(ImportDataMapAction.getActionName(), CreateDataMapAction.getActionName(), RemoveAction.getActionName(), CreateNodeAction.getActionName(), ImportDBAction.getActionName(), ImportEOModelAction.getActionName(), PasteAction.getActionName()));
        DATA_MAP_ACTIONS = new HashSet<String>(DOMAIN_ACTIONS);
        DATA_MAP_ACTIONS.addAll(Arrays.asList(GenerateCodeAction.getActionName(), CreateEmbeddableAction.getActionName(), CreateObjEntityAction.getActionName(), CreateDbEntityAction.getActionName(), CreateQueryAction.getActionName(), CreateProcedureAction.getActionName(), GenerateDBAction.getActionName(), MigrateAction.getActionName(), InferRelationshipsAction.getActionName(), CutAction.getActionName(), CopyAction.getActionName()));
        OBJ_ENTITY_ACTIONS = new HashSet<String>(DATA_MAP_ACTIONS);
        OBJ_ENTITY_ACTIONS.addAll(Arrays.asList(ObjEntitySyncAction.getActionName(), CreateAttributeAction.getActionName(), CreateRelationshipAction.getActionName()));
        DB_ENTITY_ACTIONS = new HashSet<String>(DATA_MAP_ACTIONS);
        DB_ENTITY_ACTIONS.addAll(Arrays.asList(CreateAttributeAction.getActionName(), CreateRelationshipAction.getActionName(), DbEntitySyncAction.getActionName()));
        EMBEDDABLE_ACTIONS = new HashSet<String>(DATA_MAP_ACTIONS);
        EMBEDDABLE_ACTIONS.addAll(Arrays.asList(CreateAttributeAction.getActionName()));
        PROCEDURE_ACTIONS = new HashSet<String>(DATA_MAP_ACTIONS);
        PROCEDURE_ACTIONS.addAll(Arrays.asList(CreateProcedureParameterAction.getActionName()));
        MULTIPLE_OBJECTS_ACTIONS = new HashSet<String>(PROJECT_ACTIONS);
        MULTIPLE_OBJECTS_ACTIONS.addAll(Arrays.asList(RemoveAction.getActionName(), CutAction.getActionName(), CopyAction.getActionName(), PasteAction.getActionName()));
    }
}

