/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.model.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.scopemvc.core.ModelChangeEvent;
import org.scopemvc.core.ModelChangeListener;
import org.scopemvc.core.Selector;
import org.scopemvc.model.basic.BasicModel;
import org.scopemvc.model.collection.ListModelSource;

public class ListModelAdaptor
extends BasicModel
implements ModelChangeListener {
    public static final Selector LIST_SELECTOR = Selector.fromString("list");
    public static final Selector LIST_SIZE_SELECTOR = Selector.fromString("size");
    private List list;
    private ListModelSource[] listSources;
    private boolean sorted;
    private Comparator comparator;

    public ListModelAdaptor(ListModelSource[] listModelSourceArray) {
        this.listSources = listModelSourceArray;
        int n = 0;
        while (n < listModelSourceArray.length) {
            if (listModelSourceArray[n].isModelBased()) {
                listModelSourceArray[n].getListSourceModel().addModelChangeListener(this);
            }
            ++n;
        }
    }

    public ListModelAdaptor(ListModelSource listModelSource) {
        this(new ListModelSource[]{listModelSource});
    }

    public List getList() {
        if (this.list == null) {
            this.loadList();
        }
        return this.list;
    }

    public int getSize() {
        if (this.list == null) {
            this.loadList();
        }
        return this.list.size();
    }

    public Object getElementAt(int n) {
        if (this.list == null) {
            this.loadList();
        }
        if (this.list == null) {
            return null;
        }
        return this.list.get(n);
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean bl) {
        this.sorted = true;
    }

    public void setComparator(Comparator comparator) {
        if (comparator == null) {
            this.setSorted(false);
            this.comparator = null;
            this.list = null;
        } else {
            this.setSorted(true);
            this.comparator = comparator;
            this.list = null;
        }
        this.fireModelChange(0, LIST_SELECTOR);
    }

    public void removeModelChangeListeners() {
        if (this.listSources != null) {
            int n = 0;
            while (n < this.listSources.length) {
                if (this.listSources[n].isModelBased()) {
                    this.listSources[n].getListSourceModel().removeModelChangeListener(this);
                }
                ++n;
            }
        }
    }

    public void modelChanged(ModelChangeEvent modelChangeEvent) {
        if (this.list != null && this.isListChangeEvent(modelChangeEvent)) {
            this.loadList();
            this.fireModelChange(0, LIST_SELECTOR);
        }
    }

    protected void loadList() {
        if (this.listSources.length == 1 && this.listSources[0].isList() && !this.isSorted()) {
            this.list = (List)this.listSources[0].getListSource();
            return;
        }
        if (this.list == null) {
            this.list = new ArrayList();
        } else {
            this.list.clear();
        }
        int n = 0;
        while (n < this.listSources.length) {
            this.listSources[n].addToList(this.list);
            ++n;
        }
        if (this.isSorted() && this.comparator != null) {
            Collections.sort(this.list, this.comparator);
        } else if (this.isSorted()) {
            Collections.sort(this.list);
        }
    }

    private boolean isListChangeEvent(ModelChangeEvent modelChangeEvent) {
        int n = 0;
        while (n < this.listSources.length) {
            if (this.listSources[n].isModelBased() && modelChangeEvent.getModel().equals(this.listSources[n].getListSourceModel()) && (modelChangeEvent.getSelector() == null || modelChangeEvent.getSelector().equals(this.listSources[n].getListSourceSelector()))) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

