/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.pref;

import java.io.File;
import javax.swing.JFileChooser;
import org.apache.cayenne.modeler.pref._FSPath;

public class FSPath
extends _FSPath {
    public void updateFromChooser(JFileChooser chooser) {
        File file = chooser.getSelectedFile();
        if (file != null) {
            this.setDirectory(file);
        }
    }

    public void updateChooser(JFileChooser chooser) {
        File startDir = this.getExistingDirectory(false);
        if (startDir != null) {
            chooser.setCurrentDirectory(startDir);
        }
    }

    public void setDirectory(File file) {
        if (file.isFile()) {
            this.setPath(file.getParentFile().getAbsolutePath());
        } else {
            this.setPath(file.getAbsolutePath());
        }
    }

    public File getExistingDirectory(boolean create) {
        if (this.getPath() == null) {
            return null;
        }
        File path = new File(this.getPath());
        if (path.isDirectory()) {
            return path;
        }
        if (path.isFile()) {
            return path.getParentFile();
        }
        if (create) {
            path.mkdirs();
            return path;
        }
        return null;
    }
}

