/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbentity;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.DbEntityListener;
import org.apache.cayenne.map.event.DbRelationshipListener;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.CopyRelationshipAction;
import org.apache.cayenne.modeler.action.CreateObjEntityAction;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.action.CutRelationshipAction;
import org.apache.cayenne.modeler.action.DbEntitySyncAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveRelationshipAction;
import org.apache.cayenne.modeler.dialog.ResolveDbRelationshipDialog;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.editor.dbentity.DbRelationshipTableModel;
import org.apache.cayenne.modeler.event.DbEntityDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;
import org.apache.cayenne.modeler.event.TablePopupHandler;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.CayenneWidgetFactory;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.apache.cayenne.modeler.util.UIUtil;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;

public class DbEntityRelationshipTab
extends JPanel
implements DbEntityDisplayListener,
DbEntityListener,
DbRelationshipListener,
ExistingSelectionProcessor,
ListSelectionListener,
TableModelListener {
    protected ProjectController mediator;
    protected CayenneTable table;
    protected JButton resolve;
    protected JMenuItem resolveMenu;
    protected JComboBox targetCombo;

    public DbEntityRelationshipTab(ProjectController mediator) {
        this.mediator = mediator;
        this.mediator.addDbEntityDisplayListener(this);
        this.mediator.addDbEntityListener(this);
        this.mediator.addDbRelationshipListener(this);
        this.init();
        ActionListener resolver = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbEntityRelationshipTab.this.resolveRelationship();
            }
        };
        this.resolve.addActionListener(resolver);
        this.resolveMenu.addActionListener(resolver);
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        Application app = Application.getInstance();
        toolBar.add(app.getAction(CreateObjEntityAction.getActionName()).buildButton());
        toolBar.add(app.getAction(CreateRelationshipAction.getActionName()).buildButton());
        toolBar.add(app.getAction(DbEntitySyncAction.getActionName()).buildButton());
        toolBar.addSeparator();
        this.resolve = new JButton();
        ImageIcon ico = ModelerUtil.buildIcon("icon-info.gif");
        this.resolve.setIcon(ico);
        this.resolve.setToolTipText("Database Mapping");
        toolBar.add(this.resolve);
        toolBar.addSeparator();
        toolBar.add(app.getAction(RemoveRelationshipAction.getActionName()).buildButton());
        toolBar.addSeparator();
        toolBar.add(app.getAction(CutRelationshipAction.getActionName()).buildButton());
        toolBar.add(app.getAction(CopyRelationshipAction.getActionName()).buildButton());
        toolBar.add(app.getAction(PasteAction.getActionName()).buildButton());
        this.add((Component)toolBar, "North");
        this.table = new CayenneTable();
        this.table.setDefaultRenderer(DbEntity.class, CellRenderers.entityTableRendererWithIcons(this.mediator));
        this.resolveMenu = new JMenuItem("Database Mapping", ico);
        JPopupMenu popup = new JPopupMenu();
        popup.add(this.resolveMenu);
        popup.add(app.getAction(RemoveRelationshipAction.getActionName()).buildMenu());
        popup.addSeparator();
        popup.add(app.getAction(CutRelationshipAction.getActionName()).buildMenu());
        popup.add(app.getAction(CopyRelationshipAction.getActionName()).buildMenu());
        popup.add(app.getAction(PasteAction.getActionName()).buildMenu());
        TablePopupHandler.install(this.table, popup);
        this.add((Component)PanelFactory.createTablePanel(this.table, null), "Center");
        this.mediator.getApplication().getActionManager().setupCCP(this.table, CutRelationshipAction.getActionName(), CopyRelationshipAction.getActionName());
    }

    public void valueChanged(ListSelectionEvent e) {
        this.processExistingSelection(e);
    }

    public void tableChanged(TableModelEvent e) {
        DbRelationship rel = null;
        if (this.table.getSelectedRow() >= 0) {
            DbRelationshipTableModel model = (DbRelationshipTableModel)this.table.getModel();
            rel = model.getRelationship(this.table.getSelectedRow());
            this.resolve.setEnabled(rel.getTargetEntity() != null);
            this.resolveMenu.setEnabled(this.resolve.isEnabled());
        }
    }

    public void selectRelationships(DbRelationship[] rels) {
        ModelerUtil.updateActions(rels.length, RemoveRelationshipAction.getActionName(), CutRelationshipAction.getActionName(), CopyRelationshipAction.getActionName());
        DbRelationshipTableModel model = (DbRelationshipTableModel)this.table.getModel();
        List listAttrs = model.getObjectList();
        int[] newSel = new int[rels.length];
        for (int i = 0; i < rels.length; ++i) {
            newSel[i] = listAttrs.indexOf(rels[i]);
        }
        this.table.select(newSel);
    }

    public void processExistingSelection(EventObject e) {
        if (e instanceof ChangeEvent) {
            this.table.clearSelection();
        }
        Relationship[] rels = new DbRelationship[]{};
        if (this.table.getSelectedRow() >= 0) {
            DbRelationshipTableModel model = (DbRelationshipTableModel)this.table.getModel();
            int[] sel = this.table.getSelectedRows();
            rels = new DbRelationship[sel.length];
            for (int i = 0; i < sel.length; ++i) {
                rels[i] = model.getRelationship(sel[i]);
            }
            this.resolve.setEnabled(rels.length == 1 && ((DbRelationship)rels[0]).getTargetEntity() != null);
            if (sel.length == 1) {
                UIUtil.scrollToSelectedRow(this.table);
            }
        } else {
            this.resolve.setEnabled(false);
        }
        this.resolveMenu.setEnabled(this.resolve.isEnabled());
        RelationshipDisplayEvent ev = new RelationshipDisplayEvent((Object)this, rels, (Entity)this.mediator.getCurrentDbEntity(), this.mediator.getCurrentDataMap(), this.mediator.getCurrentDataDomain());
        this.mediator.fireDbRelationshipDisplayEvent(ev);
    }

    private void resolveRelationship() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        DbRelationshipTableModel model = (DbRelationshipTableModel)this.table.getModel();
        DbRelationship rel = model.getRelationship(row);
        ResolveDbRelationshipDialog dialog = new ResolveDbRelationshipDialog(rel);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public void currentDbEntityChanged(EntityDisplayEvent e) {
        DbEntity entity = (DbEntity)e.getEntity();
        if (entity != null && e.isEntityChanged()) {
            this.rebuildTable(entity);
        }
        if (e.isUnselectAttributes()) {
            this.table.clearSelection();
        }
    }

    protected void rebuildTable(DbEntity entity) {
        DbRelationshipTableModel model = new DbRelationshipTableModel(entity, this.mediator, this);
        model.addTableModelListener(this);
        this.table.setModel(model);
        this.table.setRowHeight(25);
        this.table.setRowMargin(3);
        TableColumn col = this.table.getColumnModel().getColumn(0);
        col.setMinWidth(150);
        col = this.table.getColumnModel().getColumn(1);
        col.setMinWidth(150);
        this.targetCombo = CayenneWidgetFactory.createComboBox();
        AutoCompletion.enable(this.targetCombo);
        this.targetCombo.setRenderer(CellRenderers.entityListRendererWithIcons(entity.getDataMap()));
        this.targetCombo.setModel(this.createComboModel());
        col.setCellEditor(CayenneWidgetFactory.createCellEditor(this.targetCombo));
        this.table.getSelectionModel().addListSelectionListener(this);
    }

    public void dbEntityChanged(EntityEvent e) {
    }

    public void dbEntityAdded(EntityEvent e) {
        this.reloadEntityList(e);
    }

    public void dbEntityRemoved(EntityEvent e) {
        this.reloadEntityList(e);
    }

    public void dbRelationshipChanged(RelationshipEvent e) {
        if (e.getSource() != this) {
            if (!(this.table.getModel() instanceof DbRelationshipTableModel)) {
                this.rebuildTable((DbEntity)e.getEntity());
            }
            this.table.select(e.getRelationship());
            DbRelationshipTableModel model = (DbRelationshipTableModel)this.table.getModel();
            model.fireTableDataChanged();
        }
    }

    public void dbRelationshipAdded(RelationshipEvent e) {
        this.rebuildTable((DbEntity)e.getEntity());
        this.table.select(e.getRelationship());
    }

    public void dbRelationshipRemoved(RelationshipEvent e) {
        DbRelationshipTableModel model = (DbRelationshipTableModel)this.table.getModel();
        int ind = model.getObjectList().indexOf(e.getRelationship());
        model.removeRelationship(e.getRelationship());
        this.table.select(ind);
    }

    private void reloadEntityList(EntityEvent e) {
        if (e.getSource() == this) {
            return;
        }
        if (this.mediator.getCurrentDbEntity() == e.getEntity()) {
            return;
        }
        if (this.mediator.getCurrentDbEntity() == null) {
            return;
        }
        this.targetCombo.setModel(this.createComboModel());
        DbRelationshipTableModel model = (DbRelationshipTableModel)this.table.getModel();
        model.fireTableDataChanged();
        this.table.getSelectionModel().addListSelectionListener(this);
    }

    private ComboBoxModel createComboModel() {
        DataMap map = this.mediator.getCurrentDataMap();
        Object[] objects = map.getNamespace().getDbEntities().toArray();
        return new DefaultComboBoxModel<Object>(objects);
    }
}

