CREATE PROCEDURE cayenne_tst_select_proc (IN a_name VARCHAR(254), IN painting_price INT)
	RESULT SETS 1
	MODIFIES SQL DATA
	LANGUAGE SQL
BEGIN

	DECLARE c CURSOR WITH RETURN FOR
		SELECT DISTINCT A.ARTIST_ID, A.ARTIST_NAME, A.DATE_OF_BIRTH
		FROM ARTIST A, PAINTING P 
		WHERE A.ARTIST_ID = P.ARTIST_ID AND
		A.ARTIST_NAME = a_name;
	
	UPDATE PAINTING SET ESTIMATED_PRICE = ESTIMATED_PRICE * 2
	WHERE ESTIMATED_PRICE < painting_price;
	COMMIT; 
	
	OPEN c;
END