/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbimport;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.dbimport.DbImportView;
import org.apache.cayenne.modeler.util.NameGeneratorPreferences;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;
import org.apache.cayenne.validation.ValidationException;

public class ReverseEngineeringConfigPanel
extends JPanel {
    private static final String DATA_FIELDS_LAYOUT = "right:pref, 3dlu, fill:235dlu";
    private JComboBox<String> strategyCombo;
    private TextAdapter meaningfulPk;
    private TextAdapter stripFromTableNames;
    private JCheckBox skipRelationshipsLoading;
    private JCheckBox skipPrimaryKeyLoading;
    private JCheckBox forceDataMapCatalog;
    private JCheckBox forceDataMapSchema;
    private JCheckBox usePrimitives;
    private JCheckBox useJava7Types;
    private TextAdapter tableTypes;
    private ProjectController projectController;
    private DbImportView dbImportView;

    ReverseEngineeringConfigPanel(ProjectController projectController, DbImportView dbImportView) {
        this.projectController = projectController;
        this.dbImportView = dbImportView;
        this.initFormElements();
        this.initListeners();
        this.buildView();
    }

    private void buildView() {
        FormLayout panelLayout = new FormLayout(DATA_FIELDS_LAYOUT);
        DefaultFormBuilder panelBuilder = new DefaultFormBuilder(panelLayout);
        panelBuilder.setDefaultDialogBorder();
        panelBuilder.append("Tables with Meaningful PK Pattern:", (Component)this.meaningfulPk.getComponent());
        panelBuilder.append("Strip from table names:", (Component)this.stripFromTableNames.getComponent());
        panelBuilder.append("Skip relationships loading:", (Component)this.skipRelationshipsLoading);
        panelBuilder.append("Skip primary key loading:", (Component)this.skipPrimaryKeyLoading);
        panelBuilder.append("Force datamap catalog:", (Component)this.forceDataMapCatalog);
        panelBuilder.append("Force datamap schema:", (Component)this.forceDataMapSchema);
        panelBuilder.append("Use Java primitive types:", (Component)this.usePrimitives);
        panelBuilder.append("Use java.util.Date type:", (Component)this.useJava7Types);
        panelBuilder.append("Naming strategy:", this.strategyCombo);
        panelBuilder.append("Table types:", (Component)this.tableTypes.getComponent());
        this.add(panelBuilder.getPanel());
    }

    void fillCheckboxes(ReverseEngineering reverseEngineering) {
        this.skipRelationshipsLoading.setSelected(reverseEngineering.getSkipRelationshipsLoading());
        this.skipPrimaryKeyLoading.setSelected(reverseEngineering.getSkipPrimaryKeyLoading());
        this.forceDataMapCatalog.setSelected(reverseEngineering.isForceDataMapCatalog());
        this.forceDataMapSchema.setSelected(reverseEngineering.isForceDataMapSchema());
        this.usePrimitives.setSelected(reverseEngineering.isUsePrimitives());
        this.useJava7Types.setSelected(reverseEngineering.isUseJava7Types());
    }

    void initializeTextFields(ReverseEngineering reverseEngineering) {
        this.meaningfulPk.setText(reverseEngineering.getMeaningfulPkTables());
        this.stripFromTableNames.setText(reverseEngineering.getStripFromTableNames());
    }

    ReverseEngineering getReverseEngineeringBySelectedMap() {
        DataMap dataMap = this.projectController.getCurrentDataMap();
        return this.projectController.getApplication().getMetaData().get(dataMap, ReverseEngineering.class);
    }

    void initStrategy(ReverseEngineering reverseEngineering) {
        Vector<String> arr = NameGeneratorPreferences.getInstance().getLastUsedStrategies();
        this.strategyCombo.setModel(new DefaultComboBoxModel<String>(arr));
        this.strategyCombo.setSelectedItem(reverseEngineering.getNamingStrategy());
    }

    private void initFormElements() {
        this.strategyCombo = Application.getWidgetFactory().createComboBox();
        AutoCompletion.enable(this.strategyCombo, false, true);
        this.strategyCombo.setToolTipText("Naming strategy to use");
        JTextField meaningfulPkField = new JTextField();
        meaningfulPkField.setToolTipText("<html>Regular expression to filter tables with meaningful primary keys.<br>Multiple expressions divided by comma can be used.<br>Example: <b>^table1|^table2|^prefix.*|table_name</b></html>");
        this.meaningfulPk = new TextAdapter(meaningfulPkField){

            @Override
            protected void updateModel(String text) {
                ReverseEngineeringConfigPanel.this.getReverseEngineeringBySelectedMap().setMeaningfulPkTables(text);
                if (!ReverseEngineeringConfigPanel.this.dbImportView.isInitFromModel()) {
                    ReverseEngineeringConfigPanel.this.projectController.setDirty(true);
                }
            }
        };
        JTextField stripFromTableNamesField = new JTextField();
        stripFromTableNamesField.setToolTipText("<html>Regex that matches the part of the table name that needs to be stripped off when generating ObjEntity name</html>");
        this.stripFromTableNames = new TextAdapter(stripFromTableNamesField){

            @Override
            protected void updateModel(String text) {
                ReverseEngineeringConfigPanel.this.getReverseEngineeringBySelectedMap().setStripFromTableNames(text);
                if (!ReverseEngineeringConfigPanel.this.dbImportView.isInitFromModel()) {
                    ReverseEngineeringConfigPanel.this.projectController.setDirty(true);
                }
            }
        };
        JTextField tableTypesField = new JTextField();
        tableTypesField.setToolTipText("<html>Default types to import is TABLE and VIEW.");
        this.tableTypes = new TextAdapter(tableTypesField){

            @Override
            protected void updateModel(String text) throws ValidationException {
                ReverseEngineering reverseEngineering = ReverseEngineeringConfigPanel.this.getReverseEngineeringBySelectedMap();
                if (text == null || text.isEmpty()) {
                    CharSequence[] tableTypesFromReverseEngineering = reverseEngineering.getTableTypes();
                    ReverseEngineeringConfigPanel.this.tableTypes.setText(String.join((CharSequence)",", tableTypesFromReverseEngineering));
                    JOptionPane.showMessageDialog(Application.getFrame(), "Table types field can't be empty.", "Error setting table types", 0);
                } else {
                    String[] types;
                    reverseEngineering.getTableTypesCollection().clear();
                    for (String type : types = text.split("\\s*,\\s*")) {
                        if (type.isEmpty()) continue;
                        reverseEngineering.addTableType(type.trim());
                    }
                    if (!ReverseEngineeringConfigPanel.this.dbImportView.isInitFromModel()) {
                        ReverseEngineeringConfigPanel.this.projectController.setDirty(true);
                    }
                }
            }
        };
        this.skipRelationshipsLoading = new JCheckBox();
        this.skipRelationshipsLoading.setToolTipText("<html>Whether to load relationships.</html>");
        this.skipPrimaryKeyLoading = new JCheckBox();
        this.skipPrimaryKeyLoading.setToolTipText("<html>Whether to load primary keys.</html>");
        this.forceDataMapCatalog = new JCheckBox();
        this.forceDataMapCatalog.setToolTipText("<html>Automatically tagging each DbEntity with the actual DB catalog/schema(default behavior) may sometimes be undesirable.<br>  If this is the case then setting <b>forceDataMapCatalog</b> to <b>true</b> will set DbEntity catalog to one in the DataMap.</html>");
        this.forceDataMapSchema = new JCheckBox();
        this.forceDataMapSchema.setToolTipText("<html>Automatically tagging each DbEntity with the actual DB catalog/schema (default behavior) may sometimes be undesirable.<br> If this is the case then setting <b>forceDataMapSchema</b> to <b>true</b> will set DbEntity schema to one in the DataMap.</html>");
        this.useJava7Types = new JCheckBox();
        this.useJava7Types.setToolTipText("<html>Use <b>java.util.Date</b> for all columns with <i>DATE/TIME/TIMESTAMP</i> types.<br>By default <b>java.time.*</b> types will be used.</html>");
        this.usePrimitives = new JCheckBox();
        this.usePrimitives.setToolTipText("<html>Use primitive types (e.g. int) or Object types (e.g. java.lang.Integer)</html>");
    }

    private void initListeners() {
        this.skipRelationshipsLoading.addActionListener(e -> {
            this.getReverseEngineeringBySelectedMap().setSkipRelationshipsLoading(this.skipRelationshipsLoading.isSelected());
            if (!this.dbImportView.isInitFromModel()) {
                this.projectController.setDirty(true);
            }
        });
        this.skipPrimaryKeyLoading.addActionListener(e -> {
            this.getReverseEngineeringBySelectedMap().setSkipPrimaryKeyLoading(this.skipPrimaryKeyLoading.isSelected());
            if (!this.dbImportView.isInitFromModel()) {
                this.projectController.setDirty(true);
            }
        });
        this.forceDataMapCatalog.addActionListener(e -> {
            this.getReverseEngineeringBySelectedMap().setForceDataMapCatalog(this.forceDataMapCatalog.isSelected());
            if (!this.dbImportView.isInitFromModel()) {
                this.projectController.setDirty(true);
            }
        });
        this.forceDataMapSchema.addActionListener(e -> {
            this.getReverseEngineeringBySelectedMap().setForceDataMapSchema(this.forceDataMapSchema.isSelected());
            if (!this.dbImportView.isInitFromModel()) {
                this.projectController.setDirty(true);
            }
        });
        this.usePrimitives.addActionListener(e -> {
            this.getReverseEngineeringBySelectedMap().setUsePrimitives(this.usePrimitives.isSelected());
            if (!this.dbImportView.isInitFromModel()) {
                this.projectController.setDirty(true);
            }
        });
        this.useJava7Types.addActionListener(e -> {
            this.getReverseEngineeringBySelectedMap().setUseJava7Types(this.useJava7Types.isSelected());
            if (!this.dbImportView.isInitFromModel()) {
                this.projectController.setDirty(true);
            }
        });
        this.strategyCombo.addActionListener(e -> {
            String strategy = (String)this.getStrategyCombo().getSelectedItem();
            this.checkStrategy(strategy);
            this.getReverseEngineeringBySelectedMap().setNamingStrategy(strategy);
            NameGeneratorPreferences.getInstance().addToLastUsedStrategies(strategy);
            if (!this.dbImportView.isInitFromModel()) {
                this.projectController.setDirty(true);
            }
        });
    }

    private void checkStrategy(String strategy) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(strategy);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, strategy + " not found. Please, add naming strategy to classpath.", "Error", 2);
        }
    }

    JComboBox<String> getStrategyCombo() {
        return this.strategyCombo;
    }

    TextAdapter getMeaningfulPk() {
        return this.meaningfulPk;
    }

    TextAdapter getStripFromTableNames() {
        return this.stripFromTableNames;
    }

    JCheckBox getSkipRelationshipsLoading() {
        return this.skipRelationshipsLoading;
    }

    JCheckBox getSkipPrimaryKeyLoading() {
        return this.skipPrimaryKeyLoading;
    }

    JCheckBox getForceDataMapCatalog() {
        return this.forceDataMapCatalog;
    }

    JCheckBox getForceDataMapSchema() {
        return this.forceDataMapSchema;
    }

    JCheckBox getUsePrimitives() {
        return this.usePrimitives;
    }

    JCheckBox getUseJava7Types() {
        return this.useJava7Types;
    }

    TextAdapter getTableTypes() {
        return this.tableTypes;
    }
}

