/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.modeler.dialog.objentity.ObjRelationshipPathBrowser;
import org.apache.cayenne.modeler.util.MultiColumnBrowser;

public class ObjAttributePathBrowser
extends ObjRelationshipPathBrowser {
    JButton selectPathButton;
    JButton doneButton;

    public ObjAttributePathBrowser(JButton selectPathButton, JButton doneButton) {
        this.selectPathButton = selectPathButton;
        this.doneButton = doneButton;
    }

    protected void installColumn(MultiColumnBrowser.BrowserPanel panel) {
        if (this.panelOpener == null) {
            this.panelOpener = new PanelAttributeOpener();
        }
        if (this.panelRemover == null) {
            this.panelRemover = new ObjRelationshipPathBrowser.PanelRemover(this);
        }
        panel.addMouseListener(this.panelOpener);
        panel.addListSelectionListener(this.panelRemover);
        panel.setCellRenderer(this.renderer);
    }

    protected void selectRow(Object row, int index, TreePath path) {
        if (index > 0 && ((MultiColumnBrowser.BrowserPanel)this.columns.get(index - 1)).getSelectedValue() != row) {
            ((MultiColumnBrowser.BrowserPanel)this.columns.get(index - 1)).setSelectedValue(row, true);
        }
        if (index != path.getPathCount() - 1) {
            this.updateFromModel(row, index - 1);
        }
    }

    protected class PanelAttributeOpener
    extends MouseAdapter {
        protected PanelAttributeOpener() {
        }

        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                this.process(e);
            }
        }

        private void process(MouseEvent e) {
            MultiColumnBrowser.BrowserPanel panel = (MultiColumnBrowser.BrowserPanel)e.getSource();
            Object selectedNode = panel.getSelectedValue();
            if (selectedNode != null && selectedNode instanceof DbRelationship) {
                ObjAttributePathBrowser.this.updateFromModel(selectedNode, ObjAttributePathBrowser.this.columns.indexOf(panel));
                ObjAttributePathBrowser.this.selectPathButton.setEnabled(false);
                ObjAttributePathBrowser.this.doneButton.setEnabled(false);
            } else if (selectedNode instanceof DbAttribute) {
                ObjAttributePathBrowser.this.doneButton.setEnabled(true);
                ObjAttributePathBrowser.this.selectPathButton.setEnabled(true);
            }
        }
    }
}

