/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.mysql;

import org.apache.cayenne.access.jdbc.EJBQLConditionTranslator;
import org.apache.cayenne.access.jdbc.EJBQLTranslationContext;
import org.apache.cayenne.ejbql.EJBQLExpression;

class MySQLEJBQLConditionTranslator
extends EJBQLConditionTranslator {
    MySQLEJBQLConditionTranslator(EJBQLTranslationContext context) {
        super(context);
    }

    public boolean visitTrim(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex < 0) {
            this.context.append(" TRIM(");
        } else if (finishedChildIndex + 2 == expression.getChildrenCount()) {
            this.context.append(" FROM");
        } else if (finishedChildIndex + 1 == expression.getChildrenCount()) {
            this.context.append(")");
        }
        return true;
    }

    public boolean visitTrimCharacter(EJBQLExpression expression) {
        this.context.append(' ').append(expression.getText());
        return false;
    }

    public boolean visitTrimLeading(EJBQLExpression expression) {
        this.context.append("LEADING");
        return false;
    }

    public boolean visitTrimTrailing(EJBQLExpression expression) {
        this.context.append("TRAILING");
        return false;
    }

    public boolean visitTrimBoth(EJBQLExpression expression) {
        this.context.append("BOTH");
        return false;
    }

    public boolean visitLike(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex == 0) {
            if (this.checkNullParameter(expression, " IS NULL")) {
                return false;
            }
            if (expression.isNegated()) {
                this.context.append(" NOT");
            }
            this.context.append(" LIKE");
            if (this.context.isCaseInsensitive()) {
                this.context.append(" BINARY");
            }
        }
        return true;
    }
}

