/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.upgrade.v6;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.XMLDataMapLoader;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.MapLoader;
import org.apache.cayenne.resource.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;

class XMLDataMapLoader_V3_0_0_1 {
    private static Log logger = LogFactory.getLog(XMLDataMapLoader.class);

    XMLDataMapLoader_V3_0_0_1() {
    }

    public DataMap load(Resource configurationResource) throws CayenneRuntimeException {
        DataMap map;
        MapLoader mapLoader = new MapLoader();
        URL url = configurationResource.getURL();
        InputStream in = null;
        try {
            in = url.openStream();
            map = mapLoader.loadDataMap(new InputSource(in));
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error loading configuration from %s", (Throwable)e, new Object[]{url});
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ioex) {
                logger.info((Object)("failure closing input stream for " + url + ", ignoring"), (Throwable)ioex);
            }
        }
        return map;
    }
}

