/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils.test;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.spark.data.FileSystemSource;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.stats.BufferingInputStreamStats;
import org.apache.cassandra.spark.utils.IOUtils;
import org.apache.cassandra.spark.utils.streaming.BufferingInputStream;
import org.jetbrains.annotations.Nullable;

public final class TestSSTable
extends SSTable {
    private final Path dataFile;

    private TestSSTable(Path dataFile) {
        this.dataFile = dataFile;
    }

    public static SSTable at(Path dataFile) {
        return new TestSSTable(dataFile);
    }

    public static List<SSTable> at(Path ... dataFiles) {
        return Arrays.stream(dataFiles).map(TestSSTable::at).collect(Collectors.toList());
    }

    private static Stream<Path> list(Path directory, FileType type) throws IOException {
        return Files.list(directory).filter(path -> path.getFileName().toString().endsWith("-" + type.getFileSuffix()));
    }

    public static long countIn(Path directory) throws IOException {
        return TestSSTable.list(directory, FileType.DATA).count();
    }

    public static List<SSTable> allIn(Path directory) throws IOException {
        return TestSSTable.list(directory, FileType.DATA).map(TestSSTable::at).collect(Collectors.toList());
    }

    public static SSTable firstIn(Path directory) throws IOException {
        return TestSSTable.list(directory, FileType.DATA).findFirst().map(TestSSTable::at).orElseThrow(FileNotFoundException::new);
    }

    @VisibleForTesting
    public static Path firstIn(Path directory, FileType type) throws IOException {
        return TestSSTable.list(directory, type).findFirst().orElseThrow(FileNotFoundException::new);
    }

    @Override
    @Nullable
    protected InputStream openInputStream(FileType fileType) {
        Path filePath = this.fileComponentPath(fileType);
        try {
            if (filePath == null) {
                return null;
            }
            boolean isBtiFormat = this.isBtiFormat();
            if (isBtiFormat) {
                FileSystemSource<TestSSTable> fss = new FileSystemSource<TestSSTable>(this, fileType, filePath, false);
                return new BufferingInputStream<TestSSTable>(fss, BufferingInputStreamStats.doNothingStats());
            }
            return new BufferedInputStream(new FileInputStream(filePath.toFile()));
        }
        catch (FileNotFoundException exception) {
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Path fileComponentPath(FileType fileType) {
        return FileType.resolveComponentFile(fileType, this.dataFile);
    }

    @Override
    public long length(FileType fileType) {
        return IOUtils.size(this.fileComponentPath(fileType));
    }

    @Override
    public boolean isMissing(FileType fileType) {
        return this.fileComponentPath(fileType) == null;
    }

    @Override
    public String getDataFileName() {
        return this.dataFile.getFileName().toString();
    }

    public int hashCode() {
        return this.dataFile.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof TestSSTable && this.dataFile.equals(((TestSSTable)other).dataFile);
    }
}

