/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import com.google.common.primitives.UnsignedBytes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.IntStream;
import org.apache.cassandra.spark.utils.ByteBufferUtils;

public final class ComparisonUtils {
    private static final Comparator<Object> INET_COMPARATOR = (first, second) -> UnsignedBytes.lexicographicalComparator().compare(((Inet4Address)first).getAddress(), ((Inet4Address)second).getAddress());
    private static final Comparator<Object> NESTED_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object first, Object second) {
            if (first instanceof Comparable && second instanceof Comparable) {
                return ((Comparable)first).compareTo(second);
            }
            if (first instanceof Object[] && second instanceof Object[]) {
                Object[] array1 = (Object[])first;
                Object[] array2 = (Object[])second;
                for (int position = 0; position < array1.length && position < array2.length; ++position) {
                    int comparison = NESTED_COMPARATOR.compare(array1[position], array2[position]);
                    if (comparison == 0) continue;
                    return comparison;
                }
                return Integer.compare(array1.length, array2.length);
            }
            if (first instanceof Map && second instanceof Map) {
                Map map1 = (Map)first;
                Map map2 = (Map)second;
                for (Object key : map1.keySet()) {
                    int comparison = NESTED_COMPARATOR.compare(map1.get(key), map2.get(key));
                    if (comparison == 0) continue;
                    return comparison;
                }
                return Integer.compare(map1.size(), map2.size());
            }
            if (first instanceof Collection && second instanceof Collection) {
                return NESTED_COMPARATOR.compare(((Collection)first).toArray(new Object[0]), ((Collection)second).toArray(new Object[0]));
            }
            if (first instanceof Inet4Address && second instanceof Inet4Address) {
                return INET_COMPARATOR.compare(first, second);
            }
            throw new IllegalStateException("Unexpected comparable type: " + first.getClass().getName());
        }
    };

    private ComparisonUtils() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static boolean equals(Object[] first, Object[] second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        int length = first.length;
        if (second.length != length) {
            return false;
        }
        for (int index = 0; index < length; ++index) {
            if (ComparisonUtils.equals(first[index], second[index])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object first, Object second) {
        if (first instanceof UUID && second instanceof String) {
            return first.toString().equals(second);
        }
        if (first instanceof ByteBuffer && second instanceof byte[]) {
            return Arrays.equals(ByteBufferUtils.getArray((ByteBuffer)first), (byte[])second);
        }
        if (first instanceof InetAddress && second instanceof byte[]) {
            return Arrays.equals(((InetAddress)first).getAddress(), (byte[])second);
        }
        if (first instanceof BigInteger && second instanceof BigDecimal) {
            return first.toString().equals(second.toString());
        }
        if (first instanceof Integer && second instanceof Date) {
            return first.equals((int)((Date)second).toLocalDate().toEpochDay());
        }
        if (Objects.equals(first, second)) {
            return true;
        }
        if (first instanceof BigDecimal && second instanceof BigDecimal) {
            return ((BigDecimal)first).compareTo((BigDecimal)second) == 0;
        }
        if (first instanceof Collection && second instanceof Collection) {
            Object[] firstArray = ((Collection)first).toArray();
            Arrays.sort(firstArray, NESTED_COMPARATOR);
            Object[] secondArray = ((Collection)second).toArray();
            Arrays.sort(secondArray, NESTED_COMPARATOR);
            return ComparisonUtils.equals(firstArray, secondArray);
        }
        if (first instanceof Map && second instanceof Map) {
            Object[] firstKeys = ((Map)first).keySet().toArray();
            Object[] secondKeys = ((Map)second).keySet().toArray();
            if (firstKeys[0] instanceof Comparable) {
                Arrays.sort(firstKeys);
                Arrays.sort(secondKeys);
            } else if (firstKeys[0] instanceof Inet4Address) {
                Arrays.sort(firstKeys, INET_COMPARATOR);
                Arrays.sort(secondKeys, INET_COMPARATOR);
            }
            if (ComparisonUtils.equals(firstKeys, secondKeys)) {
                Object[] firstValues = new Object[firstKeys.length];
                Object[] secondValues = new Object[secondKeys.length];
                IntStream.range(0, firstKeys.length).forEach(position -> {
                    firstValues[position] = ((Map)first).get(firstKeys[position]);
                    secondValues[position] = ((Map)second).get(secondKeys[position]);
                });
                return ComparisonUtils.equals(firstValues, secondValues);
            }
            return false;
        }
        if (first instanceof Object[] && second instanceof Object[]) {
            return ComparisonUtils.equals((Object[])first, (Object[])second);
        }
        return false;
    }
}

