/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.partitioner;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.utils.RangeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraRing
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraRing.class);
    public static final Serializer SERIALIZER = new Serializer();
    private Partitioner partitioner;
    private String keyspace;
    private ReplicationFactor replicationFactor;
    private List<CassandraInstance> instances;
    private transient RangeMap<BigInteger, List<CassandraInstance>> replicas;
    private transient Multimap<CassandraInstance, Range<BigInteger>> tokenRangeMap;

    private static void addReplica(CassandraInstance replica, Range<BigInteger> range, RangeMap<BigInteger, List<CassandraInstance>> replicaMap) {
        Preconditions.checkArgument((((BigInteger)range.lowerEndpoint()).compareTo((BigInteger)range.upperEndpoint()) <= 0 ? 1 : 0) != 0, (Object)"Range calculations assume range is not wrapped");
        RangeMap replicaRanges = replicaMap.subRangeMap(range);
        TreeRangeMap mappingsToAdd = TreeRangeMap.create();
        replicaRanges.asMapOfRanges().forEach((arg_0, arg_1) -> CassandraRing.lambda$addReplica$0(replica, (RangeMap)mappingsToAdd, arg_0, arg_1));
        replicaMap.putAll((RangeMap)mappingsToAdd);
    }

    public CassandraRing(Partitioner partitioner, String keyspace, ReplicationFactor replicationFactor, Collection<CassandraInstance> instances) {
        this.partitioner = partitioner;
        this.keyspace = keyspace;
        this.replicationFactor = replicationFactor;
        this.instances = instances.stream().sorted(Comparator.comparing(instance -> new BigInteger(instance.token()))).collect(Collectors.toCollection(ArrayList::new));
        this.init();
    }

    private void init() {
        this.replicas = TreeRangeMap.create();
        this.tokenRangeMap = ArrayListMultimap.create();
        switch (this.replicationFactor.getReplicationStrategy()) {
            case SimpleStrategy: {
                this.tokenRangeMap.putAll(RangeUtils.calculateTokenRanges(this.instances, this.replicationFactor.getTotalReplicationFactor(), this.partitioner));
                break;
            }
            case NetworkTopologyStrategy: {
                for (String dataCenter : this.dataCenters()) {
                    int rf = this.replicationFactor.getOptions().get(dataCenter);
                    if (rf == 0) continue;
                    List dcInstances = this.instances.stream().filter(instance -> instance.dataCenter().matches(dataCenter)).collect(Collectors.toList());
                    this.tokenRangeMap.putAll(RangeUtils.calculateTokenRanges(dcInstances, this.replicationFactor.getOptions().get(dataCenter), this.partitioner));
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported replication strategy");
            }
        }
        this.replicas.put(Range.openClosed((Comparable)this.partitioner.minToken(), (Comparable)this.partitioner.maxToken()), Collections.emptyList());
        this.tokenRangeMap.asMap().forEach((instance, ranges) -> ranges.forEach(range -> CassandraRing.addReplica(instance, (Range<BigInteger>)range, this.replicas)));
    }

    public Partitioner partitioner() {
        return this.partitioner;
    }

    public String keyspace() {
        return this.keyspace;
    }

    public Collection<CassandraInstance> instances() {
        return this.instances;
    }

    public Collection<CassandraInstance> getReplicas(BigInteger token) {
        return (Collection)this.replicas.get((Comparable)token);
    }

    public RangeMap<BigInteger, List<CassandraInstance>> rangeMap() {
        return this.replicas;
    }

    public ReplicationFactor replicationFactor() {
        return this.replicationFactor;
    }

    public RangeMap<BigInteger, List<CassandraInstance>> getSubRanges(Range<BigInteger> tokenRange) {
        return this.replicas.subRangeMap(tokenRange);
    }

    public Multimap<CassandraInstance, Range<BigInteger>> tokenRanges() {
        return this.tokenRangeMap;
    }

    private Collection<String> dataCenters() {
        return this.replicationFactor.getReplicationStrategy() == ReplicationFactor.ReplicationStrategy.SimpleStrategy ? Collections.emptySet() : this.replicationFactor.getOptions().keySet();
    }

    public Collection<BigInteger> tokens() {
        return this.instances.stream().map(CassandraInstance::token).map(BigInteger::new).sorted().collect(Collectors.toList());
    }

    public Collection<BigInteger> tokens(String dataCenter) {
        Preconditions.checkArgument((this.replicationFactor.getReplicationStrategy() != ReplicationFactor.ReplicationStrategy.SimpleStrategy ? 1 : 0) != 0, (Object)"Datacenter tokens doesn't make sense for SimpleStrategy");
        return this.instances.stream().filter(instance -> instance.dataCenter().matches(dataCenter)).map(CassandraInstance::token).map(BigInteger::new).collect(Collectors.toList());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        CassandraRing that = (CassandraRing)other;
        return this.partitioner == that.partitioner && Objects.equals(this.keyspace, that.keyspace) && Objects.equals(this.replicationFactor, that.replicationFactor) && Objects.equals(this.instances, that.instances) && Objects.equals(this.replicas, that.replicas) && Objects.equals(this.tokenRangeMap, that.tokenRangeMap);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.partitioner, this.keyspace, this.replicationFactor, this.instances, this.replicas, this.tokenRangeMap});
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        LOGGER.debug("Falling back to JDK deserialization");
        this.partitioner = in.readByte() == 0 ? Partitioner.RandomPartitioner : Partitioner.Murmur3Partitioner;
        this.keyspace = in.readUTF();
        ReplicationFactor.ReplicationStrategy strategy = ReplicationFactor.ReplicationStrategy.valueOf(in.readByte());
        int optionCount = in.readByte();
        HashMap<String, Integer> options = new HashMap<String, Integer>(optionCount);
        for (int option = 0; option < optionCount; ++option) {
            options.put(in.readUTF(), Integer.valueOf(in.readByte()));
        }
        this.replicationFactor = new ReplicationFactor(strategy, options);
        int numInstances = in.readShort();
        this.instances = new ArrayList<CassandraInstance>(numInstances);
        for (int instance = 0; instance < numInstances; ++instance) {
            this.instances.add(new CassandraInstance(in.readUTF(), in.readUTF(), in.readUTF()));
        }
        this.init();
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        LOGGER.debug("Falling back to JDK serialization");
        out.writeByte(this.partitioner == Partitioner.RandomPartitioner ? 0 : 1);
        out.writeUTF(this.keyspace);
        out.writeByte(this.replicationFactor.getReplicationStrategy().value);
        Map<String, Integer> options = this.replicationFactor.getOptions();
        out.writeByte(options.size());
        for (Map.Entry<String, Integer> option : options.entrySet()) {
            out.writeUTF(option.getKey());
            out.writeByte(option.getValue());
        }
        out.writeShort(this.instances.size());
        for (CassandraInstance instance : this.instances) {
            out.writeUTF(instance.token());
            out.writeUTF(instance.nodeName());
            out.writeUTF(instance.dataCenter());
        }
    }

    private static /* synthetic */ void lambda$addReplica$0(CassandraInstance replica, RangeMap mappingsToAdd, Range key, List value) {
        ArrayList<CassandraInstance> replicas = new ArrayList<CassandraInstance>(value);
        replicas.add(replica);
        mappingsToAdd.put(key, replicas);
    }

    public static class Serializer
    extends com.esotericsoftware.kryo.Serializer<CassandraRing> {
        public void write(Kryo kryo, Output out, CassandraRing ring) {
            out.writeByte(ring.partitioner == Partitioner.RandomPartitioner ? 1 : 0);
            out.writeString(ring.keyspace);
            kryo.writeObject(out, (Object)ring.replicationFactor);
            kryo.writeObject(out, ring.instances);
        }

        public CassandraRing read(Kryo kryo, Input in, Class<CassandraRing> type) {
            return new CassandraRing(in.readByte() == 1 ? Partitioner.RandomPartitioner : Partitioner.Murmur3Partitioner, in.readString(), (ReplicationFactor)kryo.readObject(in, ReplicationFactor.class), (Collection)kryo.readObject(in, ArrayList.class));
        }
    }
}

